/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.information;

import ec.tstoolkit.MetaData;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InformationSetHelper {
    public static InformationSet fromMetaData(MetaData md) {
        if (md == null || md.isEmpty()) {
            return null;
        }
        InformationSet info = new InformationSet();
        for (Map.Entry<String, String> entry : md.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            info.set(entry.getKey(), entry.getValue());
        }
        return info;
    }

    public static void fillMetaData(InformationSet info, MetaData md) {
        List<Information<String>> sel = info.deepSelect(String.class);
        for (Information<String> sinfo : sel) {
            md.put(sinfo.name, (String)sinfo.value);
        }
    }

    public static InformationSet fromProcResults(IProcResults rslts) {
        InformationSet info = new InformationSet();
        if (rslts != null) {
            Map<String, Class> dictionary = rslts.getDictionary();
            for (Map.Entry<String, Class> entry : dictionary.entrySet()) {
                info.add(InformationSet.split(entry.getKey()), rslts.getData(entry.getKey(), entry.getValue()));
            }
        }
        return info;
    }

    public static <T> InformationSet fromProcResults(IProcResults rslts, Class<T> tclass) {
        InformationSet info = new InformationSet();
        if (rslts != null) {
            Map<String, Class> dictionary = rslts.getDictionary();
            for (Map.Entry<String, Class> entry : dictionary.entrySet()) {
                if (!tclass.isAssignableFrom(entry.getValue())) continue;
                info.add(InformationSet.split(entry.getKey()), rslts.getData(entry.getKey(), entry.getValue()));
            }
        }
        return info;
    }

    public static <T> InformationSet fromProcResults(IProcResults rslts, Set<String> sel) {
        InformationSet info = new InformationSet();
        if (rslts != null) {
            Map<String, Class> dictionary = rslts.getDictionary();
            for (Map.Entry<String, Class> entry : dictionary.entrySet()) {
                for (String n : sel) {
                    if (!InformationSet.wildCompare(n, entry.getKey())) continue;
                    info.set(InformationSet.split(entry.getKey()), rslts.getData(entry.getKey(), entry.getValue()));
                }
            }
        }
        return info;
    }
}

