/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Prism;

import java.io.IOException;
import java.util.Vector;
import keel.Algorithms.Rule_Learning.Prism.Complejo;
import keel.Algorithms.Rule_Learning.Prism.ConjDatos;
import keel.Algorithms.Rule_Learning.Prism.ConjReglas;
import keel.Algorithms.Rule_Learning.Prism.Dataset;
import keel.Algorithms.Rule_Learning.Prism.EvaluaCalidadReglas;
import keel.Algorithms.Rule_Learning.Prism.Muestra;
import keel.Algorithms.Rule_Learning.Prism.Selector;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Fichero;
import org.core.Randomize;

public class Prism {
    private Dataset train;
    private Dataset test;
    private String ficheroSalida;
    private String ficheroSalidaTr;
    private String ficheroSalidaTst;
    private String[][] valores;
    private String[] clases;
    private int[] clasitas;
    private boolean reglaPerfecta;
    private boolean cubierta;
    private InstanceSet instancias;
    private String[] nombre_atributos;
    private double accuracy;
    private double accuracy_ant;
    private int clase;
    private int seleccionado;
    private int p;
    private int atributo;
    private int num_cubiertas;
    private int num_correctas;
    private ConjReglas conjunto_reglas;
    private Selector s;
    private Complejo almacen;
    private Complejo regla;
    private boolean hayContinuos;
    private ConjDatos datosTrain;
    private ConjDatos datosTest;
    private EvaluaCalidadReglas evReg;
    private int[] muestPorClaseEval;
    private int[] muestPorClaseTest;
    private Instance instancia;
    private long seed;

    public boolean todoBien() {
        return !this.hayContinuos;
    }

    public Prism() {
        this.valores = null;
        this.clases = null;
        this.clasitas = null;
        this.nombre_atributos = null;
        this.accuracy = -1.0;
        this.accuracy_ant = -1.0;
        this.seleccionado = 0;
        this.p = 0;
        this.hayContinuos = false;
    }

    public Prism(String ficheroTrain, String ficheroTest, String fSalidaTr, String fSalidaTst, String fsalida, long semilla) {
        block17: {
            this.valores = null;
            this.clases = null;
            this.clasitas = null;
            this.nombre_atributos = null;
            this.accuracy = -1.0;
            this.accuracy_ant = -1.0;
            this.seleccionado = 0;
            this.p = 0;
            this.hayContinuos = false;
            this.ficheroSalida = fsalida;
            this.ficheroSalidaTr = fSalidaTr;
            this.ficheroSalidaTst = fSalidaTst;
            this.seed = semilla;
            this.datosTrain = new ConjDatos();
            this.datosTest = new ConjDatos();
            this.train = new Dataset();
            this.test = new Dataset();
            this.s = new Selector(0, 0, 0.0);
            this.conjunto_reglas = new ConjReglas();
            try {
                Randomize.setSeed(this.seed);
                System.out.println("la semilla es " + this.seed);
                this.train.leeConjunto(ficheroTrain, true);
                this.test.leeConjunto(ficheroTest, false);
                if (this.train.hayAtributosContinuos()) {
                    System.err.println("\nPrism may not work properly with real or integer attributes.\n");
                    this.hayContinuos = true;
                }
                if (this.hayContinuos) break block17;
                this.train.calculaMasComunes();
                this.test.calculaMasComunes();
                this.datosTrain = this.creaConjunto(this.train);
                this.datosTest = this.creaConjunto(this.test);
                this.valores = this.train.getX2();
                this.clases = this.train.getC2();
                this.clasitas = this.train.getC();
                this.clases = this.train.dameClases();
                boolean unavez = false;
                for (int i = 0; i < this.train.getnclases(); ++i) {
                    System.out.println("CLASE :" + this.clases[i] + "\n");
                    this.train.leeConjunto(ficheroTrain, false);
                    this.nombre_atributos = this.train.dameNombres();
                    this.instancias = this.train.getInstanceSet();
                    while (this.train.hayInstanciasDeClaseC(i)) {
                        this.regla = new Complejo(this.train.getnclases());
                        this.regla.setClase(i);
                        this.regla.adjuntaNombreAtributos(this.nombre_atributos);
                        this.almacen = this.hazSelectores(this.train);
                        this.almacen.adjuntaNombreAtributos(this.nombre_atributos);
                        do {
                            int jj;
                            this.accuracy_ant = -1.0;
                            this.p = 0;
                            int[] seleccionados = new int[this.almacen.size()];
                            for (int jj2 = 0; jj2 < this.almacen.size(); ++jj2) {
                                seleccionados[jj2] = 0;
                            }
                            System.out.println();
                            for (int j = 0; j < this.almacen.size(); ++j) {
                                if (j > 0) {
                                    this.regla.removeSelector(this.s);
                                }
                                this.s = this.almacen.getSelector(j);
                                this.s.print();
                                this.regla.addSelector(this.s);
                                this.accuracy = this.getAccuracy(i);
                                System.out.println("correctas " + this.num_correctas + " cubiertas " + this.num_cubiertas);
                                System.out.println("Acurracy " + this.accuracy);
                                if (this.accuracy > this.accuracy_ant || this.accuracy == this.accuracy_ant && this.num_correctas > this.p) {
                                    this.accuracy_ant = this.accuracy;
                                    this.seleccionado = j;
                                    this.p = this.num_correctas;
                                    for (jj = 0; jj < this.almacen.size(); ++jj) {
                                        seleccionados[jj] = 0;
                                    }
                                    continue;
                                }
                                if (this.accuracy != this.accuracy_ant || this.num_correctas != this.p) continue;
                                seleccionados[this.seleccionado] = 1;
                                seleccionados[j] = 1;
                            }
                            int contador = 0;
                            for (jj = 0; jj < this.almacen.size(); ++jj) {
                                if (seleccionados[jj] != 1) continue;
                                ++contador;
                                System.out.println("OPCION " + jj);
                            }
                            if (contador > 0) {
                                int candidato = Randomize.RandintClosed(1, contador);
                                contador = 0;
                                for (jj = 0; jj < this.almacen.size(); ++jj) {
                                    if (seleccionados[jj] != 1 || ++contador != candidato) continue;
                                    this.seleccionado = jj;
                                }
                            }
                            System.out.println("ELEGIDO " + this.seleccionado);
                            this.regla.removeSelector(this.s);
                            this.s = this.almacen.getSelector(this.seleccionado);
                            this.s.print();
                            this.regla.addSelector(this.s);
                            this.atributo = this.s.getAtributo();
                            this.almacen.removeSelectorAtributo(this.atributo);
                            this.reglaPerfecta = this.perfectRule(this.regla, this.train);
                        } while (!this.reglaPerfecta && this.regla.size() < this.train.getnentradas());
                        System.out.println("\n");
                        System.out.println("\nREGLA............................................");
                        this.regla.print();
                        System.out.println("\n");
                        this.evaluarComplejo(this.regla, this.datosTrain);
                        this.conjunto_reglas.addRegla(this.regla);
                        this.removeInstancesCovered(i);
                        for (int k = 0; k < this.instancias.getNumInstances(); ++k) {
                            this.instancia = this.instancias.getInstance(k);
                            this.clase = this.instancia.getOutputNominalValuesInt(0);
                            if (this.clase != i) continue;
                            System.out.print(k + " ");
                            this.instancia.print();
                            System.out.println();
                        }
                        System.out.println("\n");
                    }
                }
                int[] clasesEval = this.train.getC();
                this.muestPorClaseEval = new int[this.train.getnclases()];
                for (int j = 0; j < this.train.getnclases(); ++j) {
                    this.muestPorClaseEval[j] = 0;
                    for (int i = 0; i < this.datosTrain.size(); ++i) {
                        if (j != clasesEval[i]) continue;
                        int n = j;
                        this.muestPorClaseEval[n] = this.muestPorClaseEval[n] + 1;
                    }
                }
                this.conjunto_reglas.eliminaRepetidos(1);
                this.evReg = new EvaluaCalidadReglas(this.conjunto_reglas, this.datosTrain, this.datosTest, this.muestPorClaseEval, this.muestPorClaseEval, this.clases);
                this.generaSalida();
                System.out.println("la semilla es " + this.seed);
            }
            catch (IOException e) {
                System.err.println("There was a problem while trying to read the dataset files:");
                System.err.println("-> " + e);
            }
        }
    }

    private void evaluarComplejo(Complejo c, ConjDatos e) {
        c.borraDistrib();
        for (int i = 0; i < e.size(); ++i) {
            int cl = e.getDato(i).getClase();
            if (!c.cubre(e.getDato(i))) continue;
            c.incrementaDistrib(cl);
        }
        c.calculaLaplaciano();
    }

    private double getAccuracy(int i) {
        this.num_cubiertas = 0;
        this.num_correctas = 0;
        for (int k = 0; k < this.instancias.getNumInstances(); ++k) {
            Instance instancia = this.instancias.getInstance(k);
            this.cubierta = this.regla.reglaCubreInstancia(instancia);
            if (!this.cubierta) continue;
            ++this.num_cubiertas;
            this.clase = instancia.getOutputNominalValuesInt(0);
            if (this.clase != i) continue;
            ++this.num_correctas;
        }
        double Accuracy = (double)this.num_correctas / (double)this.num_cubiertas;
        if (this.num_cubiertas == 0) {
            Accuracy = 0.0;
        }
        return Accuracy;
    }

    private void removeInstancesCovered(int i) {
        for (int k = 0; k < this.instancias.getNumInstances(); ++k) {
            this.instancia = this.instancias.getInstance(k);
            this.cubierta = this.regla.reglaCubreInstancia(this.instancia);
            if (!this.cubierta) continue;
            this.clase = this.instancia.getOutputNominalValuesInt(0);
            this.instancias.removeInstance(k);
            this.instancia.print();
            System.out.println();
            --k;
        }
    }

    private void generaSalida() {
        Fichero f = new Fichero();
        String cad = "";
        String miSalida = new String("");
        miSalida = this.train.copiaCabeceraTest();
        this.conjunto_reglas.adjuntaNombreClases(this.clases);
        this.conjunto_reglas.adjuntaNombreClase(this.nombre_atributos[this.train.getnentradas()]);
        cad = this.conjunto_reglas.printString();
        Fichero.escribeFichero(this.ficheroSalida, cad);
        Fichero.escribeFichero(this.ficheroSalidaTr, miSalida + this.evReg.salida(this.datosTrain));
        Fichero.escribeFichero(this.ficheroSalidaTst, miSalida + this.evReg.salida(this.datosTest));
    }

    private ConjDatos creaConjunto(Dataset mis_datos) {
        ConjDatos datos = new ConjDatos();
        int tam = mis_datos.getnentradas();
        double[] vars = new double[tam];
        int clase = 0;
        double[][] X = mis_datos.getX();
        int[] C = mis_datos.getC();
        for (int i = 0; i < mis_datos.getndatos(); ++i) {
            for (int j = 0; j < tam; ++j) {
                vars[j] = mis_datos.isMissing(i, j) ? (double)mis_datos.masComun(j) : X[i][j];
            }
            clase = C[i];
            Muestra m = new Muestra(vars, clase, tam);
            m.setPosFile(i);
            datos.addDato(m);
        }
        return datos;
    }

    public boolean perfectRule(Complejo regla, Dataset train) {
        int i;
        ConjDatos datosTrain = new ConjDatos();
        datosTrain = this.creaConjunto(train);
        boolean perfecta = false;
        ConjDatos cubiertas = new ConjDatos();
        for (i = 0; i < train.getndatos(); ++i) {
            Muestra m = datosTrain.getDato(i);
            if (!regla.cubre(m)) continue;
            cubiertas.addDato(m);
        }
        for (i = 0; i < cubiertas.size(); ++i) {
            if (cubiertas.getDato(i).getClase() != regla.getClase()) {
                perfecta = false;
                return perfecta;
            }
            perfecta = true;
        }
        return perfecta;
    }

    private Complejo hazSelectores(Dataset train) {
        int nClases = train.getnclases();
        Complejo almacenSelectores = new Complejo(nClases);
        Attribute[] atributos = null;
        atributos = Attributes.getAttributes();
        int num_atributos = Attributes.getNumAttributes();
        block3: for (int i = 0; i < train.getnentradas(); ++i) {
            int type = atributos[i].getType();
            switch (type) {
                case 0: {
                    Vector nominalValues = atributos[i].getNominalValuesList();
                    for (int j = 0; j < nominalValues.size(); ++j) {
                        Selector s = new Selector(i, 0, (String)nominalValues.elementAt(j), true);
                        s.setValor(j);
                        almacenSelectores.addSelector(s);
                    }
                    continue block3;
                }
            }
        }
        return almacenSelectores;
    }
}

