/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.ANR;

import java.util.Vector;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.ConjGradNN;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.OPV;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.SquaresErrorNN;
import org.core.Randomize;

public class GCNet {
    static final int MAX_ITER = 10000;
    static final double TOL_ERR = 1.0E-8;
    static final double MIN_DELTAGC = 1.0E-5;
    ConjGradNN Net;

    public double nntrain(int nInputs, int nOutputs, double[][] examples, double[][] outputs, int[] topology, double[] weights, Randomize r) {
        double errf;
        boolean mejora = true;
        double bestSSE = Double.MAX_VALUE;
        int contador = 0;
        int bestNumHiddenNodes = 1;
        while (mejora) {
            System.out.println("NUMERO NODOS OCULTOS = " + topology[0]);
            int weightDimension = 0;
            if (topology.length == 0) {
                weightDimension = (nInputs + 1) * outputs[0].length;
            } else {
                weightDimension = (nInputs + 1) * topology[0];
                for (int i = 1; i < topology.length; ++i) {
                    weightDimension += (topology[i - 1] + 1) * topology[i];
                }
                weightDimension += outputs[0].length * (topology[topology.length - 1] + 1);
            }
            weights = new double[weightDimension];
            int nelem = examples.length;
            System.out.println("Numero entradas=" + nInputs);
            System.out.println("Numero salidas=" + nOutputs);
            System.out.println("Dimension topologia=" + topology.length);
            System.out.println("Dimension pesos=" + weights.length);
            System.out.println("Numero ejemplos=" + nelem);
            this.Net = new ConjGradNN(topology, examples, outputs, r);
            SquaresErrorNN Err = new SquaresErrorNN(this.Net);
            this.Net.randomWeights(0.05);
            errf = this.Net.conjugatedGradient(Err, 1.0E-8, 1.0E-5, 10000);
            this.Net.getWeights(weights);
            System.out.println("RMS train=" + errf);
            System.out.println("\n\n\n" + this.Net.getSSEadj() + " , best = " + bestSSE);
            if (this.Net.getSSEadj() < bestSSE) {
                bestSSE = this.Net.getSSEadj();
                bestNumHiddenNodes = topology[0];
            } else {
                ++contador;
            }
            if (contador == 2) {
                mejora = false;
            }
            topology[0] = topology[0] + 1;
        }
        topology[0] = bestNumHiddenNodes;
        int nelem = examples.length;
        int weightDimension = 0;
        if (topology.length == 0) {
            weightDimension = (nInputs + 1) * outputs[0].length;
        } else {
            weightDimension = (nInputs + 1) * topology[0];
            for (int i = 1; i < topology.length; ++i) {
                weightDimension += (topology[i - 1] + 1) * topology[i];
            }
            weightDimension += outputs[0].length * (topology[topology.length - 1] + 1);
        }
        weights = new double[weightDimension];
        this.Net = new ConjGradNN(topology, examples, outputs, r);
        SquaresErrorNN Err = new SquaresErrorNN(this.Net);
        this.Net.randomWeights(0.05);
        errf = this.Net.conjugatedGradient(Err, 1.0E-8, 1.0E-5, 10000);
        this.Net.getWeights(weights);
        System.out.println("RMS train=" + errf);
        return errf;
    }

    public Vector getNoisyInstances() {
        return this.Net.getNoisyInstances();
    }

    public double nntrainGD(int nInputs, int nOutputs, double[][] examples, double[][] outputs, int[] topology, double[] weights, Randomize r) {
        int nElements = examples.length;
        System.out.println("Numero entradas=" + nInputs);
        System.out.println("Numero salidas=" + nOutputs);
        System.out.println("Dimension topologia=" + topology.length);
        System.out.println("Dimension pesos=" + weights.length);
        System.out.println("Numero ejemplos=" + nElements);
        this.Net = new ConjGradNN(topology, examples, outputs, r);
        SquaresErrorNN Err = new SquaresErrorNN(this.Net);
        this.Net.randomWeights(0.05);
        double errf = this.Net.descentGradient(Err, 1.0E-8, 1.0E-5, 10000);
        this.Net.getWeights(weights);
        System.out.println("RMS train=" + errf);
        return errf;
    }

    public double[] nnoutput(double[] x) {
        double[] output = this.Net.nn(OPV.scale(x, this.Net.max_x, this.Net.min_x), this.Net.weights);
        return OPV.invScale(output, this.Net.max_y, this.Net.min_y);
    }
}

