/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.StringFeature;

public class FeatureUtil {
    private FeatureUtil() {
    }

    public static Feature createFeature(Field<?> field, PMMLEncoder encoder) {
        DataType dataType = field.requireDataType();
        OpType opType = field.requireOpType();
        switch (dataType) {
            case STRING: {
                return new StringFeature(encoder, field);
            }
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                switch (opType) {
                    case CONTINUOUS: {
                        return new ContinuousFeature(encoder, field);
                    }
                }
                return new ObjectFeature(encoder, (Field)field){

                    @Override
                    public ContinuousFeature toContinuousFeature() {
                        PMMLEncoder encoder = this.getEncoder();
                        DerivedField derivedField = (DerivedField)encoder.toContinuous(this.getName());
                        return new ContinuousFeature(encoder, (Field<?>)derivedField);
                    }
                };
            }
        }
        return new ObjectFeature(encoder, field);
    }

    public static String getName(Feature feature) {
        if (feature instanceof HasDerivedName) {
            HasDerivedName hasDerivedName = (HasDerivedName)((Object)feature);
            return hasDerivedName.getDerivedName();
        }
        return feature.getName();
    }
}

