/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractReaction;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLFormula;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLName;
import org.xmlcml.cml.element.CMLProduct;
import org.xmlcml.cml.element.CMLProductList;
import org.xmlcml.cml.element.CMLReactant;
import org.xmlcml.cml.element.CMLReactantList;
import org.xmlcml.cml.element.CMLSpectator;
import org.xmlcml.cml.element.CMLSpectatorList;
import org.xmlcml.cml.element.CMLSubstanceList;
import org.xmlcml.cml.element.ReactionComponent;

public class CMLReaction
extends AbstractReaction
implements ReactionComponent {
    public static final String NS = "cml:reaction";
    private static String ANYTAG = "reactant || product || spectator";
    public static final String IGNORE_ORDER = "/IgnoreBondOrders";
    public static final String MAP_REACTION_ATOM_MAP_COMPLETE = "cml:REACTION_ATOM_MAP_COMPLETE";
    public static final String MAP_REACTION_ATOM_MAP_INCOMPLETE = "cml:REACTION_ATOM_MAP_INCOMPLETE";
    public static final String FROM_PRODUCT_TO_REACTANT = "from product to product";
    public static final String FROM_SPECTATOR_PRODUCT_TO_REACTANT = "from cmlSpectator product to product";
    static final Logger logger = Logger.getLogger((String)CMLReaction.class.getName());

    public CMLReaction() {
    }

    public CMLReaction(CMLReaction old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLReaction(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLReaction();
    }

    public String getId(String type) {
        return this.getId() + "." + type;
    }

    public void mergeProductLists() {
        this.mergePRLists(Component.PRODUCTLIST, Component.PRODUCT);
    }

    public void mergeReactantLists() {
        this.mergePRLists(Component.REACTANTLIST, Component.REACTANT);
    }

    public void mergeSpectatorLists() {
        this.mergePRLists(Component.SPECTATORLIST, Component.SPECTATOR);
    }

    private void mergePRLists(Component prListC, Component prC) {
        Elements prLists = this.getChildCMLElements(prListC.name);
        if (prLists.size() > 1) {
            for (int i = 1; i < prLists.size(); ++i) {
                CMLElement prList = (CMLElement)prLists.get(i);
                Elements prs = prList.getChildCMLElements(prC.name);
                for (int j = 0; j < prs.size(); ++j) {
                    Element pr = prs.get(j);
                    pr.detach();
                    prLists.get(0).appendChild((Node)pr);
                }
                prList.detach();
            }
        }
    }

    public CMLReactantList getReactantList() {
        this.mergeReactantLists();
        CMLReactantList productList = (CMLReactantList)this.getFirstCMLChild("reactantList");
        return productList;
    }

    public CMLProductList getProductList() {
        this.mergeProductLists();
        CMLProductList productList = (CMLProductList)this.getFirstCMLChild("productList");
        return productList;
    }

    public CMLSpectatorList getSpectatorList() {
        this.mergeSpectatorLists();
        CMLSpectatorList spectatorList = (CMLSpectatorList)this.getFirstCMLChild("spectatorList");
        return spectatorList;
    }

    public String getFilename() {
        String s = null;
        Elements nameNodes = this.getChildCMLElements("name");
        for (int i = 0; i < nameNodes.size(); ++i) {
            CMLName name = (CMLName)nameNodes.get(i);
            if (!name.getDictRef().equals("cml:filename")) continue;
            s = name.getXMLContent();
        }
        return s == null ? this.getId() : s;
    }

    public List<CMLMolecule> getSpectatorMolecules(int reactOrProd) {
        ArrayList<CMLMolecule> moleculeList = new ArrayList<CMLMolecule>();
        CMLSpectatorList spectatorList = (CMLSpectatorList)this.getFirstCMLChild("spectatorList");
        Elements spectators = spectatorList.getChildCMLElements("spectator");
        for (int i = 0; i < spectators.size(); ++i) {
            Elements moleculeNodes = ((CMLElement)spectators.get(i)).getChildCMLElements("molecule");
            moleculeList.add((CMLMolecule)moleculeNodes.get(reactOrProd));
        }
        return moleculeList;
    }

    public void removeOrphanSubstances() {
        CMLSubstanceList substanceList = (CMLSubstanceList)this.getFirstCMLChild("substanceList");
        if (substanceList != null) {
            Elements substances = substanceList.getChildCMLElements("substance");
            for (int i = 0; i < substances.size(); ++i) {
                Elements childNodes = substances.get(i).getChildElements();
                if (childNodes.size() != 1 || !(childNodes.get(0) instanceof CMLName)) continue;
                substances.get(i).detach();
            }
        }
    }

    @Override
    public List<CMLAtom> getAtoms() {
        return CMLReaction.getAtoms(this);
    }

    @Override
    public List<CMLBond> getBonds() {
        return CMLReaction.getBonds(this);
    }

    @Override
    public List<CMLFormula> getFormulas() {
        return CMLReaction.getFormulas(this);
    }

    @Override
    public List<CMLMolecule> getMolecules() {
        return CMLReaction.getMolecules(this);
    }

    public void addReactant(CMLReactant reactant) {
        CMLReactantList reactantList = this.getOrCreateReactantList();
        reactantList.addReactant(reactant);
    }

    public void addReactant(CMLMolecule molecule) {
        CMLReactant reactant = new CMLReactant();
        reactant.addMolecule(molecule);
        this.addReactant(reactant);
    }

    public CMLReactantList getOrCreateReactantList() {
        CMLReactantList reactantList = this.getReactantList();
        if (reactantList == null) {
            reactantList = new CMLReactantList();
            this.addReactantList(reactantList);
        }
        return reactantList;
    }

    public void addProduct(CMLProduct product) {
        CMLProductList productList = this.getOrCreateProductList();
        productList.addProduct(product);
    }

    public void addProduct(CMLMolecule molecule) {
        CMLProduct product = new CMLProduct();
        product.addMolecule(molecule);
        this.addProduct(product);
    }

    public CMLProductList getOrCreateProductList() {
        CMLProductList productList = this.getProductList();
        if (productList == null) {
            productList = new CMLProductList();
            this.addProductList(productList);
        }
        return productList;
    }

    static List<CMLAtom> getAtoms(ReactionComponent component) {
        ArrayList<CMLAtom> atomList = new ArrayList<CMLAtom>();
        List<CMLElement> elementList = ((CMLElement)((Object)component)).getElements(".//cml:atom");
        for (CMLElement element : elementList) {
            atomList.add((CMLAtom)element);
        }
        return atomList;
    }

    static List<CMLBond> getBonds(ReactionComponent component) {
        ArrayList<CMLBond> bondList = new ArrayList<CMLBond>();
        List<CMLElement> elementList = ((CMLElement)((Object)component)).getElements(".//cml:bond");
        for (CMLElement element : elementList) {
            bondList.add((CMLBond)element);
        }
        return bondList;
    }

    static List<CMLFormula> getFormulas(ReactionComponent component) {
        ArrayList<CMLFormula> formulaList = new ArrayList<CMLFormula>();
        List<CMLElement> elementList = ((CMLElement)((Object)component)).getElements(".//cml:formula");
        for (CMLElement element : elementList) {
            formulaList.add((CMLFormula)element);
        }
        return formulaList;
    }

    static List<CMLFormula> getOrCreateFormulas(ReactionComponent component) {
        return CMLReaction.getFormulas(component);
    }

    static List<CMLMolecule> getMolecules(ReactionComponent component) {
        ArrayList<CMLMolecule> moleculeList = new ArrayList<CMLMolecule>();
        List<CMLElement> elementList = ((CMLElement)((Object)component)).getElements(".//cml:molecule");
        for (CMLElement element : elementList) {
            moleculeList.add((CMLMolecule)element);
        }
        return moleculeList;
    }

    static List<ReactionComponent> getReactionComponentDescendants(ReactionComponent component, boolean nested) {
        ArrayList<ReactionComponent> componentList = new ArrayList<ReactionComponent>();
        List<CMLElement> childElements = ((CMLElement)((Object)component)).getChildCMLElements();
        for (CMLElement child : childElements) {
            if (!(child instanceof ReactionComponent)) continue;
            componentList.add((ReactionComponent)((Object)child));
            if (!nested) continue;
            List<ReactionComponent> descendantList = CMLReaction.getReactionComponentDescendants((ReactionComponent)((Object)child), nested);
            componentList.addAll(descendantList);
        }
        return componentList;
    }

    public List<CMLReactant> getDescendantReactants() {
        List<CMLElement> elems = this.getElements(".//cml:reactant");
        ArrayList<CMLReactant> productList = new ArrayList<CMLReactant>();
        for (CMLElement elem : elems) {
            productList.add((CMLReactant)elem);
        }
        return productList;
    }

    public List<CMLProduct> getDescendantProducts() {
        List<CMLElement> elems = this.getElements(".//cml:product");
        ArrayList<CMLProduct> productList = new ArrayList<CMLProduct>();
        for (CMLElement elem : elems) {
            productList.add((CMLProduct)elem);
        }
        return productList;
    }

    public List<CMLMolecule> getMolecules(Component type) {
        String typeS = null;
        if (type == null) {
            throw new RuntimeException("null component type");
        }
        if (!Component.PRODUCT.equals((Object)type)) {
            if (Component.REACTANT.equals((Object)type)) {
                typeS = "cml:reactant";
            } else if (Component.SPECTATOR.equals((Object)type)) {
                typeS = "cml:spectator";
            } else {
                throw new RuntimeException("bad component type: " + (Object)((Object)type));
            }
        }
        ArrayList<CMLMolecule> moleculeList = new ArrayList<CMLMolecule>();
        Nodes nodes = null;
        if (typeS != null) {
            if (typeS.equals((Object)Component.ANY)) {
                nodes = this.query(".//cml:molecule", CMLConstants.CML_XPATH);
            } else {
                String qs = ".//" + typeS + "/cml:molecule";
                nodes = this.query(qs, CMLConstants.CML_XPATH);
            }
        }
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                moleculeList.add((CMLMolecule)nodes.get(i));
            }
        }
        return moleculeList;
    }

    public List<CMLAtom> getAtoms(Component type) {
        ArrayList<CMLAtom> allAtomList = new ArrayList<CMLAtom>();
        List<CMLMolecule> moleculeList = this.getMolecules(type);
        for (CMLMolecule molecule : moleculeList) {
            List<CMLAtom> atomList = molecule.getAtoms();
            for (CMLAtom atom : atomList) {
                allAtomList.add(atom);
            }
        }
        return allAtomList;
    }

    public List<CMLBond> getBonds(Component type) {
        ArrayList<CMLBond> allBondList = new ArrayList<CMLBond>();
        List<CMLMolecule> moleculeList = this.getMolecules(type);
        for (CMLMolecule molecule : moleculeList) {
            List<CMLBond> bondList = molecule.getBonds();
            for (CMLBond bond : bondList) {
                allBondList.add(bond);
            }
        }
        return allBondList;
    }

    public List<CMLSpectator> getDescendantSpectators() {
        List<CMLElement> elems = this.getElements(".//cml:spectator");
        ArrayList<CMLSpectator> spectatorList = new ArrayList<CMLSpectator>();
        for (CMLElement elem : elems) {
            spectatorList.add((CMLSpectator)elem);
        }
        return spectatorList;
    }

    public void addSpectator(CMLMolecule molecule) {
        CMLSpectator spectator = new CMLSpectator();
        spectator.addMolecule(molecule);
        this.addSpectator(spectator);
    }

    public void addSpectator(CMLSpectator spectator) {
        CMLSpectatorList spectatorList = this.getOrCreateSpectatorList();
        spectatorList.addSpectator(spectator);
    }

    public CMLSpectatorList getOrCreateSpectatorList() {
        CMLElements<CMLSpectatorList> spectatorLists = this.getSpectatorListElements();
        CMLSpectatorList spectatorList = null;
        if (spectatorLists.size() == 0) {
            spectatorList = new CMLSpectatorList();
            this.addSpectatorList(spectatorList);
        } else {
            spectatorList = spectatorLists.get(0);
        }
        return spectatorList;
    }

    static /* synthetic */ String access$000() {
        return ANYTAG;
    }

    public static enum Component {
        REACTANT("reactant", 0),
        PRODUCT("product", 1),
        SPECTATOR("spectator", 2),
        ANY(CMLReaction.access$000(), 3),
        REACTANTLIST("reactantList", 0),
        PRODUCTLIST("productList", 1),
        SPECTATORLIST("spectatorList", 2),
        ANYLIST(CMLReaction.access$000(), 3);

        public String name;
        public int number;

        private Component(String name, int number) {
            this.name = name;
            this.number = number;
        }
    }

    @Deprecated
    public static enum Index {
        REACTANT_I(1);

        public int index;

        private Index(int i) {
            this.index = i;
        }
    }

    public static enum Mapping {
        FROM_SPECTATOR_PRODUCT_TO_REACTANT,
        FROM_PRODUCT_TO_REACTANT,
        MAP_REACTION_ATOM_MAP_COMPLETE;

    }
}

