/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import moa.gui.experimentertab.ImageChart;
import moa.gui.experimentertab.ImagePanel;

public class ImageTreePanel
extends JPanel
implements TreeSelectionListener {
    private JPanel imgPanel;
    private JTree tree;
    private ImageChart[] chart;
    private ImagePanel[] chartPanel;

    public ImageTreePanel(ImageChart[] chart) {
        super(new GridLayout(1, 0));
        this.chart = chart;
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Images");
        this.imgPanel = new JPanel();
        this.imgPanel.setLayout(new GridLayout(1, 0));
        this.createNodes(top);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        this.tree.setSelectionRow(1);
        this.tree.addTreeSelectionListener(this);
        ImageIcon leafIcon = new ImageIcon("icon/img.png");
        if (leafIcon != null) {
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            renderer.setLeafIcon(leafIcon);
            this.tree.setCellRenderer(renderer);
        }
        this.imgPanel.updateUI();
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setMinimumSize(new Dimension(100, 50));
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setTopComponent(treeView);
        splitPane.setBottomComponent(this.imgPanel);
        splitPane.setDividerLocation(100);
        splitPane.setPreferredSize(new Dimension(500, 300));
        this.add(splitPane);
    }

    private void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode child = null;
        for (ImageChart chart1 : this.chart) {
            child = new DefaultMutableTreeNode(chart1);
            ImagePanel chPanel = new ImagePanel(chart1.getChart());
            chPanel.setMouseWheelEnabled(true);
            chPanel.setMouseZoomable(true);
            chPanel.repaint();
            this.imgPanel.removeAll();
            this.imgPanel.add((Component)((Object)chPanel));
            this.imgPanel.updateUI();
            top.add(child);
        }
    }

    public static void main(String[] args) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            ImageChart chart = (ImageChart)nodeInfo;
            ImagePanel chPanel = new ImagePanel(chart.getChart());
            chPanel.setMouseWheelEnabled(true);
            chPanel.setMouseZoomable(true);
            chPanel.repaint();
            this.imgPanel.removeAll();
            this.imgPanel.add((Component)((Object)chPanel));
            this.imgPanel.updateUI();
        }
    }

    public ImageChart[] getChart() {
        return this.chart;
    }
}

