/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.border;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.util.CachedPainter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class QuaquaNativeBorder
extends CachedPainter
implements Border,
VisualMargin {
    protected OSXAquaPainter painter = new OSXAquaPainter();
    protected Insets imageInsets;
    protected Insets borderInsets;
    protected static final int ARG_ACTIVE = 0;
    protected static final int ARG_PRESSED = 1;
    protected static final int ARG_DISABLED = 2;
    protected static final int ARG_ROLLOVER = 3;
    protected static final int ARG_SELECTED = 4;
    protected static final int ARG_FOCUSED = 5;
    protected static final int ARG_SIZE_VARIANT = 6;
    protected static final int ARG_SEGPOS = 8;
    protected static final int ARG_WIDGET = 11;
    protected static final int ARG_TRAILING_SEPARATOR = 18;
    protected static final int ARG_ORIENTATION = 19;

    public QuaquaNativeBorder(OSXAquaPainter.Widget widget) {
        this(12, widget, new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0));
    }

    public QuaquaNativeBorder(int cacheSize, OSXAquaPainter.Widget widget) {
        this(cacheSize, widget, new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0));
    }

    public QuaquaNativeBorder(OSXAquaPainter.Widget widget, Insets imageInsets, Insets borderInsets) {
        this(12, widget, imageInsets, borderInsets);
    }

    public QuaquaNativeBorder(int cacheSize, OSXAquaPainter.Widget widget, Insets imageInsets, Insets borderInsets) {
        super(cacheSize);
        this.painter.setWidget(widget);
        this.imageInsets = imageInsets;
        this.borderInsets = borderInsets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        OSXAquaPainter.Size size;
        OSXAquaPainter.State state;
        Insets vm = this.getVisualMargin(c);
        x += vm.left;
        y += vm.top;
        width -= vm.left + vm.right;
        height -= vm.top + vm.bottom;
        int args = 0;
        if (QuaquaUtilities.isOnActiveWindow(c)) {
            state = OSXAquaPainter.State.active;
            args |= 1;
        } else {
            state = OSXAquaPainter.State.inactive;
        }
        if (!c.isEnabled()) {
            state = OSXAquaPainter.State.disabled;
            args |= 4;
        }
        this.painter.setState(state);
        boolean isFocused = QuaquaUtilities.isFocused(c);
        args |= isFocused ? 32 : 0;
        this.painter.setValueByKey(OSXAquaPainter.Key.focused, isFocused ? 1.0 : 0.0);
        switch (QuaquaUtilities.getSizeVariant(c)) {
            default: {
                size = OSXAquaPainter.Size.regular;
                break;
            }
            case SMALL: {
                size = OSXAquaPainter.Size.small;
                break;
            }
            case MINI: {
                size = OSXAquaPainter.Size.mini;
            }
        }
        this.painter.setSize(size);
        this.paint(c, g, x, y, width, height, args |= size.getId() << 6);
    }

    protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
        return new BufferedImage(w, h, 3);
    }

    protected void paintToImage(Component c, Image img, int w, int h, Object args) {
        Graphics2D ig = (Graphics2D)img.getGraphics();
        ig.setColor(new Color(0, true));
        ig.setComposite(AlphaComposite.getInstance(2));
        ig.fillRect(0, 0, img.getWidth(null), img.getHeight(null));
        ig.dispose();
        this.painter.paint((BufferedImage)img, this.imageInsets.left, this.imageInsets.top, w - this.imageInsets.left - this.imageInsets.right, h - this.imageInsets.top - this.imageInsets.bottom);
    }

    protected void paintToImage(Component c, Graphics g, int w, int h, Object args) {
        BufferedImage img = (BufferedImage)this.createImage(c, (w / 32 + 1) * 32, (h / 32 + 1) * 32, null);
        this.paintToImage(c, img, w, h, args);
        g.drawImage(img, 0, 0, null);
        img.flush();
    }

    public Insets getBorderInsets(Component c) {
        return (Insets)this.borderInsets.clone();
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public Insets getVisualMargin(Component c) {
        Insets vm = null;
        if (c instanceof JComponent) {
            vm = (Insets)((JComponent)c).getClientProperty("Quaqua.Component.visualMargin");
        }
        return vm == null ? new Insets(0, 0, 0, 0) : (Insets)vm.clone();
    }

    public static class UIResource
    extends QuaquaNativeBorder
    implements javax.swing.plaf.UIResource {
        public UIResource(OSXAquaPainter.Widget widget) {
            super(widget);
        }

        public UIResource(OSXAquaPainter.Widget widget, Insets imageInsets, Insets borderInsets) {
            super(widget, imageInsets, borderInsets);
        }
    }
}

