/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl.lazyness;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.impl.IntVarLazyLit;
import org.chocosolver.solver.variables.impl.lazyness.ILazyBound;

public class WeakBound
implements ILazyBound {
    final TIntIntHashMap val2svar = new TIntIntHashMap(16, 1.5f, -1, -1);
    final TIntArrayList lbs = new TIntArrayList();
    final TIntArrayList ubs;
    final IStateInt li;
    final IStateInt hi;

    public WeakBound(Model model) {
        this.lbs.add(0);
        this.li = model.getEnvironment().makeInt(0);
        this.ubs = new TIntArrayList();
        this.ubs.add(1);
        this.hi = model.getEnvironment().makeInt(0);
    }

    @Override
    public int currentMinVar() {
        return this.lbs.get(this.li.get());
    }

    @Override
    public int currentMaxVar() {
        return this.ubs.get(this.hi.get());
    }

    @Override
    public int getSATVar(int value, IntVarLazyLit cvar, MiniSat sat) {
        int svar = this.val2svar.get(value);
        if (svar != -1) {
            return svar;
        }
        int var = sat.newVariable(new MiniSat.ChannelInfo(cvar, 1, 1, value));
        this.val2svar.put(value, var);
        return var;
    }

    @Override
    public void channelMin(int value, MiniSat sat, Reason r) {
        int i = this.li.add(1);
        if (i == this.lbs.size()) {
            this.lbs.add(-1);
        }
        this.lbs.setQuick(i, this.val2svar.get(value));
    }

    @Override
    public void channelMax(int value, MiniSat sat, Reason r) {
        int i = this.hi.add(1);
        if (i == this.ubs.size()) {
            this.ubs.add(-1);
        }
        this.ubs.setQuick(i, this.val2svar.get(value));
    }
}

