/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.Patterns;
import dr.evolution.alignment.SiteList;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class PatternSubSetParser
extends AbstractXMLObjectParser {
    public static final String PATTERNS_SUB_SET = "patternSubSet";
    public static final String SUB_SET = "subSet";
    public static final String SUB_SET_COUNT = "subSetCount";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("subSet", true, "Which subset of patterns to use (out of subSetCount)"), AttributeRule.newIntegerRule("subSetCount", true, "The number of subsets"), new ElementRule(SiteList.class)};

    @Override
    public String getParserName() {
        return PATTERNS_SUB_SET;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        SiteList siteList = (SiteList)xMLObject.getChild(SiteList.class);
        int n = 0;
        int n2 = 0;
        if (xMLObject.hasAttribute(SUB_SET) && (n = xMLObject.getIntegerAttribute(SUB_SET) - 1) < 0) {
            throw new XMLParseException("illegal 'subSet' attribute in patterns element");
        }
        if (xMLObject.hasAttribute(SUB_SET_COUNT) && (n2 = xMLObject.getIntegerAttribute(SUB_SET_COUNT)) < 0) {
            throw new XMLParseException("illegal 'subSetCount' attribute in patterns element");
        }
        Patterns patterns = new Patterns(siteList, 0, 0, 1, n, n2);
        if (xMLObject.hasAttribute("id")) {
            Logger logger = Logger.getLogger("dr.evoxml");
            logger.info("Pattern subset '" + xMLObject.getId() + "' created from '" + siteList.getId() + "' (" + (n + 1) + "/" + n2 + ")");
            logger.info("  pattern count = " + patterns.getPatternCount());
        }
        return patterns;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A weighted list of the unique site patterns (unique columns) in an alignment.";
    }

    @Override
    public Class getReturnType() {
        return PatternList.class;
    }
}

