/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.multidimensionalscaling;

import dr.inference.multidimensionalscaling.MultiDimensionalScalingCore;
import dr.inference.multidimensionalscaling.MultiDimensionalScalingLayout;
import dr.math.distributions.NormalDistribution;

public class NewMultiDimensionalScalingCoreImpl
implements MultiDimensionalScalingCore {
    private int embeddingDimension;
    private boolean isLeftTruncated = false;
    private MultiDimensionalScalingLayout layout;
    private int nonMissingObservationCount;
    private double precision;
    private double storedPrecision;
    private int updatedLocation = -1;
    private double[][] observations;
    private double[][] locations;
    private double[][] storedLocations;
    private boolean incrementsKnown = false;
    private boolean sumOfIncrementsKnown = false;
    private double[][] increments;
    private double[] storedIncrements;
    private double sumOfIncrements;
    private double storedSumOfIncrements;

    @Override
    public void initialize(int n, int n2, long l) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void initialize(int n, MultiDimensionalScalingLayout multiDimensionalScalingLayout, long l) {
        this.embeddingDimension = n;
        this.layout = multiDimensionalScalingLayout;
        this.observations = new double[multiDimensionalScalingLayout.rowLocationCount][multiDimensionalScalingLayout.columnLocationCount];
        this.increments = new double[multiDimensionalScalingLayout.rowLocationCount][multiDimensionalScalingLayout.columnLocationCount];
        this.storedIncrements = null;
        this.incrementsKnown = false;
        this.sumOfIncrementsKnown = false;
        this.isLeftTruncated = (l & 0x20L) != 0L;
        this.updatedLocation = -1;
        this.locations = new double[multiDimensionalScalingLayout.uniqueLocationCount][n];
        this.storedLocations = new double[multiDimensionalScalingLayout.uniqueLocationCount][n];
        this.nonMissingObservationCount = multiDimensionalScalingLayout.observationCount;
    }

    @Override
    public void setNonMissingObservationCount(int n) {
        this.nonMissingObservationCount = n;
    }

    @Override
    public void setPairwiseData(double[] dArray) {
        int n;
        if (dArray.length != this.layout.observationCount) {
            throw new RuntimeException("Observation data is not the correct dimension");
        }
        int n2 = 0;
        for (n = 0; n < this.layout.rowLocationCount; ++n) {
            System.arraycopy(dArray, n2, this.observations[n], 0, this.layout.columnLocationCount);
            n2 += this.layout.columnLocationCount;
        }
        if (this.layout.isSymmetric()) {
            for (n = 0; n < this.layout.rowLocationCount; ++n) {
                this.observations[n][n] = Double.NaN;
            }
        }
        this.makeDirty();
    }

    @Override
    public double[] getPairwiseData() {
        double[] dArray = new double[this.layout.observationCount];
        int n = 0;
        for (int i = 0; i < this.layout.rowLocationCount; ++i) {
            System.arraycopy(this.observations[i], 0, dArray, n, this.layout.columnLocationCount);
            n += this.layout.columnLocationCount;
        }
        return dArray;
    }

    @Override
    public int getInternalDimension() {
        return this.embeddingDimension;
    }

    @Override
    public void setParameters(double[] dArray) {
        this.precision = dArray[0];
        if (this.isLeftTruncated) {
            this.incrementsKnown = false;
            this.sumOfIncrementsKnown = false;
        }
    }

    @Override
    public void updateLocation(int n, double[] dArray) {
        if (this.updatedLocation != -1 || n == -1) {
            this.incrementsKnown = false;
            this.storedIncrements = null;
        }
        if (n != -1) {
            this.updatedLocation = n;
            if (dArray.length != this.embeddingDimension) {
                throw new RuntimeException("Location is not the correct dimension");
            }
            System.arraycopy(dArray, 0, this.locations[n], 0, this.embeddingDimension);
        } else {
            if (dArray.length != this.embeddingDimension * this.layout.uniqueLocationCount) {
                throw new RuntimeException("Location is the not correct dimension");
            }
            int n2 = 0;
            for (int i = 0; i < this.layout.uniqueLocationCount; ++i) {
                System.arraycopy(dArray, n2, this.locations[i], 0, this.embeddingDimension);
                n2 += this.embeddingDimension;
            }
        }
        this.sumOfIncrementsKnown = false;
    }

    @Override
    public double calculateLogLikelihood() {
        if (!this.sumOfIncrementsKnown) {
            if (!this.incrementsKnown) {
                this.computeSumOfSquaredResiduals();
            } else {
                this.updateSumOfSquaredResiduals();
            }
            this.sumOfIncrementsKnown = true;
        }
        double d = 0.5 * (Math.log(this.precision) - Math.log(Math.PI * 2)) * (double)this.nonMissingObservationCount;
        d = this.isLeftTruncated ? (d -= this.sumOfIncrements) : (d -= 0.5 * this.precision * this.sumOfIncrements);
        return d;
    }

    @Override
    public void storeState() {
        this.storedSumOfIncrements = this.sumOfIncrements;
        this.storedIncrements = null;
        for (int i = 0; i < this.layout.uniqueLocationCount; ++i) {
            System.arraycopy(this.locations[i], 0, this.storedLocations[i], 0, this.embeddingDimension);
        }
        this.updatedLocation = -1;
        this.storedPrecision = this.precision;
    }

    @Override
    public void restoreState() {
        this.sumOfIncrements = this.storedSumOfIncrements;
        this.sumOfIncrementsKnown = true;
        if (this.storedIncrements != null) {
            System.arraycopy(this.storedIncrements, 0, this.increments[this.updatedLocation], 0, this.layout.columnLocationCount);
            this.incrementsKnown = true;
        } else {
            this.incrementsKnown = false;
        }
        double[][] dArray = this.storedLocations;
        this.storedLocations = this.locations;
        this.locations = dArray;
        this.precision = this.storedPrecision;
    }

    @Override
    public void acceptState() {
        if (this.storedIncrements != null) {
            for (int i = 0; i < this.layout.rowLocationCount; ++i) {
                this.increments[i][this.updatedLocation] = this.increments[this.updatedLocation][i];
            }
        }
    }

    @Override
    public void getGradient(double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void getObservationGradient(double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void makeDirty() {
        this.sumOfIncrementsKnown = false;
        this.incrementsKnown = false;
    }

    private void computeSumOfSquaredResiduals() {
        double d = Math.sqrt(this.precision);
        double d2 = 0.5 * this.precision;
        this.sumOfIncrements = 0.0;
        for (int i = 0; i < this.layout.rowLocationCount; ++i) {
            for (int j = 0; j < this.layout.columnLocationCount; ++j) {
                if (Double.isNaN(this.observations[i][j])) continue;
                double d3 = this.calculateDistance(this.locations[i], this.locations[j]);
                double d4 = d3 - this.observations[i][j];
                double d5 = d4 * d4;
                if (this.isLeftTruncated) {
                    d5 = d2 * d5;
                    d5 += this.computeTruncation(d3, d);
                }
                this.increments[i][j] = d5;
                this.sumOfIncrements += d5;
            }
        }
        if (this.layout.isSymmetric()) {
            this.sumOfIncrements /= 2.0;
        }
        this.incrementsKnown = true;
        this.sumOfIncrementsKnown = true;
    }

    private void updateSumOfSquaredResiduals() {
        double d = Math.sqrt(this.precision);
        double d2 = 0.5 * this.precision;
        double d3 = 0.0;
        int n = this.updatedLocation;
        this.storedIncrements = new double[this.layout.columnLocationCount];
        System.arraycopy(this.increments[n], 0, this.storedIncrements, 0, this.layout.columnLocationCount);
        for (int i = 0; i < this.layout.columnLocationCount; ++i) {
            if (Double.isNaN(this.observations[n][i])) continue;
            double d4 = this.calculateDistance(this.locations[n], this.locations[i]);
            double d5 = d4 - this.observations[n][i];
            double d6 = d5 * d5;
            if (this.isLeftTruncated) {
                d6 = d2 * d6;
                d6 += this.computeTruncation(d4, d);
            }
            d3 += d6 - this.increments[n][i];
            this.increments[n][i] = d6;
        }
        this.sumOfIncrements += d3;
    }

    private double calculateDistance(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < this.embeddingDimension; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    private double computeTruncation(double d, double d2) {
        return NormalDistribution.standardCDF(d * d2, true);
    }
}

