*-------------------------------------------------------------------------*
|              SAS DATA DEFINITION STATEMENTS FOR ICPSR 2905              |
|                                                                         |
|          UNIFORM CRIME REPORTING PROGRAM DATA: [UNITED STATES]          |
|                                                                         |
|                   PROPERTY STOLEN AND RECOVERED, 1998                   |
|                                                                         |
|                                                                         |
| This SAS setup file contains the following statements:                  |
|                                                                         |
| PROC FORMAT:  Creates user-defined formats. Formats replace original    |
| value codes with value code descriptions. Formats may not be present    |
| for all variables in the data file.                                     |
|                                                                         |
| DATA:  Begins a SAS data step and names an output SAS data set.         |
|                                                                         |
| INFILE:  Specifies the input data file to be read with the input        |
| statement. Users must replace "file-specification" with a complete      |
| statement of the location of the data file.                             |
|                                                                         |
| INPUT:  Assigns the name, type, decimal specification (if any), and     |
| identifies variable beginning and ending column locations.              |
|                                                                         |
| LABEL:  Assigns descriptive labels to variables. Variable labels and    |
| variable names may be identical for certain variables.                  |
|                                                                         |
| FORMAT:  Associates the formats created by the PROC FORMAT step with    |
| the variables named in the INPUT statement. Format statements may not   |
| be present for all variables in the data file.                           
|                                                                         |
| NOTE:  Users should modify this SAS setup file to suit their specific   |
| needs. PROC FORMAT and FORMAT sections have been marked by SAS comment  |
| statements. To include these sections in a final SAS setup, users       |
| should remove the SAS comment statements from the desired section(s).   |
*-------------------------------------------------------------------------;
                                                                           
* SAS PROC FORMAT;                                                         
                                                                           
/*                                                                         
PROC FORMAT;                                                               
   VALUE V2FT (MAX=40)                                                     
   1 = "Alabama"                                                           
   2 = "Arizona"                                                           
   3 = "Arkansas"                                                          
   4 = "California"                                                        
   5 = "Colorado"                                                          
   6 = "Connecticut"                                                       
   7 = "Delaware"                                                          
   8 = "District of Columbia"                                              
   9 = "Florida"                                                           
   10 = "Georgia"                                                          
   11 = "Idaho"                                                            
   12 = "Illinois"                                                         
   13 = "Indiana"                                                          
   14 = "Iowa"                                                             
   15 = "Kansas"                                                           
   16 = "Kentucky"                                                         
   17 = "Louisiana"                                                        
   18 = "Maine"                                                            
   19 = "Maryland"                                                         
   20 = "Massachusetts"                                                    
   21 = "Michigan"                                                         
   22 = "Minnesota"                                                        
   23 = "Mississippi"                                                      
   24 = "Missouri"                                                         
   25 = "Montana"                                                          
   26 = "Nebraska"                                                         
   27 = "Nevada"                                                           
   28 = "New Hampshire"                                                    
   29 = "New Jersey"                                                       
   30 = "New Mexico"                                                       
   31 = "New York"                                                         
   32 = "North Carolina"                                                   
   33 = "North Dakota"                                                     
   34 = "Ohio"                                                             
   35 = "Oklahoma"                                                         
   36 = "Oregon"                                                           
   37 = "Pennsylvania"                                                     
   38 = "Rhode Island"                                                     
   39 = "South Carolina"                                                   
   40 = "South Dakota"                                                     
   41 = "Tennessee"                                                        
   42 = "Texas"                                                            
   43 = "Utah"                                                             
   44 = "Vermont"                                                          
   45 = "Virginia"                                                         
   46 = "Washington"                                                       
   47 = "West Virginia"                                                    
   48 = "Wisconsin"                                                        
   49 = "Wyoming"                                                          
   50 = "Alaska"                                                           
   51 = "Hawaii"                                                           
   52 = "Canal Zone"                                                       
   53 = "Puerto Rico"                                                      
   54 = "American Samoa"                                                   
   55 = "Guam"                                                             
   62 = "Virgin Islands";                                                  
   VALUE $V4FT                                                             
   "0" = "Possessions as Puerto Rico, Guam"                                
   "1" = "All cities 250,000 +"                                            
   "1A" = "Cit 1,000,000 +"                                                
   "1B" = "Cit 500,000-999,999"                                            
   "1C" = "Cit 250,000-499,999"                                            
   "2" = "Cit 100,000-249,999"                                             
   "3" = "Cit 50,000-99,999"                                               
   "4" = "Cit 25,000-49,999"                                               
   "5" = "Cit 10,000-24,999"                                               
   "6" = "Cit 2,500-9,999"                                                 
   "7" = "Cit < 2,500"                                                     
   "8" = "Non-MSA counties"                                                
   "8A" = "Non-MSA co. 100,000 +"                                          
   "8B" = "Non-MSA co. 25,000-99,999"                                      
   "8C" = "Non-MSA co. 10,000-24,999"                                      
   "8D" = "Non-MSA co. < 10,000"                                           
   "8E" = "Non-MSA state police"                                           
   "9" = "MSA counties"                                                    
   "9A" = "MSA co. 100,000 +"                                              
   "9B" = "MSA co. 25,000-99,999"                                          
   "9C" = "MSA co. 10,000-24,999"                                          
   "9D" = "MSA co. < 10,000"                                               
   "9E" = "MSA state police";                                              
   VALUE V5FT (MAX=40)                                                     
   0 = "Possessions"                                                       
   1 = "New England"                                                       
   2 = "Middle Atlantic"                                                   
   3 = "East North Central"                                                
   4 = "West North Central"                                                
   5 = "South Atlantic"                                                    
   6 = "East South Central"                                                
   7 = "West South Central"                                                
   8 = "Mountain"                                                          
   9 = "Pacific";                                                          
   VALUE V11FT (MAX=40)                                                    
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V104FT (MAX=40)                                                   
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V197FT (MAX=40)                                                   
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V290FT (MAX=40)                                                   
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V383FT (MAX=40)                                                   
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V476FT (MAX=40)                                                   
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V569FT (MAX=40)                                                   
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V662FT (MAX=40)                                                   
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V755FT (MAX=40)                                                   
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V848FT (MAX=40)                                                   
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V941FT (MAX=40)                                                   
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
   VALUE V1034FT (MAX=40)                                                  
   0 = "Not reported"                                                      
   1 = "Regular";                                                          
*/                                                                         
                                                                           
* SAS DATA, INFILE, INPUT STATEMENTS;                                      
                                                                           
DATA;                                                                      
INFILE "file-specification" LRECL=5919;                                    
INPUT                                                                      
   V1 1-1                   V2 2-3                   V3 $ 4-10             
   V4 $ 11-12               V5 13-13                 V6 14-17              
   V7 $ 18-20               V8 $ 21-44               V9 $ 45-50            
   V10 51-57                V11 58-58                V12 59-60             
   V13 61-63                V14 64-67                V15 68-70             
   V16 71-72                V17 73-74                V18 75-77             
   V19 78-79                V20 80-82                V21 83-86             
   V22 87-89                V23 90-93                V24 94-97             
   V25 98-100               V26 101-103              V27 104-106           
   V28 107-110              V29 111-114              V30 115-118           
   V31 119-122              V32 123-127              V33 128-131           
   V34 132-134              V35 135-137              V36 138-141           
   V37 142-145              V38 146-149              V39 150-152           
   V40 153-156              V41 157-158              V42 159-162           
   V43 163-167              V44 168-172              V45 173-179           
   V46 180-185              V47 186-190              V48 191-196           
   V49 197-202              V50 203-208              V51 209-214           
   V52 215-221              V53 222-228              V54 229-235           
   V55 236-242              V56 243-249              V57 250-256           
   V58 257-263              V59 264-271              V60 272-279           
   V61 280-285              V62 286-291              V63 292-299           
   V64 300-307              V65 308-315              V66 316-321           
   V67 322-327              V68 328-334              V69 335-341           
   V70 342-347              V71 348-352              V72 353-359           
   V73 360-364              V74 365-371              V75 372-375           
   V76 376-378              V77 379-382              V78 383-386           
   V79 387-393              V80 394-400              V81 401-407           
   V82 408-415              V83 416-422              V84 423-429           
   V85 430-435              V86 436-442              V87 443-448           
   V88 449-453              V89 454-461              V90 462-469           
   V91 470-475              V92 476-480              V93 481-486           
   V94 487-494              V95 495-500              V96 501-506           
   V97 507-511              V98 512-517              V99 518-522           
   V100 523-527             V101 528-534             V102 535-542          
   V103 543-545             V104 546-546             V105 547-548          
   V106 549-551             V107 552-555             V108 556-558          
   V109 559-560             V110 561-562             V111 563-565          
   V112 566-567             V113 568-570             V114 571-574          
   V115 575-577             V116 578-581             V117 582-584          
   V118 585-587             V119 588-590             V120 591-593          
   V121 594-597             V122 598-601             V123 602-605          
   V124 606-609             V125 610-614             V126 615-618          
   V127 619-621             V128 622-624             V129 625-628          
   V130 629-632             V131 633-636             V132 637-639          
   V133 640-643             V134 644-645             V135 646-649          
   V136 650-654             V137 655-659             V138 660-665          
   V139 666-672             V140 673-677             V141 678-683          
   V142 684-689             V143 690-695             V144 696-701          
   V145 702-708             V146 709-715             V147 716-722          
   V148 723-729             V149 730-736             V150 737-743          
   V151 744-749             V152 750-756             V153 757-764          
   V154 765-770             V155 771-775             V156 776-783          
   V157 784-791             V158 792-799             V159 800-805          
   V160 806-811             V161 812-817             V162 818-824          
   V163 825-831             V164 832-836             V165 837-843          
   V166 844-849             V167 850-857             V168 858-861          
   V169 862-864             V170 865-868             V171 869-871          
   V172 872-878             V173 879-885             V174 886-892          
   V175 893-900             V176 901-907             V177 908-914          
   V178 915-920             V179 921-926             V180 927-932          
   V181 933-938             V182 939-946             V183 947-954          
   V184 955-960             V185 961-966             V186 967-972          
   V187 973-980             V188 981-986             V189 987-991          
   V190 992-996             V191 997-1001            V192 1002-1006        
   V193 1007-1010           V194 1011-1016           V195 1017-1024        
   V196 1025-1027           V197 1028-1028           V198 1029-1030        
   V199 1031-1033           V200 1034-1037           V201 1038-1040        
   V202 1041-1042           V203 1043-1044           V204 1045-1047        
   V205 1048-1049           V206 1050-1052           V207 1053-1056        
   V208 1057-1059           V209 1060-1063           V210 1064-1066        
   V211 1067-1069           V212 1070-1072           V213 1073-1075        
   V214 1076-1079           V215 1080-1083           V216 1084-1087        
   V217 1088-1091           V218 1092-1096           V219 1097-1100        
   V220 1101-1103           V221 1104-1106           V222 1107-1110        
   V223 1111-1114           V224 1115-1118           V225 1119-1121        
   V226 1122-1125           V227 1126-1127           V228 1128-1131        
   V229 1132-1136           V230 1137-1141           V231 1142-1147        
   V232 1148-1153           V233 1154-1158           V234 1159-1163        
   V235 1164-1169           V236 1170-1176           V237 1177-1183        
   V238 1184-1190           V239 1191-1197           V240 1198-1204        
   V241 1205-1211           V242 1212-1218           V243 1219-1225        
   V244 1226-1232           V245 1233-1239           V246 1240-1247        
   V247 1248-1253           V248 1254-1259           V249 1260-1267        
   V250 1268-1275           V251 1276-1283           V252 1284-1289        
   V253 1290-1295           V254 1296-1302           V255 1303-1309        
   V256 1310-1316           V257 1317-1322           V258 1323-1329        
   V259 1330-1335           V260 1336-1342           V261 1343-1346        
   V262 1347-1349           V263 1350-1353           V264 1354-1356        
   V265 1357-1363           V266 1364-1370           V267 1371-1377        
   V268 1378-1385           V269 1386-1392           V270 1393-1399        
   V271 1400-1405           V272 1406-1412           V273 1413-1418        
   V274 1419-1424           V275 1425-1431           V276 1432-1439        
   V277 1440-1445           V278 1446-1452           V279 1453-1458        
   V280 1459-1466           V281 1467-1472           V282 1473-1479        
   V283 1480-1484           V284 1485-1490           V285 1491-1495        
   V286 1496-1500           V287 1501-1506           V288 1507-1514        
   V289 1515-1517           V290 1518-1518           V291 1519-1520        
   V292 1521-1523           V293 1524-1527           V294 1528-1530        
   V295 1531-1532           V296 1533-1534           V297 1535-1537        
   V298 1538-1539           V299 1540-1542           V300 1543-1546        
   V301 1547-1549           V302 1550-1553           V303 1554-1556        
   V304 1557-1559           V305 1560-1562           V306 1563-1565        
   V307 1566-1569           V308 1570-1573           V309 1574-1577        
   V310 1578-1581           V311 1582-1586           V312 1587-1590        
   V313 1591-1593           V314 1594-1596           V315 1597-1600        
   V316 1601-1604           V317 1605-1608           V318 1609-1611        
   V319 1612-1615           V320 1616-1617           V321 1618-1621        
   V322 1622-1626           V323 1627-1631           V324 1632-1637        
   V325 1638-1643           V326 1644-1648           V327 1649-1653        
   V328 1654-1659           V329 1660-1664           V330 1665-1670        
   V331 1671-1677           V332 1678-1683           V333 1684-1690        
   V334 1691-1697           V335 1698-1704           V336 1705-1711        
   V337 1712-1717           V338 1718-1725           V339 1726-1733        
   V340 1734-1739           V341 1740-1744           V342 1745-1752        
   V343 1753-1760           V344 1761-1768           V345 1769-1774        
   V346 1775-1780           V347 1781-1786           V348 1787-1793        
   V349 1794-1799           V350 1800-1805           V351 1806-1812        
   V352 1813-1817           V353 1818-1824           V354 1825-1829        
   V355 1830-1834           V356 1835-1839           V357 1840-1842        
   V358 1843-1849           V359 1850-1856           V360 1857-1863        
   V361 1864-1871           V362 1872-1878           V363 1879-1886        
   V364 1887-1892           V365 1893-1898           V366 1899-1904        
   V367 1905-1909           V368 1910-1916           V369 1917-1924        
   V370 1925-1930           V371 1931-1936           V372 1937-1942        
   V373 1943-1950           V374 1951-1955           V375 1956-1961        
   V376 1962-1967           V377 1968-1973           V378 1974-1978        
   V379 1979-1983           V380 1984-1989           V381 1990-1997        
   V382 1998-2000           V383 2001-2001           V384 2002-2003        
   V385 2004-2006           V386 2007-2010           V387 2011-2013        
   V388 2014-2015           V389 2016-2017           V390 2018-2020        
   V391 2021-2022           V392 2023-2025           V393 2026-2029        
   V394 2030-2032           V395 2033-2036           V396 2037-2039        
   V397 2040-2042           V398 2043-2045           V399 2046-2048        
   V400 2049-2052           V401 2053-2056           V402 2057-2060        
   V403 2061-2064           V404 2065-2069           V405 2070-2073        
   V406 2074-2076           V407 2077-2079           V408 2080-2083        
   V409 2084-2087           V410 2088-2091           V411 2092-2094        
   V412 2095-2098           V413 2099-2100           V414 2101-2104        
   V415 2105-2109           V416 2110-2114           V417 2115-2121        
   V418 2122-2127           V419 2128-2132           V420 2133-2138        
   V421 2139-2144           V422 2145-2150           V423 2151-2156        
   V424 2157-2163           V425 2164-2170           V426 2171-2177        
   V427 2178-2183           V428 2184-2190           V429 2191-2197        
   V430 2198-2204           V431 2205-2211           V432 2212-2219        
   V433 2220-2226           V434 2227-2232           V435 2233-2240        
   V436 2241-2248           V437 2249-2256           V438 2257-2262        
   V439 2263-2267           V440 2268-2273           V441 2274-2281        
   V442 2282-2288           V443 2289-2294           V444 2295-2301        
   V445 2302-2306           V446 2307-2313           V447 2314-2317        
   V448 2318-2320           V449 2321-2324           V450 2325-2327        
   V451 2328-2334           V452 2335-2341           V453 2342-2348        
   V454 2349-2356           V455 2357-2363           V456 2364-2370        
   V457 2371-2377           V458 2378-2383           V459 2384-2389        
   V460 2390-2395           V461 2396-2403           V462 2404-2411        
   V463 2412-2417           V464 2418-2422           V465 2423-2429        
   V466 2430-2437           V467 2438-2443           V468 2444-2448        
   V469 2449-2454           V470 2455-2459           V471 2460-2464        
   V472 2465-2469           V473 2470-2476           V474 2477-2484        
   V475 2485-2487           V476 2488-2488           V477 2489-2490        
   V478 2491-2493           V479 2494-2497           V480 2498-2500        
   V481 2501-2502           V482 2503-2504           V483 2505-2507        
   V484 2508-2509           V485 2510-2512           V486 2513-2516        
   V487 2517-2519           V488 2520-2523           V489 2524-2526        
   V490 2527-2529           V491 2530-2532           V492 2533-2535        
   V493 2536-2539           V494 2540-2543           V495 2544-2547        
   V496 2548-2551           V497 2552-2556           V498 2557-2560        
   V499 2561-2563           V500 2564-2566           V501 2567-2570        
   V502 2571-2574           V503 2575-2578           V504 2579-2581        
   V505 2582-2585           V506 2586-2587           V507 2588-2591        
   V508 2592-2596           V509 2597-2601           V510 2602-2608        
   V511 2609-2614           V512 2615-2619           V513 2620-2624        
   V514 2625-2630           V515 2631-2636           V516 2637-2643        
   V517 2644-2650           V518 2651-2657           V519 2658-2664        
   V520 2665-2671           V521 2672-2678           V522 2679-2685        
   V523 2686-2692           V524 2693-2699           V525 2700-2707        
   V526 2708-2713           V527 2714-2719           V528 2720-2727        
   V529 2728-2735           V530 2736-2743           V531 2744-2749        
   V532 2750-2755           V533 2756-2761           V534 2762-2769        
   V535 2770-2776           V536 2777-2782           V537 2783-2789        
   V538 2790-2795           V539 2796-2802           V540 2803-2806        
   V541 2807-2809           V542 2810-2813           V543 2814-2816        
   V544 2817-2823           V545 2824-2830           V546 2831-2837        
   V547 2838-2845           V548 2846-2852           V549 2853-2859        
   V550 2860-2865           V551 2866-2871           V552 2872-2877        
   V553 2878-2883           V554 2884-2891           V555 2892-2899        
   V556 2900-2905           V557 2906-2911           V558 2912-2916        
   V559 2917-2924           V560 2925-2930           V561 2931-2936        
   V562 2937-2941           V563 2942-2946           V564 2947-2951        
   V565 2952-2956           V566 2957-2962           V567 2963-2970        
   V568 2971-2973           V569 2974-2974           V570 2975-2976        
   V571 2977-2979           V572 2980-2983           V573 2984-2986        
   V574 2987-2988           V575 2989-2990           V576 2991-2993        
   V577 2994-2995           V578 2996-2998           V579 2999-3002        
   V580 3003-3005           V581 3006-3009           V582 3010-3012        
   V583 3013-3015           V584 3016-3018           V585 3019-3021        
   V586 3022-3025           V587 3026-3029           V588 3030-3033        
   V589 3034-3037           V590 3038-3042           V591 3043-3046        
   V592 3047-3049           V593 3050-3052           V594 3053-3056        
   V595 3057-3060           V596 3061-3064           V597 3065-3067        
   V598 3068-3071           V599 3072-3074           V600 3075-3078        
   V601 3079-3083           V602 3084-3088           V603 3089-3095        
   V604 3096-3101           V605 3102-3106           V606 3107-3112        
   V607 3113-3118           V608 3119-3123           V609 3124-3129        
   V610 3130-3136           V611 3137-3143           V612 3144-3150        
   V613 3151-3157           V614 3158-3164           V615 3165-3171        
   V616 3172-3178           V617 3179-3185           V618 3186-3193        
   V619 3194-3200           V620 3201-3206           V621 3207-3214        
   V622 3215-3222           V623 3223-3230           V624 3231-3236        
   V625 3237-3242           V626 3243-3248           V627 3249-3255        
   V628 3256-3261           V629 3262-3267           V630 3268-3274        
   V631 3275-3279           V632 3280-3286           V633 3287-3290        
   V634 3291-3294           V635 3295-3298           V636 3299-3302        
   V637 3303-3309           V638 3310-3316           V639 3317-3323        
   V640 3324-3331           V641 3332-3338           V642 3339-3345        
   V643 3346-3351           V644 3352-3358           V645 3359-3365        
   V646 3366-3370           V647 3371-3378           V648 3379-3386        
   V649 3387-3392           V650 3393-3398           V651 3399-3405        
   V652 3406-3413           V653 3414-3418           V654 3419-3423        
   V655 3424-3428           V656 3429-3433           V657 3434-3440        
   V658 3441-3444           V659 3445-3450           V660 3451-3458        
   V661 3459-3461           V662 3462-3462           V663 3463-3464        
   V664 3465-3467           V665 3468-3471           V666 3472-3474        
   V667 3475-3476           V668 3477-3478           V669 3479-3481        
   V670 3482-3483           V671 3484-3486           V672 3487-3490        
   V673 3491-3493           V674 3494-3497           V675 3498-3500        
   V676 3501-3503           V677 3504-3506           V678 3507-3509        
   V679 3510-3513           V680 3514-3517           V681 3518-3521        
   V682 3522-3525           V683 3526-3530           V684 3531-3534        
   V685 3535-3537           V686 3538-3540           V687 3541-3544        
   V688 3545-3548           V689 3549-3552           V690 3553-3555        
   V691 3556-3559           V692 3560-3561           V693 3562-3565        
   V694 3566-3570           V695 3571-3575           V696 3576-3582        
   V697 3583-3589           V698 3590-3594           V699 3595-3600        
   V700 3601-3606           V701 3607-3612           V702 3613-3618        
   V703 3619-3625           V704 3626-3632           V705 3633-3639        
   V706 3640-3646           V707 3647-3653           V708 3654-3660        
   V709 3661-3666           V710 3667-3673           V711 3674-3681        
   V712 3682-3687           V713 3688-3693           V714 3694-3701        
   V715 3702-3709           V716 3710-3717           V717 3718-3723        
   V718 3724-3729           V719 3730-3735           V720 3736-3743        
   V721 3744-3750           V722 3751-3755           V723 3756-3762        
   V724 3763-3768           V725 3769-3776           V726 3777-3780        
   V727 3781-3783           V728 3784-3787           V729 3788-3790        
   V730 3791-3797           V731 3798-3804           V732 3805-3811        
   V733 3812-3819           V734 3820-3827           V735 3828-3834        
   V736 3835-3840           V737 3841-3846           V738 3847-3853        
   V739 3854-3859           V740 3860-3866           V741 3867-3874        
   V742 3875-3880           V743 3881-3886           V744 3887-3892        
   V745 3893-3900           V746 3901-3905           V747 3906-3911        
   V748 3912-3916           V749 3917-3921           V750 3922-3927        
   V751 3928-3932           V752 3933-3938           V753 3939-3946        
   V754 3947-3949           V755 3950-3950           V756 3951-3952        
   V757 3953-3955           V758 3956-3959           V759 3960-3962        
   V760 3963-3964           V761 3965-3966           V762 3967-3969        
   V763 3970-3971           V764 3972-3974           V765 3975-3978        
   V766 3979-3981           V767 3982-3985           V768 3986-3988        
   V769 3989-3991           V770 3992-3994           V771 3995-3997        
   V772 3998-4001           V773 4002-4005           V774 4006-4009        
   V775 4010-4013           V776 4014-4018           V777 4019-4022        
   V778 4023-4025           V779 4026-4028           V780 4029-4032        
   V781 4033-4036           V782 4037-4040           V783 4041-4043        
   V784 4044-4047           V785 4048-4049           V786 4050-4053        
   V787 4054-4058           V788 4059-4063           V789 4064-4070        
   V790 4071-4076           V791 4077-4081           V792 4082-4086        
   V793 4087-4092           V794 4093-4098           V795 4099-4105        
   V796 4106-4112           V797 4113-4119           V798 4120-4126        
   V799 4127-4133           V800 4134-4140           V801 4141-4147        
   V802 4148-4154           V803 4155-4161           V804 4162-4169        
   V805 4170-4175           V806 4176-4181           V807 4182-4189        
   V808 4190-4197           V809 4198-4205           V810 4206-4211        
   V811 4212-4217           V812 4218-4223           V813 4224-4230        
   V814 4231-4236           V815 4237-4241           V816 4242-4248        
   V817 4249-4254           V818 4255-4261           V819 4262-4265        
   V820 4266-4268           V821 4269-4272           V822 4273-4275        
   V823 4276-4282           V824 4283-4289           V825 4290-4296        
   V826 4297-4304           V827 4305-4311           V828 4312-4318        
   V829 4319-4324           V830 4325-4331           V831 4332-4337        
   V832 4338-4343           V833 4344-4351           V834 4352-4359        
   V835 4360-4365           V836 4366-4371           V837 4372-4378        
   V838 4379-4386           V839 4387-4391           V840 4392-4397        
   V841 4398-4402           V842 4403-4407           V843 4408-4412        
   V844 4413-4417           V845 4418-4423           V846 4424-4431        
   V847 4432-4434           V848 4435-4435           V849 4436-4437        
   V850 4438-4440           V851 4441-4444           V852 4445-4447        
   V853 4448-4449           V854 4450-4451           V855 4452-4454        
   V856 4455-4456           V857 4457-4459           V858 4460-4463        
   V859 4464-4466           V860 4467-4470           V861 4471-4473        
   V862 4474-4476           V863 4477-4479           V864 4480-4482        
   V865 4483-4486           V866 4487-4490           V867 4491-4494        
   V868 4495-4498           V869 4499-4503           V870 4504-4507        
   V871 4508-4510           V872 4511-4513           V873 4514-4517        
   V874 4518-4521           V875 4522-4525           V876 4526-4528        
   V877 4529-4532           V878 4533-4535           V879 4536-4539        
   V880 4540-4544           V881 4545-4549           V882 4550-4555        
   V883 4556-4561           V884 4562-4567           V885 4568-4573        
   V886 4574-4579           V887 4580-4585           V888 4586-4592        
   V889 4593-4599           V890 4600-4606           V891 4607-4613        
   V892 4614-4620           V893 4621-4627           V894 4628-4634        
   V895 4635-4641           V896 4642-4648           V897 4649-4656        
   V898 4657-4662           V899 4663-4668           V900 4669-4676        
   V901 4677-4684           V902 4685-4692           V903 4693-4698        
   V904 4699-4704           V905 4705-4710           V906 4711-4717        
   V907 4718-4723           V908 4724-4728           V909 4729-4735        
   V910 4736-4741           V911 4742-4748           V912 4749-4752        
   V913 4753-4755           V914 4756-4759           V915 4760-4762        
   V916 4763-4769           V917 4770-4776           V918 4777-4783        
   V919 4784-4791           V920 4792-4798           V921 4799-4805        
   V922 4806-4811           V923 4812-4817           V924 4818-4823        
   V925 4824-4829           V926 4830-4837           V927 4838-4845        
   V928 4846-4851           V929 4852-4857           V930 4858-4863        
   V931 4864-4871           V932 4872-4877           V933 4878-4882        
   V934 4883-4887           V935 4888-4892           V936 4893-4898        
   V937 4899-4903           V938 4904-4909           V939 4910-4917        
   V940 4918-4920           V941 4921-4921           V942 4922-4923        
   V943 4924-4926           V944 4927-4930           V945 4931-4933        
   V946 4934-4935           V947 4936-4937           V948 4938-4940        
   V949 4941-4942           V950 4943-4945           V951 4946-4949        
   V952 4950-4952           V953 4953-4956           V954 4957-4959        
   V955 4960-4962           V956 4963-4965           V957 4966-4968        
   V958 4969-4972           V959 4973-4976           V960 4977-4980        
   V961 4981-4984           V962 4985-4989           V963 4990-4993        
   V964 4994-4996           V965 4997-4999           V966 5000-5003        
   V967 5004-5007           V968 5008-5011           V969 5012-5014        
   V970 5015-5018           V971 5019-5021           V972 5022-5025        
   V973 5026-5031           V974 5032-5036           V975 5037-5043        
   V976 5044-5049           V977 5050-5054           V978 5055-5059        
   V979 5060-5065           V980 5066-5071           V981 5072-5077        
   V982 5078-5084           V983 5085-5091           V984 5092-5098        
   V985 5099-5105           V986 5106-5112           V987 5113-5119        
   V988 5120-5126           V989 5127-5133           V990 5134-5141        
   V991 5142-5147           V992 5148-5153           V993 5154-5161        
   V994 5162-5169           V995 5170-5177           V996 5178-5183        
   V997 5184-5189           V998 5190-5195           V999 5196-5202        
   V1000 5203-5208          V1001 5209-5213          V1002 5214-5220       
   V1003 5221-5226          V1004 5227-5233          V1005 5234-5237       
   V1006 5238-5240          V1007 5241-5244          V1008 5245-5247       
   V1009 5248-5254          V1010 5255-5261          V1011 5262-5268       
   V1012 5269-5276          V1013 5277-5283          V1014 5284-5290       
   V1015 5291-5296          V1016 5297-5302          V1017 5303-5308       
   V1018 5309-5314          V1019 5315-5321          V1020 5322-5329       
   V1021 5330-5335          V1022 5336-5341          V1023 5342-5346       
   V1024 5347-5354          V1025 5355-5360          V1026 5361-5366       
   V1027 5367-5371          V1028 5372-5377          V1029 5378-5383       
   V1030 5384-5388          V1031 5389-5395          V1032 5396-5403       
   V1033 5404-5406          V1034 5407-5407          V1035 5408-5409       
   V1036 5410-5412          V1037 5413-5416          V1038 5417-5419       
   V1039 5420-5422          V1040 5423-5425          V1041 5426-5428       
   V1042 5429-5430          V1043 5431-5433          V1044 5434-5437       
   V1045 5438-5441          V1046 5442-5445          V1047 5446-5449       
   V1048 5450-5453          V1049 5454-5457          V1050 5458-5461       
   V1051 5462-5466          V1052 5467-5470          V1053 5471-5474       
   V1054 5475-5479          V1055 5480-5484          V1056 5485-5488       
   V1057 5489-5491          V1058 5492-5494          V1059 5495-5498       
   V1060 5499-5502          V1061 5503-5506          V1062 5507-5510       
   V1063 5511-5514          V1064 5515-5517          V1065 5518-5522       
   V1066 5523-5527          V1067 5528-5532          V1068 5533-5539       
   V1069 5540-5546          V1070 5547-5552          V1071 5553-5558       
   V1072 5559-5565          V1073 5566-5571          V1074 5572-5577       
   V1075 5578-5584          V1076 5585-5591          V1077 5592-5598       
   V1078 5599-5605          V1079 5606-5612          V1080 5613-5619       
   V1081 5620-5626          V1082 5627-5634          V1083 5635-5642       
   V1084 5643-5648          V1085 5649-5655          V1086 5656-5663       
   V1087 5664-5671          V1088 5672-5679          V1089 5680-5685       
   V1090 5686-5690          V1091 5691-5697          V1092 5698-5704       
   V1093 5705-5711          V1094 5712-5717          V1095 5718-5724       
   V1096 5725-5730          V1097 5731-5738          V1098 5739-5742       
   V1099 5743-5746          V1100 5747-5750          V1101 5751-5755       
   V1102 5756-5762          V1103 5763-5769          V1104 5770-5776       
   V1105 5777-5784          V1106 5785-5791          V1107 5792-5798       
   V1108 5799-5804          V1109 5805-5811          V1110 5812-5818       
   V1111 5819-5824          V1112 5825-5832          V1113 5833-5840       
   V1114 5841-5846          V1115 5847-5853          V1116 5854-5859       
   V1117 5860-5867          V1118 5868-5873          V1119 5874-5879       
   V1120 5880-5884          V1121 5885-5890          V1122 5891-5896       
   V1123 5897-5901          V1124 5902-5908          V1125 5909-5916       
   V1126 5917-5919;                                                        
                                                                           
* SAS LABEL STATEMENT;                                                     
                                                                           
LABEL                                                                      
   V1 = "IDENTIFIER CODE"                                                  
   V2 = "NUMERIC STATE CODE"                                               
   V3 = "ORI CODE ORIGINATING AGENCY IDENTIFIER"                           
   V4 = "GROUP"                                                            
   V5 = "GEOGRAPHIC DIVISION"                                              
   V6 = "YEAR"                                                             
   V7 = "MSA   METROPOLITAN STATISTICAL AREA"                              
   V8 = "AGENCY NAME"                                                      
   V9 = "AGENCY STATE NAME"                                                
   V10 = "POPULATION  TOTAL POPULATION FOR AGENCY"                         
   V11 = "STATUS"                                                          
   V12 = "MURDER OFFENSES"                                                 
   V13 = "RAPE OFFENSES"                                                   
   V14 = "ROBBERY OFFENCES-HIGHWAY"                                        
   V15 = "ROBBERY OFFENCES-COMMON HOUSE"                                   
   V16 = "ROBBERY OFFENCES-GAS STATION"                                    
   V17 = "ROBBERY OFFENCES-CHAIN STORE"                                    
   V18 = "ROBBERY OFFENCES-RESIDENCE"                                      
   V19 = "ROBBERY OFFENCES-BANK"                                           
   V20 = "ROBBERY OFFENCES-MISCELLANEOUS"                                  
   V21 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                  
   V22 = "BURGLARY OFFENSES-RESIDENT NIGHT"                                
   V23 = "BURGLARY OFFENSES-RESIDENT DAY"                                  
   V24 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                              
   V25 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                            
   V26 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                              
   V27 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                          
   V28 = "BURGLARY OFFENSES-TOTAL BURGLARY"                                
   V29 = "LARCENY OFFENSES-OVER 200"                                       
   V30 = "LARCENY OFFENCE-BETWEEN 50 TO 200"                               
   V31 = "LARCENY OFFENCE-UNDER 50"                                        
   V32 = "TOTAL LARCENY-USED FOR LARCENY SUPPLEMEN"                        
   V33 = "MOTOR VEHICLE THEFT"                                             
   V34 = "LARCENY ANALYSIS-POCKET PICKING"                                 
   V35 = "LARCENY ANALYSIS -PURSE SNATCHING"                               
   V36 = "LARCENY ANALYSIS -SHOPLIFTING"                                   
   V37 = "LARCENY ANALYSIS -FROM AUTO"                                     
   V38 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                              
   V39 = "LARCENY ANALYSIS -BICYCLE"                                       
   V40 = "LARCENY ANALYSIS -FROM BUILDING"                                 
   V41 = "LARCENY ANALYSIS -COIN MACHINE"                                  
   V42 = "LARCENY ANALYSIS -ALL OTHER"                                     
   V43 = "MURDER VALUE"                                                    
   V44 = "RAPE VALUE"                                                      
   V45 = "ROBBERY VALUE-HIGHWAY"                                           
   V46 = "ROBBERY VALUE-COMMON HOUSE"                                      
   V47 = "ROBBERY VALUE-GAS STATION"                                       
   V48 = "ROBBERY VALUE-CHAIN STORE"                                       
   V49 = "ROBBERY VALUE-RESIDENCE"                                         
   V50 = "ROBBERY VALUE-BANK"                                              
   V51 = "ROBBERY VALUE-MISCELLANEOUS"                                     
   V52 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                               
   V53 = "BURGLARY VALUE-RESIDENT NIGHT"                                   
   V54 = "BURGLARY VALUE-RESIDENT DAY"                                     
   V55 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                 
   V56 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                               
   V57 = "BURGLARY VALUE-NON-RESIDENT DAY"                                 
   V58 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                             
   V59 = "BURGLARY VALUE-TOTAL BURGLARY  VALUE"                            
   V60 = "LARCENY VALUE-OVER 200"                                          
   V61 = "LARCENY VALUE-BETWEEN 50 TO 200"                                 
   V62 = "LARCENY VALUE-UNDER 50"                                          
   V63 = "TOTAL LARCENY  VALUE"                                            
   V64 = "MOTOR VEHICLE THEFT VALUE"                                       
   V65 = "TOTAL VALUE ABOVE"                                               
   V66 = "ANALYSIS VALUE-POCKET PICKING"                                   
   V67 = "ANALYSIS VALUE-PURSE SNATCHING"                                  
   V68 = "ANALYSIS VALUE-SHOPLIFTING"                                      
   V69 = "ANALYSIS VALUE-FROM AUTO"                                        
   V70 = "ANALYSIS VALUE-AUTO ACCESSORIES"                                 
   V71 = "ANALYSIS VALUE-BICYCLE"                                          
   V72 = "ANALYSIS VALUE-FROM BUILDING"                                    
   V73 = "ANALYSIS VALUE-COIN  MACHINE"                                    
   V74 = "ANALYSIS VALUE-ALL OTHER"                                        
   V75 = "AUTO STOLEN AND  RECOVERED  LOCALLY"                             
   V76 = "AUTO STOLEN AND  RECOVERED  OTHER"                               
   V77 = "TOTAL"                                                           
   V78 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                         
   V79 = "CURRENCY"                                                        
   V80 = "JEWELRY AND PRECIOUS METALS"                                     
   V81 = "CLOTHING"                                                        
   V82 = "LOCALLY STOLEN MOTOR VEHICLES"                                   
   V83 = "OFFICE EQUIPMENT"                                                
   V84 = "TELEVISIONS, RADIOS, STEREOS"                                    
   V85 = "FIREARMS"                                                        
   V86 = "HOUSEHOLD GOODS"                                                 
   V87 = "CONSUMABLE GOODS"                                                
   V88 = "LIVESTOCK"                                                       
   V89 = "MISCELLANEOUS"                                                   
   V90 = "TOTAL VALUE STOLEN"                                              
   V91 = "CURRENCY"                                                        
   V92 = "JEWELRY AND PRECIOUS METALS"                                     
   V93 = "CLOTHING"                                                        
   V94 = "LOCALLY STOLEN MOTOR VEHICLES"                                   
   V95 = "OFFICE EQUIPMENT"                                                
   V96 = "TELEVISIONS, RADIOS, STEREOS"                                    
   V97 = "FIREARMS"                                                        
   V98 = "HOUSEHOLD GOODS"                                                 
   V99 = "CONSUMABLE GOODS"                                                
   V100 = "LIVESTOCK"                                                      
   V101 = "MISCELLANEOUS"                                                  
   V102 = "TOTAL VALUE STOLEN"                                             
   V103 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                        
   V104 = "STATUS"                                                         
   V105 = "MURDER OFFENSES"                                                
   V106 = "RAPE OFFENSES"                                                  
   V107 = "ROBBERY OFFENCES-HIGHWAY"                                       
   V108 = "ROBBERY OFFENCES-COMMON HOUSE"                                  
   V109 = "ROBBERY OFFENCES-GAS STATION"                                   
   V110 = "ROBBERY OFFENCES-CHAIN STORE"                                   
   V111 = "ROBBERY OFFENCES-RESIDENCE"                                     
   V112 = "ROBBERY OFFENCES-BANK"                                          
   V113 = "ROBBERY OFFENCES-MISCELLANEOUS"                                 
   V114 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                 
   V115 = "BURGLARY OFFENSES-RESIDENT NIGHT"                               
   V116 = "BURGLARY OFFENSES-RESIDENT DAY"                                 
   V117 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                             
   V118 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                           
   V119 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                             
   V120 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                         
   V121 = "BURGLARY OFFENSES-TOTAL BURGLARY"                               
   V122 = "LARCENY OFFENSES OVER $200"                                     
   V123 = "LARCENY OFFENSES-$50 TO $200"                                   
   V124 = "LARCENY OFFENSES-UNDER  $50"                                    
   V125 = "TOTAL LARCENY -- USED FOR LARCENY SUPPL"                        
   V126 = "MOTOR VEHICLE THEFT"                                            
   V127 = "LARCENY ANALYSIS-POCKET PICKING"                                
   V128 = "LARCENY ANALYSIS -PURSE SNATCHING"                              
   V129 = "LARCENY ANALYSIS -SHOPLIFTING"                                  
   V130 = "LARCENY ANALYSIS -FROM  AUTO"                                   
   V131 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                             
   V132 = "LARCENY ANALYSIS -BICYCLE"                                      
   V133 = "LARCENY ANALYSIS -FROM BUILDING"                                
   V134 = "LARCENY ANALYSIS -COIN MACHINE"                                 
   V135 = "LARCENY ANALYSIS -ALL OTHER"                                    
   V136 = "MURDER VALUE"                                                   
   V137 = "RAPE VALUE"                                                     
   V138 = "ROBBERY VALUE-HIGHWAY"                                          
   V139 = "ROBBERY VALUE-COMMON HOUSE"                                     
   V140 = "ROBBERY VALUE-GAS STATION"                                      
   V141 = "ROBBERY VALUE-CHAIN STORE"                                      
   V142 = "ROBBERY VALUE-RESIDENCE"                                        
   V143 = "ROBBERY VALUE-BANK"                                             
   V144 = "ROBBERY VALUE-MISCELLANEOUS"                                    
   V145 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                              
   V146 = "BURGLARY VALUE-RESIDENT NIGHT"                                  
   V147 = "BURGLARY VALUE-RESIDENT DAY"                                    
   V148 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                
   V149 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                              
   V150 = "BURGLARY VALUE-NON-RESIDENT DAY"                                
   V151 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                            
   V152 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                            
   V153 = "VALUE-OVER $200"                                                
   V154 = "LARCENY VALUE-$50 TO $200"                                      
   V155 = "LARCENY VALUE-UNDER $50"                                        
   V156 = "LARCENY VALUE-TOTAL LARCENY VALUE"                              
   V157 = "MOTOR VEHICLE THEFT VALUE"                                      
   V158 = "TOTAL VALUE ABOVE"                                              
   V159 = "ANALYSIS VALUE-POCKET PICKING"                                  
   V160 = "ANALYSIS VALUE-PURSE SNATCHING"                                 
   V161 = "ANALYSIS VALUE-SHOPLIFTING"                                     
   V162 = "ANALYSIS VALUE-FROM AUTO"                                       
   V163 = "ANALYSIS VALUE-AUTO ACCESSORIES"                                
   V164 = "ANALYSIS VALUE-BICYCLE"                                         
   V165 = "ANALYSIS VALUE-FROM BUILDING"                                   
   V166 = "ANALYSIS VALUE-COIN MACHINE"                                    
   V167 = "ANALYSIS VALUE-ALL OTHER"                                       
   V168 = "AUTO STOLEN AND RECOVERED LOCALLY"                              
   V169 = "AUTO STOLEN AND RECOVERED OTHER"                                
   V170 = "TOTAL"                                                          
   V171 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                        
   V172 = "CURRENCY"                                                       
   V173 = "JEWELRY AND PRECIOUS METALS"                                    
   V174 = "CLOTHING"                                                       
   V175 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V176 = "OFFICE EQUIPMENT"                                               
   V177 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V178 = "FIREARMS"                                                       
   V179 = "HOUSEHOLD GOODS"                                                
   V180 = "CONSUMABLE GOODS"                                               
   V181 = "LIVESTOCK"                                                      
   V182 = "MISCELLANEOUS"                                                  
   V183 = "TOTAL VALUE STOLEN"                                             
   V184 = "CURRENCY"                                                       
   V185 = "JEWELRY AND PRECIOUS METALS"                                    
   V186 = "CLOTHING"                                                       
   V187 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V188 = "OFFICE EQUIPMENT"                                               
   V189 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V190 = "FIREARMS"                                                       
   V191 = "HOUSEHOLD GOODS"                                                
   V192 = "CONSUMABLE GOODS"                                               
   V193 = "LIVESTOCK"                                                      
   V194 = "MISCELLANEOUS"                                                  
   V195 = "TOTAL VALUE STOLEN"                                             
   V196 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                        
   V197 = "STATUS"                                                         
   V198 = "MURDER OFFENSES"                                                
   V199 = "RAPE OFFENSES"                                                  
   V200 = "ROBBERY OFFENCES-HIGHWAY"                                       
   V201 = "ROBBERY OFFENCES-COMMON HOUSE"                                  
   V202 = "ROBBERY OFFENCES-GAS STATION"                                   
   V203 = "ROBBERY OFFENCES-CHAIN STORE"                                   
   V204 = "ROBBERY OFFENCES-RESIDENCE"                                     
   V205 = "ROBBERY OFFENCES-BANK"                                          
   V206 = "ROBBERY OFFENCES-MISCELLANEOUS"                                 
   V207 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                 
   V208 = "BURGLARY OFFENSES-RESIDENT NIGHT"                               
   V209 = "BURGLARY OFFENSES-RESIDENT DAY"                                 
   V210 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                             
   V211 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                           
   V212 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                             
   V213 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                         
   V214 = "BURGLARY OFFENSES-TOTAL BURGLARY"                               
   V215 = "LARCENY OFFENSES OVER $200"                                     
   V216 = "LARCENY OFFENSES-$50 TO $200"                                   
   V217 = "LARCENY OFFENSES-UNDER $50"                                     
   V218 = "TOTAL LARCENY -- USED FOR LARCENY SUPPL"                        
   V219 = "MOTOR VEHICLE THEFT"                                            
   V220 = "LARCENY ANALYSIS-POCKET PICKING"                                
   V221 = "LARCENY ANALYSIS -PURSE SNATCHING"                              
   V222 = "LARCENY ANALYSIS -SHOPLIFTING"                                  
   V223 = "LARCENY ANALYSIS -FROM AUTO"                                    
   V224 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                             
   V225 = "LARCENY ANALYSIS -BICYCLE"                                      
   V226 = "LARCENY ANALYSIS -FROM BUILDING"                                
   V227 = "LARCENY ANALYSIS -COIN MACHINE"                                 
   V228 = "LARCENY ANALYSIS -ALL OTHER"                                    
   V229 = "MURDER VALUE"                                                   
   V230 = "RAPE VALUE"                                                     
   V231 = "ROBBERY VALUE-HIGHWAY"                                          
   V232 = "ROBBERY VALUE-COMMON HOUSE"                                     
   V233 = "ROBBERY VALUE-GAS STATION"                                      
   V234 = "ROBBERY VALUE-CHAIN STORE"                                      
   V235 = "ROBBERY VALUE-RESIDENCE"                                        
   V236 = "ROBBERY VALUE-BANK"                                             
   V237 = "ROBBERY VALUE-MISCELLANEOUS"                                    
   V238 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                              
   V239 = "BURGLARY VALUE-RESIDENT NIGHT"                                  
   V240 = "BURGLARY VALUE-RESIDENT DAY"                                    
   V241 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                
   V242 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                              
   V243 = "BURGLARY VALUE-NON-RESIDENT DAY"                                
   V244 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                            
   V245 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                            
   V246 = "VALUE-OVER $200"                                                
   V247 = "LARCENY VALUE-$50 TO $200"                                      
   V248 = "LARCENY VALUE-UNDER $50"                                        
   V249 = "TOTAL LARCENY VALUE"                                            
   V250 = "MOTOR VEHICLE THEFT VALUE"                                      
   V251 = "TOTAL VALUE ABOVE"                                              
   V252 = "ANALYSIS VALUE-POCKET PICKING"                                  
   V253 = "ANALYSIS VALUE-PURSE SNATCHING"                                 
   V254 = "ANALYSIS VALUE-SHOPLIFTING"                                     
   V255 = "ANALYSIS VALUE-FROM AUTO"                                       
   V256 = "ANALYSIS VALUE-AUTO ACCESSORIES"                                
   V257 = "ANALYSIS VALUE-BICYCLE"                                         
   V258 = "ANALYSIS VALUE-FROM BUILDING"                                   
   V259 = "ANALYSIS VALUE-COIN MACHINE"                                    
   V260 = "ANALYSIS VALUE-ALL OTHER"                                       
   V261 = "AUTO STOLEN AND RECOVERED LOCALLY"                              
   V262 = "AUTO STOLEN AND RECOVERED OTHER"                                
   V263 = "TOTAL"                                                          
   V264 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                        
   V265 = "CURRENCY"                                                       
   V266 = "JEWELRY AND PRECIOUS METALS"                                    
   V267 = "CLOTHING"                                                       
   V268 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V269 = "OFFICE EQUIPMENT"                                               
   V270 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V271 = "FIREARMS"                                                       
   V272 = "HOUSEHOLD GOODS"                                                
   V273 = "CONSUMABLE GOODS"                                               
   V274 = "LIVESTOCK"                                                      
   V275 = "MISCELLANEOUS"                                                  
   V276 = "TOTAL VALUE STOLEN"                                             
   V277 = "CURRENCY"                                                       
   V278 = "JEWELRY AND PRECIOUS METALS"                                    
   V279 = "CLOTHING"                                                       
   V280 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V281 = "OFFICE EQUIPMENT"                                               
   V282 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V283 = "FIREARMS"                                                       
   V284 = "HOUSEHOLD GOODS"                                                
   V285 = "CONSUMABLE GOODS"                                               
   V286 = "LIVESTOCK"                                                      
   V287 = "MISCELLANEOUS"                                                  
   V288 = "TOTAL VALUE STOLEN"                                             
   V289 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                        
   V290 = "STATUS"                                                         
   V291 = "MURDER OFFENSES"                                                
   V292 = "RAPE OFFENSES"                                                  
   V293 = "ROBBERY OFFENCES-HIGHWAY"                                       
   V294 = "ROBBERY OFFENCES-COMMON HOUSE"                                  
   V295 = "ROBBERY OFFENCES-GAS STATION"                                   
   V296 = "ROBBERY OFFENCES-CHAIN STORE"                                   
   V297 = "ROBBERY OFFENCES-RESIDENCE"                                     
   V298 = "ROBBERY OFFENCES-BANK"                                          
   V299 = "ROBBERY OFFENCES-MISCELLANEOUS"                                 
   V300 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                 
   V301 = "BURGLARY OFFENSES-RESIDENT NIGHT"                               
   V302 = "BURGLARY OFFENSES-RESIDENT DAY"                                 
   V303 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                             
   V304 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                           
   V305 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                             
   V306 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                         
   V307 = "BURGLARY OFFENSES-TOTAL BURGLARY"                               
   V308 = "LARCENY OFFENSES OVER $200"                                     
   V309 = "LARCENY OFFENSES-BETWEEN $50 TO $200"                           
   V310 = "LARCENY OFFENSES-UNDER $50"                                     
   V311 = "-TOTAL LARCENY -- USED FOR LARCENY SUPPL"                       
   V312 = "MOTOR VEHICLE THEFT"                                            
   V313 = "LARCENY ANALYSIS-POCKET PICKING"                                
   V314 = "LARCENY ANALYSIS -PURSE SNATCHING"                              
   V315 = "LARCENY ANALYSIS -SHOPLIFTING"                                  
   V316 = "LARCENY ANALYSIS -FROM AUTO"                                    
   V317 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                             
   V318 = "LARCENY ANALYSIS -BICYCLE"                                      
   V319 = "LARCENY ANALYSIS -FROM BUILDING"                                
   V320 = "LARCENY ANALYSIS -COIN MACHINE"                                 
   V321 = "LARCENY ANALYSIS -ALL OTHER"                                    
   V322 = "MURDER VALUE"                                                   
   V323 = "RAPE VALUE"                                                     
   V324 = "ROBBERY VALUE-HIGHWAY"                                          
   V325 = "ROBBERY VALUE-COMMON HOUSE"                                     
   V326 = "ROBBERY VALUE-GAS STATION"                                      
   V327 = "ROBBERY VALUE-CHAIN STORE"                                      
   V328 = "ROBBERY VALUE-RESIDENCE"                                        
   V329 = "ROBBERY VALUE-BANK"                                             
   V330 = "ROBBERY VALUE-MISCELLANEOUS"                                    
   V331 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                              
   V332 = "BURGLARY VALUE-RESIDENT NIGHT"                                  
   V333 = "BURGLARY VALUE-RESIDENT DAY"                                    
   V334 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                
   V335 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                              
   V336 = "BURGLARY VALUE-NON-RESIDENT DAY"                                
   V337 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                            
   V338 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                            
   V339 = "VALUE-OVER $200"                                                
   V340 = "LARCENY VALUE-BETWEEN $50 TO $200"                              
   V341 = "LARCENY VALUE-UNDER $50"                                        
   V342 = "TOTAL LARCENY VALUE"                                            
   V343 = "MOTOR VEHICLE THEFT VALUE"                                      
   V344 = "TOTAL VALUE ABOVE"                                              
   V345 = "ANALYSIS VALUE-POCKET PICKING"                                  
   V346 = "ANALYSIS VALUE-PURSE SNATCHING"                                 
   V347 = "ANALYSIS VALUE-SHOPLIFTING"                                     
   V348 = "ANALYSIS VALUE-FROM AUTO"                                       
   V349 = "ANALYSIS VALUE-AUTO ACCESSORIES"                                
   V350 = "ANALYSIS VALUE-BICYCLE"                                         
   V351 = "ANALYSIS VALUE-FROM BUILDING"                                   
   V352 = "ANALYSIS VALUE-COIN MACHINE"                                    
   V353 = "ANALYSIS VALUE-ALL OTHER"                                       
   V354 = "AUTO STOLEN AND RECOVERED LOCALLY"                              
   V355 = "AUTO STOLEN AND RECOVERED OTHER"                                
   V356 = "TOTAL"                                                          
   V357 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                        
   V358 = "CURRENCY"                                                       
   V359 = "JEWELRY AND PRECIOUS METALS"                                    
   V360 = "CLOTHING"                                                       
   V361 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V362 = "OFFICE EQUIPMENT"                                               
   V363 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V364 = "FIREARMS"                                                       
   V365 = "HOUSEHOLD GOODS"                                                
   V366 = "CONSUMABLE GOODS"                                               
   V367 = "LIVESTOCK"                                                      
   V368 = "MISCELLANEOUS"                                                  
   V369 = "TOTAL VALUE STOLEN"                                             
   V370 = "CURRENCY"                                                       
   V371 = "JEWELRY AND PRECIOUS METALS"                                    
   V372 = "CLOTHING"                                                       
   V373 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V374 = "OFFICE EQUIPMENT"                                               
   V375 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V376 = "FIREARMS"                                                       
   V377 = "HOUSEHOLD GOODS"                                                
   V378 = "CONSUMABLE GOODS"                                               
   V379 = "LIVESTOCK"                                                      
   V380 = "MISCELLANEOUS"                                                  
   V381 = "TOTAL VALUE STOLEN"                                             
   V382 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                        
   V383 = "STATUS"                                                         
   V384 = "MURDER OFFENSES"                                                
   V385 = "RAPE OFFENSES"                                                  
   V386 = "ROBBERY OFFENCES-HIGHWAY"                                       
   V387 = "ROBBERY OFFENCES-COMMON HOUSE"                                  
   V388 = "ROBBERY OFFENCES-GAS STATION"                                   
   V389 = "ROBBERY OFFENCES-CHAIN STORE"                                   
   V390 = "ROBBERY OFFENCES-RESIDENCE"                                     
   V391 = "ROBBERY OFFENCES-BANK"                                          
   V392 = "ROBBERY OFFENCES-MISCELLANEOUS"                                 
   V393 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                 
   V394 = "BURGLARY OFFENSES-RESIDENT NIGHT"                               
   V395 = "BURGLARY OFFENSES-RESIDENT DAY"                                 
   V396 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                             
   V397 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                           
   V398 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                             
   V399 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                         
   V400 = "BURGLARY OFFENSES-TOTAL BURGLARY"                               
   V401 = "LARCENY OFFENSES OVER $200"                                     
   V402 = "LARCENY OFFENSES-BETWEEN $50 TO $200"                           
   V403 = "LARCENY OFFENSES-UNDER $50"                                     
   V404 = "TOTAL LARCENY -- USED FOR"                                      
   V405 = "MOTOR VEHICLE THEFT"                                            
   V406 = "LARCENY ANALYSIS-POCKET PICKING"                                
   V407 = "LARCENY ANALYSIS -PURSE SNATCHING"                              
   V408 = "LARCENY ANALYSIS -SHOPLIFTING"                                  
   V409 = "LARCENY ANALYSIS -FROM AUTO"                                    
   V410 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                             
   V411 = "LARCENY ANALYSIS -BICYCLE"                                      
   V412 = "LARCENY ANALYSIS -FROM BUILDING"                                
   V413 = "LARCENY ANALYSIS -COIN MACHINE"                                 
   V414 = "LARCENY ANALYSIS -ALL OTHER"                                    
   V415 = "MURDER VALUE"                                                   
   V416 = "RAPE VALUE"                                                     
   V417 = "ROBBERY VALUE-HIGHWAY"                                          
   V418 = "ROBBERY VALUE-COMMON HOUSE"                                     
   V419 = "ROBBERY VALUE-GAS STATION"                                      
   V420 = "ROBBERY VALUE-CHAIN STORE"                                      
   V421 = "ROBBERY VALUE-RESIDENCE"                                        
   V422 = "ROBBERY VALUE-BANK"                                             
   V423 = "ROBBERY VALUE-MISCELLANEOUS"                                    
   V424 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                              
   V425 = "BURGLARY VALUE-RESIDENT NIGHT"                                  
   V426 = "BURGLARY VALUE-RESIDENT DAY"                                    
   V427 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                
   V428 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                              
   V429 = "BURGLARY VALUE-NON-RESIDENT DAY"                                
   V430 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                            
   V431 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                            
   V432 = "VALUE-OVER $200"                                                
   V433 = "LARCENY VALUE-BETWEEN $50 TO $200"                              
   V434 = "LARCENY VALUE-UNDER $50"                                        
   V435 = "TOTAL LARCENY VALUE"                                            
   V436 = "MOTOR VEHICLE THEFT VALUE"                                      
   V437 = "TOTAL VALUE ABOVE"                                              
   V438 = "ANALYSIS VALUE-POCKET PICKING"                                  
   V439 = "ANALYSIS VALUE-PURSE SNATCHING"                                 
   V440 = "ANALYSIS VALUE-SHOPLIFTING"                                     
   V441 = "ANALYSIS VALUE-FROM AUTO"                                       
   V442 = "ANALYSIS VALUE-AUTO ACCESSORIES"                                
   V443 = "ANALYSIS VALUE-BICYCLE"                                         
   V444 = "ANALYSIS VALUE-FROM BUILDING"                                   
   V445 = "ANALYSIS VALUE-COIN MACHINE"                                    
   V446 = "ANALYSIS VALUE-ALL OTHER"                                       
   V447 = "AUTO STOLEN AND RECOVERED LOCALLY"                              
   V448 = "AUTO STOLEN AND RECOVERED OTHER"                                
   V449 = "TOTAL"                                                          
   V450 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                        
   V451 = "CURRENCY"                                                       
   V452 = "JEWELRY AND PRECIOUS METALS"                                    
   V453 = "CLOTHING"                                                       
   V454 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V455 = "OFFICE EQUIPMENT"                                               
   V456 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V457 = "FIREARMS"                                                       
   V458 = "HOUSEHOLD GOODS"                                                
   V459 = "CONSUMABLE GOODS"                                               
   V460 = "LIVESTOCK"                                                      
   V461 = "MISCELLANEOUS"                                                  
   V462 = "TOTAL VALUE STOLEN"                                             
   V463 = "CURRENCY"                                                       
   V464 = "JEWELRY AND PRECIOUS METALS"                                    
   V465 = "CLOTHING"                                                       
   V466 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V467 = "OFFICE EQUIPMENT"                                               
   V468 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V469 = "FIREARMS"                                                       
   V470 = "HOUSEHOLD GOODS"                                                
   V471 = "CONSUMABLE GOODS"                                               
   V472 = "LIVESTOCK"                                                      
   V473 = "MISCELLANEOUS"                                                  
   V474 = "TOTAL VALUE STOLEN"                                             
   V475 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                        
   V476 = "STATUS"                                                         
   V477 = "MURDER OFFENSES"                                                
   V478 = "RAPE OFFENSES"                                                  
   V479 = "ROBBERY OFFENCES-HIGHWAY"                                       
   V480 = "ROBBERY OFFENCES-COMMON HOUSE"                                  
   V481 = "ROBBERY OFFENCES-GAS STATION"                                   
   V482 = "ROBBERY OFFENCES-CHAIN STORE"                                   
   V483 = "ROBBERY OFFENCES-RESIDENCE"                                     
   V484 = "ROBBERY OFFENCES-BANK"                                          
   V485 = "ROBBERY OFFENCES-MISCELLANEOUS"                                 
   V486 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                 
   V487 = "BURGLARY OFFENSES-RESIDENT NIGHT"                               
   V488 = "BURGLARY OFFENSES-RESIDENT DAY"                                 
   V489 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                             
   V490 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                           
   V491 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                             
   V492 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                         
   V493 = "BURGLARY OFFENSES-TOTAL BURGLARY"                               
   V494 = "LARCENY OFFENSES OVER $200"                                     
   V495 = "LARCENY OFFENSES-BETWEEN $50 TO $200"                           
   V496 = "LARCENY OFFENSES-UNDER $50"                                     
   V497 = "TOTAL LARCENY -- USED FOR"                                      
   V498 = "MOTOR VEHICLE THEFT"                                            
   V499 = "LARCENY ANALYSIS-POCKET PICKING"                                
   V500 = "LARCENY ANALYSIS -PURSE SNATCHING"                              
   V501 = "LARCENY ANALYSIS -SHOPLIFTING"                                  
   V502 = "LARCENY ANALYSIS -FROM AUTO"                                    
   V503 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                             
   V504 = "LARCENY ANALYSIS -BICYCLE"                                      
   V505 = "LARCENY ANALYSIS -FROM BUILDING"                                
   V506 = "LARCENY ANALYSIS -COIN MACHINE"                                 
   V507 = "LARCENY ANALYSIS -ALL OTHER"                                    
   V508 = "MURDER VALUE"                                                   
   V509 = "RAPE VALUE"                                                     
   V510 = "ROBBERY VALUE-HIGHWAY"                                          
   V511 = "ROBBERY VALUE-COMMON HOUSE"                                     
   V512 = "ROBBERY VALUE-GAS STATION"                                      
   V513 = "ROBBERY VALUE-CHAIN STORE"                                      
   V514 = "ROBBERY VALUE-RESIDENCE"                                        
   V515 = "ROBBERY VALUE-BANK"                                             
   V516 = "ROBBERY VALUE-MISCELLANEOUS"                                    
   V517 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                              
   V518 = "BURGLARY VALUE-RESIDENT NIGHT"                                  
   V519 = "BURGLARY VALUE-RESIDENT DAY"                                    
   V520 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                
   V521 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                              
   V522 = "BURGLARY VALUE-NON-RESIDENT DAY"                                
   V523 = "BURGLARY VALUE-NON-RESIDENT  UNKNOWN"                           
   V524 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                            
   V525 = "VALUE-OVER $200"                                                
   V526 = "LARCENY VALUE-BETWEEN $50 TO $200"                              
   V527 = "LARCENY VALUE-UNDER $50"                                        
   V528 = "TOTAL LARCENY VALUE"                                            
   V529 = "MOTOR VEHICLE THEFT VALUE"                                      
   V530 = "TOTAL VALUE ABOVE"                                              
   V531 = "ANALYSIS VALUE-POCKET PICKING"                                  
   V532 = "ANALYSIS VALUE-PURSE SNATCHING"                                 
   V533 = "ANALYSIS VALUE-SHOPLIFTING"                                     
   V534 = "ANALYSIS VALUE-FROM AUTO"                                       
   V535 = "ANALYSIS VALUE-AUTO ACCESSORIES"                                
   V536 = "ANALYSIS VALUE-BICYCLE"                                         
   V537 = "ANALYSIS VALUE-FROM BUILDING"                                   
   V538 = "ANALYSIS VALUE-COIN MACHINE"                                    
   V539 = "ANALYSIS VALUE-ALL OTHER"                                       
   V540 = "AUTO STOLEN AND RECOVERED LOCALLY"                              
   V541 = "AUTO STOLEN AND RECOVERED OTHER"                                
   V542 = "TOTAL"                                                          
   V543 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                        
   V544 = "CURRENCY"                                                       
   V545 = "JEWELRY AND PRECIOUS METALS"                                    
   V546 = "CLOTHING"                                                       
   V547 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V548 = "OFFICE EQUIPMENT"                                               
   V549 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V550 = "FIREARMS"                                                       
   V551 = "HOUSEHOLD GOODS"                                                
   V552 = "CONSUMABLE GOODS"                                               
   V553 = "LIVESTOCK"                                                      
   V554 = "MISCELLANEOUS"                                                  
   V555 = "TOTAL VALUE STOLEN"                                             
   V556 = "CURRENCY"                                                       
   V557 = "JEWELRY AND PRECIOUS METALS"                                    
   V558 = "CLOTHING"                                                       
   V559 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V560 = "OFFICE EQUIPMENT"                                               
   V561 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V562 = "FIREARMS"                                                       
   V563 = "HOUSEHOLD GOODS"                                                
   V564 = "CONSUMABLE GOODS"                                               
   V565 = "LIVESTOCK"                                                      
   V566 = "MISCELLANEOUS"                                                  
   V567 = "TOTAL VALUE STOLEN"                                             
   V568 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                        
   V569 = "STATUS"                                                         
   V570 = "MURDER OFFENSES"                                                
   V571 = "RAPE OFFENSES"                                                  
   V572 = "ROBBERY OFFENCES-HIGHWAY"                                       
   V573 = "ROBBERY OFFENCES-COMMON HOUSE"                                  
   V574 = "ROBBERY OFFENCES-GAS STATION"                                   
   V575 = "ROBBERY OFFENCES-CHAIN STORE"                                   
   V576 = "ROBBERY OFFENCES-RESIDENCE"                                     
   V577 = "ROBBERY OFFENCES-BANK"                                          
   V578 = "ROBBERY OFFENCES-MISCELLANEOUS"                                 
   V579 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                 
   V580 = "BURGLARY OFFENSES-RESIDENT NIGHT"                               
   V581 = "BURGLARY OFFENSES-RESIDENT DAY"                                 
   V582 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                             
   V583 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                           
   V584 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                             
   V585 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                         
   V586 = "BURGLARY OFFENSES-TOTAL BURGLARY"                               
   V587 = "LARCENY OFFENSES OVER $200"                                     
   V588 = "LARCENY OFFENSES-BETWEEN $50 TO $200"                           
   V589 = "LARCENY OFFENSES-UNDER $50"                                     
   V590 = "TOTAL LARCENY -- USED FOR"                                      
   V591 = "MOTOR VEHICLE THEFT"                                            
   V592 = "LARCENY ANALYSIS-POCKET PICKING"                                
   V593 = "LARCENY ANALYSIS -PURSE SNATCHING"                              
   V594 = "LARCENY ANALYSIS -SHOPLIFTING"                                  
   V595 = "LARCENY ANALYSIS -FROM AUTO"                                    
   V596 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                             
   V597 = "LARCENY ANALYSIS -BICYCLE"                                      
   V598 = "LARCENY ANALYSIS -FROM BUILDING"                                
   V599 = "LARCENY ANALYSIS -COIN MACHINE"                                 
   V600 = "LARCENY ANALYSIS -ALL OTHER"                                    
   V601 = "MURDER VALUE"                                                   
   V602 = "RAPE VALUE"                                                     
   V603 = "ROBBERY VALUE-HIGHWAY"                                          
   V604 = "ROBBERY VALUE-COMMON HOUSE"                                     
   V605 = "ROBBERY VALUE-GAS STATION"                                      
   V606 = "ROBBERY VALUE-CHAIN STORE"                                      
   V607 = "ROBBERY VALUE-RESIDENCE"                                        
   V608 = "ROBBERY VALUE-BANK"                                             
   V609 = "ROBBERY VALUE-MISCELLANEOUS"                                    
   V610 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                              
   V611 = "BURGLARY VALUE-RESIDENT NIGHT"                                  
   V612 = "BURGLARY VALUE-RESIDENT DAY"                                    
   V613 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                
   V614 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                              
   V615 = "BURGLARY VALUE-NON-RESIDENT DAY"                                
   V616 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                            
   V617 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                            
   V618 = "VALUE-OVER $200"                                                
   V619 = "LARCENY VALUE-BETWEEN $50 TO $200"                              
   V620 = "LARCENY VALUE-UNDER $50"                                        
   V621 = "TOTAL LARCENY VALUE"                                            
   V622 = "MOTOR VEHICLE THEFT VALUE"                                      
   V623 = "TOTAL VALUE ABOVE"                                              
   V624 = "ANALYSIS VALUE-POCKET PICKING"                                  
   V625 = "ANALYSIS VALUE-PURSE SNATCHING"                                 
   V626 = "ANALYSIS VALUE-SHOPLIFTING"                                     
   V627 = "ANALYSIS VALUE-FROM AUTO"                                       
   V628 = "ANALYSIS VALUE-AUTO ACCESSORIES"                                
   V629 = "ANALYSIS VALUE-BICYCLE"                                         
   V630 = "ANALYSIS VALUE-FROM BUILDING"                                   
   V631 = "ANALYSIS VALUE-COIN  MACHINE"                                   
   V632 = "ANALYSIS VALUE-ALL OTHER"                                       
   V633 = "AUTO STOLEN AND RECOVERED LOCALLY"                              
   V634 = "AUTO STOLEN AND RECOVERED OTHER"                                
   V635 = "TOTAL"                                                          
   V636 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                        
   V637 = "CURRENCY"                                                       
   V638 = "JEWELRY AND PRECIOUS METALS"                                    
   V639 = "CLOTHING"                                                       
   V640 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V641 = "OFFICE EQUIPMENT"                                               
   V642 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V643 = "FIREARMS"                                                       
   V644 = "HOUSEHOLD GOODS"                                                
   V645 = "CONSUMABLE GOODS"                                               
   V646 = "LIVESTOCK"                                                      
   V647 = "MISCELLANEOUS"                                                  
   V648 = "TOTAL VALUE STOLEN"                                             
   V649 = "CURRENCY"                                                       
   V650 = "JEWELRY AND PRECIOUS METALS"                                    
   V651 = "CLOTHING"                                                       
   V652 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V653 = "OFFICE EQUIPMENT"                                               
   V654 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V655 = "FIREARMS"                                                       
   V656 = "HOUSEHOLD GOODS"                                                
   V657 = "CONSUMABLE GOODS"                                               
   V658 = "LIVESTOCK"                                                      
   V659 = "MISCELLANEOUS"                                                  
   V660 = "TOTAL VALUE STOLEN"                                             
   V661 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                        
   V662 = "STATUS"                                                         
   V663 = "MURDER OFFENSES"                                                
   V664 = "RAPE OFFENSES"                                                  
   V665 = "ROBBERY OFFENCES-HIGHWAY"                                       
   V666 = "ROBBERY OFFENCES-COMMON HOUSE"                                  
   V667 = "ROBBERY OFFENCES-GAS STATION"                                   
   V668 = "ROBBERY OFFENCES-CHAIN STORE"                                   
   V669 = "ROBBERY OFFENCES-RESIDENCE"                                     
   V670 = "ROBBERY OFFENCES-BANK"                                          
   V671 = "ROBBERY OFFENCES-MISCELLANEOUS"                                 
   V672 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                 
   V673 = "BURGLARY OFFENSES-RESIDENT NIGHT"                               
   V674 = "BURGLARY OFFENSES-RESIDENT DAY"                                 
   V675 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                             
   V676 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                           
   V677 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                             
   V678 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                         
   V679 = "BURGLARY OFFENSES-TOTAL BURGLARY"                               
   V680 = "LARCENY OFFENSES OVER $200"                                     
   V681 = "LARCENY OFFENSES-BETWEEN $50 TO $200"                           
   V682 = "LARCENY OFFENSES-UNDER $50"                                     
   V683 = "TOTAL LARCENY -- USED FOR"                                      
   V684 = "MOTOR VEHICLE THEFT"                                            
   V685 = "LARCENY ANALYSIS-POCKET PICKING"                                
   V686 = "LARCENY ANALYSIS -PURSE SNATCHING"                              
   V687 = "LARCENY ANALYSIS -SHOPLIFTING"                                  
   V688 = "LARCENY ANALYSIS -FROM AUTO"                                    
   V689 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                             
   V690 = "LARCENY ANALYSIS -BICYCLE"                                      
   V691 = "LARCENY ANALYSIS -FROM BUILDING"                                
   V692 = "LARCENY ANALYSIS -COIN MACHINE"                                 
   V693 = "LARCENY ANALYSIS -ALL OTHER"                                    
   V694 = "MURDER VALUE"                                                   
   V695 = "RAPE VALUE"                                                     
   V696 = "ROBBERY VALUE-HIGHWAY"                                          
   V697 = "ROBBERY VALUE-COMMON HOUSE"                                     
   V698 = "ROBBERY VALUE-GAS STATION"                                      
   V699 = "ROBBERY VALUE-CHAIN STORE"                                      
   V700 = "ROBBERY VALUE-RESIDENCE"                                        
   V701 = "ROBBERY VALUE-BANK"                                             
   V702 = "ROBBERY VALUE-MISCELLANEOUS"                                    
   V703 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                              
   V704 = "BURGLARY VALUE-RESIDENT NIGHT"                                  
   V705 = "BURGLARY VALUE-RESIDENT DAY"                                    
   V706 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                
   V707 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                              
   V708 = "BURGLARY VALUE-NON-RESIDENT DAY"                                
   V709 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                            
   V710 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                            
   V711 = "VALUE-OVER $200"                                                
   V712 = "LARCENY VALUE-BETWEEN $50 TO $200"                              
   V713 = "LARCENY VALUE-UNDER $50"                                        
   V714 = "TOTAL LARCENY VALUE"                                            
   V715 = "MOTOR VEHICLE THEFT VALUE"                                      
   V716 = "TOTAL VALUE ABOVE"                                              
   V717 = "ANALYSIS VALUE-POCKET PICKING"                                  
   V718 = "ANALYSIS VALUE-PURSE SNATCHING"                                 
   V719 = "ANALYSIS VALUE-SHOPLIFTING"                                     
   V720 = "ANALYSIS VALUE-FROM AUTO"                                       
   V721 = "ANALYSIS VALUE-AUTO ACCESSORIES"                                
   V722 = "ANALYSIS VALUE-BICYCLE"                                         
   V723 = "ANALYSIS VALUE-FROM BUILDING"                                   
   V724 = "ANALYSIS VALUE-COIN MACHINE"                                    
   V725 = "ANALYSIS VALUE-ALL OTHER"                                       
   V726 = "AUTO STOLEN AND RECOVERED LOCALLY"                              
   V727 = "AUTO STOLEN AND RECOVERED OTHER"                                
   V728 = "TOTAL"                                                          
   V729 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                        
   V730 = "CURRENCY"                                                       
   V731 = "JEWELRY AND PRECIOUS METALS"                                    
   V732 = "CLOTHING"                                                       
   V733 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V734 = "OFFICE EQUIPMENT"                                               
   V735 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V736 = "FIREARMS"                                                       
   V737 = "HOUSEHOLD GOODS"                                                
   V738 = "CONSUMABLE GOODS"                                               
   V739 = "LIVESTOCK"                                                      
   V740 = "MISCELLANEOUS"                                                  
   V741 = "TOTAL VALUE STOLEN"                                             
   V742 = "CURRENCY"                                                       
   V743 = "JEWELRY AND PRECIOUS METALS"                                    
   V744 = "CLOTHING"                                                       
   V745 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V746 = "OFFICE EQUIPMENT"                                               
   V747 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V748 = "FIREARMS"                                                       
   V749 = "HOUSEHOLD GOODS"                                                
   V750 = "CONSUMABLE GOODS"                                               
   V751 = "LIVESTOCK"                                                      
   V752 = "MISCELLANEOUS"                                                  
   V753 = "TOTAL VALUE STOLEN"                                             
   V754 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                        
   V755 = "STATUS"                                                         
   V756 = "MURDER OFFENSES"                                                
   V757 = "RAPE OFFENSES"                                                  
   V758 = "ROBBERY OFFENCES-HIGHWAY"                                       
   V759 = "ROBBERY OFFENCES-COMMON HOUSE"                                  
   V760 = "ROBBERY OFFENCES-GAS STATION"                                   
   V761 = "ROBBERY OFFENCES-CHAIN STORE"                                   
   V762 = "ROBBERY OFFENCES-RESIDENCE"                                     
   V763 = "ROBBERY OFFENCES-BANK"                                          
   V764 = "ROBBERY OFFENCES-MISCELLANEOUS"                                 
   V765 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                 
   V766 = "BURGLARY OFFENSES-RESIDENT NIGHT"                               
   V767 = "BURGLARY OFFENSES-RESIDENT DAY"                                 
   V768 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                             
   V769 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                           
   V770 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                             
   V771 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                         
   V772 = "BURGLARY OFFENSES-TOTAL BURGLARY"                               
   V773 = "LARCENY OFFENSES OVER $200"                                     
   V774 = "LARCENY OFFENSES-BETWEEN $50 TO $200"                           
   V775 = "LARCENY OFFENSES-UNDER $50"                                     
   V776 = "TOTAL LARCENY -- USED FOR"                                      
   V777 = "MOTOR VEHICLE THEFT"                                            
   V778 = "LARCENY ANALYSIS-POCKET PICKING"                                
   V779 = "LARCENY ANALYSIS -PURSE SNATCHING"                              
   V780 = "LARCENY ANALYSIS -SHOPLIFTING"                                  
   V781 = "LARCENY ANALYSIS -FROM AUTO"                                    
   V782 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                             
   V783 = "LARCENY ANALYSIS -BICYCLE"                                      
   V784 = "LARCENY ANALYSIS -FROM BUILDING"                                
   V785 = "LARCENY ANALYSIS -COIN MACHINE"                                 
   V786 = "LARCENY ANALYSIS -ALL OTHER"                                    
   V787 = "MURDER VALUE"                                                   
   V788 = "RAPE VALUE"                                                     
   V789 = "ROBBERY VALUE-HIGHWAY"                                          
   V790 = "ROBBERY VALUE-COMMON HOUSE"                                     
   V791 = "ROBBERY VALUE-GAS STATION"                                      
   V792 = "ROBBERY VALUE-CHAIN STORE"                                      
   V793 = "ROBBERY VALUE-RESIDENCE"                                        
   V794 = "ROBBERY VALUE-BANK"                                             
   V795 = "ROBBERY VALUE-MISCELLANEOUS"                                    
   V796 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                              
   V797 = "BURGLARY VALUE-RESIDENT NIGHT"                                  
   V798 = "BURGLARY VALUE-RESIDENT DAY"                                    
   V799 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                
   V800 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                              
   V801 = "BURGLARY VALUE-NON-RESIDENT DAY"                                
   V802 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                            
   V803 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                            
   V804 = "VALUE-OVER $200"                                                
   V805 = "LARCENY VALUE-BETWEEN $50 TO $200"                              
   V806 = "LARCENY VALUE-UNDER $50"                                        
   V807 = "TOTAL LARCENY VALUE"                                            
   V808 = "MOTOR VEHICLE THEFT VALUE"                                      
   V809 = "TOTAL VALUE ABOVE"                                              
   V810 = "ANALYSIS VALUE-POCKET PICKING"                                  
   V811 = "ANALYSIS VALUE-PURSE SNATCHING"                                 
   V812 = "ANALYSIS VALUE-SHOPLIFTING"                                     
   V813 = "ANALYSIS VALUE-FROM AUTO"                                       
   V814 = "ANALYSIS VALUE-AUTO ACCESSORIES"                                
   V815 = "ANALYSIS VALUE-BICYCLE"                                         
   V816 = "ANALYSIS VALUE-FROM BUILDING"                                   
   V817 = "ANALYSIS VALUE-COIN  MACHINE"                                   
   V818 = "ANALYSIS VALUE-ALL OTHER"                                       
   V819 = "AUTO STOLEN AND RECOVERED LOCALLY"                              
   V820 = "AUTO STOLEN AND RECOVERED OTHER"                                
   V821 = "TOTAL"                                                          
   V822 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                        
   V823 = "CURRENCY"                                                       
   V824 = "JEWELRY AND PRECIOUS METALS"                                    
   V825 = "CLOTHING"                                                       
   V826 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V827 = "OFFICE EQUIPMENT"                                               
   V828 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V829 = "FIREARMS"                                                       
   V830 = "HOUSEHOLD GOODS"                                                
   V831 = "CONSUMABLE GOODS"                                               
   V832 = "LIVESTOCK"                                                      
   V833 = "MISCELLANEOUS"                                                  
   V834 = "TOTAL VALUE STOLEN"                                             
   V835 = "CURRENCY"                                                       
   V836 = "JEWELRY AND PRECIOUS METALS"                                    
   V837 = "CLOTHING"                                                       
   V838 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V839 = "OFFICE EQUIPMENT"                                               
   V840 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V841 = "FIREARMS"                                                       
   V842 = "HOUSEHOLD GOODS"                                                
   V843 = "CONSUMABLE GOODS"                                               
   V844 = "LIVESTOCK"                                                      
   V845 = "MISCELLANEOUS"                                                  
   V846 = "TOTAL VALUE STOLEN"                                             
   V847 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                        
   V848 = "STATUS"                                                         
   V849 = "MURDER OFFENSES"                                                
   V850 = "RAPE OFFENSES"                                                  
   V851 = "ROBBERY OFFENCES-HIGHWAY"                                       
   V852 = "ROBBERY OFFENCES-COMMON HOUSE"                                  
   V853 = "ROBBERY OFFENCES-GAS STATION"                                   
   V854 = "ROBBERY OFFENCES-CHAIN STORE"                                   
   V855 = "ROBBERY OFFENCES-RESIDENCE"                                     
   V856 = "ROBBERY OFFENCES-BANK"                                          
   V857 = "ROBBERY OFFENCES-MISCELLANEOUS"                                 
   V858 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                 
   V859 = "BURGLARY OFFENSES-RESIDENT NIGHT"                               
   V860 = "BURGLARY OFFENSES-RESIDENT DAY"                                 
   V861 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                             
   V862 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                           
   V863 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                             
   V864 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                         
   V865 = "BURGLARY OFFENSES-TOTAL BURGLARY"                               
   V866 = "LARCENY OFFENSES OVER $200"                                     
   V867 = "LARCENY OFFENSES-BETWEEN $50 TO $200"                           
   V868 = "LARCENY OFFENSES-UNDER $50"                                     
   V869 = "TOTAL LARCENY -- USED FOR"                                      
   V870 = "MOTOR VEHICLE THEFT"                                            
   V871 = "LARCENY ANALYSIS-POCKET PICKING"                                
   V872 = "LARCENY ANALYSIS -PURSE SNATCHING"                              
   V873 = "LARCENY ANALYSIS -SHOPLIFTING"                                  
   V874 = "LARCENY ANALYSIS -FROM AUTO"                                    
   V875 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                             
   V876 = "LARCENY ANALYSIS -BICYCLE"                                      
   V877 = "LARCENY ANALYSIS -FROM BUILDING"                                
   V878 = "LARCENY ANALYSIS -COIN MACHINE"                                 
   V879 = "LARCENY ANALYSIS -ALL OTHER"                                    
   V880 = "MURDER VALUE"                                                   
   V881 = "RAPE VALUE"                                                     
   V882 = "ROBBERY VALUE-HIGHWAY"                                          
   V883 = "ROBBERY VALUE-COMMON HOUSE"                                     
   V884 = "ROBBERY VALUE-GAS STATION"                                      
   V885 = "ROBBERY VALUE-CHAIN STORE"                                      
   V886 = "ROBBERY VALUE-RESIDENCE"                                        
   V887 = "ROBBERY VALUE-BANK"                                             
   V888 = "ROBBERY VALUE-MISCELLANEOUS"                                    
   V889 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                              
   V890 = "BURGLARY VALUE-RESIDENT NIGHT"                                  
   V891 = "BURGLARY VALUE-RESIDENT DAY"                                    
   V892 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                
   V893 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                              
   V894 = "BURGLARY VALUE-NON-RESIDENT DAY"                                
   V895 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                            
   V896 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                            
   V897 = "VALUE-OVER $200"                                                
   V898 = "LARCENY VALUE-BETWEEN $50 TO $200"                              
   V899 = "LARCENY VALUE-UNDER $50"                                        
   V900 = "TOTAL LARCENY VALUE"                                            
   V901 = "MOTOR VEHICLE THEFT VALUE"                                      
   V902 = "TOTAL VALUE ABOVE"                                              
   V903 = "ANALYSIS VALUE-POCKET PICKING"                                  
   V904 = "ANALYSIS VALUE-PURSE SNATCHING"                                 
   V905 = "ANALYSIS VALUE-SHOPLIFTING"                                     
   V906 = "ANALYSIS VALUE-FROM AUTO"                                       
   V907 = "ANALYSIS VALUE-AUTO ACCESSORIES"                                
   V908 = "ANALYSIS VALUE-BICYCLE"                                         
   V909 = "ANALYSIS VALUE-FROM BUILDING"                                   
   V910 = "ANALYSIS VALUE-COIN MACHINE"                                    
   V911 = "ANALYSIS VALUE-ALL OTHER"                                       
   V912 = "AUTO STOLEN AND RECOVERED LOCALLY"                              
   V913 = "AUTO STOLEN AND RECOVERED OTHER"                                
   V914 = "TOTAL"                                                          
   V915 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                        
   V916 = "CURRENCY"                                                       
   V917 = "JEWELRY AND PRECIOUS METALS"                                    
   V918 = "CLOTHING"                                                       
   V919 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V920 = "OFFICE EQUIPMENT"                                               
   V921 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V922 = "FIREARMS"                                                       
   V923 = "HOUSEHOLD GOODS"                                                
   V924 = "CONSUMABLE GOODS"                                               
   V925 = "LIVESTOCK"                                                      
   V926 = "MISCELLANEOUS"                                                  
   V927 = "TOTAL VALUE STOLEN"                                             
   V928 = "CURRENCY"                                                       
   V929 = "JEWELRY AND PRECIOUS METALS"                                    
   V930 = "CLOTHING"                                                       
   V931 = "LOCALLY STOLEN MOTOR VEHICLES"                                  
   V932 = "OFFICE EQUIPMENT"                                               
   V933 = "TELEVISIONS, RADIOS, STEREOS"                                   
   V934 = "FIREARMS"                                                       
   V935 = "HOUSEHOLD GOODS"                                                
   V936 = "CONSUMABLE GOODS"                                               
   V937 = "LIVESTOCK"                                                      
   V938 = "MISCELLANEOUS"                                                  
   V939 = "TOTAL VALUE STOLEN"                                             
   V940 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                        
   V941 = "STATUS"                                                         
   V942 = "MURDER OFFENSES"                                                
   V943 = "RAPE OFFENSES"                                                  
   V944 = "ROBBERY OFFENCES-HIGHWAY"                                       
   V945 = "ROBBERY OFFENCES-COMMON HOUSE"                                  
   V946 = "ROBBERY OFFENCES-GAS STATION"                                   
   V947 = "ROBBERY OFFENCES-CHAIN STORE"                                   
   V948 = "ROBBERY OFFENCES-RESIDENCE"                                     
   V949 = "ROBBERY OFFENCES-BANK"                                          
   V950 = "ROBBERY OFFENCES-MISCELLANEOUS"                                 
   V951 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                 
   V952 = "BURGLARY OFFENSES-RESIDENT NIGHT"                               
   V953 = "BURGLARY OFFENSES-RESIDENT DAY"                                 
   V954 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                             
   V955 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                           
   V956 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                             
   V957 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                         
   V958 = "BURGLARY OFFENSES-TOTAL BURGLARY"                               
   V959 = "LARCENY OFFENSES OVER $200"                                     
   V960 = "LARCENY OFFENSES-BETWEEN $50 TO $200"                           
   V961 = "LARCENY OFFENSES-UNDER $50"                                     
   V962 = "TOTAL LARCENY -- USED FOR"                                      
   V963 = "MOTOR VEHICLE THEFT"                                            
   V964 = "LARCENY ANALYSIS-POCKET PICKING"                                
   V965 = "LARCENY ANALYSIS -PURSE SNATCHING"                              
   V966 = "LARCENY ANALYSIS -SHOPLIFTING"                                  
   V967 = "LARCENY ANALYSIS -FROM  AUTO"                                   
   V968 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                             
   V969 = "LARCENY ANALYSIS -BICYCLE"                                      
   V970 = "LARCENY ANALYSIS -FROM BUILDING"                                
   V971 = "LARCENY ANALYSIS -COIN MACHINE"                                 
   V972 = "LARCENY ANALYSIS -ALL OTHER"                                    
   V973 = "MURDER VALUE"                                                   
   V974 = "RAPE VALUE"                                                     
   V975 = "ROBBERY VALUE-HIGHWAY"                                          
   V976 = "ROBBERY VALUE-COMMON HOUSE"                                     
   V977 = "ROBBERY VALUE-GAS STATION"                                      
   V978 = "ROBBERY VALUE-CHAIN STORE"                                      
   V979 = "ROBBERY VALUE-RESIDENCE"                                        
   V980 = "ROBBERY VALUE-BANK"                                             
   V981 = "ROBBERY VALUE-MISCELLANEOUS"                                    
   V982 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                              
   V983 = "BURGLARY VALUE-RESIDENT NIGHT"                                  
   V984 = "BURGLARY VALUE-RESIDENT DAY"                                    
   V985 = "BURGLARY VALUE-RESIDENT UNKNOWN"                                
   V986 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                              
   V987 = "BURGLARY VALUE-NON-RESIDENT DAY"                                
   V988 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                            
   V989 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                            
   V990 = "VALUE-OVER $200"                                                
   V991 = "LARCENY VALUE-BETWEEN $50 TO $200"                              
   V992 = "LARCENY VALUE-UNDER $50"                                        
   V993 = "TOTAL LARCENY  VALUE"                                           
   V994 = "MOTOR VEHICLE THEFT VALUE"                                      
   V995 = "TOTAL VALUE ABOVE"                                              
   V996 = "ANALYSIS VALUE-POCKET PICKING"                                  
   V997 = "ANALYSIS VALUE-PURSE SNATCHING"                                 
   V998 = "ANALYSIS VALUE-SHOPLIFTING"                                     
   V999 = "ANALYSIS VALUE-FROM AUTO"                                       
   V1000 = "ANALYSIS VALUE-AUTO ACCESSORIES"                               
   V1001 = "ANALYSIS VALUE-BICYCLE"                                        
   V1002 = "ANALYSIS VALUE-FROM BUILDING"                                  
   V1003 = "ANALYSIS VALUE-COIN MACHINE"                                   
   V1004 = "ANALYSIS VALUE-ALL OTHER"                                      
   V1005 = "AUTO STOLEN AND RECOVERED LOCALLY"                             
   V1006 = "AUTO STOLEN AND RECOVERED OTHER"                               
   V1007 = "TOTAL"                                                         
   V1008 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                       
   V1009 = "CURRENCY"                                                      
   V1010 = "JEWELRY AND PRECIOUS METALS"                                   
   V1011 = "CLOTHING"                                                      
   V1012 = "LOCALLY STOLEN MOTOR VEHICLES"                                 
   V1013 = "OFFICE EQUIPMENT"                                              
   V1014 = "TELEVISIONS, RADIOS, STEREOS"                                  
   V1015 = "FIREARMS"                                                      
   V1016 = "HOUSEHOLD GOODS"                                               
   V1017 = "CONSUMABLE GOODS"                                              
   V1018 = "LIVESTOCK"                                                     
   V1019 = "MISCELLANEOUS"                                                 
   V1020 = "TOTAL VALUE STOLEN"                                            
   V1021 = "CURRENCY"                                                      
   V1022 = "JEWELRY AND PRECIOUS METALS"                                   
   V1023 = "CLOTHING"                                                      
   V1024 = "LOCALLY STOLEN MOTOR VEHICLES"                                 
   V1025 = "OFFICE EQUIPMENT"                                              
   V1026 = "TELEVISIONS, RADIOS, STEREOS"                                  
   V1027 = "FIREARMS"                                                      
   V1028 = "HOUSEHOLD GOODS"                                               
   V1029 = "CONSUMABLE GOODS"                                              
   V1030 = "LIVESTOCK"                                                     
   V1031 = "MISCELLANEOUS"                                                 
   V1032 = "TOTAL VALUE STOLEN"                                            
   V1033 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE"                       
   V1034 = "STATUS"                                                        
   V1035 = "MURDER OFFENSES"                                               
   V1036 = "RAPE OFFENSES"                                                 
   V1037 = "ROBBERY OFFENCES-HIGHWAY"                                      
   V1038 = "ROBBERY OFFENCES-COMMON HOUSE"                                 
   V1039 = "ROBBERY OFFENCES-GAS STATION"                                  
   V1040 = "ROBBERY OFFENCES-CHAIN STORE"                                  
   V1041 = "ROBBERY OFFENCES-RESIDENCE"                                    
   V1042 = "ROBBERY OFFENCES-BANK"                                         
   V1043 = "ROBBERY OFFENCES-MISCELLANEOUS"                                
   V1044 = "ROBBERY OFFENCES-TOTAL ROBBERY"                                
   V1045 = "BURGLARY OFFENSES-RESIDENT NIGHT"                              
   V1046 = "BURGLARY OFFENSES-RESIDENT DAY"                                
   V1047 = "BURGLARY OFFENSES-RESIDENT UNKNOWN"                            
   V1048 = "BURGLARY OFFENSES-NON-RESIDENT NIGHT"                          
   V1049 = "BURGLARY OFFENSES-NON-RESIDENT DAY"                            
   V1050 = "BURGLARY OFFENSES-NON-RESIDENT UNKNOWN"                        
   V1051 = "BURGLARY OFFENSES-TOTAL BURGLARY"                              
   V1052 = "LARCENY OFFENSES OVER $200"                                    
   V1053 = "LARCENY OFFENSES-BETWEEN $50 TO $200"                          
   V1054 = "LARCENY OFFENSES-UNDER $50"                                    
   V1055 = "TOTAL LARCENY -- USED FOR LARCENY SUPPL"                       
   V1056 = "MOTOR VEHICLE THEFT"                                           
   V1057 = "LARCENY ANALYSIS-POCKET PICKING"                               
   V1058 = "LARCENY ANALYSIS -PURSE SNATCHING"                             
   V1059 = "LARCENY ANALYSIS -SHOPLIFTING"                                 
   V1060 = "LARCENY ANALYSIS -FROM  AUTO"                                  
   V1061 = "LARCENY ANALYSIS -AUTO ACCESSORIES"                            
   V1062 = "LARCENY ANALYSIS -BICYCLE"                                     
   V1063 = "LARCENY ANALYSIS -FROM BUILDING"                               
   V1064 = "LARCENY ANALYSIS -COIN MACHINE"                                
   V1065 = "LARCENY ANALYSIS -ALL OTHER"                                   
   V1066 = "MURDER VALUE"                                                  
   V1067 = "RAPE VALUE"                                                    
   V1068 = "ROBBERY VALUE-HIGHWAY"                                         
   V1069 = "ROBBERY VALUE-COMMON HOUSE"                                    
   V1070 = "ROBBERY VALUE-GAS STATION"                                     
   V1071 = "ROBBERY VALUE-CHAIN STORE"                                     
   V1072 = "ROBBERY VALUE-RESIDENCE"                                       
   V1073 = "ROBBERY VALUE-BANK"                                            
   V1074 = "ROBBERY VALUE-MISCELLANEOUS"                                   
   V1075 = "ROBBERY VALUE-TOTAL ROBBERY VALUE"                             
   V1076 = "BURGLARY VALUE-RESIDENT NIGHT"                                 
   V1077 = "BURGLARY VALUE-RESIDENT DAY"                                   
   V1078 = "BURGLARY VALUE-RESIDENT UNKNOWN"                               
   V1079 = "BURGLARY VALUE-NON-RESIDENT NIGHT"                             
   V1080 = "BURGLARY VALUE-NON-RESIDENT DAY"                               
   V1081 = "BURGLARY VALUE-NON-RESIDENT UNKNOWN"                           
   V1082 = "BURGLARY VALUE-TOTAL BURGLARY VALUE"                           
   V1083 = "VALUE-OVER $200"                                               
   V1084 = "LARCENY VALUE-BETWEEN $50 TO $200"                             
   V1085 = "LARCENY VALUE-UNDER $50"                                       
   V1086 = "TOTAL LARCENY VALUE"                                           
   V1087 = "MOTOR VEHICLE THEFT VALUE"                                     
   V1088 = "TOTAL VALUE ABOVE"                                             
   V1089 = "ANALYSIS VALUE-POCKET PICKING"                                 
   V1090 = "ANALYSIS VALUE-PURSE SNATCHING"                                
   V1091 = "ANALYSIS VALUE-SHOPLIFTING"                                    
   V1092 = "ANALYSIS VALUE-FROM AUTO"                                      
   V1093 = "ANALYSIS VALUE-AUTO ACCESSORIES"                               
   V1094 = "ANALYSIS VALUE-BICYCLE"                                        
   V1095 = "ANALYSIS VALUE-FROM BUILDING"                                  
   V1096 = "ANALYSIS VALUE-COIN  MACHINE"                                  
   V1097 = "ANALYSIS VALUE-ALL OTHER"                                      
   V1098 = "AUTO STOLEN AND RECOVERED LOCALLY"                             
   V1099 = "AUTO STOLEN AND RECOVERED OTHER"                               
   V1100 = "TOTAL"                                                         
   V1101 = "AUTO STOLEN OTHER AND RECOVERED LOCALLY"                       
   V1102 = "CURRENCY"                                                      
   V1103 = "JEWELRY AND PRECIOUS METALS"                                   
   V1104 = "CLOTHING"                                                      
   V1105 = "LOCALLY STOLEN MOTOR VEHICLES"                                 
   V1106 = "OFFICE EQUIPMENT"                                              
   V1107 = "TELEVISIONS, RADIOS, STEREOS"                                  
   V1108 = "FIREARMS"                                                      
   V1109 = "HOUSEHOLD GOODS"                                               
   V1110 = "CONSUMABLE GOODS"                                              
   V1111 = "LIVESTOCK"                                                     
   V1112 = "MISCELLANEOUS"                                                 
   V1113 = "TOTAL VALUE STOLEN"                                            
   V1114 = "CURRENCY"                                                      
   V1115 = "JEWELRY AND PRECIOUS METALS"                                   
   V1116 = "CLOTHING"                                                      
   V1117 = "LOCALLY STOLEN MOTOR VEHICLES"                                 
   V1118 = "OFFICE EQUIPMENT"                                              
   V1119 = "TELEVISIONS, RADIOS, STEREOS"                                  
   V1120 = "FIREARMS"                                                      
   V1121 = "HOUSEHOLD GOODS"                                               
   V1122 = "CONSUMABLE GOODS"                                              
   V1123 = "LIVESTOCK"                                                     
   V1124 = "MISCELLANEOUS"                                                 
   V1125 = "TOTAL VALUE STOLEN"                                            
   V1126 = "UPDATE OR BATCH NUMBER-INTERNAL FBI USE";                      
                                                                           
* SAS FORMAT STATEMENT;                                                    
                                                                           
/*                                                                         
FORMAT                                                                     
   V2 V2FT.               V4 $V4FT.              V5 V5FT.                  
   V11 V11FT.             V104 V104FT.           V197 V197FT.              
   V290 V290FT.           V383 V383FT.           V476 V476FT.              
   V569 V569FT.           V662 V662FT.           V755 V755FT.              
   V848 V848FT.           V941 V941FT.           V1034 V1034FT.;           
*/                                                                         
                                                                           
                                                                           
                                                                           
                                                                           
