/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.ContainerPointSet;
import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class AntitheticPointSet
extends ContainerPointSet {
    public AntitheticPointSet(PointSet P) {
        this.init(P);
    }

    public double getCoordinate(int i, int j) {
        return 1.0 - this.P.getCoordinate(i, j);
    }

    public PointSetIterator iterator() {
        return new AntitheticPointSetIterator();
    }

    public String toString() {
        return "Antithetic point set of: {" + PrintfFormat.NEWLINE + this.P.toString() + PrintfFormat.NEWLINE + "}";
    }

    protected class AntitheticPointSetIterator
    extends ContainerPointSet.ContainerPointSetIterator {
        protected AntitheticPointSetIterator() {
            super(AntitheticPointSet.this);
        }

        public double nextCoordinate() {
            return 1.0 - this.innerIterator.nextCoordinate();
        }

        public double nextDouble() {
            return 1.0 - this.innerIterator.nextCoordinate();
        }

        public void nextCoordinates(double[] p, int d) {
            this.innerIterator.nextCoordinates(p, d);
            for (int j = 0; j < d; ++j) {
                p[j] = 1.0 - p[j];
            }
        }

        public int nextPoint(double[] p, int d) {
            this.innerIterator.nextPoint(p, d);
            for (int j = 0; j < d; ++j) {
                p[j] = 1.0 - p[j];
            }
            return this.getCurPointIndex();
        }
    }
}

