/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.Distribution;
import umontreal.iro.lecuyer.probdist.PiecewiseLinearEmpiricalDist;
import umontreal.iro.lecuyer.randvar.RandUnuran;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class UnuranEmpirical
extends RandomVariateGen {
    private RandUnuran unuran = new RandUnuran();

    public UnuranEmpirical(RandomStream s, String genStr) {
        if (s == null) {
            throw new IllegalArgumentException("s must not be null.");
        }
        this.unuran.mainStream = this.unuran.auxStream = s;
        this.unuran.init(genStr);
        if (!this.unuran.isEmpirical()) {
            this.unuran.close();
            throw new IllegalArgumentException("not an empirical distribution");
        }
    }

    public UnuranEmpirical(RandomStream s, RandomStream aux, String genStr) {
        if (s == null) {
            throw new IllegalArgumentException("s must not be null.");
        }
        if (aux == null) {
            throw new IllegalArgumentException("aux must not be null.");
        }
        this.unuran.mainStream = s;
        this.unuran.auxStream = aux;
        this.unuran.init(genStr);
        if (!this.unuran.isEmpirical()) {
            this.unuran.close();
            throw new IllegalArgumentException("not an empirical distribution");
        }
    }

    public UnuranEmpirical(RandomStream s, PiecewiseLinearEmpiricalDist dist, String genStr) {
        if (s == null) {
            throw new IllegalArgumentException("s must not be null.");
        }
        this.unuran.mainStream = this.unuran.auxStream = s;
        String gstr = this.readDistr(dist) + (genStr == null || genStr.equals("") ? "" : "&" + genStr);
        this.unuran.init(gstr);
        if (!this.unuran.isEmpirical()) {
            this.unuran.close();
            throw new IllegalArgumentException("not an empirical distribution");
        }
    }

    public UnuranEmpirical(RandomStream s, RandomStream aux, PiecewiseLinearEmpiricalDist dist, String genStr) {
        if (s == null) {
            throw new IllegalArgumentException("s must not be null.");
        }
        if (aux == null) {
            throw new IllegalArgumentException("aux must not be null.");
        }
        this.unuran.mainStream = s;
        this.unuran.auxStream = aux;
        String gstr = this.readDistr(dist) + (genStr == null || genStr.equals("") ? "" : "&" + genStr);
        this.unuran.init(gstr);
        if (!this.unuran.isEmpirical()) {
            this.unuran.close();
            throw new IllegalArgumentException("not an empirical distribution");
        }
    }

    private String readDistr(PiecewiseLinearEmpiricalDist dist) {
        StringBuffer sb = new StringBuffer("distr=cemp; data=(");
        boolean first = true;
        for (int i = 0; i < dist.getN(); ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(dist.getObs(i));
        }
        sb.append(")");
        return sb.toString();
    }

    public double nextDouble() {
        if (this.unuran.nativeParams == 0) {
            throw new IllegalStateException();
        }
        return this.unuran.getRandCont(this.unuran.mainStream.nextDouble(), this.unuran.nativeParams);
    }

    public void nextArrayOfDouble(double[] v, int start, int n) {
        if (v == null || start < 0 || n < 0 || start + n > v.length) {
            throw new IllegalArgumentException();
        }
        if (this.unuran.unifArray == null || this.unuran.unifArray.length < n) {
            this.unuran.unifArray = new double[n];
        }
        if (this.unuran.mainStream != this.unuran.auxStream && (this.unuran.unifAuxArray == null || this.unuran.unifAuxArray.length < n)) {
            this.unuran.unifAuxArray = new double[n];
        }
        this.unuran.getRandContArray(this.unuran.nativeParams, this.unuran.unifArray, this.unuran.unifAuxArray, v, start, n);
    }

    protected void finalize() {
        this.unuran.close();
    }

    public Distribution getDistribution() {
        return null;
    }

    public RandomStream getStream() {
        return this.unuran.mainStream;
    }

    public RandomStream getAuxStream() {
        return this.unuran.auxStream;
    }
}

