## -----------------------------------------------------------------------------
library(jrvFinance)

## -----------------------------------------------------------------------------
npv(cf=c(100,250,300), rate=5e-2)

## -----------------------------------------------------------------------------
npv(cf=c(1,3,2), rate=10e-2, cf.t=c(0.3,1.9,2.5))

## -----------------------------------------------------------------------------
irr(c(-600,300,400))

## -----------------------------------------------------------------------------
irr(c(-600,100,400))

## -----------------------------------------------------------------------------
irr(cf=c(-450,100,300,200), cf.t=c(0, 0.3,1.9,2.5)) 

## -----------------------------------------------------------------------------
irr(cf=c(100, -230, 132), interval = c(0.05, 0.17)) 
irr(cf=c(100, -230, 132), interval = c(0.17, 0.50)) 

## -----------------------------------------------------------------------------
irr(cf=c(100, -230, 132), r.guess = 0) 
irr(cf=c(100, -230, 132), r.guess = 0.5) 

## -----------------------------------------------------------------------------
duration(cf=c(100,250,300), rate=5e-2)

## -----------------------------------------------------------------------------
duration(cf=c(100,250,300), rate=5e-2, modified=TRUE)

## -----------------------------------------------------------------------------
annuity.pv(rate=10e-2, n.periods=15)

## -----------------------------------------------------------------------------
annuity.pv(rate=10e-2, n.periods=15, immediate.start = TRUE)

## -----------------------------------------------------------------------------
annuity.pv(rate=7e-2, instalment = 35, n.periods=Inf)
## or more simply
annuity.pv(rate=7e-2, instalment = 35)

## -----------------------------------------------------------------------------
annuity.pv(rate=10e-2, instalment = 450, n.periods=360, cf.freq=12, comp.freq=2)

## -----------------------------------------------------------------------------
annuity.rate(pv=50000, instalment = 450, n.periods=360, cf.freq=12, comp.freq=2)

## -----------------------------------------------------------------------------
annuity.rate(pv=250000, instalment = 450, n.periods=360, cf.freq=12, comp.freq=2)

## -----------------------------------------------------------------------------
annuity.instalment(rate=9e-2, pv=10000, n.periods=8)

## -----------------------------------------------------------------------------
AIB <- annuity.instalment.breakup(rate=9e-2, pv=10000, n.periods=8,
                                  period.no=5)
# we use unlist to print the result more compactly
unlist(AIB)


## -----------------------------------------------------------------------------
bond.price(settle="2012-04-15", mature="2022-01-01", coupon=8e-2,
           yield=8.8843e-2)

## -----------------------------------------------------------------------------
bond.price(settle="2012-04-15", mature="2022-01-01", coupon=8e-2,
           yield=8.8843e-2, freq=1)

## -----------------------------------------------------------------------------
bond.price(settle="2012-04-15", mature="2022-01-01", coupon=8e-2,
           yield=8.8843e-2, freq=1, comp.freq=2)

## -----------------------------------------------------------------------------
bond.yield(settle='2018-01-01', mature='2023-01-01', coupon=5e-2, price=101,
           redemption_value = 102)

## -----------------------------------------------------------------------------
bond.yield(settle="2012-04-15", mature="2022-01-01", coupon=8e-2,
           price=95) 

## -----------------------------------------------------------------------------
bond.yield(settle="2012-04-15", mature="2017-01-01", coupon=1e-2,
           price=120) 

## -----------------------------------------------------------------------------
bond.yield(settle='2018-01-01', mature='2023-01-01', coupon=5e-2, price=101,
           redemption_value = 102)

## -----------------------------------------------------------------------------
bond.duration(settle="2012-04-15", mature="2022-01-01", coupon=8e-2,
              yield=8.8843e-2)

## -----------------------------------------------------------------------------
bond.duration(settle="2012-04-15", mature="2022-01-01", coupon=8e-2,
              yield=8.8843e-2, modified=TRUE)

## -----------------------------------------------------------------------------
bond.prices(settle="2012-01-01", mature=c("2022-01-01", "2032-01-01"),
            coupon=c(0.09, 0.08,0.07,0.06), yield=0.10)

## -----------------------------------------------------------------------------
bond.yields(settle="2012-01-01", mature=c("2022-01-01", "2032-01-01"),
            coupon=c(0.09, 0.08,0.07,0.06),
            price=c(94, 83, 81, 65))

## -----------------------------------------------------------------------------
bond.durations(settle="2012-01-01",
               mature=c("2022-01-01", "2032-01-01"),
               coupon=c(0.09, 0.08,0.07,0.06),  yield=0.10)

## -----------------------------------------------------------------------------
coupons.dates(settle="2012-04-15", mature="2022-01-01")
coupons.dates(settle="2012-04-15", mature="2022-01-01", freq=1)

## -----------------------------------------------------------------------------
coupons.next(settle="2012-04-15", mature="2022-04-01")
coupons.prev(settle="2012-04-15", mature="2022-04-01")

## -----------------------------------------------------------------------------
coupons.n(settle="2012-04-15", mature="2017-07-01")

## -----------------------------------------------------------------------------
BS <- GenBS(s=100, X=100, r=0.1, Sigma=20e-2, t=1, div_yield=0)
# we use unlist to print the result more compactly
unlist(BS)

## -----------------------------------------------------------------------------
GBS <- GenBS(s=100, X=120, r=0.1, Sigma=15e-2, t=1, div_yield=5.8e-2)
# we use unlist to print the result more compactly
unlist(GBS)

## -----------------------------------------------------------------------------
GenBSImplied(s=100, X=100, r=0, price=7.97, t=1, div_yield=0)

## -----------------------------------------------------------------------------
GenBSImplied(s=100, X=90, r=0, price=7.97, t=1, div_yield=0)

## -----------------------------------------------------------------------------
GenBSImplied(s=100, X=900, r=0, price=7.97, t=1, div_yield=0)

## -----------------------------------------------------------------------------
equiv.rate(10e-2, from.freq = 12, to.freq = 2) 

## -----------------------------------------------------------------------------
equiv.rate(15e-2, from.freq = 1, to.freq = Inf)

## -----------------------------------------------------------------------------
edate("2005-05-17", -8) 

## -----------------------------------------------------------------------------
edate("2007-02-28", 4) 

## -----------------------------------------------------------------------------
edate("2008-02-28", 4) 

## -----------------------------------------------------------------------------
fn1 <-function(x){list(value=sin(x)-cos(x), gradient=cos(x)+sin(x))} 
newton.raphson.root(fn1) 

## -----------------------------------------------------------------------------
fn2 <-function(x){list(value=2 + sin(x), gradient=cos(x))}
newton.raphson.root(fn2) 

## -----------------------------------------------------------------------------
bisection.root(sin, guess = 7, lower=1, upper=13)
bisection.root(sin, guess = 12, lower=1, upper=13) 

