/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.exprtree.mut;

import net.sf.jclec.exprtree.ExprTree;
import net.sf.jclec.exprtree.ExprTreeIndividual;
import net.sf.jclec.exprtree.ExprTreeMutator;
import net.sf.jclec.exprtree.IExprTreeSpecies;
import net.sf.jclec.exprtree.IPrimitive;
import net.sf.jclec.util.random.IRandGen;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromoteMutator<I extends ExprTreeIndividual>
extends ExprTreeMutator<I> {
    private static final long serialVersionUID = 5710123544215454850L;

    public boolean equals(Object other) {
        if (other instanceof PromoteMutator) {
            PromoteMutator o = (PromoteMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.targetTreeIndex, o.targetTreeIndex);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected ExprTree mutateExpression(ExprTree expr, IExprTreeSpecies.IExprTreeSchema schema) {
        ExprTree son = new ExprTree();
        int size = expr.size();
        int maxSize = schema.getMaxTreeSize() - size;
        int maxArity = maxSize - 1;
        if (maxSize >= 1) {
            int i;
            int startIndex = this.randgen.choose(1, size);
            int endIndex = expr.subTree(startIndex);
            int i2 = 0;
            while (i2 < startIndex) {
                son.addBlock(expr.getBlock(i2).copy());
                ++i2;
            }
            Class<?> rtype = expr.getBlock(startIndex).returnType();
            IPrimitive result = this.functionBlockSuitable(maxArity, rtype, this.randgen, schema);
            if (result != null) {
                son.addBlock(result);
                i = startIndex;
                while (i < expr.subTree(startIndex)) {
                    son.addBlock(expr.getBlock(i));
                    ++i;
                }
                i = 1;
                while (i < result.argumentTypes().length) {
                    son.addBlock(schema.getTerminalBlock(rtype, this.randgen));
                    ++i;
                }
            } else {
                i = startIndex;
                while (i < endIndex) {
                    son.addBlock(expr.getBlock(i).copy());
                    ++i;
                }
            }
            i = endIndex;
            while (i < size) {
                son.addBlock(expr.getBlock(i).copy());
                ++i;
            }
        } else {
            son = expr.copy();
        }
        return son;
    }

    protected IPrimitive functionBlockSuitable(int maxArity, Class<?> rtype, IRandGen randgen, IExprTreeSpecies.IExprTreeSchema schema) {
        IPrimitive result = null;
        int maxAttempt = schema.getNumFunctionBlocks(rtype);
        int attempt = 0;
        boolean noValid = true;
        do {
            if ((result = schema.getFunctionBlockBetweenMinMaxArity(rtype, randgen, 1, maxArity)) == null) {
                attempt = maxAttempt;
                continue;
            }
            Class<?>[] sonstype = result.argumentTypes();
            int i = 0;
            while (i < sonstype.length && noValid) {
                if (sonstype[i].equals(rtype)) {
                    noValid = false;
                }
                ++i;
            }
        } while (noValid && ++attempt < maxAttempt);
        return result.instance();
    }
}

