## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  message = FALSE,
  warning = FALSE
)

## ----setup--------------------------------------------------------------------
library(mixtree)

## ----make_tree----------------------------------------------------------------
 make_tree(20, R = 2, stochastic = TRUE, plot = TRUE)

## ----permanova----------------------------------------------------------------
set.seed(123)
# Generate 100 trees with R₀ = 2
chainA <- lapply(1:100, function(i){
  make_tree(20, R = 2, stochastic = TRUE) |>
    igraph::as_long_data_frame()
})

# Generate 100 trees with R₀ = 4
chainB <- lapply(1:100, function(i){
  make_tree(20, R = 4, stochastic = TRUE) |>
     igraph::as_long_data_frame()
})

tree_test(chainA, chainB, method = "permanova")

## ----chisq--------------------------------------------------------------------
tree_test(chainA, chainB, method = "chisq", test_args = list(simulate.p.value = TRUE, B = 999))


## ----treespace----------------------------------------------------------------
library(treespace)
mrciDepth <- function(tree) {
 treespace::findMRCIs(as.matrix(tree))$mrciDepths
}
tree_test(chainA, chainB, within_dist = mrciDepth)

## ----shuffle_graph_ids--------------------------------------------------------
chainA <- lapply(1:50, function(i) {
  make_tree(20, R = 2, stochastic = TRUE)
})
chainB <- lapply(1:50, function(i) {
  df <- mixtree:::shuffle_graph_ids(chainA[[i]]) |>
    igraph::as_long_data_frame()
  subset(df, select = c("from", "to"))
})
chainA <- lapply(chainA, igraph::as_long_data_frame)
  
tree_test(chainA, chainB, method = "permanova")

# In contrast, the Chi-Square test will reject the null as it compare the distribution of of ancestries for each case
tree_test(chainA, chainB, method = "chisq")

