/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.distributions.LogTransformedNormalKDEDistribution;
import dr.math.distributions.NormalKDEDistribution;
import dr.util.Transform;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

public class TransformedNormalKDEDistribution
extends NormalKDEDistribution {
    public static final int MINIMUM_GRID_SIZE = 2048;
    public static final boolean DEBUG = false;
    private final Transform transform;

    public TransformedNormalKDEDistribution(Double[] doubleArray, Transform transform) {
        this(doubleArray, transform, null, null, null);
    }

    private TransformedNormalKDEDistribution(Double[] doubleArray, Transform transform, Double d, Double d2, Double d3) {
        this(doubleArray, transform, d, d2, d3, 3.0, 2048);
    }

    private TransformedNormalKDEDistribution(Double[] doubleArray, Transform transform, Double d, Double d2, Double d3, double d4, int n) {
        super(TransformedNormalKDEDistribution.getTransform(doubleArray, transform), d, d2, d3, d4, n);
        this.transform = transform;
    }

    private static Double[] getTransform(Double[] doubleArray, Transform transform) {
        Double[] doubleArray2 = new Double[doubleArray.length];
        for (int i = 0; i < doubleArray2.length; ++i) {
            if (!transform.isInInteriorDomain(doubleArray[i])) {
                throw new RuntimeException("The sample to estimate does not lie in the bound coherent with the transformation: x[" + i + "] = " + doubleArray[i] + ".");
            }
            doubleArray2[i] = transform.transform(doubleArray[i]);
        }
        return doubleArray2;
    }

    @Override
    public double getFromPoint() {
        return this.transform.inverse(this.from);
    }

    @Override
    public double getToPoint() {
        return this.transform.inverse(this.to);
    }

    @Override
    protected double evaluateKernel(double d) {
        if (!this.transform.isInInteriorDomain(d)) {
            return 0.0;
        }
        return super.evaluateKernel(d);
    }

    @Override
    void makeXGrid() {
        super.makeXGrid();
        for (int i = 0; i < this.xPoints.length; ++i) {
            this.xPoints[i] = this.transform.inverse(this.xPoints[i]);
        }
    }

    @Override
    void transformData() {
        super.transformData();
        for (int i = 0; i < this.densityPoints.length; ++i) {
            this.densityPoints[i] = this.densityPoints[i] / this.transform.gradient(this.xPoints[i]);
        }
    }

    @Override
    protected void processBounds(Double d, Double d2) {
        if (d != null && d != Double.NEGATIVE_INFINITY || d2 != null && d2 != Double.POSITIVE_INFINITY) {
            throw new RuntimeException("TransformedNormalKDEDistribution must be unbounded");
        }
    }

    public static TransformedNormalKDEDistribution getLogTransformedNormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3, double d4, int n) {
        return new TransformedNormalKDEDistribution(doubleArray, new Transform.LogTransform(), d, d2, d3, d4, n);
    }

    public static TransformedNormalKDEDistribution getLogTransformedNormalKDEDistribution(Double[] doubleArray) {
        return new TransformedNormalKDEDistribution(doubleArray, new Transform.LogTransform());
    }

    public static TransformedNormalKDEDistribution getLogitTransformedNormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3, Double d4, double d5, int n) {
        return new TransformedNormalKDEDistribution(doubleArray, new Transform.ScaledLogitTransform(d, 0.0), d2, d3, d4, d5, n);
    }

    public static TransformedNormalKDEDistribution getLogitTransformedNormalKDEDistribution(Double[] doubleArray, Double d) {
        return new TransformedNormalKDEDistribution(doubleArray, new Transform.ScaledLogitTransform(d, 0.0));
    }

    public static void main(String[] stringArray) {
        Double d;
        int n;
        int n2;
        Random random = new Random();
        random.setSeed(17920920L);
        int n3 = 1000;
        Object[] objectArray = new Double[2 * n3];
        double d2 = 0.001;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray[n2] = random.nextDouble();
            objectArray[n2] = -Math.log(objectArray[n2]) * d2;
        }
        System.out.print("par(mfrow=c(2,3))\n\nsamples <- c(");
        for (n2 = 0; n2 < objectArray.length - 1; ++n2) {
            System.out.print(objectArray[n2] + ",");
            if (n2 % 10 != 0) continue;
            System.out.print("\n");
        }
        System.out.println(objectArray[objectArray.length - 1] + ")\n");
        System.out.println("ii <- 0:" + 2 * n3 + "/" + n3);
        System.out.println("hist(samples," + 2 * n3 + ",freq=FALSE)\nminimum=min(samples)\nabline(v=minimum,col=2,lty=2)");
        System.out.println("lines(ii, dgamma(ii, shape=1,scale=" + d2 + "),col=\"green\")\n");
        System.out.println("plot(density(samples))\nabline(v=minimum,col=2,lty=2)");
        System.out.println("lines(ii, dgamma(ii, shape=1,scale=" + d2 + "),col=\"green\")\n");
        Arrays.sort(objectArray);
        LogTransformedNormalKDEDistribution logTransformedNormalKDEDistribution = new LogTransformedNormalKDEDistribution((Double[])objectArray);
        TransformedNormalKDEDistribution transformedNormalKDEDistribution = TransformedNormalKDEDistribution.getLogTransformedNormalKDEDistribution((Double[])objectArray);
        NormalKDEDistribution normalKDEDistribution = new NormalKDEDistribution((Double[])objectArray);
        System.out.print("index <- c(");
        double[] dArray = new double[2 * n3];
        double d3 = 0.0;
        double d4 = 1.5 * (Double)Collections.max(Arrays.asList(objectArray));
        double d5 = d3;
        double d6 = (d4 - d3) / (double)(2 * n3 - 1);
        for (n = 0; n < 2 * n3 - 1; ++n) {
            System.out.print(d5 + ",");
            if (n % 10 == 0) {
                System.out.print("\n");
            }
            dArray[n] = d5;
            d5 += d6;
        }
        dArray[2 * n3 - 1] = d5;
        System.out.println(d5 + ")\n");
        System.out.print("normalKDE <- c(");
        for (n = 0; n < 2 * n3 - 1; ++n) {
            d = dArray[n];
            System.out.print(normalKDEDistribution.evaluateKernel(d) + ",");
            if (n % 10 != 0) continue;
            System.out.print("\n");
        }
        System.out.println(normalKDEDistribution.evaluateKernel((2.0 * (double)n3 - 1.0) / (double)n3) + ")\n");
        System.out.print("TransKDEOld <- c(");
        for (n = 0; n < 2 * n3 - 1; ++n) {
            d = dArray[n];
            System.out.print(logTransformedNormalKDEDistribution.evaluateKernel(d) + ",");
            if (n % 10 != 0) continue;
            System.out.print("\n");
        }
        System.out.println(logTransformedNormalKDEDistribution.evaluateKernel((2.0 * (double)n3 - 1.0) / (double)n3) + ")\n");
        System.out.print("TransKDENew <- c(");
        for (n = 0; n < 2 * n3 - 1; ++n) {
            d = dArray[n];
            System.out.print(transformedNormalKDEDistribution.evaluateKernel(d) + ",");
            if (n % 10 != 0) continue;
            System.out.print("\n");
        }
        System.out.println(transformedNormalKDEDistribution.evaluateKernel((2.0 * (double)n3 - 1.0) / (double)n3) + ")\n");
        System.out.println("plot(index,normalKDE,type=\"l\",xlab=\"Bandwidth=" + normalKDEDistribution.bandWidth + "\")\nabline(v=minimum,col=2,lty=2)");
        System.out.println("lines(ii, dgamma(ii, shape=1,scale=" + d2 + "),col=\"green\")");
        System.out.println("plot(index,TransKDEOld,type=\"l\",xlab=\"Bandwidth=" + logTransformedNormalKDEDistribution.bandWidth + "\")\nabline(v=minimum,col=2,lty=2)");
        System.out.println("lines(ii, dgamma(ii, shape=1,scale=" + d2 + "),col=\"green\")");
        System.out.println("plot(index,TransKDENew,type=\"l\",xlab=\"Bandwidth=" + transformedNormalKDEDistribution.bandWidth + "\")\nabline(v=minimum,col=2,lty=2)");
        System.out.println("lines(ii, dgamma(ii, shape=1,scale=" + d2 + "),col=\"green\")");
        long l = System.currentTimeMillis();
        Random random2 = new Random(1234L);
        Double[] doubleArray = new Double[10000000];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = random2.nextDouble();
        }
        TransformedNormalKDEDistribution transformedNormalKDEDistribution2 = TransformedNormalKDEDistribution.getLogTransformedNormalKDEDistribution(doubleArray);
        for (int i = 0; i < 100; ++i) {
            transformedNormalKDEDistribution2.evaluateKernel(random2.nextDouble());
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Time: " + (l2 - l));
    }
}

