/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.io;

public class VectorInfo {
    private boolean sparse;
    private VectorField field;

    public VectorInfo(boolean sparse, VectorField field) {
        this.sparse = sparse;
        this.field = field;
        this.validate();
    }

    private void validate() {
        if (this.isDense() && this.isPattern()) {
            throw new IllegalArgumentException("Vector cannot be dense with pattern storage");
        }
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public boolean isCoordinate() {
        return this.sparse;
    }

    public boolean isDense() {
        return !this.sparse;
    }

    public boolean isArray() {
        return !this.sparse;
    }

    public boolean isReal() {
        return this.field == VectorField.Real;
    }

    public boolean isInteger() {
        return this.field == VectorField.Integer;
    }

    public boolean isComplex() {
        return this.field == VectorField.Complex;
    }

    public boolean isPattern() {
        return this.field == VectorField.Pattern;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("%%MatrixMarket vector ");
        if (this.isSparse()) {
            buf.append("coordinate ");
        } else {
            buf.append("array ");
        }
        if (this.isReal()) {
            buf.append("real\n");
        } else if (this.isComplex()) {
            buf.append("complex\n");
        } else if (this.isPattern()) {
            buf.append("pattern\n");
        } else if (this.isInteger()) {
            buf.append("integer\n");
        } else {
            throw new IllegalArgumentException("Unknown field specification");
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VectorField {
        Real,
        Integer,
        Complex,
        Pattern;

    }
}

