/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.AbstractDistributionLikelihood;
import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.model.GradientProvider;
import dr.util.Attribute;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public abstract class EmpiricalDistributionLikelihood
extends AbstractDistributionLikelihood
implements GradientProvider {
    public static final String EMPIRICAL_DISTRIBUTION_LIKELIHOOD = "empiricalDistributionLikelihood";
    private static final double MIN_DENSITY_PROPORTION = 0.01;
    private static final boolean DEBUG = false;
    private int from = -1;
    private int to = Integer.MAX_VALUE;
    private double offset = 0.0;
    private double lower = Double.NEGATIVE_INFINITY;
    private double upper = Double.POSITIVE_INFINITY;
    private List<EmpiricalDistributionData> densityList;
    protected boolean inverse;
    protected String fileName;

    EmpiricalDistributionLikelihood(String string, boolean bl, boolean bl2) {
        super(null);
        this.fileName = string;
        boolean bl3 = false;
        if (bl2) {
            this.readFileByColumn(string, bl3);
        } else {
            this.readFileByRow(string, bl3);
        }
        this.inverse = bl;
    }

    public EmpiricalDistributionLikelihood(List<EmpiricalDistributionData> list, boolean bl) {
        super(null);
        this.densityList = list;
        this.inverse = bl;
    }

    public void setBounds(double d, double d2) {
        this.lower = d;
        this.upper = d2;
    }

    private void readFileByRow(String string, boolean bl) {
        try {
            int n;
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            ArrayList<ComparablePoint2D> arrayList = new ArrayList<ComparablePoint2D>();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.charAt(0) == '#') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                try {
                    double d = Double.valueOf(stringTokenizer.nextToken());
                    double d2 = Double.valueOf(stringTokenizer.nextToken());
                    arrayList.add(new ComparablePoint2D(d, d2));
                }
                catch (Exception exception) {
                    System.err.println("Error parsing line: '" + string2 + "' in " + string);
                    System.exit(-1);
                }
            }
            Collections.sort(arrayList);
            while (((ComparablePoint2D)arrayList.get(0)).getY() == 0.0 && ((ComparablePoint2D)arrayList.get(1)).getY() == 0.0) {
                arrayList.remove(0);
            }
            while (((ComparablePoint2D)arrayList.get(arrayList.size() - 1)).getY() == 0.0 && ((ComparablePoint2D)arrayList.get(arrayList.size() - 2)).getY() == 0.0) {
                arrayList.remove(arrayList.size() - 1);
            }
            double d = Double.POSITIVE_INFINITY;
            for (ComparablePoint2D comparablePoint2D : arrayList) {
                if (!(comparablePoint2D.getY() > 0.0) || !(comparablePoint2D.getY() < d)) continue;
                d = comparablePoint2D.getY();
            }
            for (ComparablePoint2D comparablePoint2D : arrayList) {
                if (comparablePoint2D.getY() != 0.0) continue;
                comparablePoint2D.y = d * 0.01;
            }
            EmpiricalDistributionData empiricalDistributionData = new EmpiricalDistributionData(new double[arrayList.size()], new double[arrayList.size()], bl);
            double d3 = 0.0;
            for (n = 0; n < arrayList.size(); ++n) {
                ComparablePoint2D comparablePoint2D = (ComparablePoint2D)arrayList.get(n);
                empiricalDistributionData.values[n] = comparablePoint2D.getX();
                empiricalDistributionData.density[n] = comparablePoint2D.getY();
                d3 += comparablePoint2D.getY();
            }
            n = 0;
            while (n < empiricalDistributionData.density.length) {
                int n2 = n++;
                empiricalDistributionData.density[n2] = empiricalDistributionData.density[n2] / d3;
            }
            bufferedReader.close();
            this.densityList = new ArrayList<EmpiricalDistributionData>();
            this.densityList.add(empiricalDistributionData);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + string);
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("IO exception reading: " + string);
            System.exit(-1);
        }
    }

    private void readFileByColumn(String string, boolean bl) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            double[] dArray = new double[stringTokenizer.countTokens()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = Double.valueOf(stringTokenizer.nextToken());
            }
            String string3 = bufferedReader.readLine();
            stringTokenizer = new StringTokenizer(string3, " ");
            double[] dArray2 = new double[stringTokenizer.countTokens()];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = Double.valueOf(stringTokenizer.nextToken());
            }
            this.densityList = new ArrayList<EmpiricalDistributionData>();
            this.densityList.add(new EmpiricalDistributionData(dArray, dArray2, bl));
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + string);
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("IO exception reading: " + string);
            System.exit(-1);
        }
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public void setRange(int n, int n2) {
        this.from = n;
        this.to = n2;
    }

    @Override
    public double calculateLogLikelihood() {
        double d = 0.0;
        for (Attribute attribute : this.dataList) {
            double[] dArray = (double[])attribute.getAttributeValue();
            int n = 0;
            for (int i = Math.max(0, this.from); i < Math.min(dArray.length, this.to); ++i) {
                double d2 = dArray[i] + this.offset;
                if (d2 > this.lower && d2 < this.upper) {
                    d += this.logPDF(d2, this.densityList.get(n));
                } else {
                    return Double.NEGATIVE_INFINITY;
                }
                if (this.densityList.size() <= 1) continue;
                ++n;
            }
        }
        return d;
    }

    public int getDistributionDimension() {
        return this.densityList.size();
    }

    @Override
    public int getDimension() {
        int n = 0;
        for (Attribute attribute : this.dataList) {
            n += ((double[])attribute.getAttributeValue()).length;
        }
        return n;
    }

    public double[] getGradientLogDensity(double[] dArray) {
        assert (this.densityList.size() == 1 || this.densityList.size() == dArray.length);
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i] + this.offset;
            double d2 = dArray2[i] = d > this.lower && d < this.upper ? this.gradientLogPdf(d, this.densityList.get(n)) : 0.0;
            if (this.densityList.size() <= 1) continue;
            ++n;
        }
        return dArray2;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.getGradientLogDensity(GradientProvider.toDoubleArray(object));
    }

    protected abstract double logPDF(double var1, EmpiricalDistributionData var3);

    protected abstract double gradientLogPdf(double var1, EmpiricalDistributionData var3);

    class ComparablePoint2D
    extends Point2D.Double
    implements Comparable<ComparablePoint2D> {
        ComparablePoint2D(double d, double d2) {
            super(d, d2);
        }

        @Override
        public int compareTo(ComparablePoint2D comparablePoint2D) {
            return Double.compare(this.getX(), comparablePoint2D.getX());
        }
    }
}

