/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.distributions.GammaDistribution;
import dr.stats.DiscreteStatistics;

public class EmpiricalBayesPoissonSmoother {
    public static double[] smooth(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = EmpiricalBayesPoissonSmoother.getNegBin(dArray);
        double d = dArray3[0];
        double d2 = dArray3[1];
        double d3 = dArray3[2];
        if (d2 == 0.0) {
            for (int i = 0; i < n; ++i) {
                dArray2[i] = d3;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray2[i] = (dArray[i] + d) / (1.0 + 1.0 / d2);
            }
        }
        return dArray2;
    }

    public static double[] smoothWithSample(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = EmpiricalBayesPoissonSmoother.getNegBin(dArray);
        double d = dArray3[0];
        double d2 = dArray3[1];
        double d3 = dArray3[2];
        if (d2 == 0.0) {
            for (int i = 0; i < n; ++i) {
                dArray2[i] = d3;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double d4 = dArray[i] + d;
                double d5 = 1.0 / (1.0 + 1.0 / d2);
                dArray2[i] = GammaDistribution.nextGamma(d4, d5);
            }
        }
        return dArray2;
    }

    public static double[] smoothOld(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = EmpiricalBayesPoissonSmoother.getNegBin(dArray);
        for (int i = 0; i < n; ++i) {
            dArray2[i] = (dArray[i] + dArray3[0]) / (1.0 + 1.0 / dArray3[1]);
        }
        return dArray2;
    }

    private static double[] getNegBin(double[] dArray) {
        double d;
        double d2 = DiscreteStatistics.mean(dArray);
        double d3 = DiscreteStatistics.variance(dArray, d2);
        double d4 = 1.0 - d2 / d3;
        double d5 = d = d2 * ((1.0 - d4) / d4);
        double d6 = d4 / (1.0 - d4);
        if (d3 <= d2) {
            d5 = 0.0;
            d6 = 0.0;
        }
        return new double[]{d5, d6, d2};
    }
}

