/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.arima.AbstractLinearModel;
import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.ForeFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.maths.linearfilters.RationalFilter;
import ec.tstoolkit.maths.linearfilters.RationalForeFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;

public class LinearModel
extends AbstractLinearModel {
    private final RationalFilter m_rf;
    private double m_var = 1.0;

    public LinearModel(LinearModel lm) {
        this.m_rf = lm.m_rf;
        this.m_var = lm.m_var;
    }

    public LinearModel(RationalFilter rf, double var) {
        this.m_rf = rf;
        this.m_var = var;
    }

    public LinearModel doStationary() {
        RationalForeFilter rf;
        ForeFilter fdenom;
        ForeFilter.StationaryTransformation fst;
        BackFilter.StationaryTransformation bst = new BackFilter.StationaryTransformation();
        RationalBackFilter rb = this.m_rf.getRationalBackFilter();
        BackFilter bdenom = rb.getDenominator();
        if (bst.transform(bdenom)) {
            bdenom = bst.stationaryFilter;
        }
        if ((fst = new ForeFilter.StationaryTransformation()).transform(fdenom = (rf = this.m_rf.getRationalForeFilter()).getDenominator())) {
            fdenom = fst.stationaryFilter;
        }
        RationalFilter stfilter = new RationalFilter(this.m_rf.getNumerator(), bdenom, fdenom);
        return new LinearModel(stfilter, this.m_var);
    }

    @Override
    public RationalFilter getFilter() {
        return this.m_rf;
    }

    @Override
    public double getInnovationVariance() {
        return this.m_var;
    }

    @Override
    protected AutoCovarianceFunction initAcgf() {
        RationalFilter f = this.getFilter();
        Polynomial n = Polynomial.copyOf(f.getNumerator().getWeights());
        Polynomial bd = f.getRationalBackFilter().getDenominator().getPolynomial();
        Polynomial fd = f.getRationalForeFilter().getDenominator().getPolynomial();
        return new AutoCovarianceFunction(n, bd.times(fd), this.getInnovationVariance());
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public boolean isNull() {
        return this.m_var == 0.0;
    }

    @Override
    public boolean isStationary() {
        return true;
    }
}

