/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.HouseholderR;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.random.IRandomNumberGenerator;
import ec.tstoolkit.random.JdkRNG;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Matrix
implements Cloneable {
    double[] data_;
    int nrows_;
    int ncols_;
    private static final IRandomNumberGenerator RNG = JdkRNG.newRandom(0L);

    public static Matrix diagonal(double[] d) {
        Matrix M = new Matrix(d.length, d.length);
        int i = 0;
        int j = 0;
        while (i < d.length) {
            M.data_[j] = d[i];
            ++i;
            j += d.length + 1;
        }
        return M;
    }

    public static Matrix diagonal(IReadDataBlock d) {
        Matrix M = new Matrix(d.getLength(), d.getLength());
        M.diagonal().copy(d);
        return M;
    }

    public static Matrix diff(int n, int lag, int d) {
        Polynomial D = UnitRoots.D(lag, d);
        int deg = lag * d;
        Matrix diff = new Matrix(n - deg, n);
        for (int i = 0; i <= deg; ++i) {
            diff.subDiagonal(i).set(D.get(deg - i));
        }
        return diff;
    }

    public static Matrix diff(int n, Polynomial D) {
        int deg = D.getDegree();
        Matrix diff = new Matrix(n - deg, n);
        for (int i = 0; i <= deg; ++i) {
            diff.subDiagonal(i).set(D.get(deg - i));
        }
        return diff;
    }

    public static Matrix identity(int n) {
        Matrix M = new Matrix(n, n);
        int i = 0;
        int j = 0;
        while (i < n) {
            M.data_[j] = 1.0;
            ++i;
            j += n + 1;
        }
        return M;
    }

    public static Matrix square(int n) {
        return new Matrix(n, n);
    }

    public static Matrix select(SubMatrix m, boolean[] rsel, boolean[] csel) {
        int nr = 0;
        int nc = 0;
        int rmax = Math.min(rsel.length, m.m_nrows);
        for (int i = 0; i < rmax; ++i) {
            if (!rsel[i]) continue;
            ++nr;
        }
        int cmax = Math.min(csel.length, m.m_ncols);
        for (int i = 0; i < cmax; ++i) {
            if (!csel[i]) continue;
            ++nc;
        }
        Matrix M = new Matrix(nr, nc);
        if (M.isEmpty()) {
            return M;
        }
        int j = 0;
        for (int c = 0; c < cmax; ++c) {
            if (!csel[c]) continue;
            DataBlock mc = m.column(c);
            for (int r = 0; r < rmax; ++r) {
                if (!rsel[r]) continue;
                M.data_[j++] = mc.get(r);
            }
        }
        return M;
    }

    public static Matrix select(SubMatrix m, int[] rsel, int[] csel) {
        int nr = rsel.length;
        int nc = csel.length;
        Matrix M = new Matrix(nr, nc);
        if (M.isEmpty()) {
            return M;
        }
        int j = 0;
        for (int c = 0; c < csel.length; ++c) {
            DataBlock mc = m.column(csel[c]);
            for (int r = 0; r < rsel.length; ++r) {
                M.data_[j++] = mc.get(rsel[r]);
            }
        }
        return M;
    }

    public static Matrix selectRows(SubMatrix m, boolean[] rsel) {
        int nr = 0;
        int rmax = Math.min(rsel.length, m.m_nrows);
        for (int i = 0; i < rmax; ++i) {
            if (!rsel[i]) continue;
            ++nr;
        }
        Matrix M = new Matrix(nr, m.getColumnsCount());
        if (M.isEmpty()) {
            return M;
        }
        DataBlockIterator rows = M.rows();
        DataBlock row = rows.getData();
        for (int r = 0; r < rmax; ++r) {
            if (!rsel[r]) continue;
            row.copy(m.row(r));
            rows.next();
        }
        return M;
    }

    public static Matrix selectRows(SubMatrix m, int[] rsel) {
        int nr = rsel.length;
        Matrix M = new Matrix(nr, m.getColumnsCount());
        if (M.isEmpty()) {
            return M;
        }
        DataBlockIterator rows = M.rows();
        DataBlock row = rows.getData();
        for (int r = 0; r < rsel.length; ++r) {
            row.copy(m.row(rsel[r]));
            rows.next();
        }
        return M;
    }

    public static Matrix selectColumns(SubMatrix m, boolean[] csel) {
        int nc = 0;
        int cmax = Math.min(csel.length, m.m_ncols);
        for (int i = 0; i < cmax; ++i) {
            if (!csel[i]) continue;
            ++nc;
        }
        Matrix M = new Matrix(m.getRowsCount(), nc);
        if (M.isEmpty()) {
            return M;
        }
        DataBlockIterator columns = M.columns();
        DataBlock column = columns.getData();
        for (int c = 0; c < cmax; ++c) {
            if (!csel[c]) continue;
            column.copy(m.column(c));
            columns.next();
        }
        return M;
    }

    public static Matrix selectColumns(SubMatrix m, int[] csel) {
        int nc = csel.length;
        Matrix M = new Matrix(m.getRowsCount(), nc);
        if (M.isEmpty()) {
            return M;
        }
        DataBlockIterator cols = M.columns();
        DataBlock col = cols.getData();
        for (int c = 0; c < csel.length; ++c) {
            col.copy(m.column(csel[c]));
            cols.next();
        }
        return M;
    }

    public Matrix(double[] data, int nrows, int ncols) {
        this.data_ = data;
        this.nrows_ = nrows;
        this.ncols_ = ncols;
    }

    public Matrix(int nrows, int ncols) {
        this.data_ = new double[nrows * ncols];
        this.nrows_ = nrows;
        this.ncols_ = ncols;
    }

    public Matrix(SubMatrix sm) {
        int nrows = sm.getRowsCount();
        int ncols = sm.getColumnsCount();
        this.data_ = new double[nrows * ncols];
        this.nrows_ = nrows;
        this.ncols_ = ncols;
        int isel = sm.m_start;
        int c = 0;
        int j = 0;
        while (c < sm.m_ncols) {
            int sel = isel;
            for (int r = 0; r < sm.m_nrows; ++r) {
                this.data_[j] = sm.m_data[sel];
                sel += sm.m_row_inc;
                ++j;
            }
            ++c;
            isel += sm.m_col_inc;
        }
    }

    public void add(double r) {
        int n = this.data_.length;
        int i = 0;
        while (i < n) {
            int n2 = i++;
            this.data_[n2] = this.data_[n2] + r;
        }
    }

    public void add(int row, int col, double val) {
        int n = row + col * this.nrows_;
        this.data_[n] = this.data_[n] + val;
    }

    public void add(Matrix M) {
        int n = this.data_.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.data_[n2] = this.data_[n2] + M.data_[i];
        }
    }

    public void chs() {
        for (int i = 0; i < this.data_.length; ++i) {
            this.data_[i] = -this.data_[i];
        }
    }

    public void clean(double epsilon) {
        for (double d : this.data_) {
            if (!(-epsilon < d) || !(d < epsilon)) continue;
            this.data_[i] = 0.0;
        }
    }

    public void clear() {
        int n = this.data_.length;
        for (int i = 0; i < n; ++i) {
            this.data_[i] = 0.0;
        }
    }

    public Matrix clone() {
        try {
            Matrix m = (Matrix)super.clone();
            m.data_ = (double[])this.data_.clone();
            return m;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public DataBlock column(int col) {
        int beg = col * this.nrows_;
        int end = beg + this.nrows_;
        return new DataBlock(this.data_, beg, end, 1);
    }

    public List<DataBlock> columnList() {
        ArrayList<DataBlock> rc = new ArrayList<DataBlock>();
        for (int i = 0; i < this.data_.length; i += this.nrows_) {
            rc.add(new DataBlock(this.data_, i, i + this.nrows_, 1));
        }
        return rc;
    }

    public DataBlockIterator columns() {
        return new DataBlockIterator(this.data_, 0, this.ncols_, this.nrows_, this.nrows_, 1);
    }

    public void copyTo(double[] buffer, int start) {
        System.arraycopy(this.data_, 0, buffer, start, this.data_.length);
    }

    public DataBlock diagonal() {
        int n = Math.min(this.nrows_, this.ncols_);
        int inc = this.nrows_ + 1;
        return new DataBlock(this.data_, 0, inc * n, inc);
    }

    public DataBlock subDiagonal(int pos) {
        int n;
        if (pos >= this.ncols_) {
            return DataBlock.EMPTY;
        }
        if (-pos >= this.nrows_) {
            return DataBlock.EMPTY;
        }
        int beg = 0;
        int inc = 1 + this.nrows_;
        if (pos > 0) {
            beg += pos * this.nrows_;
            n = Math.min(this.nrows_, this.ncols_ - pos);
        } else if (pos < 0) {
            beg -= pos;
            n = Math.min(this.nrows_ + pos, this.ncols_);
        } else {
            n = Math.min(this.nrows_, this.ncols_);
        }
        return new DataBlock(this.data_, beg, beg + inc * n, inc);
    }

    public DataBlock skewDiagonal(int pos) {
        int n;
        int beg;
        if (pos < 0) {
            return null;
        }
        int nmax = Math.max(this.nrows_, this.ncols_);
        if (pos >= nmax) {
            return null;
        }
        int inc = this.nrows_ - 1;
        if (pos < this.nrows_) {
            beg = pos;
            n = Math.min(pos + 1, this.ncols_);
        } else {
            int rlast = this.nrows_ - 1;
            int col = pos - rlast;
            beg = rlast + this.nrows_ * col;
            n = Math.min(this.nrows_, this.ncols_ - col);
        }
        return new DataBlock(this.data_, beg, beg + inc * n, inc);
    }

    public double get(int row, int col) {
        return this.data_[row + col * this.nrows_];
    }

    public int getColumnsCount() {
        return this.ncols_;
    }

    public int getRowsCount() {
        return this.nrows_;
    }

    public double[] internalStorage() {
        return this.data_;
    }

    public boolean isZero(double eps) {
        for (double d : this.data_) {
            if (!(d < -eps) && !(d > eps)) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonal(double eps) {
        if (this.ncols_ != this.nrows_) {
            return false;
        }
        int n = this.data_.length;
        int idx = 1;
        while (idx < n) {
            int end = idx + this.nrows_;
            for (int i = idx; i < end; ++i) {
                double d = this.data_[i];
                if (!(d < -eps) && !(d > eps)) continue;
                return false;
            }
            idx = end + 1;
        }
        return true;
    }

    public boolean isZero() {
        int n = this.data_.length;
        for (int i = 0; i < n; ++i) {
            if (this.data_[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonal() {
        if (this.ncols_ != this.nrows_) {
            return false;
        }
        int n = this.data_.length;
        int idx = 1;
        while (idx < n) {
            int end = idx + this.nrows_;
            for (int i = idx; i < end; ++i) {
                if (this.data_[i] == 0.0) continue;
                return false;
            }
            idx = end + 1;
        }
        return true;
    }

    public boolean isSquare() {
        return this.ncols_ == this.nrows_;
    }

    public Matrix minus(double r) {
        Matrix s = new Matrix(this.getRowsCount(), this.getColumnsCount());
        int n = this.data_.length;
        for (int i = 0; i < n; ++i) {
            s.data_[i] = this.data_[i] - r;
        }
        return s;
    }

    public Matrix minus(Matrix Y) {
        Matrix s = new Matrix(this.getRowsCount(), this.getColumnsCount());
        int n = this.data_.length;
        for (int i = 0; i < n; ++i) {
            s.data_[i] = this.data_[i] - Y.data_[i];
        }
        return s;
    }

    public void mul(double r) {
        if (r == 1.0) {
            return;
        }
        if (r == 0.0) {
            this.clear();
        }
        int n = this.data_.length;
        int i = 0;
        while (i < n) {
            int n2 = i++;
            this.data_[n2] = this.data_[n2] * r;
        }
    }

    public void mul(int row, int col, double val) {
        if (val == 1.0) {
            return;
        }
        int n = row + col * this.nrows_;
        this.data_[n] = this.data_[n] * val;
    }

    public double nrm2() {
        return new DataBlock(this.data_).nrm2();
    }

    public Matrix plus(double r) {
        Matrix s = new Matrix(this.getRowsCount(), this.getColumnsCount());
        int n = this.data_.length;
        for (int i = 0; i < n; ++i) {
            s.data_[i] = this.data_[i] + r;
        }
        return s;
    }

    public Matrix plus(Matrix Y) {
        Matrix s = new Matrix(this.getRowsCount(), this.getColumnsCount());
        int n = this.data_.length;
        for (int i = 0; i < n; ++i) {
            s.data_[i] = this.data_[i] + Y.data_[i];
        }
        return s;
    }

    public void randomize() {
        for (int i = 0; i < this.data_.length; ++i) {
            this.data_[i] = RNG.nextDouble();
        }
    }

    public void randomize(int seed) {
        Random rnd = new Random(seed);
        for (int i = 0; i < this.data_.length; ++i) {
            this.data_[i] = rnd.nextDouble();
        }
    }

    public DataBlock row(int row) {
        return new DataBlock(this.data_, row, row + this.data_.length, this.nrows_);
    }

    public List<DataBlock> rowList() {
        ArrayList<DataBlock> rc = new ArrayList<DataBlock>();
        for (int i = 0; i < this.nrows_; ++i) {
            rc.add(new DataBlock(this.data_, i, i + this.data_.length, this.nrows_));
        }
        return rc;
    }

    public DataBlockIterator rows() {
        return new DataBlockIterator(this.data_, 0, this.nrows_, this.ncols_, 1, this.nrows_);
    }

    public void set(double value) {
        for (int i = 0; i < this.data_.length; ++i) {
            this.data_[i] = value;
        }
    }

    public void set(int row, int col, double value) {
        this.data_[row + col * this.nrows_] = value;
    }

    public void set(MatrixFunction fn) {
        int i = 0;
        for (int c = 0; c < this.ncols_; ++c) {
            int r = 0;
            while (r < this.nrows_) {
                this.data_[i] = fn.apply(r, c);
                ++r;
                ++i;
            }
        }
    }

    public void set(MatrixRelativeFunction fn) {
        int i = 0;
        for (int c = 0; c < this.ncols_; ++c) {
            int r = 0;
            while (r < this.nrows_) {
                this.data_[i] = fn.apply(r, c, this.data_[i]);
                ++r;
                ++i;
            }
        }
    }

    public void add(MatrixFunction fn) {
        int i = 0;
        for (int c = 0; c < this.ncols_; ++c) {
            for (int r = 0; r < this.nrows_; ++r) {
                int n = i++;
                this.data_[n] = this.data_[n] + fn.apply(r, c);
            }
        }
    }

    public void add(MatrixRelativeFunction fn) {
        int i = 0;
        for (int c = 0; c < this.ncols_; ++c) {
            int r = 0;
            while (r < this.nrows_) {
                int n = i;
                this.data_[n] = this.data_[n] + fn.apply(r, c, this.data_[i]);
                ++r;
                ++i;
            }
        }
    }

    public double ssq() {
        double s = 0.0;
        for (int i = 0; i < this.data_.length; ++i) {
            double d = this.data_[i];
            s += d * d;
        }
        return s;
    }

    public void sub(double r) {
        int n = this.data_.length;
        int i = 0;
        while (i < n) {
            int n2 = i++;
            this.data_[n2] = this.data_[n2] - r;
        }
    }

    public void sub(Matrix M) {
        int n = this.data_.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.data_[n2] = this.data_[n2] - M.data_[i];
        }
    }

    public SubMatrix all() {
        return new SubMatrix(this.data_, 0, this.nrows_, this.ncols_, 1, this.nrows_);
    }

    @Deprecated
    public SubMatrix subMatrix() {
        return new SubMatrix(this.data_, 0, this.nrows_, this.ncols_, 1, this.nrows_);
    }

    public SubMatrix subMatrix(int r0, int r1, int c0, int c1) {
        int nr = r1 < 0 ? this.nrows_ - r0 : r1 - r0;
        int nc = c1 < 0 ? this.ncols_ - c0 : c1 - c0;
        return new SubMatrix(this.data_, r0 + c0 * this.nrows_, nr, nc, 1, this.nrows_);
    }

    public double sum() {
        double s = 0.0;
        for (int i = 0; i < this.data_.length; ++i) {
            s += this.data_[i];
        }
        return s;
    }

    public Matrix times(double r) {
        if (r == 1.0) {
            return this.clone();
        }
        Matrix s = new Matrix(this.getRowsCount(), this.getColumnsCount());
        if (r == 0.0) {
            return s;
        }
        int n = this.data_.length;
        for (int i = 0; i < n; ++i) {
            s.data_[i] = this.data_[i] * r;
        }
        return s;
    }

    public Matrix times(Matrix Y) {
        int nr = this.nrows_;
        int nc = Y.ncols_;
        int nk = this.ncols_;
        Matrix s = new Matrix(nr, nc);
        double[] tmp = new double[nk];
        for (int i = 0; i < nr; ++i) {
            int j = 0;
            int k = i;
            while (j < nk) {
                tmp[j] = this.data_[k];
                ++j;
                k += nr;
            }
            int ir = 0;
            int idx = i;
            while (ir < Y.data_.length) {
                double x = 0.0;
                int k2 = 0;
                while (k2 < nk) {
                    x += Y.data_[ir] * tmp[k2];
                    ++k2;
                    ++ir;
                }
                s.data_[idx] = x;
                idx += nr;
            }
        }
        return s;
    }

    public double dot(Matrix m) {
        double p = 0.0;
        for (int i = 0; i < this.data_.length; ++i) {
            p += this.data_[i] * m.data_[i];
        }
        return p;
    }

    public static Matrix rsolve(SubMatrix S, SubMatrix B) {
        if (S.getRowsCount() != B.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        HouseholderR qr = new HouseholderR(true);
        qr.decompose(S);
        Matrix X = new Matrix(S.getColumnsCount(), B.getColumnsCount());
        DataBlockIterator bc = B.columns();
        DataBlockIterator xc = X.columns();
        DataBlock b = bc.getData();
        DataBlock x = xc.getData();
        do {
            qr.solve(b, x);
        } while (bc.next() && xc.next());
        return X;
    }

    public static Matrix lsolve(SubMatrix S, SubMatrix B) {
        if (S.getColumnsCount() != B.getColumnsCount()) {
            throw new MatrixException("m_err_dim");
        }
        Householder qr = new Householder(true);
        qr.decompose(S.transpose());
        Matrix X = new Matrix(B.getRowsCount(), S.getRowsCount());
        DataBlockIterator bc = B.rows();
        DataBlockIterator xc = X.rows();
        DataBlock b = bc.getData();
        DataBlock x = xc.getData();
        do {
            qr.solve(b, x);
        } while (bc.next() && xc.next());
        return X;
    }

    public void toLower() {
        int id = this.nrows_;
        for (int c = 1; c < this.ncols_; ++c) {
            int nr = Math.min(this.nrows_, c);
            for (int r = 0; r < nr; ++r) {
                this.data_[id++] = 0.0;
            }
            id += this.nrows_ - nr;
        }
    }

    public void toUpper() {
        int nc = Math.min(this.nrows_ - 1, this.ncols_);
        int c = 0;
        int id = 0;
        int rmax = this.nrows_;
        while (c < nc) {
            for (int ir = id + 1; ir < rmax; ++ir) {
                this.data_[ir] = 0.0;
            }
            ++c;
            id += this.nrows_ + 1;
            rmax += this.nrows_;
        }
    }

    public Matrix transpose() {
        Matrix T2 = new Matrix(this.ncols_, this.nrows_);
        int tmax = this.data_.length;
        int s = 0;
        for (int j = 0; j < this.ncols_; ++j) {
            int t = j;
            while (t < tmax) {
                T2.data_[t] = this.data_[s];
                t += this.ncols_;
                ++s;
            }
        }
        return T2;
    }

    public void addAY(double a, Matrix Y) {
        DataBlock t = new DataBlock(this.data_);
        DataBlock s = new DataBlock(Y.data_);
        t.addAY(a, s);
    }

    public void addXaXt(double a, DataBlock x) {
        DataBlockIterator cols = this.columns();
        DataBlock col = cols.getData();
        do {
            double z = a * x.get(cols.getPosition());
            col.addAY(z, x);
        } while (cols.next());
    }

    public void addXaYt(double a, DataBlock x, DataBlock y) {
        DataBlockIterator cols = this.columns();
        DataBlock col = cols.getData();
        do {
            double z = a * y.get(cols.getPosition());
            col.addAY(z, x);
        } while (cols.next());
    }

    public boolean isEmpty() {
        return this.data_.length == 0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return this.all().toString();
    }

    public String toString(String fmt) {
        if (this.isEmpty()) {
            return "";
        }
        return this.all().toString(fmt);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Matrix && this.equals((Matrix)obj);
    }

    public boolean equals(Matrix other) {
        return this.ncols_ == other.ncols_ && this.nrows_ == other.nrows_ && Arrays.equals(this.data_, other.data_);
    }

    public boolean equals(Matrix other, double eps) {
        if (this.ncols_ != other.ncols_ || this.nrows_ != other.nrows_) {
            return false;
        }
        for (int i = 0; i < this.data_.length; ++i) {
            if (!(Math.abs(this.data_[i] - other.data_[i]) > eps)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Arrays.hashCode(this.data_);
        hash = 97 * hash + this.nrows_;
        return hash;
    }

    public int rank() {
        Householder hous = new Householder(true);
        hous.setEpsilon(1.0E-12);
        if (this.nrows_ >= this.ncols_) {
            hous.decompose(this);
        } else {
            hous.decompose(this.all().transpose());
        }
        return hous.getRank();
    }

    public void permuteColumns(int i, int j) {
        if (i == j) {
            return;
        }
        int k = this.nrows_ * i;
        int kend = k + this.nrows_;
        int l = this.nrows_ * j;
        while (k < kend) {
            double tmp = this.data_[k];
            this.data_[k] = this.data_[l];
            this.data_[l] = tmp;
            ++k;
            ++l;
        }
    }

    public void permuteRows(int i, int j) {
        if (i == j) {
            return;
        }
        int k = i;
        int l = j;
        while (k < this.data_.length) {
            double tmp = this.data_[k];
            this.data_[k] = this.data_[l];
            this.data_[l] = tmp;
            k += this.nrows_;
            l += this.nrows_;
        }
    }

    public void copy(Matrix C) {
        System.arraycopy(C.data_, 0, this.data_, 0, this.data_.length);
    }

    public double distance(Matrix m) {
        return this.minus(m).nrm2();
    }

    public void smooth(double eps) {
        double scale = 1.0;
        for (double q = Math.sqrt(eps); q < 1.0; q *= 10.0) {
            scale *= 10.0;
        }
        for (int i = 0; i < this.data_.length; ++i) {
            double c = this.data_[i];
            double d = (double)Math.round(c * scale) / scale;
            if (!(Math.abs(d - c) < eps)) continue;
            this.data_[i] = d;
        }
    }

    public SubMatrix topLeft() {
        return new SubMatrix(this.data_, 0, 0, 0, 1, this.nrows_);
    }

    public SubMatrix topLeft(int nr, int nc) {
        return new SubMatrix(this.data_, 0, nr, nc, 1, this.nrows_);
    }

    public SubMatrix bottomRight() {
        return new SubMatrix(this.data_, this.data_.length, 0, 0, 1, this.nrows_);
    }

    public SubMatrix bottomRight(int nr, int nc) {
        int start = this.data_.length - nr - nc * this.nrows_;
        return new SubMatrix(this.data_, start, nr, nc, 1, this.nrows_);
    }

    @FunctionalInterface
    public static interface MatrixFunction {
        public double apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface MatrixRelativeFunction {
        public double apply(int var1, int var2, double var3);
    }
}

