/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.task;

import choco.kernel.solver.search.task.TaskSelector;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;

public class RandomizedTaskSelector
extends TaskSelector {
    private final Random rnd;

    public RandomizedTaskSelector(Comparator<ITask> comparator, long seed) {
        super(comparator);
        this.rnd = new Random(seed);
    }

    @Override
    public TaskVar selectTaskVar(Collection<TaskVar> vars) {
        Iterator<TaskVar> iter = vars.iterator();
        if (iter.hasNext()) {
            TaskVar selected = iter.next();
            while (iter.hasNext()) {
                TaskVar current = iter.next();
                double cmp = this.comparator.compare(selected, current);
                int n = 2;
                if (cmp > 0.0) {
                    selected = current;
                    n = 2;
                    continue;
                }
                if (cmp != 0.0) continue;
                double p = 1 / n;
                if (this.rnd.nextDouble() < p) {
                    selected = current;
                }
                ++n;
            }
            return selected;
        }
        return null;
    }
}

