/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.dictionary.Dictionary;

public class Pointer
implements Serializable {
    static final long serialVersionUID = -1275571290466732179L;
    private int _index;
    private PointerType _pointerType;
    private PointerTarget _source = null;
    private TargetIndex _targetIndex;
    private transient PointerTarget _target = null;
    private transient String _cachedToString = null;

    public Pointer(PointerTarget source, int index, PointerType pointerType, POS targetPOS, long targetOffset, int targetIndex) {
        this._source = source;
        this._index = index;
        this._pointerType = pointerType;
        this._targetIndex = new TargetIndex(targetPOS, targetOffset, targetIndex);
    }

    public boolean equals(Object object) {
        return object instanceof Pointer && ((Pointer)object).getSource().equals(this.getSource()) && ((Pointer)object).getSourceIndex() == this.getSourceIndex();
    }

    public int hashCode() {
        return this.getSource().hashCode() ^ this.getSourceIndex();
    }

    public String toString() {
        if (this._cachedToString == null) {
            String targetMsg = this._target == null ? this._targetIndex.toString() : this._target.toString();
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_012", new Object[]{new Integer(this.getSourceIndex()), this.getSource(), targetMsg});
        }
        return this._cachedToString;
    }

    public int getSourceIndex() {
        return this._index;
    }

    public PointerType getType() {
        return this._pointerType;
    }

    public boolean isLexical() {
        return this.getSource() instanceof Word;
    }

    public PointerTarget getSource() {
        return this._source;
    }

    public PointerTarget getTarget() throws JWNLException {
        if (this._target == null) {
            Dictionary dic = Dictionary.getInstance();
            Synset syn = dic.getSynsetAt(this._targetIndex._pos, this._targetIndex._offset);
            this._target = this._targetIndex._index == 0 ? syn : syn.getWord(this._targetIndex._index - 1);
        }
        return this._target;
    }

    public Synset getTargetSynset() throws JWNLException {
        PointerTarget target = this.getTarget();
        if (target instanceof Word) {
            return ((Word)target).getSynset();
        }
        return (Synset)target;
    }

    public long getTargetOffset() {
        return this._targetIndex._offset;
    }

    public int getTargetIndex() {
        return this._targetIndex._index;
    }

    public POS getTargetPOS() {
        return this._targetIndex._pos;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._pointerType = PointerType.getPointerTypeForKey(this._pointerType.getKey());
    }

    private static class TargetIndex
    implements Serializable {
        POS _pos;
        long _offset;
        int _index;
        private transient String _cachedToString = null;

        TargetIndex(POS pos, long offset, int index) {
            this._pos = pos;
            this._offset = offset;
            this._index = index;
        }

        public String toString() {
            if (this._cachedToString == null) {
                this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_013", new Object[]{this._pos, new Long(this._offset), new Integer(this._index)});
            }
            return this._cachedToString;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this._pos = POS.getPOSForKey(this._pos.getKey());
        }
    }
}

