/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import com.github.javacliparser.ListOption;
import com.github.javacliparser.Option;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import moa.core.Example;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.options.OptionHandler;
import moa.streams.ExampleStream;
import moa.streams.filters.StreamFilter;
import moa.tasks.TaskMonitor;

public class MultiFilteredStream
extends AbstractOptionHandler
implements ExampleStream {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to filter.", ExampleStream.class, "generators.RandomTreeGenerator");
    public ListOption filtersOption = new ListOption("filters", 'f', "Filters to apply.", new ClassOption("filter", ' ', "Stream filter.", StreamFilter.class, "AddNoiseFilter"), new Option[0], ',');
    protected ExampleStream filterChain;

    @Override
    public String getPurposeString() {
        return "A stream that is filtered.";
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        Option[] filterOptions = this.filtersOption.getList();
        StreamFilter[] filters = new StreamFilter[filterOptions.length];
        for (int i = 0; i < filters.length; ++i) {
            monitor.setCurrentActivity("Materializing filter " + (i + 1) + "...", -1.0);
            filters[i] = (StreamFilter)((ClassOption)filterOptions[i]).materializeObject(monitor, repository);
            if (monitor.taskShouldAbort()) {
                return;
            }
            if (!(filters[i] instanceof OptionHandler)) continue;
            monitor.setCurrentActivity("Preparing filter " + (i + 1) + "...", -1.0);
            ((OptionHandler)((Object)filters[i])).prepareForUse(monitor, repository);
            if (!monitor.taskShouldAbort()) continue;
            return;
        }
        ExampleStream chain = (ExampleStream)this.getPreparedClassOption(this.streamOption);
        for (int i = 0; i < filters.length; ++i) {
            filters[i].setInputStream(chain);
            chain = filters[i];
        }
        this.filterChain = chain;
    }

    @Override
    public long estimatedRemainingInstances() {
        return this.filterChain.estimatedRemainingInstances();
    }

    @Override
    public InstancesHeader getHeader() {
        return this.filterChain.getHeader();
    }

    @Override
    public boolean hasMoreInstances() {
        return this.filterChain.hasMoreInstances();
    }

    @Override
    public boolean isRestartable() {
        return this.filterChain.isRestartable();
    }

    public Example nextInstance() {
        return this.filterChain.nextInstance();
    }

    @Override
    public void restart() {
        this.filterChain.restart();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

