/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.util;

import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.Protocol;
import com.simba.athena.amazonaws.Request;
import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkProtectedApi;
import com.simba.athena.amazonaws.util.HttpClientWrappingInputStream;
import com.simba.athena.amazonaws.util.SdkHttpUtils;
import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.shaded.apache.http.HttpHost;
import com.simba.athena.shaded.apache.http.auth.AuthScope;
import com.simba.athena.shaded.apache.http.auth.NTCredentials;
import com.simba.athena.shaded.apache.http.client.methods.CloseableHttpResponse;
import com.simba.athena.shaded.apache.http.client.methods.HttpGet;
import com.simba.athena.shaded.apache.http.impl.client.DefaultHttpClient;
import com.simba.athena.shaded.apache.http.params.BasicHttpParams;
import com.simba.athena.shaded.apache.http.params.HttpConnectionParams;
import com.simba.athena.shaded.apache.http.params.HttpProtocolParams;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class RuntimeHttpUtils {
    private static final String COMMA = ", ";
    private static final String SPACE = " ";
    private static final String AWS_EXECUTION_ENV_PREFIX = "exec-env/";
    private static final String AWS_EXECUTION_ENV_NAME = "AWS_EXECUTION_ENV";

    public static InputStream fetchFile(URI uri, ClientConfiguration config) throws IOException {
        CloseableHttpResponse response;
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent(httpClientParams, RuntimeHttpUtils.getUserAgent(config, null));
        HttpConnectionParams.setConnectionTimeout(httpClientParams, RuntimeHttpUtils.getConnectionTimeout(config));
        HttpConnectionParams.setSoTimeout(httpClientParams, RuntimeHttpUtils.getSocketTimeout(config));
        DefaultHttpClient httpclient = new DefaultHttpClient(httpClientParams);
        if (config != null) {
            String proxyHost = config.getProxyHost();
            int proxyPort = config.getProxyPort();
            if (proxyHost != null && proxyPort > 0) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                httpclient.getParams().setParameter("http.route.default-proxy", proxy);
                if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                    httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), new NTCredentials(config.getProxyUsername(), config.getProxyPassword(), config.getProxyWorkstation(), config.getProxyDomain()));
                }
            }
        }
        if ((response = httpclient.execute(new HttpGet(uri))).getStatusLine().getStatusCode() != 200) {
            throw new IOException("Error fetching file from " + uri + ": " + response);
        }
        return new HttpClientWrappingInputStream(httpclient, response.getEntity().getContent());
    }

    public static String getUserAgent(ClientConfiguration config, String userAgentMarker) {
        String userDefinedPrefix = config != null ? config.getUserAgentPrefix() : "";
        String userDefinedSuffix = config != null ? config.getUserAgentSuffix() : "";
        String awsExecutionEnvironment = RuntimeHttpUtils.getEnvironmentVariable(AWS_EXECUTION_ENV_NAME);
        StringBuilder userAgent = new StringBuilder(userDefinedPrefix.trim());
        if (!ClientConfiguration.DEFAULT_USER_AGENT.equals(userDefinedPrefix)) {
            userAgent.append(COMMA).append(ClientConfiguration.DEFAULT_USER_AGENT);
        }
        if (StringUtils.hasValue(userDefinedSuffix)) {
            userAgent.append(COMMA).append(userDefinedSuffix.trim());
        }
        if (StringUtils.hasValue(awsExecutionEnvironment)) {
            userAgent.append(SPACE).append(AWS_EXECUTION_ENV_PREFIX).append(awsExecutionEnvironment.trim());
        }
        if (StringUtils.hasValue(userAgentMarker)) {
            userAgent.append(SPACE).append(userAgentMarker.trim());
        }
        return userAgent.toString();
    }

    private static String getEnvironmentVariable(String environmentVariableName) {
        try {
            return System.getenv(environmentVariableName);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static int getConnectionTimeout(ClientConfiguration config) {
        if (config != null) {
            return config.getConnectionTimeout();
        }
        return 10000;
    }

    private static int getSocketTimeout(ClientConfiguration config) {
        if (config != null) {
            return config.getSocketTimeout();
        }
        return 50000;
    }

    public static URI toUri(String endpoint, ClientConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("ClientConfiguration cannot be null");
        }
        return RuntimeHttpUtils.toUri(endpoint, config.getProtocol());
    }

    public static URI toUri(String endpoint, Protocol protocol) {
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint cannot be null");
        }
        if (!endpoint.contains("://")) {
            endpoint = protocol.toString() + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @SdkProtectedApi
    public static URL convertRequestToUrl(Request<?> request, boolean removeLeadingSlashInResourcePath, boolean urlEncode) {
        String resourcePath;
        String string = resourcePath = urlEncode ? SdkHttpUtils.urlEncode(request.getResourcePath(), true) : request.getResourcePath();
        if (removeLeadingSlashInResourcePath && resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        String urlPath = "/" + resourcePath;
        urlPath = urlPath.replaceAll("(?<=/)/", "%2F");
        StringBuilder url = new StringBuilder(request.getEndpoint().toString());
        url.append(urlPath);
        StringBuilder queryParams = new StringBuilder();
        Map<String, List<String>> requestParams = request.getParameters();
        for (Map.Entry<String, List<String>> entry : requestParams.entrySet()) {
            for (String value : entry.getValue()) {
                queryParams = queryParams.length() > 0 ? queryParams.append("&") : queryParams.append("?");
                queryParams.append(SdkHttpUtils.urlEncode(entry.getKey(), false)).append("=").append(SdkHttpUtils.urlEncode(value, false));
            }
        }
        url.append(queryParams.toString());
        try {
            return new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new SdkClientException("Unable to convert request to well formed URL: " + e.getMessage(), e);
        }
    }
}

