/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.operators;

import dr.evolution.alignment.SitePatterns;
import dr.inference.model.Parameter;
import dr.inference.model.ParameterParser;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class SlidingPatternsOperator
extends AbstractAdaptableOperator {
    public static final String WINDOW_SIZE = "windowSize";
    public static final String OPERATOR_NAME = "slidingPatternsOperator";
    public static final String BREAK_POINTS = "breakPoints";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("windowSize"), AttributeRule.newIntegerRule("weight"), AttributeRule.newBooleanRule("autoOptimize", true), new ElementRule("breakPoints", Parameter.class), new ElementRule(SitePatterns.class, 2, 100)};

        @Override
        public String getParserName() {
            return SlidingPatternsOperator.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Object object;
            int n;
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            int n2 = xMLObject.getIntegerAttribute("weight");
            int n3 = xMLObject.getIntegerAttribute(SlidingPatternsOperator.WINDOW_SIZE);
            ArrayList<SitePatterns> arrayList = new ArrayList<SitePatterns>();
            int n4 = xMLObject.getChildCount();
            for (n = 0; n < n4; ++n) {
                object = xMLObject.getChild(n);
                if (!(object instanceof SitePatterns)) continue;
                arrayList.add((SitePatterns)object);
            }
            if (!SlidingPatternsOperator.arePartitionsContiguous(arrayList)) {
                throw new XMLParseException("Only contiguous partitions are allowed");
            }
            n = arrayList.size() - 1;
            object = xMLObject.getChild(SlidingPatternsOperator.BREAK_POINTS);
            Parameter.Default default_ = new Parameter.Default(n);
            ParameterParser.replaceParameter((XMLObject)object, default_);
            default_.setDimension(n);
            for (int i = 0; i < n; ++i) {
                default_.setParameterValueQuietly(i, ((SitePatterns)arrayList.get(i + 1)).getFrom());
            }
            return new SlidingPatternsOperator(arrayList, default_, n3, n2, adaptationMode);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a sliding window operator on alignment sites.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private int totalAlignmentLength;
    private final List<SitePatterns> partitions;
    private int windowSize = 10;
    private final Parameter breakPoints;

    public SlidingPatternsOperator(List<SitePatterns> list, Parameter parameter, int n, int n2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.partitions = list;
        this.windowSize = n;
        this.breakPoints = parameter;
    }

    public String currentBreakPointsString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        boolean bl = true;
        for (double d : this.breakPoints.getParameterValues()) {
            int n = (int)d;
            if (!bl) {
                stringBuilder.append(",");
                bl = false;
            }
            stringBuilder.append(n);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void addNewSitePatterns(SitePatterns sitePatterns) {
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public double doOperation() {
        int n = MathUtils.nextInt(this.breakPoints.getDimension());
        int n2 = (int)this.breakPoints.getParameterValue(n);
        SitePatterns sitePatterns = this.partitions.get(n);
        SitePatterns sitePatterns2 = this.partitions.get(n + 1);
        int n3 = sitePatterns.getFrom();
        int n4 = sitePatterns2.getTo();
        int n5 = n3;
        while (n5 <= n3 || n5 >= n4) {
            if (MathUtils.nextBoolean()) {
                n5 = n2 + MathUtils.nextInt(this.windowSize) + 1;
                continue;
            }
            n5 = n2 - MathUtils.nextInt(this.windowSize) - 1;
        }
        return 0.0;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.windowSize);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.windowSize = (int)Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.windowSize;
    }

    @Override
    public String getAdaptableParameterName() {
        return WINDOW_SIZE;
    }

    public static boolean arePartitionsContiguous(List<SitePatterns> list) {
        int n = -1;
        boolean bl = false;
        for (SitePatterns sitePatterns : list) {
            int n2 = sitePatterns.getFrom();
            int n3 = sitePatterns.getTo();
            if (n != -1 && n2 != n + 1) {
                return false;
            }
            n = n3;
        }
        return true;
    }
}

