/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.util;

import com.portfolioeffect.quant.client.api.Metric;
import com.portfolioeffect.quant.client.result.LazyMetric;

public class MetricRunnable
implements Runnable {
    private final LazyMetric metric;
    private final Runnable callBack;

    public MetricRunnable(Metric m) {
        this.metric = m.getMetric();
        this.callBack = null;
    }

    public MetricRunnable(Metric m, Runnable callBack) {
        this.metric = m.getMetric();
        this.callBack = callBack;
    }

    public MetricRunnable(LazyMetric m) {
        this.metric = m;
        this.callBack = null;
    }

    public MetricRunnable(LazyMetric m, Runnable callBack) {
        this.metric = m;
        this.callBack = callBack;
    }

    @Override
    public void run() {
        try {
            this.metric.computeAsync();
            if (this.callBack != null) {
                this.callBack.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LazyMetric getMetric() {
        return this.metric;
    }
}

