/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.DefaultX11Algorithm;
import ec.satoolkit.x11.IX11Preprocessor;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.modelling.arima.x13.UscbForecasts;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.SarimaMapping;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.Arrays2;

class AirlinePreprocessor
extends DefaultX11Algorithm
implements IX11Preprocessor {
    private void addfcasts(TsData s, InformationSet info, int nb, int nf) {
        DataBlock data = new DataBlock(s.internalStorage());
        SarimaSpecification spec = new SarimaSpecification(this.context.getFrequency());
        spec.airline();
        RegArimaModel<SarimaModel> regarima = new RegArimaModel<SarimaModel>(new SarimaModel(spec), data);
        GlsSarimaMonitor monitor = new GlsSarimaMonitor();
        monitor.setMinimizer(new ProxyMinimizer(new LevenbergMarquardtMethod()));
        monitor.setPrecision(1.0E-7);
        SarimaModel model = (SarimaModel)monitor.process(regarima).model.getArima();
        SarimaMapping.stabilize(model);
        UscbForecasts fcast = new UscbForecasts(model);
        TsData xs = s;
        if (nf > 0) {
            double[] forecasts = fcast.forecasts(data, nf);
            TsData fs = new TsData(s.getEnd(), forecasts, false);
            xs = s.update(fs);
            info.subSet("a-tables").set("a1a", fs);
        }
        if (nb > 0) {
            double[] backcasts = fcast.forecasts(data.reverse(), nb);
            Arrays2.reverse(backcasts);
            TsData bs = new TsData(s.getStart().minus(backcasts.length), backcasts, false);
            xs = bs.update(xs);
        }
        info.subSet("b-tables").set("b1", xs);
    }

    private void mulfcasts(TsData s, InformationSet info, int nb, int nf) {
        TsData ls = s.log();
        TsData xs = s;
        DataBlock data = new DataBlock(ls.internalStorage());
        SarimaSpecification spec = new SarimaSpecification(this.context.getFrequency());
        spec.airline();
        RegArimaModel<SarimaModel> regarima = new RegArimaModel<SarimaModel>(new SarimaModel(spec), data);
        GlsSarimaMonitor monitor = new GlsSarimaMonitor();
        monitor.setMinimizer(new ProxyMinimizer(new LevenbergMarquardtMethod()));
        monitor.setPrecision(1.0E-7);
        SarimaModel model = (SarimaModel)monitor.process(regarima).model.getArima();
        SarimaMapping.stabilize(model);
        UscbForecasts fcast = new UscbForecasts(model);
        TsData fs = null;
        if (nf > 0) {
            double[] forecasts = fcast.forecasts(data, nf);
            fs = new TsData(s.getEnd(), forecasts, false);
            fs = fs.exp();
            xs = s.update(fs);
            info.subSet("a-tables").set("a1a", fs);
        }
        if (nb > 0) {
            double[] backcasts = fcast.forecasts(data.reverse(), nb);
            Arrays2.reverse(backcasts);
            TsData bs = new TsData(s.getStart().minus(backcasts.length), backcasts, false);
            xs = bs.exp().update(xs);
        }
        info.subSet("b-tables").set("b1", xs);
    }

    @Override
    public void preprocess(InformationSet info) {
        TsData a1 = info.subSet("a-tables").get("a1", TsData.class);
        if (this.context.isPseudoAdditive()) {
            info.subSet("b-tables").set("b1", a1);
        } else {
            int nf = this.context.getForecastHorizon();
            int nb = this.context.getBackcastHorizon();
            if (nf == 0 && nb == 0) {
                info.subSet("b-tables").set("b1", a1);
            } else if (this.context.isMultiplicative()) {
                this.mulfcasts(a1, info, nb, nf);
            } else {
                this.addfcasts(a1, info, nb, nf);
            }
        }
    }
}

