/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import it.bancaditalia.oss.sdmx.util.LanguagePriorityList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class LocalizedText {
    private static final String LANG = "lang";
    private final LanguagePriorityList languages;
    private final Map<String, String> data;

    public LocalizedText(LanguagePriorityList languagePriorityList) {
        this.languages = languagePriorityList;
        this.data = new LinkedHashMap<String, String>();
    }

    private void put(String string, String string2) {
        if (string2 != null) {
            this.data.put(string, string2);
        }
    }

    public String getText() {
        if (this.data.isEmpty()) {
            return null;
        }
        String string = this.languages.lookupTag(this.data.keySet());
        return string != null ? this.data.get(string) : this.data.values().iterator().next();
    }

    public void setText(StartElement startElement, XMLEventReader xMLEventReader) throws XMLStreamException {
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!attribute.getName().getLocalPart().equals(LANG)) continue;
            this.put(attribute.getValue(), xMLEventReader.getElementText());
        }
    }

    public void clear() {
        this.data.clear();
    }
}

