/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IPopulation;
import net.sf.jclec.IProvider;
import net.sf.jclec.ISystem;
import net.sf.jclec.util.random.IRandGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreator<I extends IIndividual>
implements IProvider<I> {
    protected IPopulation<I> context;
    protected IRandGen randgen;
    protected transient int numberOfIndividuals;
    protected transient List<I> createdBuffer;
    protected transient int createdCounter;

    @Override
    public void contextualize(ISystem<I> context) {
        if (!(context instanceof IPopulation)) {
            throw new IllegalArgumentException("This object uses a population as execution context");
        }
        this.context = (IPopulation)context;
        this.randgen = context.createRandGen();
    }

    @Override
    public List<I> provide(int numberOfIndividuals) {
        this.numberOfIndividuals = numberOfIndividuals;
        this.createdBuffer = new ArrayList<I>(numberOfIndividuals);
        this.prepareCreation();
        this.createdCounter = 0;
        while (this.createdCounter < numberOfIndividuals) {
            this.createNext();
            ++this.createdCounter;
        }
        return this.createdBuffer;
    }

    protected abstract void prepareCreation();

    protected abstract void createNext();
}

