/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.RBFN_incremental_CL;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.core.Files;

public class RBFUtils {
    static boolean verbosityValue = false;

    public static boolean setVerbosity(Hashtable _hashtable) {
        verbosityValue = _hashtable.containsKey("verbose");
        return verbosityValue;
    }

    public static boolean setVerbosity(boolean _value) {
        verbosityValue = _value;
        return verbosityValue;
    }

    public static boolean getVerbosity() {
        return verbosityValue;
    }

    public static void verbose(String _cad) {
        if (verbosityValue) {
            System.out.print(_cad);
        }
    }

    public static void verboseln(String _cad) {
        if (verbosityValue) {
            System.out.println(_cad);
        }
    }

    public static double[] vector2doubles(Vector _v) {
        int tamanio = _v.size();
        double[] toRet = new double[tamanio];
        for (int i = 0; i < tamanio; ++i) {
            toRet[i] = Double.parseDouble((String)_v.elementAt(i));
        }
        return toRet;
    }

    public static void vector2InputOutput(Vector _v, int _inpDim, double[] _input, double[] _output) throws IOException {
        int i;
        if (_input.length > 0) {
            for (i = 0; i < _input.length; ++i) {
                _input[i] = Double.parseDouble((String)_v.elementAt(i));
            }
        } else {
            Exception e = new Exception("Error: vector2InputOuput function: Dimension of inputs is 0!");
            throw new InternalError(e.toString());
        }
        if (_output.length > 0) {
            for (i = 0; i < _output.length; ++i) {
                _output[i] = Double.parseDouble((String)_v.elementAt(i + _inpDim));
            }
        } else {
            Exception e = new Exception("Error: vector2InputOuput function: Dimension of outputs is 0!");
            throw new InternalError(e.toString());
        }
    }

    public static double[] vector2Input(Vector _v, int _inpDim) throws IOException {
        if (_inpDim > 0) {
            double[] toRet = new double[_inpDim];
            for (int i = 0; i < toRet.length; ++i) {
                toRet[i] = Double.parseDouble((String)_v.elementAt(i));
            }
            return toRet;
        }
        Exception e = new Exception("Error: vector2Input function: Dimension of inputs is 0!");
        throw new InternalError(e.toString());
    }

    public static double[] vector2Output(Vector _v, int _outDim) throws IOException {
        if (_outDim > 0) {
            double[] toRet = new double[_outDim];
            for (int i = 0; i < toRet.length; ++i) {
                toRet[i] = Double.parseDouble((String)_v.elementAt(_v.size() - _outDim + i));
            }
            return toRet;
        }
        Exception e = new Exception("Error: vector2Output function: Dimension of outputs is 0!");
        throw new InternalError(e.toString());
    }

    public static void printArray(double[] _a) {
        System.out.println(RBFUtils.array2string(_a));
    }

    public static String array2string(double[] _a) {
        String toRet = "";
        for (int i = 0; i < _a.length - 1; ++i) {
            toRet = toRet + Double.toString(_a[i]) + ", ";
        }
        toRet = toRet + _a[_a.length - 1];
        return toRet;
    }

    public static double euclidean(double[] _a, double[] _b) {
        double toRet = 0.0;
        if (_a.length != _b.length) {
            System.out.println("ERROR: Euclidean can not be used if vectors have different size!");
            toRet = -1.0;
        } else {
            for (int i = 0; i < _a.length; ++i) {
                toRet += (_a[i] - _b[i]) * (_a[i] - _b[i]);
            }
            toRet = Math.sqrt(toRet);
        }
        return toRet;
    }

    public static double[] medVect(double[][] v) {
        int i;
        double[] toRet = new double[v.length];
        int numFil = v.length;
        int numCol = v[0].length;
        for (i = 0; i < numCol; ++i) {
            toRet[i] = 0.0;
        }
        for (i = 0; i < numFil; ++i) {
            for (int j = 0; j < numCol; ++j) {
                int n = j;
                toRet[n] = toRet[n] + v[i][j];
            }
        }
        i = 0;
        while (i < numCol) {
            int n = i++;
            toRet[n] = toRet[n] / (double)numFil;
        }
        return toRet;
    }

    public static double maxDistance(double[][] _values) {
        double toRet = 0.0;
        int numDatos = _values.length;
        for (int i = 0; i < numDatos; ++i) {
            for (int j = i + 1; j < numDatos; ++j) {
                double distancia = RBFUtils.euclidean(_values[i], _values[j]);
                toRet = distancia > toRet ? distancia : toRet;
            }
        }
        return toRet;
    }

    public static double avegDistance(double[][] _values) {
        double toRet = 0.0;
        int cont = 0;
        int numDatos = _values.length;
        for (int i = 0; i < numDatos; ++i) {
            for (int j = i + 1; j < numDatos; ++j) {
                toRet += RBFUtils.euclidean(_values[i], _values[j]);
                ++cont;
            }
        }
        return toRet / (double)cont;
    }

    public static double geomDistance(double[] center, int nCenter, double[][] _values) {
        double toRet = 0.0;
        boolean cont = false;
        int numDatos = _values.length;
        double min2 = Double.MAX_VALUE;
        double min1 = Double.MAX_VALUE;
        for (int i = 0; i < numDatos; ++i) {
            double tmp;
            if (i == nCenter || !((tmp = RBFUtils.euclidean(_values[i], center)) < min1) && !(tmp < min2) || tmp == 0.0) continue;
            if (min1 < min2) {
                min2 = tmp;
                continue;
            }
            min1 = tmp;
        }
        toRet = numDatos > 1 ? Math.sqrt(min1 * min2) : (numDatos == 1 ? min1 : RBFUtils.avegDistance(_values));
        return toRet;
    }

    public static double RMSDistance(double[] center, int nCenter, double[][] _values, int N) {
        int i;
        double toRet = 0.0;
        boolean cont = false;
        int numDatos = _values.length;
        Vector<Double> dist = new Vector<Double>();
        for (i = 0; i < numDatos; ++i) {
            double tmp;
            if (i == nCenter || (tmp = RBFUtils.euclidean(_values[i], center)) == 0.0) continue;
            dist.addElement(new Double(tmp));
        }
        Collections.sort(dist);
        for (i = 0; i < N && i < numDatos - 1; ++i) {
            toRet += ((Double)dist.elementAt(i)).doubleValue();
        }
        return toRet /= (double)N;
    }

    public static Hashtable parameters(String fileName) {
        Hashtable toRet = new Hashtable();
        StringTokenizer st = new StringTokenizer(Files.readFile(fileName), "\n");
        while (st.hasMoreTokens()) {
            StringTokenizer lin = new StringTokenizer(st.nextToken(), "=");
            String nombre = lin.nextToken().trim();
            String valores = lin.hasMoreTokens() ? lin.nextToken().trim() : "";
            Vector<String> vValores = new Vector<String>();
            if (valores != "") {
                StringTokenizer val = new StringTokenizer(valores, " ");
                while (val.hasMoreTokens()) {
                    vValores.add(val.nextToken().trim());
                }
            }
            toRet.put(nombre, vValores);
        }
        return toRet;
    }

    public static void createOutputFile(String _origin, String _destiny) {
        try {
            if (_origin != "") {
                String linea = "";
                BufferedReader in = new BufferedReader(new FileReader(_origin));
                Files.writeFile(_destiny, "");
                do {
                    if ((linea = in.readLine()) == null) continue;
                    Files.addToFile(_destiny, linea + "\n");
                    RBFUtils.verboseln("Escrito: " + linea + "\n");
                } while (linea != "" && linea.compareTo("@data") != 0);
                in.close();
            } else {
                Files.writeFile(_destiny, "");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int maxInVector(double[] _vector) {
        int toRet = 0;
        for (int j = 0; j < _vector.length; ++j) {
            if (!(_vector[toRet] < _vector[j])) continue;
            toRet = j;
        }
        return toRet;
    }
}

