% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2num.R
\name{str2num}
\alias{str2num}
\title{Convert Character Numbers to Numeric}
\usage{
str2num(x)
}
\arguments{
\item{x}{A string representing a (possibly German) number.}
}
\value{
The number as a numeric.
}
\description{
If you read text containing  (possibly German, i.e. the decimals separated by
comma and dots inserted for what they think of as readability) numbers, you
may want to convert them to numeric.
}
\examples{
line_in_text <- "foo bar 10.303,70 foo bar  1.211.000,55 foo bar"
words <- unlist(strsplit(line_in_text, split = " "))
print(na.omit(sapply(words, str2num)), digits = 9)
print(str2num(words[7]), digits = 9)
}
\seealso{
Other bits and pieces: 
\code{\link{golden_ratio}()},
\code{\link{is_difftime_less}()},
\code{\link{is_valid_primary_key}()},
\code{\link{r_cmd_install}()},
\code{\link{round_half_away_from_zero}()},
\code{\link{strip_off_attributes}()},
\code{\link{tapply}()},
\code{\link{throw}()},
\code{\link{weighted_variance}()}
}
\concept{bits and pieces}
