/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.core;

import com.qarks.util.Cancellable;
import com.qarks.util.CancellableImpl;
import com.qarks.util.files.diff.FileDiffResult;
import com.qarks.util.files.diff.FileLine;
import com.qarks.util.files.diff.ParsedFile;
import com.qarks.util.files.diff.core.Chunk;
import com.qarks.util.files.diff.core.Delta;
import com.qarks.util.files.diff.core.DiffNode;
import com.qarks.util.files.diff.core.PathNode;
import com.qarks.util.files.diff.core.Snake;
import java.util.ArrayList;

public class MyersDiff {
    public static FileDiffResult diff(ParsedFile parsedFile, ParsedFile parsedFile2, Cancellable cancellable, boolean bl) {
        return MyersDiff.diff(parsedFile.getLines(), parsedFile2.getLines(), cancellable, bl);
    }

    public static FileDiffResult diff(ParsedFile parsedFile, ParsedFile parsedFile2, boolean bl) {
        return MyersDiff.diff(parsedFile.getLines(), parsedFile2.getLines(), (Cancellable)new CancellableImpl(), bl);
    }

    public static FileDiffResult diff(FileLine[] fileLineArray, FileLine[] fileLineArray2, Cancellable cancellable, boolean bl) {
        FileDiffResult fileDiffResult = null;
        PathNode pathNode = MyersDiff.buildPath(fileLineArray, fileLineArray2, cancellable, bl);
        if (pathNode != null) {
            fileDiffResult = MyersDiff.buildRevision(pathNode, fileLineArray, fileLineArray2);
        }
        return fileDiffResult;
    }

    public static PathNode buildPath(FileLine[] fileLineArray, FileLine[] fileLineArray2, Cancellable cancellable, boolean bl) {
        if (fileLineArray == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (fileLineArray2 == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        int n = fileLineArray.length;
        int n2 = fileLineArray2.length;
        int n3 = n + n2 + 1;
        int n4 = 1 + 2 * n3;
        int n5 = (n4 + 1) / 2;
        PathNode[] pathNodeArray = new PathNode[n4];
        pathNodeArray[n5 + 1] = new Snake(0, -1, null);
        for (int i = 0; i < n3; ++i) {
            if (cancellable != null && cancellable.isCancelled()) {
                return null;
            }
            for (int j = -i; j <= i; j += 2) {
                int n6;
                int n7;
                if (cancellable != null && cancellable.isCancelled()) {
                    return null;
                }
                int n8 = n5 + j;
                int n9 = n8 + 1;
                int n10 = n8 - 1;
                PathNode pathNode = null;
                if (j == -i || j != i && pathNodeArray[n10].i < pathNodeArray[n9].i) {
                    n7 = pathNodeArray[n9].i;
                    pathNode = pathNodeArray[n9];
                } else {
                    n7 = pathNodeArray[n10].i + 1;
                    pathNode = pathNodeArray[n10];
                }
                pathNodeArray[n10] = null;
                PathNode pathNode2 = new DiffNode(n7, n6, pathNode);
                for (n6 = n7 - j; n7 < n && n6 < n2 && fileLineArray[n7].matches(fileLineArray2[n6], bl); ++n7, ++n6) {
                }
                if (n7 > pathNode2.i) {
                    pathNode2 = new Snake(n7, n6, pathNode2);
                }
                pathNodeArray[n8] = pathNode2;
                if (n7 < n || n6 < n2) continue;
                return pathNodeArray[n8];
            }
            pathNodeArray[n5 + i - 1] = null;
        }
        return null;
    }

    public static FileDiffResult buildRevision(PathNode pathNode, FileLine[] fileLineArray, FileLine[] fileLineArray2) {
        int n;
        Object object;
        int n2;
        int n3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (pathNode == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (fileLineArray == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (fileLineArray2 == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        if (pathNode.isSnake()) {
            pathNode = pathNode.prev;
        }
        while (pathNode != null && pathNode.prev != null && pathNode.prev.j >= 0) {
            if (pathNode.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            n3 = pathNode.i;
            n2 = pathNode.j;
            pathNode = pathNode.prev;
            int n4 = pathNode.i;
            int n5 = pathNode.j;
            object = new Delta(new Chunk(n4, n3 - n4), new Chunk(n5, n2 - n5));
            arrayList.add(0, object);
            if (!pathNode.isSnake()) continue;
            pathNode = pathNode.prev;
        }
        n3 = 0;
        n2 = 0;
        for (Delta delta : arrayList) {
            FileLine fileLine;
            int n6;
            object = delta.getOriginal();
            Chunk chunk = delta.getRevised();
            int n7 = ((Chunk)object).count == 0 || chunk.count == 0 ? -1 : 3;
            for (n6 = n3; n6 < ((Chunk)object).first(); ++n6) {
                if (n6 >= fileLineArray.length) continue;
                fileLine = fileLineArray[n6];
                fileLine.setStatus(1);
            }
            for (n6 = n3 = ((Chunk)object).first(); n6 < n3 + ((Chunk)object).count; ++n6) {
                if (n6 >= fileLineArray.length) continue;
                fileLine = fileLineArray[n6];
                fileLine.setStatus(n7);
            }
            n3 += ((Chunk)object).count;
            for (n6 = n2; n6 < chunk.first(); ++n6) {
                if (n6 >= fileLineArray2.length) continue;
                fileLine = fileLineArray2[n6];
                fileLine.setStatus(1);
            }
            for (n6 = n2 = chunk.first(); n6 < n2 + chunk.count; ++n6) {
                if (n6 >= fileLineArray2.length) continue;
                fileLine = fileLineArray2[n6];
                fileLine.setStatus(n7);
            }
            n2 += chunk.count;
        }
        for (n = n3; n < fileLineArray.length; ++n) {
            fileLineArray[n].setStatus(1);
        }
        for (n = n2; n < fileLineArray2.length; ++n) {
            fileLineArray2[n].setStatus(1);
        }
        FileDiffResult fileDiffResult = new FileDiffResult(new ParsedFile(fileLineArray), new ParsedFile(fileLineArray2));
        return fileDiffResult;
    }
}

