## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(refer)

## -----------------------------------------------------------------------------
map   <- matrix(' ', nrow=10, ncol=10)
map

## -----------------------------------------------------------------------------
person <- list(
  map     = ref(map), 
  row     = 1,
  col     = 1
)
map[1,1] <- 'X'

## -----------------------------------------------------------------------------
person$map

## -----------------------------------------------------------------------------
!person$map

## -----------------------------------------------------------------------------
map[1,5] <- "O"
!person$map

## -----------------------------------------------------------------------------
location <- ref(c(person$row, person$col))
location

## -----------------------------------------------------------------------------
!location

## -----------------------------------------------------------------------------
person$row <- person$row + 1
!location

## -----------------------------------------------------------------------------
location + 1
!location

## -----------------------------------------------------------------------------
row1 <- slice(map, 1, 1:5)
!row1

## -----------------------------------------------------------------------------
map[1, 3] <- "%"
!row1

## -----------------------------------------------------------------------------
loc_row <- slice(location, 1)
!loc_row

## -----------------------------------------------------------------------------
person$col %+=% 3
person$col

## -----------------------------------------------------------------------------
person$col %-=% 3
person$col

## -----------------------------------------------------------------------------
x <- 1:nrow(map)
slice_x <- slice(x, 3:6)
slice_x %+=% 10
x

## -----------------------------------------------------------------------------
modify_by(x, sqrt)
x

## -----------------------------------------------------------------------------
modify_by(x, 5)
x

## -----------------------------------------------------------------------------
p <- sref(person)
!p

## ----eval=FALSE---------------------------------------------------------------
#  ## These will spawn an error. Don't run!
#  p$row
#  modify_by(p, function(x){ x$row <- x$row + 1; x })

