/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageioimpl.plugins.cog.PropertyLocator;

public class CacheConfig {
    public static final String COG_CACHING_USE_DISK = "IIO_COG_CACHING_USEDISK";
    public static final String COG_CACHING_USE_OFF_HEAP = "IIO_COG_CACHING_USEOFFHEAP";
    public static final String COG_CACHING_DISK_CACHE_SIZE = "IIO_COG_CACHING_DISKCACHESIZE";
    public static final String COG_CACHING_DISK_PATH = "IIO_COG_CACHING_DISKPATH";
    public static final String COG_CACHING_EH_CACHE_CONFIG = "IIO_COG_CACHING_EHCACHECONFIG";
    public static final String COG_CACHING_HEAP_ENTRIES = "IIO_COG_CACHING_HEAPENTRIES";
    public static final String COG_CACHING_OFF_HEAP_SIZE = "IIO_COG_CACHING_OFFHEAPSIZE";
    public static final String COG_CACHING_TIME_TO_IDLE = "IIO_COG_CACHING_TIMETOIDLE";
    public static final String COG_CACHING_TIME_TO_LIVE = "IIO_COG_CACHING_TIMETOLIVE";
    public static final int MEBIBYTE_IN_BYTES = 0x100000;
    private static boolean useDiskCache;
    private static boolean useOffHeapCache;
    private static int diskCacheSize;
    private static int offHeapSize;
    private static int heapEntries;
    private static String cacheDirectory;
    private static long timeToIdle;
    private static long timeToLive;
    private static String xmlConfigPath;

    public CacheConfig() {
        useDiskCache = Boolean.getBoolean(PropertyLocator.getEnvironmentValue(COG_CACHING_USE_DISK, "false"));
        useOffHeapCache = Boolean.getBoolean(PropertyLocator.getEnvironmentValue(COG_CACHING_USE_OFF_HEAP, "false"));
        diskCacheSize = Integer.parseInt(PropertyLocator.getEnvironmentValue(COG_CACHING_DISK_CACHE_SIZE, Integer.toString(524288000)));
        offHeapSize = Integer.parseInt(PropertyLocator.getEnvironmentValue(COG_CACHING_OFF_HEAP_SIZE, Integer.toString(0x3200000)));
        heapEntries = Integer.parseInt(PropertyLocator.getEnvironmentValue(COG_CACHING_HEAP_ENTRIES, "2000"));
        cacheDirectory = PropertyLocator.getEnvironmentValue(COG_CACHING_DISK_PATH, null);
        timeToIdle = Integer.parseInt(PropertyLocator.getEnvironmentValue(COG_CACHING_TIME_TO_IDLE, "0"));
        timeToLive = Integer.parseInt(PropertyLocator.getEnvironmentValue(COG_CACHING_TIME_TO_LIVE, "0"));
        xmlConfigPath = PropertyLocator.getEnvironmentValue(COG_CACHING_EH_CACHE_CONFIG, null);
    }

    public static CacheConfig getDefaultConfig() {
        return new CacheConfig();
    }

    public boolean isUseDiskCache() {
        return useDiskCache;
    }

    public void setUseDiskCache(boolean useDiskCache) {
        CacheConfig.useDiskCache = useDiskCache;
    }

    public boolean isUseOffHeapCache() {
        return useOffHeapCache;
    }

    public void setUseOffHeapCache(boolean useOffHeapCache) {
        CacheConfig.useOffHeapCache = useOffHeapCache;
    }

    public int getDiskCacheSize() {
        return diskCacheSize;
    }

    public void setDiskCacheSize(int diskCacheSize) {
        CacheConfig.diskCacheSize = diskCacheSize;
    }

    public String getCacheDirectory() {
        return cacheDirectory;
    }

    public void setCacheDirectory(String cacheDirectory) {
        CacheConfig.cacheDirectory = cacheDirectory;
    }

    public int getHeapEntries() {
        return heapEntries;
    }

    public void setHeapEntries(int heapEntries) {
        CacheConfig.heapEntries = heapEntries;
    }

    public int getOffHeapSize() {
        return offHeapSize;
    }

    public void setOffHeapSize(int offHeapSize) {
        CacheConfig.offHeapSize = offHeapSize;
    }

    public long getTimeToIdle() {
        return timeToIdle;
    }

    public long getTimeToLive() {
        return timeToLive;
    }

    public void setTimeToIdle(long timeToIdle) {
        CacheConfig.timeToIdle = timeToIdle;
    }

    public void setTimeToLive(long timeToLive) {
        CacheConfig.timeToLive = timeToLive;
    }

    public String getXmlConfigPath() {
        return xmlConfigPath;
    }

    public void setXmlConfigPath(String xmlConfigPath) {
        CacheConfig.xmlConfigPath = xmlConfigPath;
    }
}

