/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorconvert;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.colorconvert.ColorSpaceJAIExt;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;
import javax.media.jai.iterator.RandomIter;

public class IHSColorSpaceJAIExt
extends ColorSpaceJAIExt {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private static final double PI2 = Math.PI * 2;
    private static final double PI23 = 2.0943951023931953;
    private static final double PI43 = 4.1887902047863905;
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double BYTESCALE = 40.58451048843331;
    private static SoftReference reference = new SoftReference<Object>(null);
    private static byte[] acosTable = null;
    private static double[] sqrtTable = null;
    private static double[] tanTable = null;
    private static SoftReference acosSoftRef;
    private static SoftReference sqrtSoftRef;
    private static SoftReference tanSoftRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IHSColorSpaceJAIExt getInstance() {
        SoftReference softReference = reference;
        synchronized (softReference) {
            IHSColorSpaceJAIExt cs;
            Object referent = reference.get();
            if (referent == null) {
                cs = new IHSColorSpaceJAIExt();
                reference = new SoftReference<IHSColorSpaceJAIExt>(cs);
            } else {
                cs = (IHSColorSpaceJAIExt)referent;
            }
            return cs;
        }
    }

    public IHSColorSpaceJAIExt() {
        super(7, 3, true);
    }

    private synchronized void generateACosTable() {
        if (acosSoftRef == null || acosSoftRef.get() == null) {
            acosTable = new byte[1001];
            acosSoftRef = new SoftReference<byte[]>(acosTable);
            for (int i = 0; i <= 1000; ++i) {
                IHSColorSpaceJAIExt.acosTable[i] = (byte)(40.58451048843331 * Math.acos((double)(i - 500) * 0.002) + 0.5);
            }
        }
    }

    private synchronized void generateSqrtTable() {
        if (sqrtSoftRef == null || sqrtSoftRef.get() == null) {
            sqrtTable = new double[1001];
            sqrtSoftRef = new SoftReference<double[]>(sqrtTable);
            for (int i = 0; i <= 1000; ++i) {
                IHSColorSpaceJAIExt.sqrtTable[i] = Math.sqrt((double)i / 1000.0);
            }
        }
    }

    private synchronized void generateTanTable() {
        if (tanSoftRef == null || tanSoftRef.get() == null) {
            tanTable = new double[256];
            tanSoftRef = new SoftReference<double[]>(tanTable);
            for (int i = 0; i < 256; ++i) {
                IHSColorSpaceJAIExt.tanTable[i] = Math.tan((double)i * (Math.PI * 2) / 255.0);
            }
        }
    }

    @Override
    public float[] fromCIEXYZ(float[] colorValue) {
        float[] rgb = new float[3];
        IHSColorSpaceJAIExt.XYZ2RGB(colorValue, rgb);
        float r = rgb[0];
        float g2 = rgb[1];
        float b2 = rgb[2];
        float[] ihs = new float[3];
        ihs[0] = (r + g2 + b2) / 3.0f;
        float drg = r - g2;
        float drb = r - b2;
        float temp = (float)Math.sqrt((double)drg * (double)drg + (double)drb * (double)(drb - drg));
        if (temp != 0.0f) {
            temp = (float)Math.acos((double)(drg + drb) / (double)temp / 2.0);
            ihs[1] = g2 < b2 ? (float)(Math.PI * 2 - (double)temp) : temp;
        } else {
            ihs[1] = (float)Math.PI * 2;
        }
        float min2 = r < g2 ? r : g2;
        min2 = min2 < b2 ? min2 : b2;
        ihs[2] = ihs[0] == 0.0f ? 0.0f : 1.0f - min2 / ihs[0];
        return ihs;
    }

    @Override
    public float[] fromRGB(float[] rgbValue) {
        float r = rgbValue[0];
        float g2 = rgbValue[1];
        float b2 = rgbValue[2];
        float f = r < 0.0f ? 0.0f : (r = r > 1.0f ? 1.0f : r);
        float f2 = g2 < 0.0f ? 0.0f : (g2 = g2 > 1.0f ? 1.0f : g2);
        b2 = b2 < 0.0f ? 0.0f : (b2 > 1.0f ? 1.0f : b2);
        float[] ihs = new float[3];
        ihs[0] = (r + g2 + b2) / 3.0f;
        float drg = r - g2;
        float drb = r - b2;
        float temp = (float)Math.sqrt((double)drg * (double)drg + (double)drb * (double)(drb - drg));
        if (temp != 0.0f) {
            temp = (float)Math.acos((double)(drg + drb) / (double)temp / 2.0);
            ihs[1] = g2 < b2 ? (float)(Math.PI * 2 - (double)temp) : temp;
        } else {
            ihs[1] = (float)Math.PI * 2;
        }
        float min2 = r < g2 ? r : g2;
        min2 = min2 < b2 ? min2 : b2;
        ihs[2] = ihs[0] == 0.0f ? 0.0f : 1.0f - min2 / ihs[0];
        return ihs;
    }

    @Override
    public float[] toCIEXYZ(float[] colorValue) {
        float c2;
        float c1;
        float i = colorValue[0];
        float h2 = colorValue[1];
        float s2 = colorValue[2];
        float f = i < 0.0f ? 0.0f : (i = i > 1.0f ? 1.0f : i);
        float f2 = h2 < 0.0f ? 0.0f : (h2 = h2 > (float)Math.PI * 2 ? (float)Math.PI * 2 : h2);
        s2 = s2 < 0.0f ? 0.0f : (s2 > 1.0f ? 1.0f : s2);
        float r = 0.0f;
        float g2 = 0.0f;
        float b2 = 0.0f;
        if (s2 == 0.0f) {
            g2 = b2 = i;
            r = b2;
        } else if ((double)h2 >= 2.0943951023931953 && (double)h2 < 4.1887902047863905) {
            r = (1.0f - s2) * i;
            c1 = 3.0f * i - r;
            c2 = (float)(SQRT3 * (double)(r - i) * Math.tan(h2));
            g2 = (c1 + c2) / 2.0f;
            b2 = (c1 - c2) / 2.0f;
        } else if ((double)h2 > 4.1887902047863905) {
            g2 = (1.0f - s2) * i;
            c1 = 3.0f * i - g2;
            c2 = (float)(SQRT3 * (double)(g2 - i) * Math.tan((double)h2 - 2.0943951023931953));
            b2 = (c1 + c2) / 2.0f;
            r = (c1 - c2) / 2.0f;
        } else if ((double)h2 < 2.0943951023931953) {
            b2 = (1.0f - s2) * i;
            c1 = 3.0f * i - b2;
            c2 = (float)(SQRT3 * (double)(b2 - i) * Math.tan((double)h2 - 4.1887902047863905));
            r = (c1 + c2) / 2.0f;
            g2 = (c1 - c2) / 2.0f;
        }
        float[] xyz = new float[3];
        float[] rgb = new float[]{r, g2, b2};
        IHSColorSpaceJAIExt.RGB2XYZ(rgb, xyz);
        return xyz;
    }

    @Override
    public float[] toRGB(float[] colorValue) {
        float i = colorValue[0];
        float h2 = colorValue[1];
        float s2 = colorValue[2];
        float f = i < 0.0f ? 0.0f : (i = i > 1.0f ? 1.0f : i);
        float f2 = h2 < 0.0f ? 0.0f : (h2 = h2 > (float)Math.PI * 2 ? (float)Math.PI * 2 : h2);
        s2 = s2 < 0.0f ? 0.0f : (s2 > 1.0f ? 1.0f : s2);
        float[] rgb = new float[3];
        if (s2 == 0.0f) {
            rgb[1] = rgb[2] = i;
            rgb[0] = rgb[2];
        } else if ((double)h2 >= 2.0943951023931953 && (double)h2 <= 4.1887902047863905) {
            float r = (1.0f - s2) * i;
            float c1 = 3.0f * i - r;
            float c2 = (float)(SQRT3 * (double)(r - i) * Math.tan(h2));
            rgb[0] = r;
            rgb[1] = (c1 + c2) / 2.0f;
            rgb[2] = (c1 - c2) / 2.0f;
        } else if ((double)h2 > 4.1887902047863905) {
            float g2 = (1.0f - s2) * i;
            float c1 = 3.0f * i - g2;
            float c2 = (float)(SQRT3 * (double)(g2 - i) * Math.tan((double)h2 - 2.0943951023931953));
            rgb[0] = (c1 - c2) / 2.0f;
            rgb[1] = g2;
            rgb[2] = (c1 + c2) / 2.0f;
        } else if ((double)h2 < 2.0943951023931953) {
            float b2 = (1.0f - s2) * i;
            float c1 = 3.0f * i - b2;
            float c2 = (float)(SQRT3 * (double)(b2 - i) * Math.tan((double)h2 - 4.1887902047863905));
            rgb[0] = (c1 + c2) / 2.0f;
            rgb[1] = (c1 - c2) / 2.0f;
            rgb[2] = b2;
        }
        return rgb;
    }

    @Override
    public WritableRaster fromCIEXYZ(Raster src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, ROI roi, Range nodata, float[] destNodata) {
        WritableRaster tempRas = IHSColorSpaceJAIExt.CIEXYZToRGB(src, srcComponentSize, null, null, roi, nodata, destNodata);
        return this.fromRGB(tempRas, tempRas.getSampleModel().getSampleSize(), dest, destComponentSize, roi, nodata, destNodata);
    }

    @Override
    public WritableRaster fromRGB(Raster src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, ROI roi, Range nodata, float[] destNodata) {
        IHSColorSpaceJAIExt.checkParameters(src, srcComponentSize, dest, destComponentSize);
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        Rectangle bounds = null;
        if (roi != null) {
            bounds = roi.getBounds();
            Rectangle srcRectExpanded = src.getBounds();
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            roiTile = roi.intersect(new ROIShape(srcRectExpanded));
            if (!bounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = roi.getAsImage();
                        roiIter = RandomIterFactory.create(roiIMG, null, true, true);
                    }
                }
            }
        }
        SampleModel srcSampleModel = src.getSampleModel();
        if (srcComponentSize == null) {
            srcComponentSize = srcSampleModel.getSampleSize();
        }
        if (dest == null) {
            Point origin = new Point(src.getMinX(), src.getMinY());
            dest = RasterFactory.createWritableRaster(srcSampleModel, origin);
        }
        SampleModel dstSampleModel = dest.getSampleModel();
        if (destComponentSize == null) {
            destComponentSize = dstSampleModel.getSampleSize();
        }
        PixelAccessor srcAcc = new PixelAccessor(srcSampleModel, null);
        UnpackedImageData srcUid = srcAcc.getPixels(src, src.getBounds(), srcSampleModel.getDataType(), false);
        switch (srcSampleModel.getDataType()) {
            case 0: {
                this.fromRGBByte(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 1: 
            case 2: {
                this.fromRGBShort(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 3: {
                this.fromRGBInt(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 4: {
                this.fromRGBFloat(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 5: {
                this.fromRGBDouble(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
            }
        }
        return dest;
    }

    private void fromRGBByte(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean isByte;
        byte[] rBuf = src.getByteData(0);
        byte[] gBuf = src.getByteData(1);
        byte[] bBuf = src.getByteData(2);
        int normr = 8 - srcComponentSize[0];
        int normg = 8 - srcComponentSize[1];
        int normb = 8 - srcComponentSize[2];
        double normi = 0.00392156862745098;
        double normh = 1.0;
        double norms = 1.0;
        int bnormi = 0;
        int bnormh = 0;
        int bnorms = 0;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isByte = dstType == 0;
        if (isByte) {
            bnormi = 8 - destComponentSize[0];
            bnormh = 8 - destComponentSize[1];
            bnorms = 8 - destComponentSize[2];
            this.generateACosTable();
            this.generateSqrtTable();
        } else if (dstType < 4) {
            normi = (double)((1L << destComponentSize[0]) - 1L) / 255.0;
            normh = (double)((1L << destComponentSize[1]) - 1L) / (Math.PI * 2);
            norms = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = null;
        int[] dstIntPixels = null;
        if (isByte) {
            dstIntPixels = new int[3 * height * width];
        } else {
            dstPixels = new double[3 * height * width];
        }
        int rStart = src.bandOffsets[0];
        int gStart = src.bandOffsets[1];
        int bStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        if (destNodata == null) {
            destNodata = new float[3];
        }
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = this.getConvertedNodataBfromRGB(isByte, destNodata, normr, normg, normb, bnormi, bnormh, bnorms, normi, normh, norms);
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, dest.getBounds(), destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    double temp;
                    float intensity;
                    short R5 = (short)((rBuf[rIndex] & 0xFF) << normr);
                    short G2 = (short)((gBuf[gIndex] & 0xFF) << normg);
                    short B = (short)((bBuf[bIndex] & 0xFF) << normb);
                    if (isByte) {
                        intensity = (float)(R5 + G2 + B) / 3.0f;
                        dstIntPixels[dIndex++] = (short)(intensity + 0.5f) >> bnormi;
                        short drg = (short)(R5 - G2);
                        short drb = (short)(R5 - B);
                        int tint = drg * drg + drb * (drb - drg);
                        short sum = (short)(drg + drb);
                        temp = tint != 0 ? sqrtTable[(int)(250.0 * (double)sum * (double)sum / (double)tint + 0.5)] : -1.0;
                        byte hue = sum > 0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                        dstIntPixels[dIndex++] = B >= G2 ? 255 - hue >> bnormh : hue >> bnormh;
                        short min2 = G2 > B ? B : G2;
                        min2 = R5 > min2 ? min2 : R5;
                        dstIntPixels[dIndex++] = 255 - (int)((float)(255 * min2) / intensity + 0.5f) >> bnorms;
                    } else {
                        intensity = (float)(R5 + G2 + B) / 3.0f;
                        dstPixels[dIndex++] = normi * (double)intensity;
                        double drg = R5 - G2;
                        double drb = R5 - B;
                        temp = Math.sqrt(drg * drg + drb * (drb - drg));
                        if (temp != 0.0) {
                            temp = Math.acos((drg + drb) / temp / 2.0);
                            if (B >= G2) {
                                temp = Math.PI * 2 - temp;
                            }
                        } else {
                            temp = Math.PI * 2;
                        }
                        dstPixels[dIndex++] = normh * temp;
                        double min3 = G2 > B ? (double)B : (double)G2;
                        min3 = (double)R5 > min3 ? min3 : (double)R5;
                        dstPixels[dIndex++] = norms * (1.0 - min3 / (double)intensity);
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasROI && !hasNodata) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        double temp;
                        float intensity;
                        short R6 = (short)((rBuf[rIndex] & 0xFF) << normr);
                        short G3 = (short)((gBuf[gIndex] & 0xFF) << normg);
                        short B = (short)((bBuf[bIndex] & 0xFF) << normb);
                        if (isByte) {
                            intensity = (float)(R6 + G3 + B) / 3.0f;
                            dstIntPixels[dIndex++] = (short)(intensity + 0.5f) >> bnormi;
                            short drg = (short)(R6 - G3);
                            short drb = (short)(R6 - B);
                            int tint = drg * drg + drb * (drb - drg);
                            short sum = (short)(drg + drb);
                            temp = tint != 0 ? sqrtTable[(int)(250.0 * (double)sum * (double)sum / (double)tint + 0.5)] : -1.0;
                            byte hue = sum > 0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G3 ? 255 - hue >> bnormh : hue >> bnormh;
                            short min4 = G3 > B ? B : G3;
                            min4 = R6 > min4 ? min4 : R6;
                            dstIntPixels[dIndex++] = 255 - (int)((float)(255 * min4) / intensity + 0.5f) >> bnorms;
                        } else {
                            intensity = (float)(R6 + G3 + B) / 3.0f;
                            dstPixels[dIndex++] = normi * (double)intensity;
                            double drg = R6 - G3;
                            double drb = R6 - B;
                            temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G3) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min5 = G3 > B ? (double)B : (double)G3;
                            min5 = (double)R6 > min5 ? min5 : (double)R6;
                            dstPixels[dIndex++] = norms * (1.0 - min5 / (double)intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    byte r = rBuf[rIndex];
                    byte g2 = gBuf[gIndex];
                    byte b2 = bBuf[bIndex];
                    boolean bl2 = notValid = nodata.contains(r) || nodata.contains(g2) || nodata.contains(b2);
                    if (notValid) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        double temp;
                        float intensity;
                        short R7 = (short)((r & 0xFF) << normr);
                        short G4 = (short)((g2 & 0xFF) << normg);
                        short B = (short)((b2 & 0xFF) << normb);
                        if (isByte) {
                            intensity = (float)(R7 + G4 + B) / 3.0f;
                            dstIntPixels[dIndex++] = (short)(intensity + 0.5f) >> bnormi;
                            short drg = (short)(R7 - G4);
                            short drb = (short)(R7 - B);
                            int tint = drg * drg + drb * (drb - drg);
                            short sum = (short)(drg + drb);
                            temp = tint != 0 ? sqrtTable[(int)(250.0 * (double)sum * (double)sum / (double)tint + 0.5)] : -1.0;
                            byte hue = sum > 0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G4 ? 255 - hue >> bnormh : hue >> bnormh;
                            short min6 = G4 > B ? B : G4;
                            min6 = R7 > min6 ? min6 : R7;
                            dstIntPixels[dIndex++] = 255 - (int)((float)(255 * min6) / intensity + 0.5f) >> bnorms;
                        } else {
                            intensity = (float)(R7 + G4 + B) / 3.0f;
                            dstPixels[dIndex++] = normi * (double)intensity;
                            double drg = R7 - G4;
                            double drb = R7 - B;
                            temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G4) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min7 = G4 > B ? (double)B : (double)G4;
                            min7 = (double)R7 > min7 ? min7 : (double)R7;
                            dstPixels[dIndex++] = norms * (1.0 - min7 / (double)intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    byte r = rBuf[rIndex];
                    byte g3 = gBuf[gIndex];
                    byte b3 = bBuf[bIndex];
                    boolean bl3 = notValid = nodata.contains(r) || nodata.contains(g3) || nodata.contains(b3);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        double temp;
                        float intensity;
                        short R8 = (short)((r & 0xFF) << normr);
                        short G5 = (short)((g3 & 0xFF) << normg);
                        short B = (short)((b3 & 0xFF) << normb);
                        if (isByte) {
                            intensity = (float)(R8 + G5 + B) / 3.0f;
                            dstIntPixels[dIndex++] = (short)(intensity + 0.5f) >> bnormi;
                            short drg = (short)(R8 - G5);
                            short drb = (short)(R8 - B);
                            int tint = drg * drg + drb * (drb - drg);
                            short sum = (short)(drg + drb);
                            temp = tint != 0 ? sqrtTable[(int)(250.0 * (double)sum * (double)sum / (double)tint + 0.5)] : -1.0;
                            byte hue = sum > 0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G5 ? 255 - hue >> bnormh : hue >> bnormh;
                            short min8 = G5 > B ? B : G5;
                            min8 = R8 > min8 ? min8 : R8;
                            dstIntPixels[dIndex++] = 255 - (int)((float)(255 * min8) / intensity + 0.5f) >> bnorms;
                        } else {
                            intensity = (float)(R8 + G5 + B) / 3.0f;
                            dstPixels[dIndex++] = normi * (double)intensity;
                            double drg = R8 - G5;
                            double drb = R8 - B;
                            temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G5) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min9 = G5 > B ? (double)B : (double)G5;
                            min9 = (double)R8 > min9 ? min9 : (double)R8;
                            dstPixels[dIndex++] = norms * (1.0 - min9 / (double)intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        }
        if (isByte) {
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstIntPixels);
        } else {
            IHSColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
        }
    }

    private void fromRGBShort(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean isByte;
        short[] rBuf = src.getShortData(0);
        short[] gBuf = src.getShortData(1);
        short[] bBuf = src.getShortData(2);
        int normr = 16 - srcComponentSize[0];
        int normg = 16 - srcComponentSize[1];
        int normb = 16 - srcComponentSize[2];
        double normi = 1.5259021896696422E-5;
        double normh = 1.0;
        double norms = 1.0;
        int bnormi = 0;
        int bnormh = 0;
        int bnorms = 0;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isByte = dstType == 0;
        if (isByte) {
            bnormi = 16 - destComponentSize[0];
            bnormh = 8 - destComponentSize[1];
            bnorms = 8 - destComponentSize[2];
            this.generateACosTable();
            this.generateSqrtTable();
        } else if (dstType < 4) {
            normi = (double)((1L << destComponentSize[0]) - 1L) / 65535.0;
            normh = (double)((1L << destComponentSize[1]) - 1L) / (Math.PI * 2);
            norms = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = null;
        int[] dstIntPixels = null;
        if (isByte) {
            dstIntPixels = new int[3 * height * width];
        } else {
            dstPixels = new double[3 * height * width];
        }
        int rStart = src.bandOffsets[0];
        int gStart = src.bandOffsets[1];
        int bStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = this.getConvertedNodataIfromRGB(isByte, destNodata, normr, normg, normb, bnormi, bnormh, bnorms, normi, normh, norms, false);
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, dest.getBounds(), destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    float intensity;
                    int R5 = (rBuf[rIndex] & 0xFFFF) << normr;
                    int G2 = (gBuf[gIndex] & 0xFFFF) << normg;
                    int B = (bBuf[bIndex] & 0xFFFF) << normb;
                    if (isByte) {
                        intensity = (float)(R5 + G2 + B) / 3.0f;
                        dstIntPixels[dIndex++] = (int)(intensity + 0.5f) >> bnormi;
                        int drg = R5 - G2;
                        int drb = R5 - B;
                        double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                        double sum = drg + drb;
                        double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                        byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                        dstIntPixels[dIndex++] = B >= G2 ? 255 - hue >> bnormh : hue >> bnormh;
                        int min2 = G2 > B ? B : G2;
                        min2 = R5 > min2 ? min2 : R5;
                        dstIntPixels[dIndex++] = 255 - (int)((float)(255 * min2) / intensity + 0.5f) >> bnorms;
                    } else {
                        intensity = (float)(R5 + G2 + B) / 3.0f;
                        dstPixels[dIndex++] = normi * (double)intensity;
                        double drg = R5 - G2;
                        double drb = R5 - B;
                        double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                        if (temp != 0.0) {
                            temp = Math.acos((drg + drb) / temp / 2.0);
                            if (B >= G2) {
                                temp = Math.PI * 2 - temp;
                            }
                        } else {
                            temp = Math.PI * 2;
                        }
                        dstPixels[dIndex++] = normh * temp;
                        double min3 = G2 > B ? (double)B : (double)G2;
                        min3 = (double)R5 > min3 ? min3 : (double)R5;
                        dstPixels[dIndex++] = norms * (1.0 - min3 / (double)intensity);
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasROI && !hasNodata) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        float intensity;
                        int R6 = (rBuf[rIndex] & 0xFFFF) << normr;
                        int G3 = (gBuf[gIndex] & 0xFFFF) << normg;
                        int B = (bBuf[bIndex] & 0xFFFF) << normb;
                        if (isByte) {
                            intensity = (float)(R6 + G3 + B) / 3.0f;
                            dstIntPixels[dIndex++] = (int)(intensity + 0.5f) >> bnormi;
                            int drg = R6 - G3;
                            int drb = R6 - B;
                            double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                            double sum = drg + drb;
                            double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                            byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G3 ? 255 - hue >> bnormh : hue >> bnormh;
                            int min4 = G3 > B ? B : G3;
                            min4 = R6 > min4 ? min4 : R6;
                            dstIntPixels[dIndex++] = 255 - (int)((float)(255 * min4) / intensity + 0.5f) >> bnorms;
                        } else {
                            intensity = (float)(R6 + G3 + B) / 3.0f;
                            dstPixels[dIndex++] = normi * (double)intensity;
                            double drg = R6 - G3;
                            double drb = R6 - B;
                            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G3) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min5 = G3 > B ? (double)B : (double)G3;
                            min5 = (double)R6 > min5 ? min5 : (double)R6;
                            dstPixels[dIndex++] = norms * (1.0 - min5 / (double)intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    short r = rBuf[rIndex];
                    short g2 = gBuf[gIndex];
                    short b2 = bBuf[bIndex];
                    boolean bl2 = notValid = nodata.contains(r) || nodata.contains(g2) || nodata.contains(b2);
                    if (notValid) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        float intensity;
                        int R7 = (r & 0xFFFF) << normr;
                        int G4 = (g2 & 0xFFFF) << normg;
                        int B = (b2 & 0xFFFF) << normb;
                        if (isByte) {
                            intensity = (float)(R7 + G4 + B) / 3.0f;
                            dstIntPixels[dIndex++] = (int)(intensity + 0.5f) >> bnormi;
                            int drg = R7 - G4;
                            int drb = R7 - B;
                            double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                            double sum = drg + drb;
                            double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                            byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G4 ? 255 - hue >> bnormh : hue >> bnormh;
                            int min6 = G4 > B ? B : G4;
                            min6 = R7 > min6 ? min6 : R7;
                            dstIntPixels[dIndex++] = 255 - (int)((float)(255 * min6) / intensity + 0.5f) >> bnorms;
                        } else {
                            intensity = (float)(R7 + G4 + B) / 3.0f;
                            dstPixels[dIndex++] = normi * (double)intensity;
                            double drg = R7 - G4;
                            double drb = R7 - B;
                            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G4) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min7 = G4 > B ? (double)B : (double)G4;
                            min7 = (double)R7 > min7 ? min7 : (double)R7;
                            dstPixels[dIndex++] = norms * (1.0 - min7 / (double)intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    short r = rBuf[rIndex];
                    short g3 = gBuf[gIndex];
                    short b3 = bBuf[bIndex];
                    boolean bl3 = notValid = nodata.contains(r) || nodata.contains(g3) || nodata.contains(b3);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        float intensity;
                        int R8 = (r & 0xFFFF) << normr;
                        int G5 = (g3 & 0xFFFF) << normg;
                        int B = (b3 & 0xFFFF) << normb;
                        if (isByte) {
                            intensity = (float)(R8 + G5 + B) / 3.0f;
                            dstIntPixels[dIndex++] = (int)(intensity + 0.5f) >> bnormi;
                            int drg = R8 - G5;
                            int drb = R8 - B;
                            double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                            double sum = drg + drb;
                            double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                            byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G5 ? 255 - hue >> bnormh : hue >> bnormh;
                            int min8 = G5 > B ? B : G5;
                            min8 = R8 > min8 ? min8 : R8;
                            dstIntPixels[dIndex++] = 255 - (int)((float)(255 * min8) / intensity + 0.5f) >> bnorms;
                        } else {
                            intensity = (float)(R8 + G5 + B) / 3.0f;
                            dstPixels[dIndex++] = normi * (double)intensity;
                            double drg = R8 - G5;
                            double drb = R8 - B;
                            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G5) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min9 = G5 > B ? (double)B : (double)G5;
                            min9 = (double)R8 > min9 ? min9 : (double)R8;
                            dstPixels[dIndex++] = norms * (1.0 - min9 / (double)intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        }
        if (isByte) {
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstIntPixels);
        } else {
            IHSColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
        }
    }

    private void fromRGBInt(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean isByte;
        int[] rBuf = src.getIntData(0);
        int[] gBuf = src.getIntData(1);
        int[] bBuf = src.getIntData(2);
        int normr = 32 - srcComponentSize[0];
        int normg = 32 - srcComponentSize[1];
        int normb = 32 - srcComponentSize[2];
        double range = 4.294967295E9;
        double normi = 1.0 / range;
        double normh = 1.0;
        double norms = 1.0;
        int bnormi = 0;
        int bnormh = 0;
        int bnorms = 0;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isByte = dstType == 0;
        if (isByte) {
            bnormi = 32 - destComponentSize[0];
            bnormh = 8 - destComponentSize[1];
            bnorms = 8 - destComponentSize[2];
            this.generateACosTable();
            this.generateSqrtTable();
        } else if (dstType < 4) {
            normi = (double)((1L << destComponentSize[0]) - 1L) / range;
            normh = (double)((1L << destComponentSize[1]) - 1L) / (Math.PI * 2);
            norms = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = null;
        int[] dstIntPixels = null;
        if (isByte) {
            dstIntPixels = new int[3 * height * width];
        } else {
            dstPixels = new double[3 * height * width];
        }
        int rStart = src.bandOffsets[0];
        int gStart = src.bandOffsets[1];
        int bStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = this.getConvertedNodataIfromRGB(isByte, destNodata, normr, normg, normb, bnormi, bnormh, bnorms, normi, normh, norms, true);
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, dest.getBounds(), destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    float intensity;
                    long R5 = ((long)rBuf[rIndex] & 0xFFFFFFFFL) << normr;
                    long G2 = ((long)gBuf[gIndex] & 0xFFFFFFFFL) << normg;
                    long B = ((long)bBuf[bIndex] & 0xFFFFFFFFL) << normb;
                    if (isByte) {
                        intensity = (float)(R5 + G2 + B) / 3.0f;
                        dstIntPixels[dIndex++] = (int)((long)(intensity + 0.5f) >> bnormi);
                        long drg = R5 - G2;
                        long drb = R5 - B;
                        double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                        double sum = drg + drb;
                        double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                        byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                        dstIntPixels[dIndex++] = B >= G2 ? 255 - hue >> bnormh : hue >> bnormh;
                        long min2 = G2 > B ? B : G2;
                        min2 = R5 > min2 ? min2 : R5;
                        dstIntPixels[dIndex++] = 255 - (int)((float)(255L * min2) / intensity + 0.5f) >> bnorms;
                    } else {
                        intensity = (float)(R5 + G2 + B) / 3.0f;
                        dstPixels[dIndex++] = normi * (double)intensity;
                        double drg = R5 - G2;
                        double drb = R5 - B;
                        double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                        if (temp != 0.0) {
                            temp = Math.acos((drg + drb) / temp / 2.0);
                            if (B >= G2) {
                                temp = Math.PI * 2 - temp;
                            }
                        } else {
                            temp = Math.PI * 2;
                        }
                        dstPixels[dIndex++] = normh * temp;
                        double min3 = G2 > B ? (double)B : (double)G2;
                        min3 = (double)R5 > min3 ? min3 : (double)R5;
                        dstPixels[dIndex++] = norms * (1.0 - min3 / (double)intensity);
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasROI && !hasNodata) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        float intensity;
                        long R6 = ((long)rBuf[rIndex] & 0xFFFFFFFFL) << normr;
                        long G3 = ((long)gBuf[gIndex] & 0xFFFFFFFFL) << normg;
                        long B = ((long)bBuf[bIndex] & 0xFFFFFFFFL) << normb;
                        if (isByte) {
                            intensity = (float)(R6 + G3 + B) / 3.0f;
                            dstIntPixels[dIndex++] = (int)((long)(intensity + 0.5f) >> bnormi);
                            long drg = R6 - G3;
                            long drb = R6 - B;
                            double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                            double sum = drg + drb;
                            double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                            byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G3 ? 255 - hue >> bnormh : hue >> bnormh;
                            long min4 = G3 > B ? B : G3;
                            min4 = R6 > min4 ? min4 : R6;
                            dstIntPixels[dIndex++] = 255 - (int)((float)(255L * min4) / intensity + 0.5f) >> bnorms;
                        } else {
                            intensity = (float)(R6 + G3 + B) / 3.0f;
                            dstPixels[dIndex++] = normi * (double)intensity;
                            double drg = R6 - G3;
                            double drb = R6 - B;
                            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G3) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min5 = G3 > B ? (double)B : (double)G3;
                            min5 = (double)R6 > min5 ? min5 : (double)R6;
                            dstPixels[dIndex++] = norms * (1.0 - min5 / (double)intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    int r = rBuf[rIndex];
                    int g2 = gBuf[gIndex];
                    int b2 = bBuf[bIndex];
                    boolean bl2 = notValid = nodata.contains(r) || nodata.contains(g2) || nodata.contains(b2);
                    if (notValid) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        float intensity;
                        long R7 = ((long)r & 0xFFFFFFFFL) << normr;
                        long G4 = ((long)g2 & 0xFFFFFFFFL) << normg;
                        long B = ((long)b2 & 0xFFFFFFFFL) << normb;
                        if (isByte) {
                            intensity = (float)(R7 + G4 + B) / 3.0f;
                            dstIntPixels[dIndex++] = (int)((long)(intensity + 0.5f) >> bnormi);
                            long drg = R7 - G4;
                            long drb = R7 - B;
                            double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                            double sum = drg + drb;
                            double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                            byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G4 ? 255 - hue >> bnormh : hue >> bnormh;
                            long min6 = G4 > B ? B : G4;
                            min6 = R7 > min6 ? min6 : R7;
                            dstIntPixels[dIndex++] = 255 - (int)((float)(255L * min6) / intensity + 0.5f) >> bnorms;
                        } else {
                            intensity = (float)(R7 + G4 + B) / 3.0f;
                            dstPixels[dIndex++] = normi * (double)intensity;
                            double drg = R7 - G4;
                            double drb = R7 - B;
                            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G4) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min7 = G4 > B ? (double)B : (double)G4;
                            min7 = (double)R7 > min7 ? min7 : (double)R7;
                            dstPixels[dIndex++] = norms * (1.0 - min7 / (double)intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    int r = rBuf[rIndex];
                    int g3 = gBuf[gIndex];
                    int b3 = bBuf[bIndex];
                    boolean bl3 = notValid = nodata.contains(r) || nodata.contains(g3) || nodata.contains(b3);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        float intensity;
                        long R8 = ((long)r & 0xFFFFFFFFL) << normr;
                        long G5 = ((long)g3 & 0xFFFFFFFFL) << normg;
                        long B = ((long)b3 & 0xFFFFFFFFL) << normb;
                        if (isByte) {
                            intensity = (float)(R8 + G5 + B) / 3.0f;
                            dstIntPixels[dIndex++] = (int)((long)(intensity + 0.5f) >> bnormi);
                            long drg = R8 - G5;
                            long drb = R8 - B;
                            double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                            double sum = drg + drb;
                            double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                            byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G5 ? 255 - hue >> bnormh : hue >> bnormh;
                            long min8 = G5 > B ? B : G5;
                            min8 = R8 > min8 ? min8 : R8;
                            dstIntPixels[dIndex++] = 255 - (int)((float)(255L * min8) / intensity + 0.5f) >> bnorms;
                        } else {
                            intensity = (float)(R8 + G5 + B) / 3.0f;
                            dstPixels[dIndex++] = normi * (double)intensity;
                            double drg = R8 - G5;
                            double drb = R8 - B;
                            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G5) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min9 = G5 > B ? (double)B : (double)G5;
                            min9 = (double)R8 > min9 ? min9 : (double)R8;
                            dstPixels[dIndex++] = norms * (1.0 - min9 / (double)intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        }
        if (isByte) {
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstIntPixels);
        } else {
            IHSColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
        }
    }

    private void fromRGBFloat(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean isByte;
        float[] rBuf = src.getFloatData(0);
        float[] gBuf = src.getFloatData(1);
        float[] bBuf = src.getFloatData(2);
        double normi = 1.0;
        double normh = 1.0;
        double norms = 1.0;
        int bnormi = 0;
        int bnormh = 0;
        int bnorms = 0;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isByte = dstType == 0;
        if (isByte) {
            bnormi = (1 << destComponentSize[0]) - 1;
            bnormh = 8 - destComponentSize[1];
            bnorms = 8 - destComponentSize[2];
            this.generateACosTable();
            this.generateSqrtTable();
        } else if (dstType < 4) {
            normi = (1L << destComponentSize[0]) - 1L;
            normh = (double)((1L << destComponentSize[1]) - 1L) / (Math.PI * 2);
            norms = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = null;
        int[] dstIntPixels = null;
        if (isByte) {
            dstIntPixels = new int[3 * height * width];
        } else {
            dstPixels = new double[3 * height * width];
        }
        int rStart = src.bandOffsets[0];
        int gStart = src.bandOffsets[1];
        int bStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = this.getConvertedNodataDfromRGB(isByte, destNodata, bnormi, bnormh, bnorms, normi, normh, norms);
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, dest.getBounds(), destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    float intensity;
                    float R5 = rBuf[rIndex];
                    float G2 = gBuf[gIndex];
                    float B = bBuf[bIndex];
                    if (isByte) {
                        intensity = (R5 + G2 + B) / 3.0f;
                        dstIntPixels[dIndex++] = (int)(intensity * (float)bnormi + 0.5f);
                        float drg = R5 - G2;
                        float drb = R5 - B;
                        double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                        double sum = drg + drb;
                        double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                        byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                        dstIntPixels[dIndex++] = B >= G2 ? 255 - hue >> bnormh : hue >> bnormh;
                        float min2 = G2 > B ? B : G2;
                        min2 = R5 > min2 ? min2 : R5;
                        dstIntPixels[dIndex++] = 255 - (int)(255.0f * min2 / intensity + 0.5f) >> bnorms;
                    } else {
                        intensity = (R5 + G2 + B) / 3.0f;
                        dstPixels[dIndex++] = normi * (double)intensity;
                        double drg = R5 - G2;
                        double drb = R5 - B;
                        double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                        if (temp != 0.0) {
                            temp = Math.acos((drg + drb) / temp / 2.0);
                            if (B >= G2) {
                                temp = Math.PI * 2 - temp;
                            }
                        } else {
                            temp = Math.PI * 2;
                        }
                        dstPixels[dIndex++] = normh * temp;
                        double min3 = G2 > B ? (double)B : (double)G2;
                        min3 = (double)R5 > min3 ? min3 : (double)R5;
                        dstPixels[dIndex++] = norms * (1.0 - min3 / (double)intensity);
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasROI && !hasNodata) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        float intensity;
                        float R6 = rBuf[rIndex];
                        float G3 = gBuf[gIndex];
                        float B = bBuf[bIndex];
                        if (isByte) {
                            intensity = (R6 + G3 + B) / 3.0f;
                            dstIntPixels[dIndex++] = (int)(intensity * (float)bnormi + 0.5f);
                            float drg = R6 - G3;
                            float drb = R6 - B;
                            double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                            double sum = drg + drb;
                            double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                            byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G3 ? 255 - hue >> bnormh : hue >> bnormh;
                            float min4 = G3 > B ? B : G3;
                            min4 = R6 > min4 ? min4 : R6;
                            dstIntPixels[dIndex++] = 255 - (int)(255.0f * min4 / intensity + 0.5f) >> bnorms;
                        } else {
                            intensity = (R6 + G3 + B) / 3.0f;
                            dstPixels[dIndex++] = normi * (double)intensity;
                            double drg = R6 - G3;
                            double drb = R6 - B;
                            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G3) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min5 = G3 > B ? (double)B : (double)G3;
                            min5 = (double)R6 > min5 ? min5 : (double)R6;
                            dstPixels[dIndex++] = norms * (1.0 - min5 / (double)intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    float intensity;
                    boolean notValid;
                    float R7 = rBuf[rIndex];
                    float G4 = gBuf[gIndex];
                    float B = bBuf[bIndex];
                    boolean bl2 = notValid = nodata.contains(R7) || nodata.contains(G4) || nodata.contains(B);
                    if (notValid) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else if (isByte) {
                        intensity = (R7 + G4 + B) / 3.0f;
                        dstIntPixels[dIndex++] = (int)(intensity * (float)bnormi + 0.5f);
                        float drg = R7 - G4;
                        float drb = R7 - B;
                        double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                        double sum = drg + drb;
                        double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                        byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                        dstIntPixels[dIndex++] = B >= G4 ? 255 - hue >> bnormh : hue >> bnormh;
                        float min6 = G4 > B ? B : G4;
                        min6 = R7 > min6 ? min6 : R7;
                        dstIntPixels[dIndex++] = 255 - (int)(255.0f * min6 / intensity + 0.5f) >> bnorms;
                    } else {
                        intensity = (R7 + G4 + B) / 3.0f;
                        dstPixels[dIndex++] = normi * (double)intensity;
                        double drg = R7 - G4;
                        double drb = R7 - B;
                        double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                        if (temp != 0.0) {
                            temp = Math.acos((drg + drb) / temp / 2.0);
                            if (B >= G4) {
                                temp = Math.PI * 2 - temp;
                            }
                        } else {
                            temp = Math.PI * 2;
                        }
                        dstPixels[dIndex++] = normh * temp;
                        double min7 = G4 > B ? (double)B : (double)G4;
                        min7 = (double)R7 > min7 ? min7 : (double)R7;
                        dstPixels[dIndex++] = norms * (1.0 - min7 / (double)intensity);
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    float intensity;
                    boolean notValid;
                    int x0 = i + destX;
                    float R8 = rBuf[rIndex];
                    float G5 = gBuf[gIndex];
                    float B = bBuf[bIndex];
                    boolean bl3 = notValid = nodata.contains(R8) || nodata.contains(G5) || nodata.contains(B);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else if (isByte) {
                        intensity = (R8 + G5 + B) / 3.0f;
                        dstIntPixels[dIndex++] = (int)(intensity * (float)bnormi + 0.5f);
                        float drg = R8 - G5;
                        float drb = R8 - B;
                        double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
                        double sum = drg + drb;
                        double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                        byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                        dstIntPixels[dIndex++] = B >= G5 ? 255 - hue >> bnormh : hue >> bnormh;
                        float min8 = G5 > B ? B : G5;
                        min8 = R8 > min8 ? min8 : R8;
                        dstIntPixels[dIndex++] = 255 - (int)(255.0f * min8 / intensity + 0.5f) >> bnorms;
                    } else {
                        intensity = (R8 + G5 + B) / 3.0f;
                        dstPixels[dIndex++] = normi * (double)intensity;
                        double drg = R8 - G5;
                        double drb = R8 - B;
                        double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                        if (temp != 0.0) {
                            temp = Math.acos((drg + drb) / temp / 2.0);
                            if (B >= G5) {
                                temp = Math.PI * 2 - temp;
                            }
                        } else {
                            temp = Math.PI * 2;
                        }
                        dstPixels[dIndex++] = normh * temp;
                        double min9 = G5 > B ? (double)B : (double)G5;
                        min9 = (double)R8 > min9 ? min9 : (double)R8;
                        dstPixels[dIndex++] = norms * (1.0 - min9 / (double)intensity);
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        }
        if (isByte) {
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstIntPixels);
        } else {
            IHSColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
        }
    }

    private void fromRGBDouble(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean isByte;
        double[] rBuf = src.getDoubleData(0);
        double[] gBuf = src.getDoubleData(1);
        double[] bBuf = src.getDoubleData(2);
        double normi = 1.0;
        double normh = 1.0;
        double norms = 1.0;
        int bnormi = 0;
        int bnormh = 0;
        int bnorms = 0;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isByte = dstType == 0;
        if (isByte) {
            bnormi = (1 << destComponentSize[0]) - 1;
            bnormh = 8 - destComponentSize[1];
            bnorms = 8 - destComponentSize[2];
            this.generateACosTable();
            this.generateSqrtTable();
        } else if (dstType < 4) {
            normi = (1L << destComponentSize[0]) - 1L;
            normh = (double)((1L << destComponentSize[1]) - 1L) / (Math.PI * 2);
            norms = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = null;
        int[] dstIntPixels = null;
        if (isByte) {
            dstIntPixels = new int[3 * height * width];
        } else {
            dstPixels = new double[3 * height * width];
        }
        int rStart = src.bandOffsets[0];
        int gStart = src.bandOffsets[1];
        int bStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = this.getConvertedNodataDfromRGB(isByte, destNodata, bnormi, bnormh, bnorms, normi, normh, norms);
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, dest.getBounds(), destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    double drb;
                    double drg;
                    double intensity;
                    double R5 = rBuf[rIndex];
                    double G2 = gBuf[gIndex];
                    double B = bBuf[bIndex];
                    if (isByte) {
                        intensity = (R5 + G2 + B) / 3.0;
                        dstIntPixels[dIndex++] = (int)(intensity * (double)bnormi + 0.5);
                        drg = R5 - G2;
                        drb = R5 - B;
                        double tint = drg * drg + drb * (drb - drg);
                        double sum = drg + drb;
                        double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                        byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                        dstIntPixels[dIndex++] = B >= G2 ? 255 - hue >> bnormh : hue >> bnormh;
                        double min2 = G2 > B ? B : G2;
                        min2 = R5 > min2 ? min2 : R5;
                        dstIntPixels[dIndex++] = 255 - (int)(255.0 * min2 / intensity + 0.5) >> bnorms;
                    } else {
                        intensity = (R5 + G2 + B) / 3.0;
                        dstPixels[dIndex++] = normi * intensity;
                        drg = R5 - G2;
                        drb = R5 - B;
                        double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                        if (temp != 0.0) {
                            temp = Math.acos((drg + drb) / temp / 2.0);
                            if (B >= G2) {
                                temp = Math.PI * 2 - temp;
                            }
                        } else {
                            temp = Math.PI * 2;
                        }
                        dstPixels[dIndex++] = normh * temp;
                        double min3 = G2 > B ? B : G2;
                        min3 = R5 > min3 ? min3 : R5;
                        dstPixels[dIndex++] = norms * (1.0 - min3 / intensity);
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        double drb;
                        double drg;
                        double intensity;
                        double R6 = rBuf[rIndex];
                        double G3 = gBuf[gIndex];
                        double B = bBuf[bIndex];
                        if (isByte) {
                            intensity = (R6 + G3 + B) / 3.0;
                            dstIntPixels[dIndex++] = (int)(intensity * (double)bnormi + 0.5);
                            drg = R6 - G3;
                            drb = R6 - B;
                            double tint = drg * drg + drb * (drb - drg);
                            double sum = drg + drb;
                            double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                            byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                            dstIntPixels[dIndex++] = B >= G3 ? 255 - hue >> bnormh : hue >> bnormh;
                            double min4 = G3 > B ? B : G3;
                            min4 = R6 > min4 ? min4 : R6;
                            dstIntPixels[dIndex++] = 255 - (int)(255.0 * min4 / intensity + 0.5) >> bnorms;
                        } else {
                            intensity = (R6 + G3 + B) / 3.0;
                            dstPixels[dIndex++] = normi * intensity;
                            drg = R6 - G3;
                            drb = R6 - B;
                            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                            if (temp != 0.0) {
                                temp = Math.acos((drg + drb) / temp / 2.0);
                                if (B >= G3) {
                                    temp = Math.PI * 2 - temp;
                                }
                            } else {
                                temp = Math.PI * 2;
                            }
                            dstPixels[dIndex++] = normh * temp;
                            double min5 = G3 > B ? B : G3;
                            min5 = R6 > min5 ? min5 : R6;
                            dstPixels[dIndex++] = norms * (1.0 - min5 / intensity);
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    double drb;
                    double drg;
                    double intensity;
                    boolean notValid;
                    double R7 = rBuf[rIndex];
                    double G4 = gBuf[gIndex];
                    double B = bBuf[bIndex];
                    boolean bl2 = notValid = nodata.contains(R7) || nodata.contains(G4) || nodata.contains(B);
                    if (notValid) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else if (isByte) {
                        intensity = (R7 + G4 + B) / 3.0;
                        dstIntPixels[dIndex++] = (int)(intensity * (double)bnormi + 0.5);
                        drg = R7 - G4;
                        drb = R7 - B;
                        double tint = drg * drg + drb * (drb - drg);
                        double sum = drg + drb;
                        double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                        byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                        dstIntPixels[dIndex++] = B >= G4 ? 255 - hue >> bnormh : hue >> bnormh;
                        double min6 = G4 > B ? B : G4;
                        min6 = R7 > min6 ? min6 : R7;
                        dstIntPixels[dIndex++] = 255 - (int)(255.0 * min6 / intensity + 0.5) >> bnorms;
                    } else {
                        intensity = (R7 + G4 + B) / 3.0;
                        dstPixels[dIndex++] = normi * intensity;
                        drg = R7 - G4;
                        drb = R7 - B;
                        double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                        if (temp != 0.0) {
                            temp = Math.acos((drg + drb) / temp / 2.0);
                            if (B >= G4) {
                                temp = Math.PI * 2 - temp;
                            }
                        } else {
                            temp = Math.PI * 2;
                        }
                        dstPixels[dIndex++] = normh * temp;
                        double min7 = G4 > B ? B : G4;
                        min7 = R7 > min7 ? min7 : R7;
                        dstPixels[dIndex++] = norms * (1.0 - min7 / intensity);
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    double drb;
                    double drg;
                    double intensity;
                    boolean notValid;
                    int x0 = i + destX;
                    double R8 = rBuf[rIndex];
                    double G5 = gBuf[gIndex];
                    double B = bBuf[bIndex];
                    boolean bl3 = notValid = nodata.contains(R8) || nodata.contains(G5) || nodata.contains(B);
                    if (notValid && (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0)) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else if (isByte) {
                        intensity = (R8 + G5 + B) / 3.0;
                        dstIntPixels[dIndex++] = (int)(intensity * (double)bnormi + 0.5);
                        drg = R8 - G5;
                        drb = R8 - B;
                        double tint = drg * drg + drb * (drb - drg);
                        double sum = drg + drb;
                        double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
                        byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
                        dstIntPixels[dIndex++] = B >= G5 ? 255 - hue >> bnormh : hue >> bnormh;
                        double min8 = G5 > B ? B : G5;
                        min8 = R8 > min8 ? min8 : R8;
                        dstIntPixels[dIndex++] = 255 - (int)(255.0 * min8 / intensity + 0.5) >> bnorms;
                    } else {
                        intensity = (R8 + G5 + B) / 3.0;
                        dstPixels[dIndex++] = normi * intensity;
                        drg = R8 - G5;
                        drb = R8 - B;
                        double temp = Math.sqrt(drg * drg + drb * (drb - drg));
                        if (temp != 0.0) {
                            temp = Math.acos((drg + drb) / temp / 2.0);
                            if (B >= G5) {
                                temp = Math.PI * 2 - temp;
                            }
                        } else {
                            temp = Math.PI * 2;
                        }
                        dstPixels[dIndex++] = normh * temp;
                        double min9 = G5 > B ? B : G5;
                        min9 = R8 > min9 ? min9 : R8;
                        dstPixels[dIndex++] = norms * (1.0 - min9 / intensity);
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        }
        if (isByte) {
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstIntPixels);
        } else {
            IHSColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
        }
    }

    @Override
    public WritableRaster toCIEXYZ(Raster src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, ROI roi, Range nodata, float[] destNodata) {
        WritableRaster tempRas = this.toRGB(src, srcComponentSize, null, null, roi, nodata, destNodata);
        return IHSColorSpaceJAIExt.RGBToCIEXYZ(tempRas, tempRas.getSampleModel().getSampleSize(), dest, destComponentSize, roi, nodata, destNodata);
    }

    @Override
    public WritableRaster toRGB(Raster src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, ROI roi, Range nodata, float[] destNodata) {
        IHSColorSpaceJAIExt.checkParameters(src, srcComponentSize, dest, destComponentSize);
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        Rectangle bounds = null;
        if (roi != null) {
            bounds = roi.getBounds();
            Rectangle srcRectExpanded = src.getBounds();
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            roiTile = roi.intersect(new ROIShape(srcRectExpanded));
            if (!bounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = roi.getAsImage();
                        roiIter = RandomIterFactory.create(roiIMG, null, true, true);
                    }
                }
            }
        }
        SampleModel srcSampleModel = src.getSampleModel();
        if (srcComponentSize == null) {
            srcComponentSize = srcSampleModel.getSampleSize();
        }
        if (dest == null) {
            Point origin = new Point(src.getMinX(), src.getMinY());
            dest = RasterFactory.createWritableRaster(srcSampleModel, origin);
        }
        SampleModel dstSampleModel = dest.getSampleModel();
        if (destComponentSize == null) {
            destComponentSize = dstSampleModel.getSampleSize();
        }
        PixelAccessor srcAcc = new PixelAccessor(srcSampleModel, null);
        UnpackedImageData srcUid = srcAcc.getPixels(src, src.getBounds(), srcSampleModel.getDataType(), false);
        switch (srcSampleModel.getDataType()) {
            case 0: {
                this.toRGBByte(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 1: 
            case 2: {
                this.toRGBShort(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 3: {
                this.toRGBInt(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 4: {
                this.toRGBFloat(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 5: {
                this.toRGBDouble(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
            }
        }
        return dest;
    }

    private void toRGBByte(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean isByte;
        byte[] iBuf = src.getByteData(0);
        byte[] hBuf = src.getByteData(1);
        byte[] sBuf = src.getByteData(2);
        double normi = 1.0 / (double)((1 << srcComponentSize[0]) - 1);
        double normh = 1.0 / (double)((1 << srcComponentSize[1]) - 1) * (Math.PI * 2);
        double norms = 1.0 / (double)((1 << srcComponentSize[2]) - 1);
        double normr = 1.0;
        double normg = 1.0;
        double normb = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isByte = dstType == 0;
        if (isByte) {
            this.generateTanTable();
        }
        if (dstType < 4) {
            normr = (1L << destComponentSize[0]) - 1L;
            normg = (1L << destComponentSize[1]) - 1L;
            normb = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = null;
        int[] dstIntPixels = null;
        if (isByte) {
            dstIntPixels = new int[3 * height * width];
        } else {
            dstPixels = new double[3 * height * width];
        }
        int iStart = src.bandOffsets[0];
        int hStart = src.bandOffsets[1];
        int sStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = this.getConvertedNodataBToRGB(isByte, destNodata, normi, norms, normr, normg, normb, normh);
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, dest.getBounds(), destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    double I = (double)(iBuf[iIndex] & 0xFF) * normi;
                    int h2 = hBuf[hIndex] & 0xFF;
                    double S = (double)(sBuf[sIndex] & 0xFF) * norms;
                    if (isByte) {
                        float b2;
                        float g2 = b2 = (float)I;
                        float r = b2;
                        if (S != 0.0) {
                            float c1;
                            if (h2 >= 85 && h2 <= 170) {
                                r = (float)((1.0 - S) * I);
                                c1 = (float)(3.0 * I - (double)r);
                                float c2 = (float)(SQRT3 * ((double)r - I) * tanTable[h2]);
                                g2 = (c1 + c2) / 2.0f;
                                b2 = (c1 - c2) / 2.0f;
                            } else if (h2 > 170) {
                                g2 = (float)((1.0 - S) * I);
                                c1 = (float)(3.0 * I - (double)g2);
                                float c2 = (float)(SQRT3 * ((double)g2 - I) * tanTable[h2 - 85]);
                                b2 = (c1 + c2) / 2.0f;
                                r = (c1 - c2) / 2.0f;
                            } else if (h2 < 85) {
                                b2 = (float)((1.0 - S) * I);
                                c1 = (float)(3.0 * I - (double)b2);
                                float c2 = (float)(SQRT3 * ((double)b2 - I) * tanTable[h2 + 85]);
                                r = (c1 + c2) / 2.0f;
                                g2 = (c1 - c2) / 2.0f;
                            }
                        }
                        dstIntPixels[dIndex++] = (int)((double)(r < 0.0f ? 0.0f : (r > 1.0f ? 1.0f : r)) * normr + 0.5);
                        dstIntPixels[dIndex++] = (int)((double)(g2 < 0.0f ? 0.0f : (g2 > 1.0f ? 1.0f : g2)) * normg + 0.5);
                        dstIntPixels[dIndex++] = (int)((double)(b2 < 0.0f ? 0.0f : (b2 > 1.0f ? 1.0f : b2)) * normb + 0.5);
                    } else {
                        double B;
                        double G2 = B = I;
                        double R5 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            double H = (double)h2 * normh;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R5 = (1.0 - S) * I;
                                c1 = 3.0 * I - R5;
                                c2 = SQRT3 * (R5 - I) * Math.tan(H);
                                G2 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G2 = (1.0 - S) * I;
                                c1 = 3.0 * I - G2;
                                c2 = SQRT3 * (G2 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R5 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R5 = (c1 + c2) / 2.0;
                                G2 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R5 < 0.0 ? 0.0 : (R5 > 1.0 ? 1.0 : R5)) * normr;
                        dstPixels[dIndex++] = (G2 < 0.0 ? 0.0 : (G2 > 1.0 ? 1.0 : G2)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        double I = (double)(iBuf[iIndex] & 0xFF) * normi;
                        int h3 = hBuf[hIndex] & 0xFF;
                        double S = (double)(sBuf[sIndex] & 0xFF) * norms;
                        if (isByte) {
                            float b3;
                            float g3 = b3 = (float)I;
                            float r = b3;
                            if (S != 0.0) {
                                float c1;
                                if (h3 >= 85 && h3 <= 170) {
                                    r = (float)((1.0 - S) * I);
                                    c1 = (float)(3.0 * I - (double)r);
                                    float c2 = (float)(SQRT3 * ((double)r - I) * tanTable[h3]);
                                    g3 = (c1 + c2) / 2.0f;
                                    b3 = (c1 - c2) / 2.0f;
                                } else if (h3 > 170) {
                                    g3 = (float)((1.0 - S) * I);
                                    c1 = (float)(3.0 * I - (double)g3);
                                    float c2 = (float)(SQRT3 * ((double)g3 - I) * tanTable[h3 - 85]);
                                    b3 = (c1 + c2) / 2.0f;
                                    r = (c1 - c2) / 2.0f;
                                } else if (h3 < 85) {
                                    b3 = (float)((1.0 - S) * I);
                                    c1 = (float)(3.0 * I - (double)b3);
                                    float c2 = (float)(SQRT3 * ((double)b3 - I) * tanTable[h3 + 85]);
                                    r = (c1 + c2) / 2.0f;
                                    g3 = (c1 - c2) / 2.0f;
                                }
                            }
                            dstIntPixels[dIndex++] = (int)((double)(r < 0.0f ? 0.0f : (r > 1.0f ? 1.0f : r)) * normr + 0.5);
                            dstIntPixels[dIndex++] = (int)((double)(g3 < 0.0f ? 0.0f : (g3 > 1.0f ? 1.0f : g3)) * normg + 0.5);
                            dstIntPixels[dIndex++] = (int)((double)(b3 < 0.0f ? 0.0f : (b3 > 1.0f ? 1.0f : b3)) * normb + 0.5);
                        } else {
                            double B;
                            double G3 = B = I;
                            double R6 = B;
                            if (S != 0.0) {
                                double c2;
                                double c1;
                                double H = (double)h3 * normh;
                                if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                    R6 = (1.0 - S) * I;
                                    c1 = 3.0 * I - R6;
                                    c2 = SQRT3 * (R6 - I) * Math.tan(H);
                                    G3 = (c1 + c2) / 2.0;
                                    B = (c1 - c2) / 2.0;
                                } else if (H > 4.1887902047863905) {
                                    G3 = (1.0 - S) * I;
                                    c1 = 3.0 * I - G3;
                                    c2 = SQRT3 * (G3 - I) * Math.tan(H - 2.0943951023931953);
                                    B = (c1 + c2) / 2.0;
                                    R6 = (c1 - c2) / 2.0;
                                } else if (H < 2.0943951023931953) {
                                    B = (1.0 - S) * I;
                                    c1 = 3.0 * I - B;
                                    c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                    R6 = (c1 + c2) / 2.0;
                                    G3 = (c1 - c2) / 2.0;
                                }
                            }
                            dstPixels[dIndex++] = (R6 < 0.0 ? 0.0 : (R6 > 1.0 ? 1.0 : R6)) * normr;
                            dstPixels[dIndex++] = (G3 < 0.0 ? 0.0 : (G3 > 1.0 ? 1.0 : G3)) * normg;
                            dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                        }
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    boolean notValid;
                    byte iB = iBuf[iIndex];
                    byte hB = hBuf[hIndex];
                    byte sB = sBuf[sIndex];
                    boolean bl2 = notValid = nodata.contains(iB) || nodata.contains(hB) || nodata.contains(sB);
                    if (notValid) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        double I = (double)(iB & 0xFF) * normi;
                        int h4 = hB & 0xFF;
                        double S = (double)(sB & 0xFF) * norms;
                        if (isByte) {
                            float b4;
                            float g4 = b4 = (float)I;
                            float r = b4;
                            if (S != 0.0) {
                                float c1;
                                if (h4 >= 85 && h4 <= 170) {
                                    r = (float)((1.0 - S) * I);
                                    c1 = (float)(3.0 * I - (double)r);
                                    float c2 = (float)(SQRT3 * ((double)r - I) * tanTable[h4]);
                                    g4 = (c1 + c2) / 2.0f;
                                    b4 = (c1 - c2) / 2.0f;
                                } else if (h4 > 170) {
                                    g4 = (float)((1.0 - S) * I);
                                    c1 = (float)(3.0 * I - (double)g4);
                                    float c2 = (float)(SQRT3 * ((double)g4 - I) * tanTable[h4 - 85]);
                                    b4 = (c1 + c2) / 2.0f;
                                    r = (c1 - c2) / 2.0f;
                                } else if (h4 < 85) {
                                    b4 = (float)((1.0 - S) * I);
                                    c1 = (float)(3.0 * I - (double)b4);
                                    float c2 = (float)(SQRT3 * ((double)b4 - I) * tanTable[h4 + 85]);
                                    r = (c1 + c2) / 2.0f;
                                    g4 = (c1 - c2) / 2.0f;
                                }
                            }
                            dstIntPixels[dIndex++] = (int)((double)(r < 0.0f ? 0.0f : (r > 1.0f ? 1.0f : r)) * normr + 0.5);
                            dstIntPixels[dIndex++] = (int)((double)(g4 < 0.0f ? 0.0f : (g4 > 1.0f ? 1.0f : g4)) * normg + 0.5);
                            dstIntPixels[dIndex++] = (int)((double)(b4 < 0.0f ? 0.0f : (b4 > 1.0f ? 1.0f : b4)) * normb + 0.5);
                        } else {
                            double B;
                            double G4 = B = I;
                            double R7 = B;
                            if (S != 0.0) {
                                double c2;
                                double c1;
                                double H = (double)h4 * normh;
                                if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                    R7 = (1.0 - S) * I;
                                    c1 = 3.0 * I - R7;
                                    c2 = SQRT3 * (R7 - I) * Math.tan(H);
                                    G4 = (c1 + c2) / 2.0;
                                    B = (c1 - c2) / 2.0;
                                } else if (H > 4.1887902047863905) {
                                    G4 = (1.0 - S) * I;
                                    c1 = 3.0 * I - G4;
                                    c2 = SQRT3 * (G4 - I) * Math.tan(H - 2.0943951023931953);
                                    B = (c1 + c2) / 2.0;
                                    R7 = (c1 - c2) / 2.0;
                                } else if (H < 2.0943951023931953) {
                                    B = (1.0 - S) * I;
                                    c1 = 3.0 * I - B;
                                    c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                    R7 = (c1 + c2) / 2.0;
                                    G4 = (c1 - c2) / 2.0;
                                }
                            }
                            dstPixels[dIndex++] = (R7 < 0.0 ? 0.0 : (R7 > 1.0 ? 1.0 : R7)) * normr;
                            dstPixels[dIndex++] = (G4 < 0.0 ? 0.0 : (G4 > 1.0 ? 1.0 : G4)) * normg;
                            dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                        }
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    byte iB = iBuf[iIndex];
                    byte hB = hBuf[hIndex];
                    byte sB = sBuf[sIndex];
                    boolean bl3 = notValid = nodata.contains(iB) || nodata.contains(hB) || nodata.contains(sB);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        if (isByte) {
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[0];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[1];
                            dstIntPixels[dIndex++] = (int)destNoDataFinal[2];
                        } else {
                            dstPixels[dIndex++] = destNoDataFinal[0];
                            dstPixels[dIndex++] = destNoDataFinal[1];
                            dstPixels[dIndex++] = destNoDataFinal[2];
                        }
                    } else {
                        double I = (double)(iB & 0xFF) * normi;
                        int h5 = hB & 0xFF;
                        double S = (double)(sB & 0xFF) * norms;
                        if (isByte) {
                            float b5;
                            float g5 = b5 = (float)I;
                            float r = b5;
                            if (S != 0.0) {
                                float c1;
                                if (h5 >= 85 && h5 <= 170) {
                                    r = (float)((1.0 - S) * I);
                                    c1 = (float)(3.0 * I - (double)r);
                                    float c2 = (float)(SQRT3 * ((double)r - I) * tanTable[h5]);
                                    g5 = (c1 + c2) / 2.0f;
                                    b5 = (c1 - c2) / 2.0f;
                                } else if (h5 > 170) {
                                    g5 = (float)((1.0 - S) * I);
                                    c1 = (float)(3.0 * I - (double)g5);
                                    float c2 = (float)(SQRT3 * ((double)g5 - I) * tanTable[h5 - 85]);
                                    b5 = (c1 + c2) / 2.0f;
                                    r = (c1 - c2) / 2.0f;
                                } else if (h5 < 85) {
                                    b5 = (float)((1.0 - S) * I);
                                    c1 = (float)(3.0 * I - (double)b5);
                                    float c2 = (float)(SQRT3 * ((double)b5 - I) * tanTable[h5 + 85]);
                                    r = (c1 + c2) / 2.0f;
                                    g5 = (c1 - c2) / 2.0f;
                                }
                            }
                            dstIntPixels[dIndex++] = (int)((double)(r < 0.0f ? 0.0f : (r > 1.0f ? 1.0f : r)) * normr + 0.5);
                            dstIntPixels[dIndex++] = (int)((double)(g5 < 0.0f ? 0.0f : (g5 > 1.0f ? 1.0f : g5)) * normg + 0.5);
                            dstIntPixels[dIndex++] = (int)((double)(b5 < 0.0f ? 0.0f : (b5 > 1.0f ? 1.0f : b5)) * normb + 0.5);
                        } else {
                            double B;
                            double G5 = B = I;
                            double R8 = B;
                            if (S != 0.0) {
                                double c2;
                                double c1;
                                double H = (double)h5 * normh;
                                if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                    R8 = (1.0 - S) * I;
                                    c1 = 3.0 * I - R8;
                                    c2 = SQRT3 * (R8 - I) * Math.tan(H);
                                    G5 = (c1 + c2) / 2.0;
                                    B = (c1 - c2) / 2.0;
                                } else if (H > 4.1887902047863905) {
                                    G5 = (1.0 - S) * I;
                                    c1 = 3.0 * I - G5;
                                    c2 = SQRT3 * (G5 - I) * Math.tan(H - 2.0943951023931953);
                                    B = (c1 + c2) / 2.0;
                                    R8 = (c1 - c2) / 2.0;
                                } else if (H < 2.0943951023931953) {
                                    B = (1.0 - S) * I;
                                    c1 = 3.0 * I - B;
                                    c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                    R8 = (c1 + c2) / 2.0;
                                    G5 = (c1 - c2) / 2.0;
                                }
                            }
                            dstPixels[dIndex++] = (R8 < 0.0 ? 0.0 : (R8 > 1.0 ? 1.0 : R8)) * normr;
                            dstPixels[dIndex++] = (G5 < 0.0 ? 0.0 : (G5 > 1.0 ? 1.0 : G5)) * normg;
                            dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                        }
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        }
        if (isByte) {
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstIntPixels);
        } else {
            IHSColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
            dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
        }
    }

    private void toRGBShort(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        short[] iBuf = src.getShortData(0);
        short[] hBuf = src.getShortData(1);
        short[] sBuf = src.getShortData(2);
        double normi = 1.0 / (double)((1 << srcComponentSize[0]) - 1);
        double normh = 1.0 / (double)((1 << srcComponentSize[1]) - 1) * (Math.PI * 2);
        double norms = 1.0 / (double)((1 << srcComponentSize[2]) - 1);
        double normr = 1.0;
        double normg = 1.0;
        double normb = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        if (dstType < 4) {
            normr = (1L << destComponentSize[0]) - 1L;
            normg = (1L << destComponentSize[1]) - 1L;
            normb = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int iStart = src.bandOffsets[0];
        int hStart = src.bandOffsets[1];
        int sStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = this.getConvertedNodataToRGB(destNodata, 2, normi, normh, norms, normr, normg, normb);
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, dest.getBounds(), destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    double B;
                    double I = (double)(iBuf[iIndex] & 0xFFFF) * normi;
                    double H = (double)(hBuf[hIndex] & 0xFFFF) * normh;
                    double S = (double)(sBuf[sIndex] & 0xFFFF) * norms;
                    double G2 = B = I;
                    double R5 = B;
                    if (S != 0.0) {
                        double c2;
                        double c1;
                        if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                            R5 = (1.0 - S) * I;
                            c1 = 3.0 * I - R5;
                            c2 = SQRT3 * (R5 - I) * Math.tan(H);
                            G2 = (c1 + c2) / 2.0;
                            B = (c1 - c2) / 2.0;
                        } else if (H > 4.1887902047863905) {
                            G2 = (1.0 - S) * I;
                            c1 = 3.0 * I - G2;
                            c2 = SQRT3 * (G2 - I) * Math.tan(H - 2.0943951023931953);
                            B = (c1 + c2) / 2.0;
                            R5 = (c1 - c2) / 2.0;
                        } else if (H < 2.0943951023931953) {
                            B = (1.0 - S) * I;
                            c1 = 3.0 * I - B;
                            c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                            R5 = (c1 + c2) / 2.0;
                            G2 = (c1 - c2) / 2.0;
                        }
                    }
                    dstPixels[dIndex++] = (R5 < 0.0 ? 0.0 : (R5 > 1.0 ? 1.0 : R5)) * normr;
                    dstPixels[dIndex++] = (G2 < 0.0 ? 0.0 : (G2 > 1.0 ? 1.0 : G2)) * normg;
                    dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double I = (double)(iBuf[iIndex] & 0xFFFF) * normi;
                        double H = (double)(hBuf[hIndex] & 0xFFFF) * normh;
                        double S = (double)(sBuf[sIndex] & 0xFFFF) * norms;
                        double G3 = B = I;
                        double R6 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R6 = (1.0 - S) * I;
                                c1 = 3.0 * I - R6;
                                c2 = SQRT3 * (R6 - I) * Math.tan(H);
                                G3 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G3 = (1.0 - S) * I;
                                c1 = 3.0 * I - G3;
                                c2 = SQRT3 * (G3 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R6 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R6 = (c1 + c2) / 2.0;
                                G3 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R6 < 0.0 ? 0.0 : (R6 > 1.0 ? 1.0 : R6)) * normr;
                        dstPixels[dIndex++] = (G3 < 0.0 ? 0.0 : (G3 > 1.0 ? 1.0 : G3)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    boolean notValid;
                    short iB = iBuf[iIndex];
                    short hB = hBuf[hIndex];
                    short sB = sBuf[sIndex];
                    boolean bl = notValid = nodata.contains(iB) || nodata.contains(hB) || nodata.contains(sB);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double I = (double)(iB & 0xFFFF) * normi;
                        double H = (double)(hB & 0xFFFF) * normh;
                        double S = (double)(sB & 0xFFFF) * norms;
                        double G4 = B = I;
                        double R7 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R7 = (1.0 - S) * I;
                                c1 = 3.0 * I - R7;
                                c2 = SQRT3 * (R7 - I) * Math.tan(H);
                                G4 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G4 = (1.0 - S) * I;
                                c1 = 3.0 * I - G4;
                                c2 = SQRT3 * (G4 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R7 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R7 = (c1 + c2) / 2.0;
                                G4 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R7 < 0.0 ? 0.0 : (R7 > 1.0 ? 1.0 : R7)) * normr;
                        dstPixels[dIndex++] = (G4 < 0.0 ? 0.0 : (G4 > 1.0 ? 1.0 : G4)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    short iB = iBuf[iIndex];
                    short hB = hBuf[hIndex];
                    short sB = sBuf[sIndex];
                    boolean bl = notValid = nodata.contains(iB) || nodata.contains(hB) || nodata.contains(sB);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double I = (double)(iB & 0xFFFF) * normi;
                        double H = (double)(hB & 0xFFFF) * normh;
                        double S = (double)(sB & 0xFFFF) * norms;
                        double G5 = B = I;
                        double R8 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R8 = (1.0 - S) * I;
                                c1 = 3.0 * I - R8;
                                c2 = SQRT3 * (R8 - I) * Math.tan(H);
                                G5 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G5 = (1.0 - S) * I;
                                c1 = 3.0 * I - G5;
                                c2 = SQRT3 * (G5 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R8 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R8 = (c1 + c2) / 2.0;
                                G5 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R8 < 0.0 ? 0.0 : (R8 > 1.0 ? 1.0 : R8)) * normr;
                        dstPixels[dIndex++] = (G5 < 0.0 ? 0.0 : (G5 > 1.0 ? 1.0 : G5)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        }
        IHSColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private void toRGBInt(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        int[] iBuf = src.getIntData(0);
        int[] hBuf = src.getIntData(1);
        int[] sBuf = src.getIntData(2);
        double normi = 1.0 / (double)((1L << srcComponentSize[0]) - 1L);
        double normh = 1.0 / (double)((1L << srcComponentSize[1]) - 1L) * (Math.PI * 2);
        double norms = 1.0 / (double)((1L << srcComponentSize[2]) - 1L);
        double normr = 1.0;
        double normg = 1.0;
        double normb = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        if (dstType < 4) {
            normr = (1L << destComponentSize[0]) - 1L;
            normg = (1L << destComponentSize[1]) - 1L;
            normb = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int iStart = src.bandOffsets[0];
        int hStart = src.bandOffsets[1];
        int sStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = this.getConvertedNodataToRGB(destNodata, 3, normi, normh, norms, normr, normg, normb);
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, dest.getBounds(), destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    double B;
                    double I = (double)((long)iBuf[iIndex] & 0xFFFFFFFFL) * normi;
                    double H = (double)((long)hBuf[hIndex] & 0xFFFFFFFFL) * normh;
                    double S = (double)((long)sBuf[sIndex] & 0xFFFFFFFFL) * norms;
                    double G2 = B = I;
                    double R5 = B;
                    if (S != 0.0) {
                        double c2;
                        double c1;
                        if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                            R5 = (1.0 - S) * I;
                            c1 = 3.0 * I - R5;
                            c2 = SQRT3 * (R5 - I) * Math.tan(H);
                            G2 = (c1 + c2) / 2.0;
                            B = (c1 - c2) / 2.0;
                        } else if (H > 4.1887902047863905) {
                            G2 = (1.0 - S) * I;
                            c1 = 3.0 * I - G2;
                            c2 = SQRT3 * (G2 - I) * Math.tan(H - 2.0943951023931953);
                            B = (c1 + c2) / 2.0;
                            R5 = (c1 - c2) / 2.0;
                        } else if (H < 2.0943951023931953) {
                            B = (1.0 - S) * I;
                            c1 = 3.0 * I - B;
                            c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                            R5 = (c1 + c2) / 2.0;
                            G2 = (c1 - c2) / 2.0;
                        }
                    }
                    dstPixels[dIndex++] = (R5 < 0.0 ? 0.0 : (R5 > 1.0 ? 1.0 : R5)) * normr;
                    dstPixels[dIndex++] = (G2 < 0.0 ? 0.0 : (G2 > 1.0 ? 1.0 : G2)) * normg;
                    dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double I = (double)((long)iBuf[iIndex] & 0xFFFFFFFFL) * normi;
                        double H = (double)((long)hBuf[hIndex] & 0xFFFFFFFFL) * normh;
                        double S = (double)((long)sBuf[sIndex] & 0xFFFFFFFFL) * norms;
                        double G3 = B = I;
                        double R6 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R6 = (1.0 - S) * I;
                                c1 = 3.0 * I - R6;
                                c2 = SQRT3 * (R6 - I) * Math.tan(H);
                                G3 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G3 = (1.0 - S) * I;
                                c1 = 3.0 * I - G3;
                                c2 = SQRT3 * (G3 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R6 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R6 = (c1 + c2) / 2.0;
                                G3 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R6 < 0.0 ? 0.0 : (R6 > 1.0 ? 1.0 : R6)) * normr;
                        dstPixels[dIndex++] = (G3 < 0.0 ? 0.0 : (G3 > 1.0 ? 1.0 : G3)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    boolean notValid;
                    int iB = iBuf[iIndex];
                    int hB = hBuf[hIndex];
                    int sB = sBuf[sIndex];
                    boolean bl = notValid = nodata.contains(iB) || nodata.contains(hB) || nodata.contains(sB);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double I = (double)((long)iB & 0xFFFFFFFFL) * normi;
                        double H = (double)((long)hB & 0xFFFFFFFFL) * normh;
                        double S = (double)((long)sB & 0xFFFFFFFFL) * norms;
                        double G4 = B = I;
                        double R7 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R7 = (1.0 - S) * I;
                                c1 = 3.0 * I - R7;
                                c2 = SQRT3 * (R7 - I) * Math.tan(H);
                                G4 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G4 = (1.0 - S) * I;
                                c1 = 3.0 * I - G4;
                                c2 = SQRT3 * (G4 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R7 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R7 = (c1 + c2) / 2.0;
                                G4 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R7 < 0.0 ? 0.0 : (R7 > 1.0 ? 1.0 : R7)) * normr;
                        dstPixels[dIndex++] = (G4 < 0.0 ? 0.0 : (G4 > 1.0 ? 1.0 : G4)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    int iB = iBuf[iIndex];
                    int hB = hBuf[hIndex];
                    int sB = sBuf[sIndex];
                    boolean bl = notValid = nodata.contains(iB) || nodata.contains(hB) || nodata.contains(sB);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double I = (double)((long)iB & 0xFFFFFFFFL) * normi;
                        double H = (double)((long)hB & 0xFFFFFFFFL) * normh;
                        double S = (double)((long)sB & 0xFFFFFFFFL) * norms;
                        double G5 = B = I;
                        double R8 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R8 = (1.0 - S) * I;
                                c1 = 3.0 * I - R8;
                                c2 = SQRT3 * (R8 - I) * Math.tan(H);
                                G5 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G5 = (1.0 - S) * I;
                                c1 = 3.0 * I - G5;
                                c2 = SQRT3 * (G5 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R8 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R8 = (c1 + c2) / 2.0;
                                G5 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R8 < 0.0 ? 0.0 : (R8 > 1.0 ? 1.0 : R8)) * normr;
                        dstPixels[dIndex++] = (G5 < 0.0 ? 0.0 : (G5 > 1.0 ? 1.0 : G5)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        }
        IHSColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private void toRGBFloat(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean hasNodata;
        float[] iBuf = src.getFloatData(0);
        float[] hBuf = src.getFloatData(1);
        float[] sBuf = src.getFloatData(2);
        double normr = 1.0;
        double normg = 1.0;
        double normb = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        if (dstType < 4) {
            normr = (1L << destComponentSize[0]) - 1L;
            normg = (1L << destComponentSize[1]) - 1L;
            normb = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int iStart = src.bandOffsets[0];
        int hStart = src.bandOffsets[1];
        int sStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean bl = hasNodata = nodata != null;
        if (hasNodata) {
            nodata = RangeFactory.convertToDoubleRange(nodata);
        }
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = this.getConvertedNodataToRGB(destNodata, 4, 0.0, 0.0, 0.0, normr, normg, normb);
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, dest.getBounds(), destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    double B;
                    double I = iBuf[iIndex];
                    double H = hBuf[hIndex];
                    double S = sBuf[sIndex];
                    double G2 = B = I;
                    double R5 = B;
                    if (S != 0.0) {
                        double c2;
                        double c1;
                        if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                            R5 = (1.0 - S) * I;
                            c1 = 3.0 * I - R5;
                            c2 = SQRT3 * (R5 - I) * Math.tan(H);
                            G2 = (c1 + c2) / 2.0;
                            B = (c1 - c2) / 2.0;
                        } else if (H > 4.1887902047863905) {
                            G2 = (1.0 - S) * I;
                            c1 = 3.0 * I - G2;
                            c2 = SQRT3 * (G2 - I) * Math.tan(H - 2.0943951023931953);
                            B = (c1 + c2) / 2.0;
                            R5 = (c1 - c2) / 2.0;
                        } else if (H < 2.0943951023931953) {
                            B = (1.0 - S) * I;
                            c1 = 3.0 * I - B;
                            c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                            R5 = (c1 + c2) / 2.0;
                            G2 = (c1 - c2) / 2.0;
                        }
                    }
                    dstPixels[dIndex++] = (R5 < 0.0 ? 0.0 : (R5 > 1.0 ? 1.0 : R5)) * normr;
                    dstPixels[dIndex++] = (G2 < 0.0 ? 0.0 : (G2 > 1.0 ? 1.0 : G2)) * normg;
                    dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double I = iBuf[iIndex];
                        double H = hBuf[hIndex];
                        double S = sBuf[sIndex];
                        double G3 = B = I;
                        double R6 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R6 = (1.0 - S) * I;
                                c1 = 3.0 * I - R6;
                                c2 = SQRT3 * (R6 - I) * Math.tan(H);
                                G3 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G3 = (1.0 - S) * I;
                                c1 = 3.0 * I - G3;
                                c2 = SQRT3 * (G3 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R6 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R6 = (c1 + c2) / 2.0;
                                G3 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R6 < 0.0 ? 0.0 : (R6 > 1.0 ? 1.0 : R6)) * normr;
                        dstPixels[dIndex++] = (G3 < 0.0 ? 0.0 : (G3 > 1.0 ? 1.0 : G3)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    boolean notValid;
                    double I = iBuf[iIndex];
                    double H = hBuf[hIndex];
                    double S = sBuf[sIndex];
                    boolean bl2 = notValid = nodata.contains(I) || nodata.contains(H) || nodata.contains(S);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double G4 = B = I;
                        double R7 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R7 = (1.0 - S) * I;
                                c1 = 3.0 * I - R7;
                                c2 = SQRT3 * (R7 - I) * Math.tan(H);
                                G4 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G4 = (1.0 - S) * I;
                                c1 = 3.0 * I - G4;
                                c2 = SQRT3 * (G4 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R7 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R7 = (c1 + c2) / 2.0;
                                G4 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R7 < 0.0 ? 0.0 : (R7 > 1.0 ? 1.0 : R7)) * normr;
                        dstPixels[dIndex++] = (G4 < 0.0 ? 0.0 : (G4 > 1.0 ? 1.0 : G4)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    double I = iBuf[iIndex];
                    double H = hBuf[hIndex];
                    double S = sBuf[sIndex];
                    boolean bl3 = notValid = nodata.contains(I) || nodata.contains(H) || nodata.contains(S);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double G5 = B = I;
                        double R8 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R8 = (1.0 - S) * I;
                                c1 = 3.0 * I - R8;
                                c2 = SQRT3 * (R8 - I) * Math.tan(H);
                                G5 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G5 = (1.0 - S) * I;
                                c1 = 3.0 * I - G5;
                                c2 = SQRT3 * (G5 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R8 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R8 = (c1 + c2) / 2.0;
                                G5 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R8 < 0.0 ? 0.0 : (R8 > 1.0 ? 1.0 : R8)) * normr;
                        dstPixels[dIndex++] = (G5 < 0.0 ? 0.0 : (G5 > 1.0 ? 1.0 : G5)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        }
        IHSColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private void toRGBDouble(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        double[] iBuf = src.getDoubleData(0);
        double[] hBuf = src.getDoubleData(1);
        double[] sBuf = src.getDoubleData(2);
        double normr = 1.0;
        double normg = 1.0;
        double normb = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        if (dstType < 4) {
            normr = (1L << destComponentSize[0]) - 1L;
            normg = (1L << destComponentSize[1]) - 1L;
            normb = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int iStart = src.bandOffsets[0];
        int hStart = src.bandOffsets[1];
        int sStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = this.getConvertedNodataToRGB(destNodata, 5, 0.0, 0.0, 0.0, normr, normg, normb);
        if (roiDisjointTile) {
            ImageUtil.fillBackground(dest, dest.getBounds(), destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    double B;
                    double I = iBuf[iIndex];
                    double H = hBuf[hIndex];
                    double S = sBuf[sIndex];
                    double G2 = B = I;
                    double R5 = B;
                    if (S != 0.0) {
                        double c2;
                        double c1;
                        if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                            R5 = (1.0 - S) * I;
                            c1 = 3.0 * I - R5;
                            c2 = SQRT3 * (R5 - I) * Math.tan(H);
                            G2 = (c1 + c2) / 2.0;
                            B = (c1 - c2) / 2.0;
                        } else if (H > 4.1887902047863905) {
                            G2 = (1.0 - S) * I;
                            c1 = 3.0 * I - G2;
                            c2 = SQRT3 * (G2 - I) * Math.tan(H - 2.0943951023931953);
                            B = (c1 + c2) / 2.0;
                            R5 = (c1 - c2) / 2.0;
                        } else if (H < 2.0943951023931953) {
                            B = (1.0 - S) * I;
                            c1 = 3.0 * I - B;
                            c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                            R5 = (c1 + c2) / 2.0;
                            G2 = (c1 - c2) / 2.0;
                        }
                    }
                    dstPixels[dIndex++] = (R5 < 0.0 ? 0.0 : (R5 > 1.0 ? 1.0 : R5)) * normr;
                    dstPixels[dIndex++] = (G2 < 0.0 ? 0.0 : (G2 > 1.0 ? 1.0 : G2)) * normg;
                    dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double I = iBuf[iIndex];
                        double H = hBuf[hIndex];
                        double S = sBuf[sIndex];
                        double G3 = B = I;
                        double R6 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R6 = (1.0 - S) * I;
                                c1 = 3.0 * I - R6;
                                c2 = SQRT3 * (R6 - I) * Math.tan(H);
                                G3 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G3 = (1.0 - S) * I;
                                c1 = 3.0 * I - G3;
                                c2 = SQRT3 * (G3 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R6 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R6 = (c1 + c2) / 2.0;
                                G3 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R6 < 0.0 ? 0.0 : (R6 > 1.0 ? 1.0 : R6)) * normr;
                        dstPixels[dIndex++] = (G3 < 0.0 ? 0.0 : (G3 > 1.0 ? 1.0 : G3)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    boolean notValid;
                    double I = iBuf[iIndex];
                    double H = hBuf[hIndex];
                    double S = sBuf[sIndex];
                    boolean bl = notValid = nodata.contains(I) || nodata.contains(H) || nodata.contains(S);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double G4 = B = I;
                        double R7 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R7 = (1.0 - S) * I;
                                c1 = 3.0 * I - R7;
                                c2 = SQRT3 * (R7 - I) * Math.tan(H);
                                G4 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G4 = (1.0 - S) * I;
                                c1 = 3.0 * I - G4;
                                c2 = SQRT3 * (G4 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R7 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R7 = (c1 + c2) / 2.0;
                                G4 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R7 < 0.0 ? 0.0 : (R7 > 1.0 ? 1.0 : R7)) * normr;
                        dstPixels[dIndex++] = (G4 < 0.0 ? 0.0 : (G4 > 1.0 ? 1.0 : G4)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int iIndex = iStart;
                int hIndex = hStart;
                int sIndex = sStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    double I = iBuf[iIndex];
                    double H = hBuf[hIndex];
                    double S = sBuf[sIndex];
                    boolean bl = notValid = nodata.contains(I) || nodata.contains(H) || nodata.contains(S);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double B;
                        double G5 = B = I;
                        double R8 = B;
                        if (S != 0.0) {
                            double c2;
                            double c1;
                            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                                R8 = (1.0 - S) * I;
                                c1 = 3.0 * I - R8;
                                c2 = SQRT3 * (R8 - I) * Math.tan(H);
                                G5 = (c1 + c2) / 2.0;
                                B = (c1 - c2) / 2.0;
                            } else if (H > 4.1887902047863905) {
                                G5 = (1.0 - S) * I;
                                c1 = 3.0 * I - G5;
                                c2 = SQRT3 * (G5 - I) * Math.tan(H - 2.0943951023931953);
                                B = (c1 + c2) / 2.0;
                                R8 = (c1 - c2) / 2.0;
                            } else if (H < 2.0943951023931953) {
                                B = (1.0 - S) * I;
                                c1 = 3.0 * I - B;
                                c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                                R8 = (c1 + c2) / 2.0;
                                G5 = (c1 - c2) / 2.0;
                            }
                        }
                        dstPixels[dIndex++] = (R8 < 0.0 ? 0.0 : (R8 > 1.0 ? 1.0 : R8)) * normr;
                        dstPixels[dIndex++] = (G5 < 0.0 ? 0.0 : (G5 > 1.0 ? 1.0 : G5)) * normg;
                        dstPixels[dIndex++] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
                    }
                    ++i;
                    iIndex += srcPixelStride;
                    hIndex += srcPixelStride;
                    sIndex += srcPixelStride;
                }
                ++j;
                iStart += srcLineStride;
                hStart += srcLineStride;
                sStart += srcLineStride;
            }
        }
        IHSColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private double[] getConvertedNodataBfromRGB(boolean isByte, float[] destNodata, int normr, int normg, int normb, int bnormi, int bnormh, int bnorms, double normi, double normh, double norms) {
        short R5 = (short)(((int)destNodata[0] & 0xFF) << normr);
        short G2 = (short)(((int)destNodata[1] & 0xFF) << normg);
        short B = (short)(((int)destNodata[2] & 0xFF) << normb);
        double[] result = new double[3];
        if (isByte) {
            float intensity = (float)(R5 + G2 + B) / 3.0f;
            result[0] = (short)(intensity + 0.5f) >> bnormi;
            short drg = (short)(R5 - G2);
            short drb = (short)(R5 - B);
            int tint = drg * drg + drb * (drb - drg);
            short sum = (short)(drg + drb);
            double temp = tint != 0 ? sqrtTable[(int)(250.0 * (double)sum * (double)sum / (double)tint + 0.5)] : -1.0;
            byte hue = sum > 0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
            result[1] = B >= G2 ? (double)(255 - hue >> bnormh) : (double)(hue >> bnormh);
            short min2 = G2 > B ? B : G2;
            min2 = R5 > min2 ? min2 : R5;
            result[2] = 255 - (int)((float)(255 * min2) / intensity + 0.5f) >> bnorms;
        } else {
            float intensity = (float)(R5 + G2 + B) / 3.0f;
            result[0] = normi * (double)intensity;
            double drg = R5 - G2;
            double drb = R5 - B;
            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
            if (temp != 0.0) {
                temp = Math.acos((drg + drb) / temp / 2.0);
                if (B >= G2) {
                    temp = Math.PI * 2 - temp;
                }
            } else {
                temp = Math.PI * 2;
            }
            result[1] = normh * temp;
            double min3 = G2 > B ? (double)B : (double)G2;
            min3 = (double)R5 > min3 ? min3 : (double)R5;
            result[2] = norms * (1.0 - min3 / (double)intensity);
        }
        return result;
    }

    private double[] getConvertedNodataIfromRGB(boolean isByte, float[] destNodata, int normr, int normg, int normb, int bnormi, int bnormh, int bnorms, double normi, double normh, double norms, boolean isInteger) {
        long and = isInteger ? 0xFFFFFFFFL : 65535L;
        long R5 = ((long)((int)destNodata[0]) & and) << normr;
        long G2 = ((long)((int)destNodata[1]) & and) << normg;
        long B = ((long)((int)destNodata[2]) & and) << normb;
        double[] result = new double[3];
        if (isByte) {
            float intensity = (float)(R5 + G2 + B) / 3.0f;
            result[0] = (long)(intensity + 0.5f) >> bnormi;
            long drg = R5 - G2;
            long drb = R5 - B;
            double tint = (double)drg * (double)drg + (double)drb * (double)(drb - drg);
            double sum = drg + drb;
            double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
            byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
            result[1] = B >= G2 ? (double)(255 - hue >> bnormh) : (double)(hue >> bnormh);
            long min2 = G2 > B ? B : G2;
            min2 = R5 > min2 ? min2 : R5;
            result[2] = 255 - (int)((float)(255L * min2) / intensity + 0.5f) >> bnorms;
        } else {
            float intensity = (float)(R5 + G2 + B) / 3.0f;
            result[0] = normi * (double)intensity;
            double drg = R5 - G2;
            double drb = R5 - B;
            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
            if (temp != 0.0) {
                temp = Math.acos((drg + drb) / temp / 2.0);
                if (B >= G2) {
                    temp = Math.PI * 2 - temp;
                }
            } else {
                temp = Math.PI * 2;
            }
            result[1] = normh * temp;
            double min3 = G2 > B ? (double)B : (double)G2;
            min3 = (double)R5 > min3 ? min3 : (double)R5;
            result[2] = norms * (1.0 - min3 / (double)intensity);
        }
        return result;
    }

    private double[] getConvertedNodataDfromRGB(boolean isByte, float[] destNodata, int bnormi, int bnormh, int bnorms, double normi, double normh, double norms) {
        double R5 = destNodata[0];
        double G2 = destNodata[1];
        double B = destNodata[2];
        double[] result = new double[3];
        if (isByte) {
            double intensity = (R5 + G2 + B) / 3.0;
            result[0] = (int)(intensity * (double)bnormi + 0.5);
            double drg = R5 - G2;
            double drb = R5 - B;
            double tint = drg * drg + drb * (drb - drg);
            double sum = drg + drb;
            double temp = tint != 0.0 ? sqrtTable[(int)(250.0 * sum * sum / tint + 0.5)] : -1.0;
            byte hue = sum > 0.0 ? acosTable[(int)(500.0 * temp + 0.5) + 500] : acosTable[(int)(-500.0 * temp - 0.5) + 500];
            result[1] = B >= G2 ? (double)(255 - hue >> bnormh) : (double)(hue >> bnormh);
            double min2 = G2 > B ? B : G2;
            min2 = R5 > min2 ? min2 : R5;
            result[2] = 255 - (int)(255.0 * min2 / intensity + 0.5) >> bnorms;
        } else {
            double intensity = (R5 + G2 + B) / 3.0;
            result[0] = normi * intensity;
            double drg = R5 - G2;
            double drb = R5 - B;
            double temp = Math.sqrt(drg * drg + drb * (drb - drg));
            if (temp != 0.0) {
                temp = Math.acos((drg + drb) / temp / 2.0);
                if (B >= G2) {
                    temp = Math.PI * 2 - temp;
                }
            } else {
                temp = Math.PI * 2;
            }
            result[1] = normh * temp;
            double min3 = G2 > B ? B : G2;
            min3 = R5 > min3 ? min3 : R5;
            result[2] = norms * (1.0 - min3 / intensity);
        }
        return result;
    }

    private double[] getConvertedNodataBToRGB(boolean isByte, float[] destNodata, double normi, double norms, double normr, double normg, double normb, double normh) {
        double[] result = new double[3];
        double I = (double)((int)destNodata[0] & 0xFF) * normi;
        int h2 = (int)destNodata[1] & 0xFF;
        double S = (double)((int)destNodata[2] & 0xFF) * norms;
        if (isByte) {
            float b2;
            float g2 = b2 = (float)I;
            float r = b2;
            if (S != 0.0) {
                if (h2 >= 85 && h2 <= 170) {
                    r = (float)((1.0 - S) * I);
                    float c1 = (float)(3.0 * I - (double)r);
                    float c2 = (float)(SQRT3 * ((double)r - I) * tanTable[h2]);
                    g2 = (c1 + c2) / 2.0f;
                    b2 = (c1 - c2) / 2.0f;
                } else if (h2 > 170) {
                    g2 = (float)((1.0 - S) * I);
                    float c1 = (float)(3.0 * I - (double)g2);
                    float c2 = (float)(SQRT3 * ((double)g2 - I) * tanTable[h2 - 85]);
                    b2 = (c1 + c2) / 2.0f;
                    r = (c1 - c2) / 2.0f;
                } else if (h2 < 85) {
                    b2 = (float)((1.0 - S) * I);
                    float c1 = (float)(3.0 * I - (double)b2);
                    float c2 = (float)(SQRT3 * ((double)b2 - I) * tanTable[h2 + 85]);
                    r = (c1 + c2) / 2.0f;
                    g2 = (c1 - c2) / 2.0f;
                }
            }
            result[0] = (int)((double)(r < 0.0f ? 0.0f : (r > 1.0f ? 1.0f : r)) * normr + 0.5);
            result[1] = (int)((double)(g2 < 0.0f ? 0.0f : (g2 > 1.0f ? 1.0f : g2)) * normg + 0.5);
            result[2] = (int)((double)(b2 < 0.0f ? 0.0f : (b2 > 1.0f ? 1.0f : b2)) * normb + 0.5);
        } else {
            double B;
            double G2 = B = I;
            double R5 = B;
            if (S != 0.0) {
                double H = (double)h2 * normh;
                if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                    R5 = (1.0 - S) * I;
                    double c1 = 3.0 * I - R5;
                    double c2 = SQRT3 * (R5 - I) * Math.tan(H);
                    G2 = (c1 + c2) / 2.0;
                    B = (c1 - c2) / 2.0;
                } else if (H > 4.1887902047863905) {
                    G2 = (1.0 - S) * I;
                    double c1 = 3.0 * I - G2;
                    double c2 = SQRT3 * (G2 - I) * Math.tan(H - 2.0943951023931953);
                    B = (c1 + c2) / 2.0;
                    R5 = (c1 - c2) / 2.0;
                } else if (H < 2.0943951023931953) {
                    B = (1.0 - S) * I;
                    double c1 = 3.0 * I - B;
                    double c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                    R5 = (c1 + c2) / 2.0;
                    G2 = (c1 - c2) / 2.0;
                }
            }
            result[0] = (R5 < 0.0 ? 0.0 : (R5 > 1.0 ? 1.0 : R5)) * normr;
            result[1] = (G2 < 0.0 ? 0.0 : (G2 > 1.0 ? 1.0 : G2)) * normg;
            result[2] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
        }
        return result;
    }

    private double[] getConvertedNodataToRGB(float[] destNodata, int dataType, double normi, double normh, double norms, double normr, double normg, double normb) {
        double B;
        double S;
        double H;
        double I;
        double[] result = new double[3];
        switch (dataType) {
            case 1: 
            case 2: {
                I = (double)((int)destNodata[0] & 0xFFFF) * normi;
                H = (double)((int)destNodata[1] & 0xFFFF) * normh;
                S = (double)((int)destNodata[2] & 0xFFFF) * norms;
                break;
            }
            case 3: {
                I = (double)((long)((int)destNodata[0]) & 0xFFFFFFFFL) * normi;
                H = (double)((long)((int)destNodata[1]) & 0xFFFFFFFFL) * normh;
                S = (double)((long)((int)destNodata[2]) & 0xFFFFFFFFL) * norms;
                break;
            }
            case 4: 
            case 5: {
                I = destNodata[0];
                H = destNodata[1];
                S = destNodata[2];
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type defined");
            }
        }
        double G2 = B = I;
        double R5 = B;
        if (S != 0.0) {
            if (H >= 2.0943951023931953 && H <= 4.1887902047863905) {
                R5 = (1.0 - S) * I;
                double c1 = 3.0 * I - R5;
                double c2 = SQRT3 * (R5 - I) * Math.tan(H);
                G2 = (c1 + c2) / 2.0;
                B = (c1 - c2) / 2.0;
            } else if (H > 4.1887902047863905) {
                G2 = (1.0 - S) * I;
                double c1 = 3.0 * I - G2;
                double c2 = SQRT3 * (G2 - I) * Math.tan(H - 2.0943951023931953);
                B = (c1 + c2) / 2.0;
                R5 = (c1 - c2) / 2.0;
            } else if (H < 2.0943951023931953) {
                B = (1.0 - S) * I;
                double c1 = 3.0 * I - B;
                double c2 = SQRT3 * (B - I) * Math.tan(H - 4.1887902047863905);
                R5 = (c1 + c2) / 2.0;
                G2 = (c1 - c2) / 2.0;
            }
        }
        result[0] = (R5 < 0.0 ? 0.0 : (R5 > 1.0 ? 1.0 : R5)) * normr;
        result[1] = (G2 < 0.0 ? 0.0 : (G2 > 1.0 ? 1.0 : G2)) * normg;
        result[2] = (B < 0.0 ? 0.0 : (B > 1.0 ? 1.0 : B)) * normb;
        return result;
    }
}

