/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.lookup;

import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class LookupTable
extends LookupTableJAI
implements Serializable {
    protected byte destinationNoDataByte;
    protected short destinationNoDataShort;
    protected int destinationNoDataInt;
    protected float destinationNoDataFloat;
    protected double destinationNoDataDouble;
    protected Range noData;
    protected Rectangle roiBounds;
    protected boolean useROIAccessor;
    protected PlanarImage srcROIImage;
    protected boolean hasNoData;
    protected boolean hasROI;

    protected LookupTable(byte[] data) {
        super(data);
    }

    protected LookupTable(byte[] data, int offset) {
        super(data, offset);
    }

    public LookupTable(byte[][] data) {
        super(data);
    }

    public LookupTable(byte[][] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(byte[][] data, int[] offsets) {
        super(data, offsets);
    }

    protected LookupTable(short[] data, boolean isUShort) {
        super(data, isUShort);
    }

    protected LookupTable(short[] data, int offset, boolean isUShort) {
        super(data, offset, isUShort);
    }

    protected LookupTable(short[][] data, boolean isUShort) {
        super(data, isUShort);
    }

    protected LookupTable(short[][] data, int offset, boolean isUShort) {
        super(data, offset, isUShort);
    }

    protected LookupTable(short[][] data, int[] offsets, boolean isUShort) {
        super(data, offsets, isUShort);
    }

    protected LookupTable(int[] data) {
        super(data);
    }

    protected LookupTable(int[] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(int[][] data) {
        super(data);
    }

    protected LookupTable(int[][] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(int[][] data, int[] offsets) {
        super(data, offsets);
    }

    protected LookupTable(float[] data) {
        super(data);
    }

    protected LookupTable(float[] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(float[][] data) {
        super(data);
    }

    protected LookupTable(float[][] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(float[][] data, int[] offsets) {
        super(data, offsets);
    }

    protected LookupTable(double[] data) {
        super(data);
    }

    protected LookupTable(double[] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(double[][] data) {
        super(data);
    }

    protected LookupTable(double[][] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(double[][] data, int[] offsets) {
        super(data, offsets);
    }

    public void setDestinationNoData(double destinationNoData) {
        this.destinationNoDataByte = (byte)((byte)destinationNoData & 0xFF);
        this.destinationNoDataShort = (short)((short)destinationNoData & 0xFFFF);
        this.destinationNoDataShort = (short)destinationNoData;
        this.destinationNoDataInt = (int)destinationNoData;
        this.destinationNoDataFloat = (float)destinationNoData;
        this.destinationNoDataDouble = destinationNoData;
    }

    public void setNoDataRange(Range noData) {
        this.noData = noData;
        this.hasNoData = true;
    }

    public void unsetNoData() {
        this.noData = null;
        this.hasNoData = false;
    }

    public void setROIparams(Rectangle roiBounds, PlanarImage srcROIImage, boolean useROIAccessor) {
        this.hasROI = true;
        this.roiBounds = roiBounds;
        this.useROIAccessor = useROIAccessor;
        this.srcROIImage = srcROIImage;
    }

    public void unsetROI() {
        this.hasROI = false;
        this.roiBounds = null;
        this.srcROIImage = null;
        this.useROIAccessor = false;
    }

    protected void lookup(Raster source, WritableRaster dst, Rectangle rect, Raster roi) {
        SampleModel dstSampleModel;
        if (source == null) {
            throw new IllegalArgumentException("Source data must be present");
        }
        SampleModel srcSampleModel = source.getSampleModel();
        if (!this.isIntegralDataType(srcSampleModel)) {
            throw new IllegalArgumentException("Only integral data type are handled");
        }
        rect = rect == null ? source.getBounds() : rect.intersection(source.getBounds());
        if (dst != null) {
            rect = rect.intersection(dst.getBounds());
        }
        if (dst == null) {
            dstSampleModel = this.getDestSampleModel(srcSampleModel, rect.width, rect.height);
            dst = RasterFactory.createWritableRaster(dstSampleModel, new Point(rect.x, rect.y));
        } else {
            dstSampleModel = dst.getSampleModel();
            if (dstSampleModel.getTransferType() != this.getDataType() || dstSampleModel.getNumBands() != this.getDestNumBands(srcSampleModel.getNumBands())) {
                throw new IllegalArgumentException("Destination image must have the same data type and band number of the Table");
            }
        }
        int sTagID = RasterAccessor.findCompatibleTag(null, srcSampleModel);
        int dTagID = RasterAccessor.findCompatibleTag(null, dstSampleModel);
        RasterFormatTag sTag = new RasterFormatTag(srcSampleModel, sTagID);
        RasterFormatTag dTag = new RasterFormatTag(dstSampleModel, dTagID);
        RasterAccessor s2 = new RasterAccessor(source, rect, sTag, null);
        RasterAccessor d2 = new RasterAccessor(dst, rect, dTag, null);
        RasterAccessor roiAccessor = null;
        RandomIter roiIter = null;
        if (this.useROIAccessor) {
            Rectangle srcRect = source.getBounds();
            roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags(new RenderedImage[]{this.srcROIImage}, this.srcROIImage)[0], this.srcROIImage.getColorModel());
        } else if (this.hasROI) {
            roiIter = RandomIterFactory.create(this.srcROIImage, this.srcROIImage.getBounds(), true, true);
        }
        int srcNumBands = s2.getNumBands();
        int srcDataType = s2.getDataType();
        int tblNumBands = this.getNumBands();
        int tblDataType = this.getDataType();
        int dstWidth = d2.getWidth();
        int dstHeight = d2.getHeight();
        int dstNumBands = d2.getNumBands();
        int dstDataType = d2.getDataType();
        int srcLineStride = s2.getScanlineStride();
        int srcPixelStride = s2.getPixelStride();
        int[] srcBandOffsets = s2.getBandOffsets();
        Object bSrcData = s2.getByteDataArrays();
        Object sSrcData = s2.getShortDataArrays();
        Object iSrcData = s2.getIntDataArrays();
        if (srcNumBands < dstNumBands) {
            int offset0 = srcBandOffsets[0];
            srcBandOffsets = new int[dstNumBands];
            for (int i = 0; i < dstNumBands; ++i) {
                srcBandOffsets[i] = offset0;
            }
            switch (srcDataType) {
                case 0: {
                    byte[] bData0 = bSrcData[0];
                    bSrcData = new byte[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        bSrcData[i] = bData0;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[] sData0 = sSrcData[0];
                    sSrcData = new short[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        sSrcData[i] = sData0;
                    }
                    break;
                }
                case 3: {
                    int[] iData0 = iSrcData[0];
                    iSrcData = new int[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        iSrcData[i] = iData0;
                    }
                    break;
                }
            }
        }
        int[] tblOffsets = this.getOffsets();
        Object bTblData = this.getByteData();
        Object sTblData = this.getShortData();
        Object iTblData = this.getIntData();
        Object fTblData = this.getFloatData();
        Object dTblData = this.getDoubleData();
        if (tblNumBands < dstNumBands) {
            int offset0 = tblOffsets[0];
            tblOffsets = new int[dstNumBands];
            for (int i = 0; i < dstNumBands; ++i) {
                tblOffsets[i] = offset0;
            }
            switch (tblDataType) {
                case 0: {
                    byte[] bData0 = bTblData[0];
                    bTblData = new byte[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        bTblData[i] = bData0;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[] sData0 = sTblData[0];
                    sTblData = new short[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        sTblData[i] = sData0;
                    }
                    break;
                }
                case 3: {
                    int[] iData0 = iTblData[0];
                    iTblData = new int[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        iTblData[i] = iData0;
                    }
                    break;
                }
                case 4: {
                    float[] fData0 = fTblData[0];
                    fTblData = new float[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        fTblData[i] = fData0;
                    }
                    break;
                }
                case 5: {
                    double[] dData0 = dTblData[0];
                    dTblData = new double[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        dTblData[i] = dData0;
                    }
                    break;
                }
            }
        }
        int dstLineStride = d2.getScanlineStride();
        int dstPixelStride = d2.getPixelStride();
        int[] dstBandOffsets = d2.getBandOffsets();
        byte[][] bDstData = d2.getByteDataArrays();
        short[][] sDstData = d2.getShortDataArrays();
        int[][] iDstData = d2.getIntDataArrays();
        float[][] fDstData = d2.getFloatDataArrays();
        double[][] dDstData = d2.getDoubleDataArrays();
        block12 : switch (dstDataType) {
            case 0: {
                switch (srcDataType) {
                    case 0: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (byte[][])bSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, bDstData, tblOffsets, (byte[][])bTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 1: {
                        this.lookupU(srcLineStride, srcPixelStride, srcBandOffsets, (short[][])sSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, bDstData, tblOffsets, (byte[][])bTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 2: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (short[][])sSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, bDstData, tblOffsets, (byte[][])bTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 3: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (int[][])iSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, bDstData, tblOffsets, (byte[][])bTblData, roiAccessor, roiIter, rect);
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                switch (srcDataType) {
                    case 0: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (byte[][])bSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, sDstData, tblOffsets, (short[][])sTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 1: {
                        this.lookupU(srcLineStride, srcPixelStride, srcBandOffsets, (short[][])sSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, sDstData, tblOffsets, (short[][])sTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 2: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (short[][])sSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, sDstData, tblOffsets, (short[][])sTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 3: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (int[][])iSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, sDstData, tblOffsets, (short[][])sTblData, roiAccessor, roiIter, rect);
                    }
                }
                break;
            }
            case 3: {
                switch (srcDataType) {
                    case 0: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (byte[][])bSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, iDstData, tblOffsets, (int[][])iTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 1: {
                        this.lookupU(srcLineStride, srcPixelStride, srcBandOffsets, (short[][])sSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, iDstData, tblOffsets, (int[][])iTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 2: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (short[][])sSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, iDstData, tblOffsets, (int[][])iTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 3: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (int[][])iSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, iDstData, tblOffsets, (int[][])iTblData, roiAccessor, roiIter, rect);
                    }
                }
                break;
            }
            case 4: {
                switch (srcDataType) {
                    case 0: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (byte[][])bSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, fDstData, tblOffsets, (float[][])fTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 1: {
                        this.lookupU(srcLineStride, srcPixelStride, srcBandOffsets, (short[][])sSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, fDstData, tblOffsets, (float[][])fTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 2: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (short[][])sSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, fDstData, tblOffsets, (float[][])fTblData, roiAccessor, roiIter, rect);
                        break;
                    }
                    case 3: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (int[][])iSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, fDstData, tblOffsets, (float[][])fTblData, roiAccessor, roiIter, rect);
                    }
                }
                break;
            }
            case 5: {
                switch (srcDataType) {
                    case 0: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (byte[][])bSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, dDstData, tblOffsets, (double[][])dTblData, roiAccessor, roiIter, rect);
                        break block12;
                    }
                    case 1: {
                        this.lookupU(srcLineStride, srcPixelStride, srcBandOffsets, (short[][])sSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, dDstData, tblOffsets, (double[][])dTblData, roiAccessor, roiIter, rect);
                        break block12;
                    }
                    case 2: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (short[][])sSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, dDstData, tblOffsets, (double[][])dTblData, roiAccessor, roiIter, rect);
                        break block12;
                    }
                    case 3: {
                        this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (int[][])iSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, dDstData, tblOffsets, (double[][])dTblData, roiAccessor, roiIter, rect);
                    }
                }
            }
        }
        d2.copyDataToRaster();
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, byte[][] bSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, byte[][] bDstData, int[] tblOffsets, byte[][] bTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                byte[] s2 = bSrcData[b2];
                byte[] d2 = bDstData[b2];
                byte[] t = bTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[(s2[srcPixelOffset] & 0xFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    byte[] s3 = bSrcData[b3];
                    byte[] d3 = bDstData[b3];
                    byte[] t = bTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : t[(s3[srcPixelOffset] & 0xFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    byte[] s4 = bSrcData[b4];
                    byte[] d4 = bDstData[b4];
                    byte[] t = bTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataByte : t[(s4[srcPixelOffset] & 0xFF) - tblOffset]) : this.destinationNoDataByte;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                byte[] s5 = bSrcData[b5];
                byte[] d5 = bDstData[b5];
                byte[] t = bTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        byte value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataByte : t[value & 255 - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                byte[] s6 = bSrcData[b6];
                byte[] d6 = bDstData[b6];
                byte[] t = bTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataByte : t[value & 255 - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                byte[] s7 = bSrcData[b7];
                byte[] d7 = bDstData[b7];
                byte[] t = bTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataByte : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataByte : t[value & 255 - tblOffset])) : this.destinationNoDataByte;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, byte[][] bSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, short[][] sDstData, int[] tblOffsets, short[][] sTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                byte[] s2 = bSrcData[b2];
                short[] d2 = sDstData[b2];
                short[] t = sTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[(s2[srcPixelOffset] & 0xFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    byte[] s3 = bSrcData[b3];
                    short[] d3 = sDstData[b3];
                    short[] t = sTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : t[(s3[srcPixelOffset] & 0xFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    byte[] s4 = bSrcData[b4];
                    short[] d4 = sDstData[b4];
                    short[] t = sTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataShort : t[(s4[srcPixelOffset] & 0xFF) - tblOffset]) : this.destinationNoDataShort;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                byte[] s5 = bSrcData[b5];
                short[] d5 = sDstData[b5];
                short[] t = sTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        byte value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataShort : t[value & 255 - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                byte[] s6 = bSrcData[b6];
                short[] d6 = sDstData[b6];
                short[] t = sTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataShort : t[value & 255 - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                byte[] s7 = bSrcData[b7];
                short[] d7 = sDstData[b7];
                short[] t = sTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataShort : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataShort : t[value & 255 - tblOffset])) : this.destinationNoDataShort;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, byte[][] bSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, int[][] iDstData, int[] tblOffsets, int[][] iTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseNull;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean caseC = !this.hasROI && this.hasNoData;
        boolean bl = caseNull = iTblData == null;
        if (caseA) {
            if (caseNull) {
                for (int b2 = 0; b2 < dstNumBands; ++b2) {
                    byte[] s2 = bSrcData[b2];
                    int[] d2 = iDstData[b2];
                    int srcLineOffset = srcBandOffsets[b2];
                    int dstLineOffset = dstBandOffsets[b2];
                    for (int h2 = 0; h2 < dstHeight; ++h2) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d2[dstPixelOffset] = this.getData().getElem(b2, s2[srcPixelOffset] & 0xFF);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    byte[] s3 = bSrcData[b3];
                    int[] d3 = iDstData[b3];
                    int[] t = iTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int h3 = 0; h3 < dstHeight; ++h3) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d3[dstPixelOffset] = t[(s3[srcPixelOffset] & 0xFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                if (caseNull) {
                    for (int b4 = 0; b4 < dstNumBands; ++b4) {
                        byte[] s4 = bSrcData[b4];
                        int[] d4 = iDstData[b4];
                        int srcLineOffset = srcBandOffsets[b4];
                        int dstLineOffset = dstBandOffsets[b4];
                        for (int y = dst_min_y; y < dst_max_y; ++y) {
                            int srcPixelOffset = srcLineOffset;
                            int dstPixelOffset = dstLineOffset;
                            int posyROI = (y - dst_min_y) * roiLineStride;
                            srcLineOffset += srcLineStride;
                            dstLineOffset += dstLineStride;
                            for (int x = dst_min_x; x < dst_max_x; ++x) {
                                int posx = (x - dst_min_x) * srcPixelStride;
                                int windex = posx / dstNumBands + posyROI;
                                int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                d4[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : this.getData().getElem(b4, s4[srcPixelOffset] & 0xFF);
                                srcPixelOffset += srcPixelStride;
                                dstPixelOffset += dstPixelStride;
                            }
                        }
                    }
                } else {
                    for (int b5 = 0; b5 < dstNumBands; ++b5) {
                        byte[] s5 = bSrcData[b5];
                        int[] d5 = iDstData[b5];
                        int[] t = iTblData[b5];
                        int srcLineOffset = srcBandOffsets[b5];
                        int dstLineOffset = dstBandOffsets[b5];
                        int tblOffset = tblOffsets[b5];
                        for (int y = dst_min_y; y < dst_max_y; ++y) {
                            int srcPixelOffset = srcLineOffset;
                            int dstPixelOffset = dstLineOffset;
                            srcLineOffset += srcLineStride;
                            dstLineOffset += dstLineStride;
                            int posyROI = (y - dst_min_y) * roiLineStride;
                            for (int x = dst_min_x; x < dst_max_x; ++x) {
                                int posx = (x - dst_min_x) * srcPixelStride;
                                int windex = posx / dstNumBands + posyROI;
                                int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                d5[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : t[(s5[srcPixelOffset] & 0xFF) - tblOffset];
                                srcPixelOffset += srcPixelStride;
                                dstPixelOffset += dstPixelStride;
                            }
                        }
                    }
                }
            } else if (caseNull) {
                for (int b6 = 0; b6 < dstNumBands; ++b6) {
                    byte[] s6 = bSrcData[b6];
                    int[] d6 = iDstData[b6];
                    int srcLineOffset = srcBandOffsets[b6];
                    int dstLineOffset = dstBandOffsets[b6];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d6[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : this.getData().getElem(b6, s6[srcPixelOffset] & 0xFF)) : this.destinationNoDataInt;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b7 = 0; b7 < dstNumBands; ++b7) {
                    byte[] s7 = bSrcData[b7];
                    int[] d7 = iDstData[b7];
                    int[] t = iTblData[b7];
                    int srcLineOffset = srcBandOffsets[b7];
                    int dstLineOffset = dstBandOffsets[b7];
                    int tblOffset = tblOffsets[b7];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : t[(s7[srcPixelOffset] & 0xFF) - tblOffset]) : this.destinationNoDataInt;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            if (caseNull) {
                for (int b8 = 0; b8 < dstNumBands; ++b8) {
                    byte[] s8 = bSrcData[b8];
                    int[] d8 = iDstData[b8];
                    int srcLineOffset = srcBandOffsets[b8];
                    int dstLineOffset = dstBandOffsets[b8];
                    for (int y = 0; y < dstHeight; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = 0; x < dstWidth; ++x) {
                            byte value = s8[srcPixelOffset];
                            d8[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : this.getData().getElem(b8, s8[srcPixelOffset] & 0xFF);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b9 = 0; b9 < dstNumBands; ++b9) {
                    byte[] s9 = bSrcData[b9];
                    int[] d9 = iDstData[b9];
                    int[] t = iTblData[b9];
                    int srcLineOffset = srcBandOffsets[b9];
                    int dstLineOffset = dstBandOffsets[b9];
                    int tblOffset = tblOffsets[b9];
                    for (int y = 0; y < dstHeight; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = 0; x < dstWidth; ++x) {
                            byte value = s9[srcPixelOffset];
                            d9[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : t[value & 255 - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            if (caseNull) {
                for (int b10 = 0; b10 < dstNumBands; ++b10) {
                    byte[] s10 = bSrcData[b10];
                    int[] d10 = iDstData[b10];
                    int srcLineOffset = srcBandOffsets[b10];
                    int dstLineOffset = dstBandOffsets[b10];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            byte value;
                            int w;
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d10[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s10[srcPixelOffset]) ? this.destinationNoDataInt : this.getData().getElem(b10, s10[srcPixelOffset] & 0xFF));
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b11 = 0; b11 < dstNumBands; ++b11) {
                    byte[] s11 = bSrcData[b11];
                    int[] d11 = iDstData[b11];
                    int[] t = iTblData[b11];
                    int srcLineOffset = srcBandOffsets[b11];
                    int dstLineOffset = dstBandOffsets[b11];
                    int tblOffset = tblOffsets[b11];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            byte value;
                            int w;
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d11[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s11[srcPixelOffset]) ? this.destinationNoDataInt : t[value & 255 - tblOffset]);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseNull) {
            for (int b12 = 0; b12 < dstNumBands; ++b12) {
                byte[] s12 = bSrcData[b12];
                int[] d12 = iDstData[b12];
                int srcLineOffset = srcBandOffsets[b12];
                int dstLineOffset = dstBandOffsets[b12];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d12[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s12[srcPixelOffset]) ? this.destinationNoDataInt : this.getData().getElem(b12, s12[srcPixelOffset] & 0xFF))) : this.destinationNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b13 = 0; b13 < dstNumBands; ++b13) {
                byte[] s13 = bSrcData[b13];
                int[] d13 = iDstData[b13];
                int[] t = iTblData[b13];
                int srcLineOffset = srcBandOffsets[b13];
                int dstLineOffset = dstBandOffsets[b13];
                int tblOffset = tblOffsets[b13];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d13[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s13[srcPixelOffset]) ? this.destinationNoDataInt : t[value & 255 - tblOffset])) : this.destinationNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, byte[][] bSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, float[][] fDstData, int[] tblOffsets, float[][] fTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                byte[] s2 = bSrcData[b2];
                float[] d2 = fDstData[b2];
                float[] t = fTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[(s2[srcPixelOffset] & 0xFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    byte[] s3 = bSrcData[b3];
                    float[] d3 = fDstData[b3];
                    float[] t = fTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : t[(s3[srcPixelOffset] & 0xFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    byte[] s4 = bSrcData[b4];
                    float[] d4 = fDstData[b4];
                    float[] t = fTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataFloat : t[(s4[srcPixelOffset] & 0xFF) - tblOffset]) : this.destinationNoDataFloat;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                byte[] s5 = bSrcData[b5];
                float[] d5 = fDstData[b5];
                float[] t = fTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        byte value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataFloat : t[value & 255 - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                byte[] s6 = bSrcData[b6];
                float[] d6 = fDstData[b6];
                float[] t = fTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataFloat : t[value & 255 - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                byte[] s7 = bSrcData[b7];
                float[] d7 = fDstData[b7];
                float[] t = fTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataFloat : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataFloat : t[value & 255 - tblOffset])) : this.destinationNoDataFloat;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, byte[][] bSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, double[][] dDstData, int[] tblOffsets, double[][] dTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                byte[] s2 = bSrcData[b2];
                double[] d2 = dDstData[b2];
                double[] t = dTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[(s2[srcPixelOffset] & 0xFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    byte[] s3 = bSrcData[b3];
                    double[] d3 = dDstData[b3];
                    double[] t = dTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : t[(s3[srcPixelOffset] & 0xFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    byte[] s4 = bSrcData[b4];
                    double[] d4 = dDstData[b4];
                    double[] t = dTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataDouble : t[(s4[srcPixelOffset] & 0xFF) - tblOffset]) : this.destinationNoDataDouble;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                byte[] s5 = bSrcData[b5];
                double[] d5 = dDstData[b5];
                double[] t = dTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        byte value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataDouble : t[value & 255 - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                byte[] s6 = bSrcData[b6];
                double[] d6 = dDstData[b6];
                double[] t = dTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataDouble : t[value & 255 - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                byte[] s7 = bSrcData[b7];
                double[] d7 = dDstData[b7];
                double[] t = dTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataDouble : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataDouble : t[value & 255 - tblOffset])) : this.destinationNoDataDouble;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookupU(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, short[][] sSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, byte[][] bDstData, int[] tblOffsets, byte[][] bTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                short[] s2 = sSrcData[b2];
                byte[] d2 = bDstData[b2];
                byte[] t = bTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[(s2[srcPixelOffset] & 0xFFFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    short[] s3 = sSrcData[b3];
                    byte[] d3 = bDstData[b3];
                    byte[] t = bTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : t[(s3[srcPixelOffset] & 0xFFFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    short[] s4 = sSrcData[b4];
                    byte[] d4 = bDstData[b4];
                    byte[] t = bTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataByte : t[(s4[srcPixelOffset] & 0xFFFF) - tblOffset]) : this.destinationNoDataByte;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                short[] s5 = sSrcData[b5];
                byte[] d5 = bDstData[b5];
                byte[] t = bTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        short value = (short)(s5[srcPixelOffset] & 0xFFFF);
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataByte : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                short[] s6 = sSrcData[b6];
                byte[] d6 = bDstData[b6];
                byte[] t = bTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : (this.noData.contains(value = (short)(s6[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataByte : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                short[] s7 = sSrcData[b7];
                byte[] d7 = bDstData[b7];
                byte[] t = bTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataByte : (this.noData.contains(value = (short)(s7[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataByte : t[value - tblOffset])) : this.destinationNoDataByte;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookupU(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, short[][] sSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, short[][] sDstData, int[] tblOffsets, short[][] sTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                short[] s2 = sSrcData[b2];
                short[] d2 = sDstData[b2];
                short[] t = sTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[(s2[srcPixelOffset] & 0xFFFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    short[] s3 = sSrcData[b3];
                    short[] d3 = sDstData[b3];
                    short[] t = sTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : t[(s3[srcPixelOffset] & 0xFFFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    short[] s4 = sSrcData[b4];
                    short[] d4 = sDstData[b4];
                    short[] t = sTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataShort : t[(s4[srcPixelOffset] & 0xFFFF) - tblOffset]) : this.destinationNoDataShort;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                short[] s5 = sSrcData[b5];
                short[] d5 = sDstData[b5];
                short[] t = sTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        short value = (short)(s5[srcPixelOffset] & 0xFFFF);
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataShort : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                short[] s6 = sSrcData[b6];
                short[] d6 = sDstData[b6];
                short[] t = sTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : (this.noData.contains(value = (short)(s6[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataShort : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                short[] s7 = sSrcData[b7];
                short[] d7 = sDstData[b7];
                short[] t = sTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataShort : (this.noData.contains(value = (short)(s7[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataShort : t[value - tblOffset])) : this.destinationNoDataShort;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookupU(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, short[][] sSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, int[][] iDstData, int[] tblOffsets, int[][] iTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseNull;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean caseC = !this.hasROI && this.hasNoData;
        boolean bl = caseNull = iTblData == null;
        if (caseA) {
            if (caseNull) {
                for (int b2 = 0; b2 < dstNumBands; ++b2) {
                    short[] s2 = sSrcData[b2];
                    int[] d2 = iDstData[b2];
                    int srcLineOffset = srcBandOffsets[b2];
                    int dstLineOffset = dstBandOffsets[b2];
                    for (int h2 = 0; h2 < dstHeight; ++h2) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d2[dstPixelOffset] = this.getData().getElem(b2, s2[srcPixelOffset] & 0xFFFF);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    short[] s3 = sSrcData[b3];
                    int[] d3 = iDstData[b3];
                    int[] t = iTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int h3 = 0; h3 < dstHeight; ++h3) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d3[dstPixelOffset] = t[(s3[srcPixelOffset] & 0xFFFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                if (caseNull) {
                    for (int b4 = 0; b4 < dstNumBands; ++b4) {
                        short[] s4 = sSrcData[b4];
                        int[] d4 = iDstData[b4];
                        int srcLineOffset = srcBandOffsets[b4];
                        int dstLineOffset = dstBandOffsets[b4];
                        for (int y = dst_min_y; y < dst_max_y; ++y) {
                            int srcPixelOffset = srcLineOffset;
                            int dstPixelOffset = dstLineOffset;
                            int posyROI = (y - dst_min_y) * roiLineStride;
                            srcLineOffset += srcLineStride;
                            dstLineOffset += dstLineStride;
                            for (int x = dst_min_x; x < dst_max_x; ++x) {
                                int posx = (x - dst_min_x) * srcPixelStride;
                                int windex = posx / dstNumBands + posyROI;
                                int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                d4[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : this.getData().getElem(b4, s4[srcPixelOffset] & 0xFFFF);
                                srcPixelOffset += srcPixelStride;
                                dstPixelOffset += dstPixelStride;
                            }
                        }
                    }
                } else {
                    for (int b5 = 0; b5 < dstNumBands; ++b5) {
                        short[] s5 = sSrcData[b5];
                        int[] d5 = iDstData[b5];
                        int[] t = iTblData[b5];
                        int srcLineOffset = srcBandOffsets[b5];
                        int dstLineOffset = dstBandOffsets[b5];
                        int tblOffset = tblOffsets[b5];
                        for (int y = dst_min_y; y < dst_max_y; ++y) {
                            int srcPixelOffset = srcLineOffset;
                            int dstPixelOffset = dstLineOffset;
                            srcLineOffset += srcLineStride;
                            dstLineOffset += dstLineStride;
                            int posyROI = (y - dst_min_y) * roiLineStride;
                            for (int x = dst_min_x; x < dst_max_x; ++x) {
                                int posx = (x - dst_min_x) * srcPixelStride;
                                int windex = posx / dstNumBands + posyROI;
                                int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                d5[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : t[(s5[srcPixelOffset] & 0xFFFF) - tblOffset];
                                srcPixelOffset += srcPixelStride;
                                dstPixelOffset += dstPixelStride;
                            }
                        }
                    }
                }
            } else if (caseNull) {
                for (int b6 = 0; b6 < dstNumBands; ++b6) {
                    short[] s6 = sSrcData[b6];
                    int[] d6 = iDstData[b6];
                    int srcLineOffset = srcBandOffsets[b6];
                    int dstLineOffset = dstBandOffsets[b6];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d6[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : this.getData().getElem(b6, s6[srcPixelOffset] & 0xFFFF)) : this.destinationNoDataInt;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b7 = 0; b7 < dstNumBands; ++b7) {
                    short[] s7 = sSrcData[b7];
                    int[] d7 = iDstData[b7];
                    int[] t = iTblData[b7];
                    int srcLineOffset = srcBandOffsets[b7];
                    int dstLineOffset = dstBandOffsets[b7];
                    int tblOffset = tblOffsets[b7];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : t[(s7[srcPixelOffset] & 0xFFFF) - tblOffset]) : this.destinationNoDataInt;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            if (caseNull) {
                for (int b8 = 0; b8 < dstNumBands; ++b8) {
                    short[] s8 = sSrcData[b8];
                    int[] d8 = iDstData[b8];
                    int srcLineOffset = srcBandOffsets[b8];
                    int dstLineOffset = dstBandOffsets[b8];
                    for (int y = 0; y < dstHeight; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = 0; x < dstWidth; ++x) {
                            short value = (short)(s8[srcPixelOffset] & 0xFFFF);
                            d8[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : this.getData().getElem(b8, value);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b9 = 0; b9 < dstNumBands; ++b9) {
                    short[] s9 = sSrcData[b9];
                    int[] d9 = iDstData[b9];
                    int[] t = iTblData[b9];
                    int srcLineOffset = srcBandOffsets[b9];
                    int dstLineOffset = dstBandOffsets[b9];
                    int tblOffset = tblOffsets[b9];
                    for (int y = 0; y < dstHeight; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = 0; x < dstWidth; ++x) {
                            short value = (short)(s9[srcPixelOffset] & 0xFFFF);
                            d9[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : t[value - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            if (caseNull) {
                for (int b10 = 0; b10 < dstNumBands; ++b10) {
                    short[] s10 = sSrcData[b10];
                    int[] d10 = iDstData[b10];
                    int srcLineOffset = srcBandOffsets[b10];
                    int dstLineOffset = dstBandOffsets[b10];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            short value;
                            int w;
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d10[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : (this.noData.contains(value = (short)(s10[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataInt : this.getData().getElem(b10, value));
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b11 = 0; b11 < dstNumBands; ++b11) {
                    short[] s11 = sSrcData[b11];
                    int[] d11 = iDstData[b11];
                    int[] t = iTblData[b11];
                    int srcLineOffset = srcBandOffsets[b11];
                    int dstLineOffset = dstBandOffsets[b11];
                    int tblOffset = tblOffsets[b11];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            short value;
                            int w;
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d11[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : (this.noData.contains(value = (short)(s11[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataInt : t[value - tblOffset]);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseNull) {
            for (int b12 = 0; b12 < dstNumBands; ++b12) {
                short[] s12 = sSrcData[b12];
                int[] d12 = iDstData[b12];
                int srcLineOffset = srcBandOffsets[b12];
                int dstLineOffset = dstBandOffsets[b12];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d12[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : (this.noData.contains(value = (short)(s12[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataInt : this.getData().getElem(b12, value))) : this.destinationNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b13 = 0; b13 < dstNumBands; ++b13) {
                short[] s13 = sSrcData[b13];
                int[] d13 = iDstData[b13];
                int[] t = iTblData[b13];
                int srcLineOffset = srcBandOffsets[b13];
                int dstLineOffset = dstBandOffsets[b13];
                int tblOffset = tblOffsets[b13];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d13[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : (this.noData.contains(value = (short)(s13[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataInt : t[value - tblOffset])) : this.destinationNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookupU(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, short[][] sSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, float[][] fDstData, int[] tblOffsets, float[][] fTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                short[] s2 = sSrcData[b2];
                float[] d2 = fDstData[b2];
                float[] t = fTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[(s2[srcPixelOffset] & 0xFFFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    short[] s3 = sSrcData[b3];
                    float[] d3 = fDstData[b3];
                    float[] t = fTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : t[(s3[srcPixelOffset] & 0xFFFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    short[] s4 = sSrcData[b4];
                    float[] d4 = fDstData[b4];
                    float[] t = fTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataFloat : t[(s4[srcPixelOffset] & 0xFFFF) - tblOffset]) : this.destinationNoDataFloat;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                short[] s5 = sSrcData[b5];
                float[] d5 = fDstData[b5];
                float[] t = fTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        short value = (short)(s5[srcPixelOffset] & 0xFFFF);
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataFloat : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                short[] s6 = sSrcData[b6];
                float[] d6 = fDstData[b6];
                float[] t = fTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : (this.noData.contains(value = (short)(s6[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataFloat : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                short[] s7 = sSrcData[b7];
                float[] d7 = fDstData[b7];
                float[] t = fTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataFloat : (this.noData.contains(value = (short)(s7[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataFloat : t[value - tblOffset])) : this.destinationNoDataFloat;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookupU(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, short[][] sSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, double[][] dDstData, int[] tblOffsets, double[][] dTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                short[] s2 = sSrcData[b2];
                double[] d2 = dDstData[b2];
                double[] t = dTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[(s2[srcPixelOffset] & 0xFFFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    short[] s3 = sSrcData[b3];
                    double[] d3 = dDstData[b3];
                    double[] t = dTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : t[(s3[srcPixelOffset] & 0xFFFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    short[] s4 = sSrcData[b4];
                    double[] d4 = dDstData[b4];
                    double[] t = dTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataDouble : t[(s4[srcPixelOffset] & 0xFFFF) - tblOffset]) : this.destinationNoDataDouble;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                short[] s5 = sSrcData[b5];
                double[] d5 = dDstData[b5];
                double[] t = dTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        short value = (short)(s5[srcPixelOffset] & 0xFFFF);
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataDouble : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                short[] s6 = sSrcData[b6];
                double[] d6 = dDstData[b6];
                double[] t = dTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : (this.noData.contains(value = (short)(s6[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataDouble : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                short[] s7 = sSrcData[b7];
                double[] d7 = dDstData[b7];
                double[] t = dTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataDouble : (this.noData.contains(value = (short)(s7[srcPixelOffset] & 0xFFFF)) ? this.destinationNoDataDouble : t[value - tblOffset])) : this.destinationNoDataDouble;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, short[][] sSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, byte[][] bDstData, int[] tblOffsets, byte[][] bTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                short[] s2 = sSrcData[b2];
                byte[] d2 = bDstData[b2];
                byte[] t = bTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[s2[srcPixelOffset] - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    short[] s3 = sSrcData[b3];
                    byte[] d3 = bDstData[b3];
                    byte[] t = bTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : t[s3[srcPixelOffset] - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    short[] s4 = sSrcData[b4];
                    byte[] d4 = bDstData[b4];
                    byte[] t = bTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataByte : t[s4[srcPixelOffset] - tblOffset]) : this.destinationNoDataByte;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                short[] s5 = sSrcData[b5];
                byte[] d5 = bDstData[b5];
                byte[] t = bTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        short value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataByte : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                short[] s6 = sSrcData[b6];
                byte[] d6 = bDstData[b6];
                byte[] t = bTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataByte : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                short[] s7 = sSrcData[b7];
                byte[] d7 = bDstData[b7];
                byte[] t = bTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataByte : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataByte : t[value - tblOffset])) : this.destinationNoDataByte;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, short[][] sSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, short[][] sDstData, int[] tblOffsets, short[][] sTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                short[] s2 = sSrcData[b2];
                short[] d2 = sDstData[b2];
                short[] t = sTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[s2[srcPixelOffset] - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    short[] s3 = sSrcData[b3];
                    short[] d3 = sDstData[b3];
                    short[] t = sTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : t[s3[srcPixelOffset] - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    short[] s4 = sSrcData[b4];
                    short[] d4 = sDstData[b4];
                    short[] t = sTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataShort : t[s4[srcPixelOffset] - tblOffset]) : this.destinationNoDataShort;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                short[] s5 = sSrcData[b5];
                short[] d5 = sDstData[b5];
                short[] t = sTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        short value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataShort : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                short[] s6 = sSrcData[b6];
                short[] d6 = sDstData[b6];
                short[] t = sTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataShort : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                short[] s7 = sSrcData[b7];
                short[] d7 = sDstData[b7];
                short[] t = sTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataShort : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataShort : t[value - tblOffset])) : this.destinationNoDataShort;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, short[][] sSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, int[][] iDstData, int[] tblOffsets, int[][] iTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseNull;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean caseC = !this.hasROI && this.hasNoData;
        boolean bl = caseNull = iTblData == null;
        if (caseA) {
            if (caseNull) {
                for (int b2 = 0; b2 < dstNumBands; ++b2) {
                    short[] s2 = sSrcData[b2];
                    int[] d2 = iDstData[b2];
                    int srcLineOffset = srcBandOffsets[b2];
                    int dstLineOffset = dstBandOffsets[b2];
                    for (int h2 = 0; h2 < dstHeight; ++h2) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d2[dstPixelOffset] = this.getData().getElem(b2, s2[srcPixelOffset]);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    short[] s3 = sSrcData[b3];
                    int[] d3 = iDstData[b3];
                    int[] t = iTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int h3 = 0; h3 < dstHeight; ++h3) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d3[dstPixelOffset] = t[s3[srcPixelOffset] - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                if (caseNull) {
                    for (int b4 = 0; b4 < dstNumBands; ++b4) {
                        short[] s4 = sSrcData[b4];
                        int[] d4 = iDstData[b4];
                        int srcLineOffset = srcBandOffsets[b4];
                        int dstLineOffset = dstBandOffsets[b4];
                        for (int y = dst_min_y; y < dst_max_y; ++y) {
                            int srcPixelOffset = srcLineOffset;
                            int dstPixelOffset = dstLineOffset;
                            int posyROI = (y - dst_min_y) * roiLineStride;
                            srcLineOffset += srcLineStride;
                            dstLineOffset += dstLineStride;
                            for (int x = dst_min_x; x < dst_max_x; ++x) {
                                int posx = (x - dst_min_x) * srcPixelStride;
                                int windex = posx / dstNumBands + posyROI;
                                int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                d4[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : this.getData().getElem(b4, s4[srcPixelOffset]);
                                srcPixelOffset += srcPixelStride;
                                dstPixelOffset += dstPixelStride;
                            }
                        }
                    }
                } else {
                    for (int b5 = 0; b5 < dstNumBands; ++b5) {
                        short[] s5 = sSrcData[b5];
                        int[] d5 = iDstData[b5];
                        int[] t = iTblData[b5];
                        int srcLineOffset = srcBandOffsets[b5];
                        int dstLineOffset = dstBandOffsets[b5];
                        int tblOffset = tblOffsets[b5];
                        for (int y = dst_min_y; y < dst_max_y; ++y) {
                            int srcPixelOffset = srcLineOffset;
                            int dstPixelOffset = dstLineOffset;
                            srcLineOffset += srcLineStride;
                            dstLineOffset += dstLineStride;
                            int posyROI = (y - dst_min_y) * roiLineStride;
                            for (int x = dst_min_x; x < dst_max_x; ++x) {
                                int posx = (x - dst_min_x) * srcPixelStride;
                                int windex = posx / dstNumBands + posyROI;
                                int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                d5[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : t[s5[srcPixelOffset] - tblOffset];
                                srcPixelOffset += srcPixelStride;
                                dstPixelOffset += dstPixelStride;
                            }
                        }
                    }
                }
            } else if (caseNull) {
                for (int b6 = 0; b6 < dstNumBands; ++b6) {
                    short[] s6 = sSrcData[b6];
                    int[] d6 = iDstData[b6];
                    int srcLineOffset = srcBandOffsets[b6];
                    int dstLineOffset = dstBandOffsets[b6];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d6[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : this.getData().getElem(b6, s6[srcPixelOffset])) : this.destinationNoDataInt;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b7 = 0; b7 < dstNumBands; ++b7) {
                    short[] s7 = sSrcData[b7];
                    int[] d7 = iDstData[b7];
                    int[] t = iTblData[b7];
                    int srcLineOffset = srcBandOffsets[b7];
                    int dstLineOffset = dstBandOffsets[b7];
                    int tblOffset = tblOffsets[b7];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : t[s7[srcPixelOffset] - tblOffset]) : this.destinationNoDataInt;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            if (caseNull) {
                for (int b8 = 0; b8 < dstNumBands; ++b8) {
                    short[] s8 = sSrcData[b8];
                    int[] d8 = iDstData[b8];
                    int srcLineOffset = srcBandOffsets[b8];
                    int dstLineOffset = dstBandOffsets[b8];
                    for (int y = 0; y < dstHeight; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = 0; x < dstWidth; ++x) {
                            short value = s8[srcPixelOffset];
                            d8[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : this.getData().getElem(b8, value);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b9 = 0; b9 < dstNumBands; ++b9) {
                    short[] s9 = sSrcData[b9];
                    int[] d9 = iDstData[b9];
                    int[] t = iTblData[b9];
                    int srcLineOffset = srcBandOffsets[b9];
                    int dstLineOffset = dstBandOffsets[b9];
                    int tblOffset = tblOffsets[b9];
                    for (int y = 0; y < dstHeight; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = 0; x < dstWidth; ++x) {
                            short value = s9[srcPixelOffset];
                            d9[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : t[value - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            if (caseNull) {
                for (int b10 = 0; b10 < dstNumBands; ++b10) {
                    short[] s10 = sSrcData[b10];
                    int[] d10 = iDstData[b10];
                    int srcLineOffset = srcBandOffsets[b10];
                    int dstLineOffset = dstBandOffsets[b10];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            short value;
                            int w;
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d10[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s10[srcPixelOffset]) ? this.destinationNoDataInt : this.getData().getElem(b10, value));
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b11 = 0; b11 < dstNumBands; ++b11) {
                    short[] s11 = sSrcData[b11];
                    int[] d11 = iDstData[b11];
                    int[] t = iTblData[b11];
                    int srcLineOffset = srcBandOffsets[b11];
                    int dstLineOffset = dstBandOffsets[b11];
                    int tblOffset = tblOffsets[b11];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            short value;
                            int w;
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d11[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s11[srcPixelOffset]) ? this.destinationNoDataInt : t[value - tblOffset]);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseNull) {
            for (int b12 = 0; b12 < dstNumBands; ++b12) {
                short[] s12 = sSrcData[b12];
                int[] d12 = iDstData[b12];
                int srcLineOffset = srcBandOffsets[b12];
                int dstLineOffset = dstBandOffsets[b12];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d12[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s12[srcPixelOffset]) ? this.destinationNoDataInt : this.getData().getElem(b12, value))) : this.destinationNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b13 = 0; b13 < dstNumBands; ++b13) {
                short[] s13 = sSrcData[b13];
                int[] d13 = iDstData[b13];
                int[] t = iTblData[b13];
                int srcLineOffset = srcBandOffsets[b13];
                int dstLineOffset = dstBandOffsets[b13];
                int tblOffset = tblOffsets[b13];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d13[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s13[srcPixelOffset]) ? this.destinationNoDataInt : t[value - tblOffset])) : this.destinationNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, short[][] sSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, float[][] fDstData, int[] tblOffsets, float[][] fTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                short[] s2 = sSrcData[b2];
                float[] d2 = fDstData[b2];
                float[] t = fTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[s2[srcPixelOffset] - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    short[] s3 = sSrcData[b3];
                    float[] d3 = fDstData[b3];
                    float[] t = fTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : t[s3[srcPixelOffset] - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    short[] s4 = sSrcData[b4];
                    float[] d4 = fDstData[b4];
                    float[] t = fTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataFloat : t[s4[srcPixelOffset] - tblOffset]) : this.destinationNoDataFloat;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                short[] s5 = sSrcData[b5];
                float[] d5 = fDstData[b5];
                float[] t = fTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        short value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataFloat : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                short[] s6 = sSrcData[b6];
                float[] d6 = fDstData[b6];
                float[] t = fTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataFloat : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                short[] s7 = sSrcData[b7];
                float[] d7 = fDstData[b7];
                float[] t = fTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataFloat : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataFloat : t[value - tblOffset])) : this.destinationNoDataFloat;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, short[][] sSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, double[][] dDstData, int[] tblOffsets, double[][] dTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                short[] s2 = sSrcData[b2];
                double[] d2 = dDstData[b2];
                double[] t = dTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[s2[srcPixelOffset] - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    short[] s3 = sSrcData[b3];
                    double[] d3 = dDstData[b3];
                    double[] t = dTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : t[s3[srcPixelOffset] - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    short[] s4 = sSrcData[b4];
                    double[] d4 = dDstData[b4];
                    double[] t = dTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataDouble : t[s4[srcPixelOffset] - tblOffset]) : this.destinationNoDataDouble;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                short[] s5 = sSrcData[b5];
                double[] d5 = dDstData[b5];
                double[] t = dTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        short value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataDouble : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                short[] s6 = sSrcData[b6];
                double[] d6 = dDstData[b6];
                double[] t = dTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataDouble : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                short[] s7 = sSrcData[b7];
                double[] d7 = dDstData[b7];
                double[] t = dTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        short value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataDouble : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataDouble : t[value - tblOffset])) : this.destinationNoDataDouble;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, int[][] iSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, byte[][] bDstData, int[] tblOffsets, byte[][] bTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                int[] s2 = iSrcData[b2];
                byte[] d2 = bDstData[b2];
                byte[] t = bTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[s2[srcPixelOffset] - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    int[] s3 = iSrcData[b3];
                    byte[] d3 = bDstData[b3];
                    byte[] t = bTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : t[s3[srcPixelOffset] - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    int[] s4 = iSrcData[b4];
                    byte[] d4 = bDstData[b4];
                    byte[] t = bTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataByte : t[s4[srcPixelOffset] - tblOffset]) : this.destinationNoDataByte;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                int[] s5 = iSrcData[b5];
                byte[] d5 = bDstData[b5];
                byte[] t = bTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataByte : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                int[] s6 = iSrcData[b6];
                byte[] d6 = bDstData[b6];
                byte[] t = bTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        int value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataByte : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                int[] s7 = iSrcData[b7];
                byte[] d7 = bDstData[b7];
                byte[] t = bTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        int value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataByte : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataByte : t[value - tblOffset])) : this.destinationNoDataByte;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, int[][] iSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, short[][] sDstData, int[] tblOffsets, short[][] sTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                int[] s2 = iSrcData[b2];
                short[] d2 = sDstData[b2];
                short[] t = sTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[s2[srcPixelOffset] - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    int[] s3 = iSrcData[b3];
                    short[] d3 = sDstData[b3];
                    short[] t = sTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : t[s3[srcPixelOffset] - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    int[] s4 = iSrcData[b4];
                    short[] d4 = sDstData[b4];
                    short[] t = sTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataShort : t[s4[srcPixelOffset] - tblOffset]) : this.destinationNoDataShort;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                int[] s5 = iSrcData[b5];
                short[] d5 = sDstData[b5];
                short[] t = sTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataShort : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                int[] s6 = iSrcData[b6];
                short[] d6 = sDstData[b6];
                short[] t = sTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        int value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataShort : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                int[] s7 = iSrcData[b7];
                short[] d7 = sDstData[b7];
                short[] t = sTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        int value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataShort : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataShort : t[value - tblOffset])) : this.destinationNoDataShort;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, int[][] iSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, int[][] iDstData, int[] tblOffsets, int[][] iTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseNull;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean caseC = !this.hasROI && this.hasNoData;
        boolean bl = caseNull = iTblData == null;
        if (caseA) {
            if (caseNull) {
                for (int b2 = 0; b2 < dstNumBands; ++b2) {
                    int[] s2 = iSrcData[b2];
                    int[] d2 = iDstData[b2];
                    int srcLineOffset = srcBandOffsets[b2];
                    int dstLineOffset = dstBandOffsets[b2];
                    for (int h2 = 0; h2 < dstHeight; ++h2) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d2[dstPixelOffset] = this.getData().getElem(b2, s2[srcPixelOffset]);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    int[] s3 = iSrcData[b3];
                    int[] d3 = iDstData[b3];
                    int[] t = iTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int h3 = 0; h3 < dstHeight; ++h3) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d3[dstPixelOffset] = t[s3[srcPixelOffset] - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                if (caseNull) {
                    for (int b4 = 0; b4 < dstNumBands; ++b4) {
                        int[] s4 = iSrcData[b4];
                        int[] d4 = iDstData[b4];
                        int srcLineOffset = srcBandOffsets[b4];
                        int dstLineOffset = dstBandOffsets[b4];
                        for (int y = dst_min_y; y < dst_max_y; ++y) {
                            int srcPixelOffset = srcLineOffset;
                            int dstPixelOffset = dstLineOffset;
                            int posyROI = (y - dst_min_y) * roiLineStride;
                            srcLineOffset += srcLineStride;
                            dstLineOffset += dstLineStride;
                            for (int x = dst_min_x; x < dst_max_x; ++x) {
                                int posx = (x - dst_min_x) * srcPixelStride;
                                int windex = posx / dstNumBands + posyROI;
                                int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                d4[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : this.getData().getElem(b4, s4[srcPixelOffset]);
                                srcPixelOffset += srcPixelStride;
                                dstPixelOffset += dstPixelStride;
                            }
                        }
                    }
                } else {
                    for (int b5 = 0; b5 < dstNumBands; ++b5) {
                        int[] s5 = iSrcData[b5];
                        int[] d5 = iDstData[b5];
                        int[] t = iTblData[b5];
                        int srcLineOffset = srcBandOffsets[b5];
                        int dstLineOffset = dstBandOffsets[b5];
                        int tblOffset = tblOffsets[b5];
                        for (int y = dst_min_y; y < dst_max_y; ++y) {
                            int srcPixelOffset = srcLineOffset;
                            int dstPixelOffset = dstLineOffset;
                            srcLineOffset += srcLineStride;
                            dstLineOffset += dstLineStride;
                            int posyROI = (y - dst_min_y) * roiLineStride;
                            for (int x = dst_min_x; x < dst_max_x; ++x) {
                                int posx = (x - dst_min_x) * srcPixelStride;
                                int windex = posx / dstNumBands + posyROI;
                                int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                d5[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : t[s5[srcPixelOffset] - tblOffset];
                                srcPixelOffset += srcPixelStride;
                                dstPixelOffset += dstPixelStride;
                            }
                        }
                    }
                }
            } else if (caseNull) {
                for (int b6 = 0; b6 < dstNumBands; ++b6) {
                    int[] s6 = iSrcData[b6];
                    int[] d6 = iDstData[b6];
                    int srcLineOffset = srcBandOffsets[b6];
                    int dstLineOffset = dstBandOffsets[b6];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d6[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : this.getData().getElem(b6, s6[srcPixelOffset])) : this.destinationNoDataInt;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b7 = 0; b7 < dstNumBands; ++b7) {
                    int[] s7 = iSrcData[b7];
                    int[] d7 = iDstData[b7];
                    int[] t = iTblData[b7];
                    int srcLineOffset = srcBandOffsets[b7];
                    int dstLineOffset = dstBandOffsets[b7];
                    int tblOffset = tblOffsets[b7];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : t[s7[srcPixelOffset] - tblOffset]) : this.destinationNoDataInt;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            if (caseNull) {
                for (int b8 = 0; b8 < dstNumBands; ++b8) {
                    int[] s8 = iSrcData[b8];
                    int[] d8 = iDstData[b8];
                    int srcLineOffset = srcBandOffsets[b8];
                    int dstLineOffset = dstBandOffsets[b8];
                    for (int y = 0; y < dstHeight; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = 0; x < dstWidth; ++x) {
                            int value = s8[srcPixelOffset];
                            d8[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : this.getData().getElem(b8, value);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b9 = 0; b9 < dstNumBands; ++b9) {
                    int[] s9 = iSrcData[b9];
                    int[] d9 = iDstData[b9];
                    int[] t = iTblData[b9];
                    int srcLineOffset = srcBandOffsets[b9];
                    int dstLineOffset = dstBandOffsets[b9];
                    int tblOffset = tblOffsets[b9];
                    for (int y = 0; y < dstHeight; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = 0; x < dstWidth; ++x) {
                            int value = s9[srcPixelOffset];
                            d9[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : t[value - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            if (caseNull) {
                for (int b10 = 0; b10 < dstNumBands; ++b10) {
                    int[] s10 = iSrcData[b10];
                    int[] d10 = iDstData[b10];
                    int srcLineOffset = srcBandOffsets[b10];
                    int dstLineOffset = dstBandOffsets[b10];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int value;
                            int w;
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d10[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s10[srcPixelOffset]) ? this.destinationNoDataInt : this.getData().getElem(b10, value));
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b11 = 0; b11 < dstNumBands; ++b11) {
                    int[] s11 = iSrcData[b11];
                    int[] d11 = iDstData[b11];
                    int[] t = iTblData[b11];
                    int srcLineOffset = srcBandOffsets[b11];
                    int dstLineOffset = dstBandOffsets[b11];
                    int tblOffset = tblOffsets[b11];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int value;
                            int w;
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d11[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s11[srcPixelOffset]) ? this.destinationNoDataInt : t[value - tblOffset]);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseNull) {
            for (int b12 = 0; b12 < dstNumBands; ++b12) {
                int[] s12 = iSrcData[b12];
                int[] d12 = iDstData[b12];
                int srcLineOffset = srcBandOffsets[b12];
                int dstLineOffset = dstBandOffsets[b12];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        int value;
                        int w;
                        d12[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s12[srcPixelOffset]) ? this.destinationNoDataInt : this.getData().getElem(b12, value))) : this.destinationNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b13 = 0; b13 < dstNumBands; ++b13) {
                int[] s13 = iSrcData[b13];
                int[] d13 = iDstData[b13];
                int[] t = iTblData[b13];
                int srcLineOffset = srcBandOffsets[b13];
                int dstLineOffset = dstBandOffsets[b13];
                int tblOffset = tblOffsets[b13];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        int value;
                        int w;
                        d13[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s13[srcPixelOffset]) ? this.destinationNoDataInt : t[value - tblOffset])) : this.destinationNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, int[][] iSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, float[][] fDstData, int[] tblOffsets, float[][] fTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                int[] s2 = iSrcData[b2];
                float[] d2 = fDstData[b2];
                float[] t = fTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[s2[srcPixelOffset] - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    int[] s3 = iSrcData[b3];
                    float[] d3 = fDstData[b3];
                    float[] t = fTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : t[s3[srcPixelOffset] - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    int[] s4 = iSrcData[b4];
                    float[] d4 = fDstData[b4];
                    float[] t = fTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataFloat : t[s4[srcPixelOffset] - tblOffset]) : this.destinationNoDataFloat;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                int[] s5 = iSrcData[b5];
                float[] d5 = fDstData[b5];
                float[] t = fTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataFloat : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                int[] s6 = iSrcData[b6];
                float[] d6 = fDstData[b6];
                float[] t = fTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        int value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataFloat : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                int[] s7 = iSrcData[b7];
                float[] d7 = fDstData[b7];
                float[] t = fTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        int value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataFloat : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataFloat : t[value - tblOffset])) : this.destinationNoDataFloat;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, int[][] iSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, double[][] dDstData, int[] tblOffsets, double[][] dTblData, RasterAccessor roi, RandomIter roiIter, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b2 = 0; b2 < dstNumBands; ++b2) {
                int[] s2 = iSrcData[b2];
                double[] d2 = dDstData[b2];
                double[] t = dTblData[b2];
                int srcLineOffset = srcBandOffsets[b2];
                int dstLineOffset = dstBandOffsets[b2];
                int tblOffset = tblOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = t[s2[srcPixelOffset] - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b3 = 0; b3 < dstNumBands; ++b3) {
                    int[] s3 = iSrcData[b3];
                    double[] d3 = dDstData[b3];
                    double[] t = dTblData[b3];
                    int srcLineOffset = srcBandOffsets[b3];
                    int dstLineOffset = dstBandOffsets[b3];
                    int tblOffset = tblOffsets[b3];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d3[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : t[s3[srcPixelOffset] - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b4 = 0; b4 < dstNumBands; ++b4) {
                    int[] s4 = iSrcData[b4];
                    double[] d4 = dDstData[b4];
                    double[] t = dTblData[b4];
                    int srcLineOffset = srcBandOffsets[b4];
                    int dstLineOffset = dstBandOffsets[b4];
                    int tblOffset = tblOffsets[b4];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d4[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataDouble : t[s4[srcPixelOffset] - tblOffset]) : this.destinationNoDataDouble;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b5 = 0; b5 < dstNumBands; ++b5) {
                int[] s5 = iSrcData[b5];
                double[] d5 = dDstData[b5];
                double[] t = dTblData[b5];
                int srcLineOffset = srcBandOffsets[b5];
                int dstLineOffset = dstBandOffsets[b5];
                int tblOffset = tblOffsets[b5];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        int value = s5[srcPixelOffset];
                        d5[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataDouble : t[value - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b6 = 0; b6 < dstNumBands; ++b6) {
                int[] s6 = iSrcData[b6];
                double[] d6 = dDstData[b6];
                double[] t = dTblData[b6];
                int srcLineOffset = srcBandOffsets[b6];
                int dstLineOffset = dstBandOffsets[b6];
                int tblOffset = tblOffsets[b6];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        int value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d6[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : (this.noData.contains(value = s6[srcPixelOffset]) ? this.destinationNoDataDouble : t[value - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b7 = 0; b7 < dstNumBands; ++b7) {
                int[] s7 = iSrcData[b7];
                double[] d7 = dDstData[b7];
                double[] t = dTblData[b7];
                int srcLineOffset = srcBandOffsets[b7];
                int dstLineOffset = dstBandOffsets[b7];
                int tblOffset = tblOffsets[b7];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        int value;
                        int w;
                        d7[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataDouble : (this.noData.contains(value = s7[srcPixelOffset]) ? this.destinationNoDataDouble : t[value - tblOffset])) : this.destinationNoDataDouble;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }
}

