/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.piecewise;

import it.geosolutions.jaiext.piecewise.DefaultDomainElement1D;
import it.geosolutions.jaiext.piecewise.DefaultPassthroughPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.Domain1D;
import it.geosolutions.jaiext.piecewise.DomainElement1D;
import it.geosolutions.jaiext.piecewise.PiecewiseUtilities;
import it.geosolutions.jaiext.range.Range;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;

public class DefaultDomain1D<E extends DefaultDomainElement1D>
extends AbstractList<E>
implements Domain1D<E> {
    private E[] elements;
    private boolean hasGaps;
    private E main;
    private double[] minimums;
    private String name;
    private Range range;
    private int hashCode = -1;

    @Override
    public synchronized String getName() {
        if (this.name == null) {
            StringBuffer buffer = new StringBuffer(30);
            Locale locale = Locale.getDefault();
            if (this.main != null) {
                buffer.append(((DefaultDomainElement1D)this.main).getName());
            } else {
                buffer.append('(');
                buffer.append("Untitled");
                buffer.append(')');
            }
            this.name = buffer.toString();
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Range getApproximateDomainRange() {
        E[] EArray = this.elements;
        synchronized (this.elements) {
            if (this.range == null) {
                Range range = null;
                for (E element : this.elements) {
                    Range extent = ((DefaultDomainElement1D)element).getRange();
                    if (Double.isNaN(extent.getMin().doubleValue()) || Double.isNaN(extent.getMax().doubleValue())) continue;
                    range = range != null ? range.union(extent) : extent;
                }
                this.range = range;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.range;
        }
    }

    public DefaultDomain1D(E[] inDomainElements) {
        this.init((DefaultDomainElement1D[])inDomainElements);
    }

    private void init(E[] inDomainElements) throws IllegalArgumentException, MissingResourceException {
        PiecewiseUtilities.ensureNonNull("DomainElement1D[]", inDomainElements);
        this.elements = inDomainElements == null ? new DefaultDomainElement1D[]{new DefaultPassthroughPiecewiseTransform1DElement("p0")} : (DefaultDomainElement1D[])inDomainElements.clone();
        Arrays.sort(this.elements);
        this.hasGaps = false;
        this.minimums = new double[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            E c2 = this.elements[i];
            double inMinimum = this.minimums[i] = ((DefaultDomainElement1D)c2).getInputMinimum();
            if (i == 0) continue;
            assert (!(inMinimum < this.minimums[i - 1])) : inMinimum;
            E previous = this.elements[i - 1];
            if (PiecewiseUtilities.compare(inMinimum, ((DefaultDomainElement1D)previous).getInputMaximum()) <= 0) {
                PiecewiseUtilities.domainElementsOverlap(this.elements, i);
            }
            if (Double.isNaN(inMinimum) || inMinimum == ((DefaultDomainElement1D)previous).getRange().getMax(false).doubleValue()) continue;
            this.hasGaps = true;
        }
        double range = 0.0;
        Object main = null;
        int i = this.elements.length;
        while (--i >= 0) {
            E candidate = this.elements[i];
            if (Double.isInfinite(((DefaultDomainElement1D)candidate).getInputMinimum()) && Double.isInfinite(((DefaultDomainElement1D)candidate).getInputMaximum())) {
                range = Double.POSITIVE_INFINITY;
                main = candidate;
                continue;
            }
            double candidateRange = ((DefaultDomainElement1D)candidate).getInputMaximum() - ((DefaultDomainElement1D)candidate).getInputMinimum();
            if (!(candidateRange >= range)) continue;
            range = candidateRange;
            main = candidate;
        }
        this.main = main;
        assert (PiecewiseUtilities.isSorted(this.elements));
    }

    @Override
    public E findDomainElement(double value) {
        E domainElement1D;
        int i = this.getDomainElementIndex(value);
        if (i < 0) {
            return null;
        }
        if (i > this.elements.length) {
            return null;
        }
        if (i < this.elements.length) {
            domainElement1D = this.elements[i];
            if (((DefaultDomainElement1D)domainElement1D).contains(value)) {
                return domainElement1D;
            }
            if (i == 0) {
                return null;
            }
        }
        if (((DefaultDomainElement1D)(domainElement1D = this.elements[i - 1])).contains(value)) {
            return domainElement1D;
        }
        assert (i >= this.elements.length || this.hasGaps) : value;
        return null;
    }

    private int getDomainElementIndex(double sample) {
        int i = -1;
        i = PiecewiseUtilities.binarySearch(this.minimums, sample);
        if (i >= 0) {
            assert (Double.doubleToRawLongBits(sample) == Double.doubleToRawLongBits(this.minimums[i]));
            return i;
        }
        assert (i == Arrays.binarySearch(this.minimums, sample)) : i;
        i = -i - 1;
        return i;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public E get(int i) {
        return this.elements[i];
    }

    @Override
    public Object[] toArray() {
        return (DomainElement1D[])this.elements.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultDomain1D)) {
            return false;
        }
        DefaultDomain1D that = (DefaultDomain1D)object;
        if (this.getEquivalenceClass() != that.getEquivalenceClass()) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (!this.getApproximateDomainRange().equals(that.getApproximateDomainRange())) {
            return false;
        }
        if (Arrays.equals(this.elements, that.elements)) {
            assert (Arrays.equals(this.minimums, that.minimums));
            return true;
        }
        return false;
    }

    protected Class<?> getEquivalenceClass() {
        return DefaultDomain1D.class;
    }

    @Override
    public boolean hasGaps() {
        return this.hasGaps;
    }

    public E getMain() {
        return this.main;
    }

    public double[] getMinimums() {
        return (double[])this.minimums.clone();
    }

    @Override
    public int hashCode() {
        if (this.hashCode < 0) {
            int result = PiecewiseUtilities.deepHashCode(this.elements);
            result = PiecewiseUtilities.deepHashCode(this.minimums);
            result = PiecewiseUtilities.hash(this.getName(), result);
            this.hashCode = PiecewiseUtilities.hash(this.getApproximateDomainRange(), this.hashCode);
        }
        return this.hashCode;
    }
}

