/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.shadedrelief;

import it.geosolutions.jaiext.range.Range;

public enum ShadedReliefAlgorithm {
    ZEVENBERGEN_THORNE{

        @Override
        public double getX(double[] window) {
            return ShadedReliefAlgorithm.getZevenbergenThorneX(window);
        }

        @Override
        public double getY(double[] window) {
            return ShadedReliefAlgorithm.getZevenbergenThorneY(window);
        }

        @Override
        public double getFactor() {
            return ShadedReliefAlgorithm.getZevenbergenThorneFactor();
        }
    }
    ,
    ZEVENBERGEN_THORNE_COMBINED{

        @Override
        public double getX(double[] window) {
            return ShadedReliefAlgorithm.getZevenbergenThorneX(window);
        }

        @Override
        public double getY(double[] window) {
            return ShadedReliefAlgorithm.getZevenbergenThorneY(window);
        }

        @Override
        public double getFactor() {
            return ShadedReliefAlgorithm.getZevenbergenThorneFactor();
        }

        @Override
        public double refineValue(double value, double slope) {
            return ShadedReliefAlgorithm.combineValue(value, slope);
        }
    }
    ,
    DEFAULT,
    COMBINED{

        @Override
        public double refineValue(double value, double slope) {
            return ShadedReliefAlgorithm.combineValue(value, slope);
        }
    };

    private static final double DEGREES_TO_RADIANS = Math.PI / 180;
    static final double SQUARED_PI_2 = 2.4674011002723395;
    private static double DELTA;

    public double getFactor() {
        return 8.0;
    }

    private static double getZevenbergenThorneFactor() {
        return 2.0;
    }

    private static double getZevenbergenThorneX(double[] window) {
        return window[3] - window[5];
    }

    private static double getZevenbergenThorneY(double[] window) {
        return window[7] - window[1];
    }

    public double getX(double[] window) {
        return window[3] - window[5] + (window[0] + window[3] + window[6] - (window[2] + window[5] + window[8]));
    }

    public double getY(double[] window) {
        return window[7] - window[1] + (window[6] + window[7] + window[8] - (window[0] + window[1] + window[2]));
    }

    private static double combineValue(double value, double slope) {
        value = Math.acos(value);
        value = 1.0 - value * Math.atan(Math.sqrt(slope)) / 2.4674011002723395;
        return value;
    }

    public double refineValue(double value, double slope) {
        return value;
    }

    public float getValue(double[] window, ShadedReliefParameters params) {
        double xNum = this.getX(window);
        double yNum = this.getY(window);
        double x = xNum / params.resX;
        double y = yNum / params.resY;
        double xx_yy = x * x + y * y;
        double slope = xx_yy * params.square_z;
        double shade = (params.sinAlt - (y * params.cos_az_mul_cos_alt_mul_z - x * params.sin_az_mul_cos_alt_mul_z)) / Math.sqrt(1.0 + params.square_z * xx_yy);
        shade = params.algorithm.refineValue(shade, slope);
        shade = shade <= 0.0 ? 1.0 : 1.0 + 254.0 * shade;
        return (float)shade;
    }

    static boolean areEquals(double a2, double b2) {
        return Math.abs(a2 - b2) < DELTA;
    }

    static {
        DELTA = 1.0E-10;
    }

    public static class ShadedReliefParameters {
        final double resY;
        final double resX;
        final double sinAlt;
        final double z_scaled;
        final double square_z;
        final double cos_az_mul_cos_alt_mul_z;
        final double sin_az_mul_cos_alt_mul_z;
        private final ShadedReliefAlgorithm algorithm;

        public ShadedReliefParameters(double resX, double resY, double zetaFactor, double scale, double altitude, double azimuth, ShadedReliefAlgorithm algorithm) {
            this.resY = resY;
            this.resX = resX;
            this.sinAlt = Math.sin(altitude * (Math.PI / 180));
            this.z_scaled = zetaFactor / (algorithm.getFactor() * scale);
            this.square_z = this.z_scaled * this.z_scaled;
            this.algorithm = algorithm;
            double cos_alt = Math.cos(altitude * (Math.PI / 180));
            this.cos_az_mul_cos_alt_mul_z = Math.cos(azimuth * (Math.PI / 180)) * cos_alt * this.z_scaled;
            this.sin_az_mul_cos_alt_mul_z = Math.sin(azimuth * (Math.PI / 180)) * cos_alt * this.z_scaled;
        }
    }

    static enum ProcessingCase {
        TOP_LEFT{

            @Override
            public void setWindow(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[3] = data.getValue(centerScanlineOffset + 1);
                window[4] = data.getValue(centerScanlineOffset + 1);
                window[5] = data.getValue(centerScanlineOffset + 2);
                window[6] = data.getValue(centerScanlineOffset * 2 + 1);
                window[7] = data.getValue(centerScanlineOffset * 2 + 1);
                window[8] = data.getValue(centerScanlineOffset * 2 + 2);
                window[0] = data.interpolate(window[3], window[6]);
                window[1] = data.interpolate(window[4], window[7]);
                window[2] = data.interpolate(window[5], window[8]);
            }

            @Override
            public void setWindowNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[3] = data.getValue(centerScanlineOffset + 1);
                window[4] = data.getValue(centerScanlineOffset + 1);
                window[5] = data.getValue(centerScanlineOffset + 2);
                window[6] = data.getValue(centerScanlineOffset * 2 + 1);
                window[7] = data.getValue(centerScanlineOffset * 2 + 1);
                window[8] = data.getValue(centerScanlineOffset * 2 + 2);
                window[0] = data.interpolateNoData(window[3], window[6]);
                window[1] = data.interpolateNoData(window[4], window[7]);
                window[2] = data.interpolateNoData(window[5], window[8]);
            }
        }
        ,
        TOP{

            @Override
            public void setWindow(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[3] = data.getValue(centerScanlineOffset + i);
                window[4] = data.getValue(centerScanlineOffset + i + 1);
                window[5] = data.getValue(centerScanlineOffset + i + 2);
                window[6] = data.getValue(centerScanlineOffset * 2 + i);
                window[7] = data.getValue(centerScanlineOffset * 2 + i + 1);
                window[8] = data.getValue(centerScanlineOffset * 2 + i + 2);
                window[0] = data.interpolate(window[3], window[6]);
                window[1] = data.interpolate(window[4], window[7]);
                window[2] = data.interpolate(window[5], window[8]);
            }

            @Override
            public void setWindowNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[3] = data.getValue(centerScanlineOffset + i);
                window[4] = data.getValue(centerScanlineOffset + i + 1);
                window[5] = data.getValue(centerScanlineOffset + i + 2);
                window[6] = data.getValue(centerScanlineOffset * 2 + i);
                window[7] = data.getValue(centerScanlineOffset * 2 + i + 1);
                window[8] = data.getValue(centerScanlineOffset * 2 + i + 2);
                window[0] = data.interpolateNoData(window[3], window[6]);
                window[1] = data.interpolateNoData(window[4], window[7]);
                window[2] = data.interpolateNoData(window[5], window[8]);
            }
        }
        ,
        TOP_RIGHT{

            @Override
            public void setWindow(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[3] = data.getValue(centerScanlineOffset + i);
                window[4] = data.getValue(centerScanlineOffset + i + 1);
                window[5] = data.getValue(centerScanlineOffset + i + 1);
                window[6] = data.getValue(centerScanlineOffset * 2 + i);
                window[7] = data.getValue(centerScanlineOffset * 2 + i + 1);
                window[8] = data.getValue(centerScanlineOffset * 2 + i + 1);
                window[0] = data.interpolate(window[3], window[6]);
                window[1] = data.interpolate(window[4], window[7]);
                window[2] = data.interpolate(window[5], window[8]);
            }

            @Override
            public void setWindowNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[3] = data.getValue(centerScanlineOffset + i);
                window[4] = data.getValue(centerScanlineOffset + i + 1);
                window[5] = data.getValue(centerScanlineOffset + i + 1);
                window[6] = data.getValue(centerScanlineOffset * 2 + i);
                window[7] = data.getValue(centerScanlineOffset * 2 + i + 1);
                window[8] = data.getValue(centerScanlineOffset * 2 + i + 1);
                window[0] = data.interpolateNoData(window[3], window[6]);
                window[1] = data.interpolateNoData(window[4], window[7]);
                window[2] = data.interpolateNoData(window[5], window[8]);
            }
        }
        ,
        LEFT{

            @Override
            public void setWindow(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[1] = data.getValue(srcPixelOffset + i + 1);
                window[2] = data.getValue(srcPixelOffset + i + 2);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + i + 1);
                window[5] = data.getValue(srcPixelOffset + centerScanlineOffset + i + 2);
                window[7] = data.getValue(srcPixelOffset + centerScanlineOffset * 2 + i + 1);
                window[8] = data.getValue(srcPixelOffset + centerScanlineOffset * 2 + i + 2);
                window[0] = data.interpolate(window[1], window[2]);
                window[3] = data.interpolate(window[4], window[5]);
                window[6] = data.interpolate(window[7], window[8]);
            }

            @Override
            public void setWindowNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[1] = data.getValue(srcPixelOffset + i + 1);
                window[2] = data.getValue(srcPixelOffset + i + 2);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + i + 1);
                window[5] = data.getValue(srcPixelOffset + centerScanlineOffset + i + 2);
                window[7] = data.getValue(srcPixelOffset + centerScanlineOffset * 2 + i + 1);
                window[8] = data.getValue(srcPixelOffset + centerScanlineOffset * 2 + i + 2);
                window[0] = data.interpolateNoData(window[1], window[2]);
                window[3] = data.interpolateNoData(window[4], window[5]);
                window[6] = data.interpolateNoData(window[7], window[8]);
            }
        }
        ,
        STANDARD{

            @Override
            public void setWindow(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[0] = data.getValue(srcPixelOffset);
                window[1] = data.getValue(srcPixelOffset + 1);
                window[2] = data.getValue(srcPixelOffset + 2);
                window[3] = data.getValue(srcPixelOffset + centerScanlineOffset);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[5] = data.getValue(srcPixelOffset + centerScanlineOffset + 2);
                window[6] = data.getValue(srcPixelOffset + centerScanlineOffset * 2);
                window[7] = data.getValue(srcPixelOffset + centerScanlineOffset * 2 + 1);
                window[8] = data.getValue(srcPixelOffset + centerScanlineOffset * 2 + 2);
            }

            @Override
            public void setWindowNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                this.setWindow(window, i, srcPixelOffset, centerScanlineOffset, data);
            }
        }
        ,
        RIGHT{

            @Override
            public void setWindow(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[0] = data.getValue(srcPixelOffset);
                window[1] = data.getValue(srcPixelOffset + 1);
                window[3] = data.getValue(srcPixelOffset + centerScanlineOffset);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[6] = data.getValue(srcPixelOffset + centerScanlineOffset * 2);
                window[7] = data.getValue(srcPixelOffset + centerScanlineOffset * 2 + 1);
                window[2] = data.interpolate(window[1], window[0]);
                window[5] = data.interpolate(window[4], window[3]);
                window[8] = data.interpolate(window[7], window[6]);
            }

            @Override
            public void setWindowNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[0] = data.getValue(srcPixelOffset);
                window[1] = data.getValue(srcPixelOffset + 1);
                window[3] = data.getValue(srcPixelOffset + centerScanlineOffset);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[6] = data.getValue(srcPixelOffset + centerScanlineOffset * 2);
                window[7] = data.getValue(srcPixelOffset + centerScanlineOffset * 2 + 1);
                window[2] = data.interpolateNoData(window[1], window[0]);
                window[5] = data.interpolateNoData(window[4], window[3]);
                window[8] = data.interpolateNoData(window[7], window[6]);
            }
        }
        ,
        BOTTOM_LEFT{

            @Override
            public void setWindow(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[0] = data.getValue(srcPixelOffset + 1);
                window[1] = data.getValue(srcPixelOffset + 1);
                window[2] = data.getValue(srcPixelOffset + 2);
                window[3] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[5] = data.getValue(srcPixelOffset + centerScanlineOffset + 2);
                window[6] = data.interpolate(window[3], window[0]);
                window[7] = data.interpolate(window[4], window[1]);
                window[8] = data.interpolate(window[5], window[2]);
            }

            @Override
            public void setWindowNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[0] = data.getValue(srcPixelOffset + 1);
                window[1] = data.getValue(srcPixelOffset + 1);
                window[2] = data.getValue(srcPixelOffset + 2);
                window[3] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[5] = data.getValue(srcPixelOffset + centerScanlineOffset + 2);
                window[6] = data.interpolateNoData(window[3], window[0]);
                window[7] = data.interpolateNoData(window[4], window[1]);
                window[8] = data.interpolateNoData(window[5], window[2]);
            }
        }
        ,
        BOTTOM{

            @Override
            public void setWindow(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[0] = data.getValue(srcPixelOffset);
                window[1] = data.getValue(srcPixelOffset + 1);
                window[2] = data.getValue(srcPixelOffset + 2);
                window[3] = data.getValue(srcPixelOffset + centerScanlineOffset);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[5] = data.getValue(srcPixelOffset + centerScanlineOffset + 2);
                window[6] = data.interpolate(window[3], window[0]);
                window[7] = data.interpolate(window[4], window[1]);
                window[8] = data.interpolate(window[5], window[2]);
            }

            @Override
            public void setWindowNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[0] = data.getValue(srcPixelOffset);
                window[1] = data.getValue(srcPixelOffset + 1);
                window[2] = data.getValue(srcPixelOffset + 2);
                window[3] = data.getValue(srcPixelOffset + centerScanlineOffset);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[5] = data.getValue(srcPixelOffset + centerScanlineOffset + 2);
                window[6] = data.interpolateNoData(window[3], window[0]);
                window[7] = data.interpolateNoData(window[4], window[1]);
                window[8] = data.interpolateNoData(window[5], window[2]);
            }
        }
        ,
        BOTTOM_RIGHT{

            @Override
            public void setWindow(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[0] = data.getValue(srcPixelOffset);
                window[1] = data.getValue(srcPixelOffset + 1);
                window[2] = data.getValue(srcPixelOffset + 1);
                window[3] = data.getValue(srcPixelOffset + centerScanlineOffset);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[5] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[6] = data.interpolate(window[3], window[0]);
                window[7] = data.interpolate(window[4], window[1]);
                window[8] = data.interpolate(window[5], window[2]);
            }

            @Override
            public void setWindowNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data) {
                window[0] = data.getValue(srcPixelOffset);
                window[1] = data.getValue(srcPixelOffset + 1);
                window[2] = data.getValue(srcPixelOffset + 1);
                window[3] = data.getValue(srcPixelOffset + centerScanlineOffset);
                window[4] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[5] = data.getValue(srcPixelOffset + centerScanlineOffset + 1);
                window[6] = data.interpolateNoData(window[3], window[0]);
                window[7] = data.interpolateNoData(window[4], window[1]);
                window[8] = data.interpolateNoData(window[5], window[2]);
            }
        };


        abstract void setWindow(double[] var1, int var2, int var3, int var4, DataProcessor var5);

        abstract void setWindowNoData(double[] var1, int var2, int var3, int var4, DataProcessor var5);

        void setWindowRoi(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data, boolean[] roi) {
            this.setWindow(window, i, srcPixelOffset, centerScanlineOffset, data);
            for (int k = 0; k < 9; ++k) {
                window[k] = k == 4 || !roi[k] ? window[4] : window[k];
            }
        }

        void setWindowRoiNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, DataProcessor data, boolean[] roi) {
            this.setWindowNoData(window, i, srcPixelOffset, centerScanlineOffset, data);
            for (int k = 0; k < 9; ++k) {
                window[k] = k == 4 || !roi[k] ? window[4] : window[k];
            }
        }
    }

    static class DataProcessorByte
    extends DataProcessor {
        byte[] srcDataByte;

        public DataProcessorByte(byte[] data, boolean hasNoData, Range noDataSrc, double noDataDst, ShadedReliefParameters params) {
            super(hasNoData, noDataSrc, noDataDst, params);
            this.srcDataByte = data;
        }

        @Override
        double getValue(int index) {
            return this.srcDataByte[index];
        }
    }

    static class DataProcessorFloat
    extends DataProcessor {
        float[] srcDataFloat;

        public DataProcessorFloat(float[] data, boolean hasNoData, Range noDataSrc, double noDataDst, ShadedReliefParameters params) {
            super(hasNoData, noDataSrc, noDataDst, params);
            this.srcDataFloat = data;
        }

        @Override
        double getValue(int index) {
            return this.srcDataFloat[index];
        }
    }

    static class DataProcessorDouble
    extends DataProcessor {
        double[] srcDataDouble;

        public DataProcessorDouble(double[] data, boolean hasNoData, Range noDataSrc, double noDataDst, ShadedReliefParameters params) {
            super(hasNoData, noDataSrc, noDataDst, params);
            this.srcDataDouble = data;
        }

        @Override
        double getValue(int index) {
            return this.srcDataDouble[index];
        }
    }

    static class DataProcessorInt
    extends DataProcessor {
        int[] srcDataInt;

        public DataProcessorInt(int[] data, boolean hasNoData, Range noDataSrc, double noDataDst, ShadedReliefParameters params) {
            super(hasNoData, noDataSrc, noDataDst, params);
            this.srcDataInt = data;
        }

        @Override
        double getValue(int index) {
            return this.srcDataInt[index];
        }
    }

    static class DataProcessorShort
    extends DataProcessor {
        short[] srcDataShort;

        public DataProcessorShort(short[] data, boolean hasNoData, Range noDataSrc, double noDataDst, ShadedReliefParameters params) {
            super(hasNoData, noDataSrc, noDataDst, params);
            this.srcDataShort = data;
        }

        @Override
        double getValue(int index) {
            return this.srcDataShort[index];
        }
    }

    static abstract class DataProcessor {
        boolean hasNoData;
        Range srcNoData;
        double dstNoData;
        ShadedReliefAlgorithm algorithm;
        ShadedReliefParameters params;

        public DataProcessor(boolean hasNoData, Range srcNoData, double dstNoData, ShadedReliefParameters params) {
            this.hasNoData = hasNoData;
            this.srcNoData = srcNoData;
            this.dstNoData = dstNoData;
            this.params = params;
            this.algorithm = params.algorithm;
        }

        abstract double getValue(int var1);

        public final double interpolate(double a2, double b2) {
            return 2.0 * a2 - b2;
        }

        public final double interpolateNoData(double a2, double b2) {
            return this.hasNoData && (this.srcNoData.contains(a2) || this.srcNoData.contains(b2)) ? this.dstNoData : this.interpolate(a2, b2);
        }

        public double processWindowNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, ProcessingCase processingCase) {
            processingCase.setWindowNoData(window, i, srcPixelOffset, centerScanlineOffset, this);
            if (this.isNoData(window[4])) {
                return Double.NaN;
            }
            for (int index = 0; index < 9; ++index) {
                if (!this.isNoData(window[index])) continue;
                window[index] = window[4];
            }
            return this.algorithm.getValue(window, this.params);
        }

        public double processWindow(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, ProcessingCase processingCase) {
            processingCase.setWindow(window, i, srcPixelOffset, centerScanlineOffset, this);
            return this.algorithm.getValue(window, this.params);
        }

        public double processWindowRoi(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, ProcessingCase processingCase, boolean[] roiMask) {
            processingCase.setWindowRoi(window, i, srcPixelOffset, centerScanlineOffset, this, roiMask);
            return this.algorithm.getValue(window, this.params);
        }

        public double processWindowRoiNoData(double[] window, int i, int srcPixelOffset, int centerScanlineOffset, ProcessingCase processingCase, boolean[] roiMask) {
            processingCase.setWindowRoiNoData(window, i, srcPixelOffset, centerScanlineOffset, this, roiMask);
            if (this.isNoData(window[4])) {
                return Double.NaN;
            }
            for (int index = 0; index < 9; ++index) {
                if (!this.isNoData(window[index])) continue;
                window[index] = window[4];
            }
            return this.algorithm.getValue(window, this.params);
        }

        private boolean isNoData(double value) {
            return this.hasNoData && this.srcNoData.contains(value);
        }
    }
}

