/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class PropNotEqualXY_C
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;
    private final int cste;

    public PropNotEqualXY_C(IntVar[] vars, int c2) {
        super((Variable[])vars, (Priority)PropagatorPriority.BINARY, false);
        this.x = vars[0];
        this.y = vars[1];
        this.cste = c2;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (((IntVar[])this.vars)[vIdx].hasEnumeratedDomain()) {
            return IntEventType.instantiation();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.x.isInstantiated()) {
            if (this.y.removeValue(this.cste - this.x.getValue(), this) || !this.y.contains(this.cste - this.x.getValue())) {
                this.setPassive();
            }
        } else if (this.y.isInstantiated()) {
            if (this.x.removeValue(this.cste - this.y.getValue(), this) || !this.x.contains(this.cste - this.y.getValue())) {
                this.setPassive();
            }
        } else if (this.x.getLB() + this.y.getLB() > this.cste || this.x.getUB() + this.y.getUB() < this.cste) {
            this.setPassive();
        }
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        if (explanation.readVar(p) == ((IntVar[])this.vars)[0]) {
            int m3 = explanation.readDom(((IntVar[])this.vars)[1]).min();
            IntIterableRangeSet set0 = explanation.universe();
            IntIterableRangeSet set1 = explanation.universe();
            set0.remove(this.cste - m3);
            set1.remove(m3);
            ((IntVar[])this.vars)[0].intersectLit(set0, explanation);
            ((IntVar[])this.vars)[1].unionLit(set1, explanation);
        } else {
            assert (explanation.readDom(((IntVar[])this.vars)[0]).size() == 1);
            int m4 = explanation.readDom(((IntVar[])this.vars)[0]).min();
            IntIterableRangeSet set1 = explanation.universe();
            IntIterableRangeSet set0 = explanation.universe();
            set0.remove(m4);
            set1.remove(this.cste - m4);
            ((IntVar[])this.vars)[0].unionLit(set0, explanation);
            ((IntVar[])this.vars)[1].intersectLit(set1, explanation);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() + this.y.getUB() < this.cste || this.y.getLB() + this.x.getLB() > this.cste) {
            return ESat.TRUE;
        }
        if (this.x.isInstantiated() && this.y.isInstantiated() && this.x.getValue() + this.y.getValue() == this.cste) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }
}

