/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision;

import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.GraphDecisionOperator;
import org.chocosolver.solver.search.strategy.decision.GraphDecision;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.search.strategy.decision.RealDecision;
import org.chocosolver.solver.search.strategy.decision.SetDecision;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.util.PoolManager;

public class DecisionMaker {
    private final PoolManager<IntDecision> intDecisionPool = new PoolManager();
    private final PoolManager<RealDecision> realDecisionPool = new PoolManager();
    private final PoolManager<SetDecision> setDecisionPool = new PoolManager();
    private final PoolManager<GraphDecision> graphDecisionPool = new PoolManager();

    public IntDecision makeIntDecision(IntVar var, DecisionOperator<IntVar> dop, int value) {
        IntDecision d2 = this.intDecisionPool.getE();
        if (d2 == null) {
            d2 = new IntDecision(this.intDecisionPool);
        }
        d2.set(var, value, dop);
        return d2;
    }

    public RealDecision makeRealDecision(RealVar var, double value, double epsilon, boolean leftFirst) {
        RealDecision d2 = this.realDecisionPool.getE();
        if (d2 == null) {
            d2 = new RealDecision(this.realDecisionPool);
        }
        d2.set(var, value, epsilon, leftFirst);
        return d2;
    }

    public SetDecision makeSetDecision(SetVar var, DecisionOperator<SetVar> dop, int value) {
        SetDecision d2 = this.setDecisionPool.getE();
        if (d2 == null) {
            d2 = new SetDecision(this.setDecisionPool);
        }
        d2.set(var, value, dop);
        return d2;
    }

    public <G extends GraphVar<?>> GraphDecision<G> makeGraphNodeDecision(G var, GraphDecisionOperator dop, int node) {
        GraphDecision<G> d2 = this.graphDecisionPool.getE();
        if (d2 == null) {
            d2 = new GraphDecision<G>(this.graphDecisionPool);
        }
        d2.setNode(var, node, dop);
        return d2;
    }

    public <G extends GraphVar<?>> GraphDecision<G> makeGraphEdgeDecision(G var, GraphDecisionOperator dop, int from, int to) {
        GraphDecision<G> d2 = this.graphDecisionPool.getE();
        if (d2 == null) {
            d2 = new GraphDecision<G>(this.graphDecisionPool);
        }
        d2.setEdge(var, from, to, dop);
        return d2;
    }
}

