/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.util.Arrays;
import org.ejml.data.FMatrixSparse;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.ops.SortCoupledArray_F32;

public class FMatrixSparseCSC
implements FMatrixSparse {
    public float[] nz_values;
    public int nz_length;
    public int[] nz_rows;
    public int[] col_idx;
    public int numRows;
    public int numCols;
    public boolean indicesSorted = false;

    public FMatrixSparseCSC(int numRows, int numCols) {
        this(numRows, numCols, 0);
    }

    public FMatrixSparseCSC(int numRows, int numCols, int arrayLength) {
        arrayLength = Math.min(numCols * numRows, arrayLength);
        this.numRows = numRows;
        this.numCols = numCols;
        this.nz_length = 0;
        this.nz_values = new float[arrayLength];
        this.col_idx = new int[numCols + 1];
        this.nz_rows = new int[arrayLength];
    }

    public FMatrixSparseCSC(FMatrixSparseCSC original) {
        this(original.numRows, original.numCols, original.nz_length);
        this.set(original);
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    public FMatrixSparseCSC copy() {
        return new FMatrixSparseCSC(this);
    }

    public FMatrixSparseCSC createLike() {
        return new FMatrixSparseCSC(this.numRows, this.numCols);
    }

    @Override
    public void set(Matrix original) {
        FMatrixSparseCSC o = (FMatrixSparseCSC)original;
        this.reshape(o.numRows, o.numCols, o.nz_length);
        this.nz_length = o.nz_length;
        System.arraycopy(o.nz_values, 0, this.nz_values, 0, this.nz_length);
        System.arraycopy(o.nz_rows, 0, this.nz_rows, 0, this.nz_length);
        System.arraycopy(o.col_idx, 0, this.col_idx, 0, this.numCols + 1);
        this.indicesSorted = o.indicesSorted;
    }

    @Override
    public void print() {
        System.out.println(this.getClass().getSimpleName() + "\nnumRows = " + this.numRows + " , numCols = " + this.numCols + " , nz_length = " + this.nz_length);
        for (int row = 0; row < this.numRows; ++row) {
            for (int col = 0; col < this.numCols; ++col) {
                int index = this.nz_index(row, col);
                if (index >= 0) {
                    System.out.printf("%6.3ff", Float.valueOf(this.get(row, col)));
                } else {
                    System.out.print("   *  ");
                }
                if (col == this.numCols - 1) continue;
                System.out.print(" ");
            }
            System.out.println();
        }
    }

    @Override
    public void printNonZero() {
        System.out.println(this.getClass().getSimpleName() + "\nnumRows = " + this.numRows + " , numCols = " + this.numCols + " , nz_length = " + this.nz_length);
        for (int col = 0; col < this.numCols; ++col) {
            int idx0 = this.col_idx[col];
            int idx1 = this.col_idx[col + 1];
            for (int i = idx0; i < idx1; ++i) {
                int row = this.nz_rows[i];
                float value = this.nz_values[i];
                System.out.printf("%d %d %f\n", row, col, Float.valueOf(value));
            }
        }
    }

    @Override
    public boolean isAssigned(int row, int col) {
        return this.nz_index(row, col) >= 0;
    }

    @Override
    public float get(int row, int col) {
        if (row < 0 || row >= this.numRows || col < 0 || col >= this.numCols) {
            throw new IllegalArgumentException("Outside of matrix bounds");
        }
        return this.unsafe_get(row, col);
    }

    @Override
    public float unsafe_get(int row, int col) {
        int index = this.nz_index(row, col);
        if (index >= 0) {
            return this.nz_values[index];
        }
        return 0.0f;
    }

    public int nz_index(int row, int col) {
        int col0 = this.col_idx[col];
        int col1 = this.col_idx[col + 1];
        for (int i = col0; i < col1; ++i) {
            if (this.nz_rows[i] != row) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void set(int row, int col, float val) {
        if (row < 0 || row >= this.numRows || col < 0 || col >= this.numCols) {
            throw new IllegalArgumentException("Outside of matrix bounds");
        }
        this.unsafe_set(row, col, val);
    }

    @Override
    public void unsafe_set(int row, int col, float val) {
        int index = this.nz_index(row, col);
        if (index >= 0) {
            this.nz_values[index] = val;
        } else {
            int idx0 = this.col_idx[col];
            int idx1 = this.col_idx[col + 1];
            for (index = idx0; index < idx1 && row >= this.nz_rows[index]; ++index) {
            }
            int i = col + 1;
            while (i <= this.numCols) {
                int n = i++;
                this.col_idx[n] = this.col_idx[n] + 1;
            }
            if (this.nz_length >= this.nz_values.length) {
                this.growMaxLength(this.nz_length * 2 + 1, true);
            }
            for (i = this.nz_length; i > index; --i) {
                this.nz_rows[i] = this.nz_rows[i - 1];
                this.nz_values[i] = this.nz_values[i - 1];
            }
            this.nz_rows[index] = row;
            this.nz_values[index] = val;
            ++this.nz_length;
        }
    }

    @Override
    public void remove(int row, int col) {
        int index = this.nz_index(row, col);
        if (index < 0) {
            return;
        }
        int i = col + 1;
        while (i <= this.numCols) {
            int n = i++;
            this.col_idx[n] = this.col_idx[n] - 1;
        }
        --this.nz_length;
        for (i = index; i < this.nz_length; ++i) {
            this.nz_rows[i] = this.nz_rows[i + 1];
            this.nz_values[i] = this.nz_values[i + 1];
        }
    }

    @Override
    public void zero() {
        Arrays.fill(this.col_idx, 0, this.numCols + 1, 0);
        this.nz_length = 0;
        this.indicesSorted = false;
    }

    @Override
    public int getNumElements() {
        return this.nz_length;
    }

    @Override
    public void reshape(int numRows, int numCols, int arrayLength) {
        this.indicesSorted = false;
        this.numRows = numRows;
        this.numCols = numCols;
        this.growMaxLength(arrayLength, false);
        this.nz_length = 0;
        if (numCols + 1 > this.col_idx.length) {
            this.col_idx = new int[numCols + 1];
        } else {
            Arrays.fill(this.col_idx, 0, numCols + 1, 0);
        }
    }

    @Override
    public void shrinkArrays() {
        if (this.nz_length < this.nz_values.length) {
            float[] tmp_values = new float[this.nz_length];
            int[] tmp_rows = new int[this.nz_length];
            System.arraycopy(this.nz_values, 0, tmp_values, 0, this.nz_length);
            System.arraycopy(this.nz_rows, 0, tmp_rows, 0, this.nz_length);
            this.nz_values = tmp_values;
            this.nz_rows = tmp_rows;
        }
    }

    public void growMaxLength(int arrayLength, boolean preserveValue) {
        if ((arrayLength = Math.min(this.numRows * this.numCols, arrayLength)) > this.nz_values.length) {
            float[] data = new float[arrayLength];
            int[] row_idx = new int[arrayLength];
            if (preserveValue) {
                System.arraycopy(this.nz_values, 0, data, 0, this.nz_length);
                System.arraycopy(this.nz_rows, 0, row_idx, 0, this.nz_length);
            }
            this.nz_values = data;
            this.nz_rows = row_idx;
        }
    }

    public void growMaxColumns(int desiredColumns, boolean preserveValue) {
        if (this.col_idx.length < desiredColumns + 1) {
            int[] c2 = new int[desiredColumns + 1];
            if (preserveValue) {
                System.arraycopy(this.col_idx, 0, c2, 0, this.col_idx.length);
            }
            this.col_idx = c2;
        }
    }

    public void colsum(int[] histogram) {
        this.col_idx[0] = 0;
        int index = 0;
        for (int i = 1; i <= this.numCols; ++i) {
            this.col_idx[i] = index += histogram[i - 1];
        }
        System.arraycopy(this.col_idx, 0, histogram, 0, this.numCols);
        this.nz_length = index;
        this.growMaxLength(this.nz_length, false);
        if (this.col_idx[this.numCols] != this.nz_length) {
            throw new RuntimeException("Egads");
        }
    }

    public void sortIndices(SortCoupledArray_F32 sorter) {
        if (sorter == null) {
            sorter = new SortCoupledArray_F32();
        }
        sorter.quick(this.col_idx, this.numCols + 1, this.nz_rows, this.nz_values);
        this.indicesSorted = true;
    }

    public void copyStructure(FMatrixSparseCSC orig) {
        this.reshape(orig.numRows, orig.numCols, orig.nz_length);
        this.nz_length = orig.nz_length;
        System.arraycopy(orig.col_idx, 0, this.col_idx, 0, orig.numCols + 1);
        System.arraycopy(orig.nz_rows, 0, this.nz_rows, 0, orig.nz_length);
    }

    public boolean isIndicesSorted() {
        return this.indicesSorted;
    }

    public boolean isFull() {
        return this.nz_length == this.numRows * this.numCols;
    }

    @Override
    public MatrixType getType() {
        return MatrixType.FSCC;
    }
}

