/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.block;

public class InnerTriangularSolver_DDRB {
    public static void invertLower(double[] L, double[] L_inv, int m3, int offsetL, int offsetL_inv) {
        for (int i = 0; i < m3; ++i) {
            double L_ii = L[offsetL + i * m3 + i];
            for (int j = 0; j < i; ++j) {
                double val = 0.0;
                for (int k = j; k < i; ++k) {
                    val += L[offsetL + i * m3 + k] * L_inv[offsetL_inv + k * m3 + j];
                }
                L_inv[offsetL_inv + i * m3 + j] = -val / L_ii;
            }
            L_inv[offsetL_inv + i * m3 + i] = 1.0 / L_ii;
        }
    }

    public static void invertLower(double[] L, int m3, int offsetL) {
        for (int i = 0; i < m3; ++i) {
            double L_ii = L[offsetL + i * m3 + i];
            for (int j = 0; j < i; ++j) {
                double val = 0.0;
                for (int k = j; k < i; ++k) {
                    val += L[offsetL + i * m3 + k] * L[offsetL + k * m3 + j];
                }
                L[offsetL + i * m3 + j] = -val / L_ii;
            }
            L[offsetL + i * m3 + i] = 1.0 / L_ii;
        }
    }

    public static void solveL(double[] L, double[] b2, int m3, int n, int strideL, int offsetL, int offsetB) {
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m3; ++i) {
                double sum = b2[offsetB + i * n + j];
                for (int k = 0; k < i; ++k) {
                    sum -= L[offsetL + i * strideL + k] * b2[offsetB + k * n + j];
                }
                b2[offsetB + i * n + j] = sum / L[offsetL + i * strideL + i];
            }
        }
    }

    public static void solveTransL(double[] L, double[] b2, int m3, int n, int strideL, int offsetL, int offsetB) {
        for (int j = 0; j < n; ++j) {
            for (int i = m3 - 1; i >= 0; --i) {
                double sum = b2[offsetB + i * n + j];
                for (int k = i + 1; k < m3; ++k) {
                    sum -= L[offsetL + k * strideL + i] * b2[offsetB + k * n + j];
                }
                b2[offsetB + i * n + j] = sum / L[offsetL + i * strideL + i];
            }
        }
    }

    public static void solveLTransB(double[] L, double[] b2, int m3, int n, int strideL, int offsetL, int offsetB) {
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m3; ++i) {
                double sum = b2[offsetB + j * m3 + i];
                int l = offsetL + i * strideL;
                int bb = offsetB + j * m3;
                int endL = l + i;
                while (l != endL) {
                    sum -= L[l++] * b2[bb++];
                }
                b2[offsetB + j * m3 + i] = sum / L[offsetL + i * strideL + i];
            }
        }
    }

    public static void solveU(double[] U, double[] b2, int m3, int n, int strideU, int offsetU, int offsetB) {
        for (int j = 0; j < n; ++j) {
            for (int i = m3 - 1; i >= 0; --i) {
                double sum = b2[offsetB + i * n + j];
                for (int k = i + 1; k < m3; ++k) {
                    sum -= U[offsetU + i * strideU + k] * b2[offsetB + k * n + j];
                }
                b2[offsetB + i * n + j] = sum / U[offsetU + i * strideU + i];
            }
        }
    }

    public static void solveTransU(double[] U, double[] b2, int m3, int n, int strideU, int offsetU, int offsetB) {
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m3; ++i) {
                double sum = b2[offsetB + i * n + j];
                for (int k = 0; k < i; ++k) {
                    sum -= U[offsetU + k * strideU + i] * b2[offsetB + k * n + j];
                }
                b2[offsetB + i * n + j] = sum / U[offsetU + i * strideU + i];
            }
        }
    }
}

