/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.FilteringFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.filter.visitor.BindingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.sort.SortBy;

public class FilteringFeatureCollection<T extends FeatureType, F extends Feature>
extends DecoratingFeatureCollection<T, F> {
    FeatureCollection<T, F> delegate;
    Filter filter;

    public FilteringFeatureCollection(FeatureCollection<T, F> delegate, Filter filter) {
        super(delegate);
        this.delegate = delegate;
        this.filter = (Filter)filter.accept((FilterVisitor)new BindingFilterVisitor(delegate.getSchema()), null);
    }

    public FeatureCollection<T, F> subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FeatureCollection<T, F> sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int count = 0;
        try (FeatureIterator<F> i = this.features();){
            while (i.hasNext()) {
                ++count;
                i.next();
            }
            int n = count;
            return n;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O[] toArray(O[] a2) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        try (FeatureIterator<F> i = this.features();){
            while (i.hasNext()) {
                list.add(i.next());
            }
            O[] OArray = list.toArray(a2);
            return OArray;
        }
    }

    public boolean contains(Object o) {
        return this.delegate.contains(o) && this.filter.evaluate(o);
    }

    public boolean containsAll(Collection<?> c2) {
        Iterator<?> i = c2.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public FeatureIterator<F> features() {
        return new FilteringFeatureIterator(this.delegate.features(), this.filter);
    }

    public FeatureReader<T, F> reader() throws IOException {
        return new DelegateFeatureReader<FeatureType, F>(this.getSchema(), this.features());
    }

    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds((FeatureCollection<? extends FeatureType, ? extends Feature>)this);
    }
}

