/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.cycle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.generate.ComplementGraphGenerator;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.GraphWalk;
import org.jgrapht.graph.Multigraph;
import org.jgrapht.graph.SimpleGraph;

public class BergeGraphInspector<V, E> {
    private GraphPath<V, E> certificate = null;
    private boolean certify = false;

    private List<V> intersectGraphPaths(GraphPath<V, E> p1, GraphPath<V, E> p2) {
        LinkedList<V> res = new LinkedList<V>();
        res.addAll(p1.getVertexList());
        res.retainAll(p2.getVertexList());
        return res;
    }

    private GraphPath<V, E> P(Graph<V, E> g2, GraphPath<V, E> S, GraphPath<V, E> T, V m3, V b1, V b2, V b3, V s1, V s22, V s3) {
        if (s1 == b1) {
            if (b1 == m3) {
                LinkedList edgeList = new LinkedList();
                return new GraphWalk<V, E>(g2, s1, b1, edgeList, 0.0);
            }
            return null;
        }
        if (b1 == m3) {
            return null;
        }
        if (g2.containsEdge(m3, b2) || g2.containsEdge(m3, b3) || g2.containsEdge(m3, s22) || g2.containsEdge(m3, s3) || S == null || T == null) {
            return null;
        }
        if (S.getVertexList().stream().anyMatch(t -> g2.containsEdge(t, b2) || g2.containsEdge(t, b3) || g2.containsEdge(t, s22) || g2.containsEdge(t, s3)) || T.getVertexList().stream().anyMatch(t -> t != b1 && (g2.containsEdge(t, b2) || g2.containsEdge(t, b3) || g2.containsEdge(t, s22) || g2.containsEdge(t, s3)))) {
            return null;
        }
        List<V> intersection = this.intersectGraphPaths(S, T);
        if (intersection.size() != 1 || !intersection.contains(m3)) {
            return null;
        }
        if (S.getVertexList().stream().anyMatch(s2 -> s2 != m3 && T.getVertexList().stream().anyMatch(t -> t != m3 && g2.containsEdge(s2, t)))) {
            return null;
        }
        LinkedList<E> edgeList = new LinkedList<E>();
        edgeList.addAll(T.getEdgeList());
        edgeList.addAll(S.getEdgeList());
        double weight = edgeList.stream().mapToDouble(g2::getEdgeWeight).sum();
        return new GraphWalk<V, E>(g2, b1, s1, edgeList, weight);
    }

    private void BFOddHoleCertificate(Graph<V, E> g2) {
        for (V start : g2.vertexSet()) {
            if (g2.degreeOf(start) < 2) continue;
            HashSet<V> set = new HashSet<V>();
            set.addAll(g2.vertexSet());
            for (V neighborOfStart : g2.vertexSet()) {
                if (neighborOfStart == start || !g2.containsEdge(start, neighborOfStart) || g2.degreeOf(neighborOfStart) != 2) continue;
                set.remove(neighborOfStart);
                AsSubgraph<V, E> subg = new AsSubgraph<V, E>(g2, set);
                for (V neighborsNeighbor : g2.vertexSet()) {
                    GraphPath<V, E> path;
                    if (neighborsNeighbor == start || neighborsNeighbor == neighborOfStart || !g2.containsEdge(neighborsNeighbor, neighborOfStart) || g2.containsEdge(neighborsNeighbor, start) || g2.degreeOf(neighborsNeighbor) < 2 || (path = new DijkstraShortestPath<V, E>(subg).getPath(start, neighborsNeighbor)) == null || path.getLength() < 3 || path.getLength() % 2 == 0) continue;
                    LinkedList<E> edgeList = new LinkedList<E>();
                    edgeList.addAll(path.getEdgeList());
                    edgeList.add(g2.getEdge(neighborsNeighbor, neighborOfStart));
                    edgeList.add(g2.getEdge(neighborOfStart, start));
                    double weight = edgeList.stream().mapToDouble(g2::getEdgeWeight).sum();
                    this.certificate = new GraphWalk<V, E>(g2, start, start, edgeList, weight);
                    break;
                }
                if (this.certificate == null) continue;
                break;
            }
            if (this.certificate == null) continue;
            break;
        }
    }

    boolean containsPyramid(Graph<V, E> g2) {
        HashSet visitedTriangles = new HashSet();
        for (Object b1 : g2.vertexSet()) {
            for (Object b2 : g2.vertexSet()) {
                if (b1 == b2 || !g2.containsEdge(b1, b2)) continue;
                for (Object b3 : g2.vertexSet()) {
                    if (b3 == b1 || b3 == b2 || !g2.containsEdge(b2, b3) || !g2.containsEdge(b1, b3)) continue;
                    HashSet<V> triangles = new HashSet<V>();
                    triangles.add(b1);
                    triangles.add(b2);
                    triangles.add(b3);
                    if (visitedTriangles.contains(triangles)) continue;
                    visitedTriangles.add(triangles);
                    for (V aCandidate : g2.vertexSet()) {
                        if (aCandidate == b1 || aCandidate == b2 || aCandidate == b3 || g2.containsEdge(aCandidate, b1) && g2.containsEdge(aCandidate, b2) || g2.containsEdge(aCandidate, b2) && g2.containsEdge(aCandidate, b3) || g2.containsEdge(aCandidate, b1) && g2.containsEdge(aCandidate, b3)) continue;
                        for (Object s1 : g2.vertexSet()) {
                            if (s1 == aCandidate || !g2.containsEdge(s1, aCandidate) || s1 == b2 || s1 == b3 || s1 != b1 && (g2.containsEdge(s1, b2) || g2.containsEdge(s1, b3))) continue;
                            for (Object s2 : g2.vertexSet()) {
                                if (s2 == aCandidate || !g2.containsEdge(s2, aCandidate) || g2.containsEdge(s1, s2) || s1 == s2 || s2 == b1 || s2 == b3 || s2 != b2 && (g2.containsEdge(s2, b1) || g2.containsEdge(s2, b3))) continue;
                                for (Object s3 : g2.vertexSet()) {
                                    AsSubgraph<V, E> subg;
                                    HashSet<Object> validInterior;
                                    if (s3 == aCandidate || !g2.containsEdge(s3, aCandidate) || g2.containsEdge(s3, s2) || s1 == s3 || s3 == s2 || g2.containsEdge(s1, s3) || s3 == b1 || s3 == b2 || s3 != b3 && (g2.containsEdge(s3, b1) || g2.containsEdge(s3, b2))) continue;
                                    HashSet<V> M = new HashSet<V>();
                                    M.addAll(g2.vertexSet());
                                    M.remove(b1);
                                    M.remove(b2);
                                    M.remove(b3);
                                    M.remove(s1);
                                    M.remove(s2);
                                    M.remove(s3);
                                    HashMap S1 = new HashMap();
                                    HashMap S2 = new HashMap();
                                    HashMap S3 = new HashMap();
                                    HashMap T1 = new HashMap();
                                    HashMap T2 = new HashMap();
                                    HashMap T3 = new HashMap();
                                    for (Object m1 : M) {
                                        validInterior = new HashSet<Object>();
                                        validInterior.addAll(M);
                                        validInterior.removeIf(i -> g2.containsEdge(i, b2) || g2.containsEdge(i, s2) || g2.containsEdge(i, b3) || g2.containsEdge(i, s3));
                                        validInterior.add(m1);
                                        validInterior.add(s1);
                                        subg = new AsSubgraph<V, E>(g2, validInterior);
                                        S1.put(m1, new DijkstraShortestPath(subg).getPath(m1, s1));
                                        validInterior.remove(s1);
                                        validInterior.add(b1);
                                        subg = new AsSubgraph<V, E>(g2, validInterior);
                                        T1.put(m1, new DijkstraShortestPath<V, E>(subg).getPath(b1, m1));
                                    }
                                    for (Object m22 : M) {
                                        validInterior = new HashSet();
                                        validInterior.addAll(M);
                                        validInterior.removeIf(i -> g2.containsEdge(i, b1) || g2.containsEdge(i, s1) || g2.containsEdge(i, b3) || g2.containsEdge(i, s3));
                                        validInterior.add(m22);
                                        validInterior.add(s2);
                                        subg = new AsSubgraph<V, E>(g2, validInterior);
                                        S2.put(m22, new DijkstraShortestPath(subg).getPath(m22, s2));
                                        validInterior.remove(s2);
                                        validInterior.add(b2);
                                        subg = new AsSubgraph<V, E>(g2, validInterior);
                                        T2.put(m22, new DijkstraShortestPath<V, E>(subg).getPath(b2, m22));
                                    }
                                    for (Object m3 : M) {
                                        validInterior = new HashSet();
                                        validInterior.addAll(M);
                                        validInterior.removeIf(i -> g2.containsEdge(i, b1) || g2.containsEdge(i, s1) || g2.containsEdge(i, b2) || g2.containsEdge(i, s2));
                                        validInterior.add(m3);
                                        validInterior.add(s3);
                                        subg = new AsSubgraph<V, E>(g2, validInterior);
                                        S3.put(m3, new DijkstraShortestPath(subg).getPath(m3, s3));
                                        validInterior.remove(s3);
                                        validInterior.add(b3);
                                        subg = new AsSubgraph<V, E>(g2, validInterior, null);
                                        T3.put(m3, new DijkstraShortestPath<V, E>(subg).getPath(b3, m3));
                                    }
                                    HashSet<V> M1 = new HashSet<V>();
                                    M1.addAll(M);
                                    M1.add(b1);
                                    for (Object m1 : M1) {
                                        GraphPath<V, E> P1 = this.P(g2, (GraphPath)S1.get(m1), (GraphPath)T1.get(m1), m1, b1, b2, b3, s1, s2, s3);
                                        if (P1 == null) continue;
                                        HashSet<V> M2 = new HashSet<V>();
                                        M2.addAll(M);
                                        M2.add(b2);
                                        for (Object m23 : M) {
                                            GraphPath<V, E> P2 = this.P(g2, (GraphPath)S2.get(m23), (GraphPath)T2.get(m23), m23, b2, b1, b3, s2, s1, s3);
                                            if (P2 == null) continue;
                                            HashSet<V> M3 = new HashSet<V>();
                                            M3.addAll(M);
                                            M3.add(b3);
                                            for (Object m3 : M3) {
                                                GraphPath<V, E> P3 = this.P(g2, (GraphPath)S3.get(m3), (GraphPath)T3.get(m3), m3, b3, b1, b2, s3, s1, s2);
                                                if (P3 == null) continue;
                                                if (this.certify) {
                                                    if ((P1.getLength() + P2.getLength()) % 2 == 0) {
                                                        HashSet<V> set = new HashSet<V>();
                                                        set.addAll(P1.getVertexList());
                                                        set.addAll(P2.getVertexList());
                                                        set.add(aCandidate);
                                                        this.BFOddHoleCertificate(new AsSubgraph<V, E>(g2, set));
                                                    } else if ((P1.getLength() + P3.getLength()) % 2 == 0) {
                                                        HashSet<V> set = new HashSet<V>();
                                                        set.addAll(P1.getVertexList());
                                                        set.addAll(P3.getVertexList());
                                                        set.add(aCandidate);
                                                        this.BFOddHoleCertificate(new AsSubgraph<V, E>(g2, set));
                                                    } else {
                                                        HashSet<V> set = new HashSet<V>();
                                                        set.addAll(P3.getVertexList());
                                                        set.addAll(P2.getVertexList());
                                                        set.add(aCandidate);
                                                        this.BFOddHoleCertificate(new AsSubgraph<V, E>(g2, set));
                                                    }
                                                }
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private List<Set<V>> findAllComponents(Graph<V, E> g2, Set<V> F2) {
        return new ConnectivityInspector<V, E>(new AsSubgraph<V, E>(g2, F2)).connectedSets();
    }

    boolean containsJewel(Graph<V, E> g2) {
        for (V v2 : g2.vertexSet()) {
            for (V v3 : g2.vertexSet()) {
                if (v2 == v3 || !g2.containsEdge(v2, v3)) continue;
                for (V v5 : g2.vertexSet()) {
                    if (v2 == v5 || v3 == v5) continue;
                    HashSet<V> F2 = new HashSet<V>();
                    for (V f : g2.vertexSet()) {
                        if (f == v2 || f == v3 || f == v5 || g2.containsEdge(f, v2) || g2.containsEdge(f, v3) || g2.containsEdge(f, v5)) continue;
                        F2.add(f);
                    }
                    List<Set<V>> componentsOfF = this.findAllComponents(g2, F2);
                    HashSet<V> X1 = new HashSet<V>();
                    for (V x1 : g2.vertexSet()) {
                        if (x1 == v2 || x1 == v3 || x1 == v5 || !g2.containsEdge(x1, v2) || !g2.containsEdge(x1, v5) || g2.containsEdge(x1, v3)) continue;
                        X1.add(x1);
                    }
                    HashSet<V> X2 = new HashSet<V>();
                    for (V x2 : g2.vertexSet()) {
                        if (x2 == v2 || x2 == v3 || x2 == v5 || g2.containsEdge(x2, v2) || !g2.containsEdge(x2, v5) || !g2.containsEdge(x2, v3)) continue;
                        X2.add(x2);
                    }
                    for (Object v1 : X1) {
                        if (g2.containsEdge(v1, v3)) continue;
                        for (Object v4 : X2) {
                            if (v1 == v4 || g2.containsEdge(v1, v4) || g2.containsEdge(v2, v4)) continue;
                            for (Set<V> FPrime : componentsOfF) {
                                if (!this.hasANeighbour(g2, FPrime, v1) || !this.hasANeighbour(g2, FPrime, v4)) continue;
                                if (this.certify) {
                                    HashSet<Object> validSet = new HashSet<Object>();
                                    validSet.addAll(FPrime);
                                    validSet.add(v1);
                                    validSet.add(v4);
                                    GraphPath<Object, E> p = new DijkstraShortestPath<Object, E>(new AsSubgraph<V, E>(g2, validSet)).getPath(v1, v4);
                                    LinkedList<E> edgeList = new LinkedList<E>();
                                    edgeList.addAll(p.getEdgeList());
                                    if (p.getLength() % 2 == 1) {
                                        edgeList.add(g2.getEdge(v4, v5));
                                        edgeList.add(g2.getEdge(v5, v1));
                                    } else {
                                        edgeList.add(g2.getEdge(v4, v3));
                                        edgeList.add(g2.getEdge(v3, v2));
                                        edgeList.add(g2.getEdge(v2, v1));
                                    }
                                    double weight = edgeList.stream().mapToDouble(g2::getEdgeWeight).sum();
                                    this.certificate = new GraphWalk<Object, E>(g2, v1, v1, edgeList, weight);
                                }
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    boolean containsCleanShortestOddHole(Graph<V, E> g2) {
        for (V u : g2.vertexSet()) {
            for (V v : g2.vertexSet()) {
                GraphPath<V, E> puv;
                if (u == v || g2.containsEdge(u, v) || (puv = new DijkstraShortestPath<V, E>(g2).getPath(u, v)) == null) continue;
                for (V w : g2.vertexSet()) {
                    GraphPath<V, E> pwu;
                    GraphPath<V, E> pvw;
                    if (w == u || w == v || g2.containsEdge(w, u) || g2.containsEdge(w, v) || (pvw = new DijkstraShortestPath<V, E>(g2).getPath(v, w)) == null || (pwu = new DijkstraShortestPath<V, E>(g2).getPath(w, u)) == null) continue;
                    HashSet<V> set = new HashSet<V>();
                    set.addAll(puv.getVertexList());
                    set.addAll(pvw.getVertexList());
                    set.addAll(pwu.getVertexList());
                    AsSubgraph subg = new AsSubgraph(g2, set);
                    if (set.size() < 7 || subg.vertexSet().size() != set.size() || subg.edgeSet().size() != subg.vertexSet().size() || subg.vertexSet().size() % 2 == 0 || subg.vertexSet().stream().anyMatch(t -> subg.degreeOf(t) != 2)) continue;
                    if (this.certify) {
                        LinkedList<E> edgeList = new LinkedList<E>();
                        edgeList.addAll(puv.getEdgeList());
                        edgeList.addAll(pvw.getEdgeList());
                        edgeList.addAll(pwu.getEdgeList());
                        double weight = edgeList.stream().mapToDouble(g2::getEdgeWeight).sum();
                        this.certificate = new GraphWalk<V, E>(g2, u, u, edgeList, weight);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private GraphPath<V, E> getPathAvoidingX(Graph<V, E> g2, V start, V end, Set<V> X2) {
        HashSet<V> vertexSet = new HashSet<V>();
        vertexSet.addAll(g2.vertexSet());
        vertexSet.removeAll(X2);
        vertexSet.add(start);
        vertexSet.add(end);
        AsSubgraph<V, E> subg = new AsSubgraph<V, E>(g2, vertexSet, null);
        return new DijkstraShortestPath<V, E>(subg).getPath(start, end);
    }

    private boolean containsShortestOddHole(Graph<V, E> g2, Set<V> X2) {
        for (V y1 : g2.vertexSet()) {
            if (X2.contains(y1)) continue;
            for (V x1 : g2.vertexSet()) {
                if (x1 == y1) continue;
                GraphPath<V, E> rx1y1 = this.getPathAvoidingX(g2, x1, y1, X2);
                for (V x3 : g2.vertexSet()) {
                    if (x3 == x1 || x3 == y1 || !g2.containsEdge(x1, x3)) continue;
                    for (V x2 : g2.vertexSet()) {
                        if (x2 == x3 || x2 == x1 || x2 == y1 || g2.containsEdge(x2, x1) || !g2.containsEdge(x3, x2)) continue;
                        GraphPath<V, E> rx2y1 = this.getPathAvoidingX(g2, x2, y1, X2);
                        if (rx1y1 == null || rx2y1 == null) continue;
                        V y2 = null;
                        for (V y2Candidate : rx2y1.getVertexList()) {
                            if (!g2.containsEdge(y1, y2Candidate) || y2Candidate == x1 || y2Candidate == x2 || y2Candidate == x3 || y2Candidate == y1) continue;
                            y2 = y2Candidate;
                            break;
                        }
                        if (y2 == null) continue;
                        GraphPath<V, E> rx3y1 = this.getPathAvoidingX(g2, x3, y1, X2);
                        GraphPath<Object, E> rx3y2 = this.getPathAvoidingX(g2, x3, y2, X2);
                        GraphPath<Object, E> rx1y2 = this.getPathAvoidingX(g2, x1, y2, X2);
                        if (rx3y1 == null || rx3y2 == null || rx1y2 == null) continue;
                        double n = rx1y1.getLength() + 1;
                        if ((double)rx2y1.getLength() != n || n != (double)rx1y2.getLength() || !((double)rx3y1.getLength() >= n) || !((double)rx3y2.getLength() >= n)) continue;
                        if (this.certify) {
                            LinkedList<E> edgeList = new LinkedList<E>();
                            edgeList.addAll(rx1y1.getEdgeList());
                            for (int i = rx2y1.getLength() - 1; i >= 0; --i) {
                                edgeList.add(rx2y1.getEdgeList().get(i));
                            }
                            edgeList.add(g2.getEdge(x2, x3));
                            edgeList.add(g2.getEdge(x3, x1));
                            double weight = edgeList.stream().mapToDouble(g2::getEdgeWeight).sum();
                            this.certificate = new GraphWalk<V, E>(g2, x1, x1, edgeList, weight);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean routine1(Graph<V, E> g2, Set<V> X2) {
        return this.containsCleanShortestOddHole(g2) || this.containsShortestOddHole(g2, X2);
    }

    private boolean hasConfigurationType1(Graph<V, E> g2) {
        for (V v1 : g2.vertexSet()) {
            Set<V> temp = new ConnectivityInspector<V, E>(g2).connectedSetOf(v1);
            for (V v2 : temp) {
                if (v1 == v2 || !g2.containsEdge(v1, v2)) continue;
                for (V v3 : temp) {
                    if (v3 == v1 || v3 == v2 || !g2.containsEdge(v2, v3) || g2.containsEdge(v1, v3)) continue;
                    for (V v4 : temp) {
                        if (v4 == v1 || v4 == v2 || v4 == v3 || g2.containsEdge(v1, v4) || g2.containsEdge(v2, v4) || !g2.containsEdge(v3, v4)) continue;
                        for (V v5 : temp) {
                            if (v5 == v1 || v5 == v2 || v5 == v3 || v5 == v4 || g2.containsEdge(v2, v5) || g2.containsEdge(v3, v5) || !g2.containsEdge(v1, v5) || !g2.containsEdge(v4, v5)) continue;
                            if (this.certify) {
                                LinkedList<E> edgeList = new LinkedList<E>();
                                edgeList.add(g2.getEdge(v1, v2));
                                edgeList.add(g2.getEdge(v2, v3));
                                edgeList.add(g2.getEdge(v3, v4));
                                edgeList.add(g2.getEdge(v4, v5));
                                edgeList.add(g2.getEdge(v5, v1));
                                double weight = edgeList.stream().mapToDouble(g2::getEdgeWeight).sum();
                                this.certificate = new GraphWalk<V, E>(g2, v1, v1, edgeList, weight);
                            }
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    boolean isYXComplete(Graph<V, E> g2, V y, Set<V> X2) {
        return X2.stream().allMatch(t -> g2.containsEdge(t, y));
    }

    private List<Set<V>> findAllAnticomponentsOfY(Graph<V, E> g2, Set<V> Y) {
        AbstractBaseGraph target = g2.getType().isSimple() ? new SimpleGraph<V, E>(g2.getVertexSupplier(), g2.getEdgeSupplier(), g2.getType().isWeighted()) : new Multigraph<V, E>(g2.getVertexSupplier(), g2.getEdgeSupplier(), g2.getType().isWeighted());
        new ComplementGraphGenerator<V, E>(g2).generateGraph(target);
        return this.findAllComponents(target, Y);
    }

    boolean hasConfigurationType2(Graph<V, E> g2) {
        for (V v1 : g2.vertexSet()) {
            for (V v2 : g2.vertexSet()) {
                if (v1 == v2 || !g2.containsEdge(v1, v2)) continue;
                for (V v3 : g2.vertexSet()) {
                    if (v3 == v2 || v1 == v3 || g2.containsEdge(v1, v3) || !g2.containsEdge(v2, v3)) continue;
                    for (V v4 : g2.vertexSet()) {
                        if (v4 == v1 || v4 == v2 || v4 == v3 || g2.containsEdge(v4, v2) || g2.containsEdge(v4, v1) || !g2.containsEdge(v3, v4)) continue;
                        HashSet<V> temp = new HashSet<V>();
                        temp.add(v1);
                        temp.add(v2);
                        temp.add(v4);
                        HashSet<V> Y = new HashSet<V>();
                        for (V y : g2.vertexSet()) {
                            if (!this.isYXComplete(g2, y, temp)) continue;
                            Y.add(y);
                        }
                        List<Set<V>> anticomponentsOfY = this.findAllAnticomponentsOfY(g2, Y);
                        for (Set<V> X2 : anticomponentsOfY) {
                            List<V> P;
                            GraphPath<V, E> Path2;
                            HashSet<V> v2v3 = new HashSet<V>();
                            v2v3.addAll(g2.vertexSet());
                            v2v3.remove(v2);
                            v2v3.remove(v3);
                            v2v3.removeAll(X2);
                            if (!v2v3.contains(v1) || !v2v3.contains(v4) || (Path2 = new DijkstraShortestPath<V, E>(new AsSubgraph<V, E>(g2, v2v3)).getPath(v1, v4)) == null || !(P = Path2.getVertexList()).contains(v1) || !P.contains(v4)) continue;
                            boolean cont = true;
                            for (V p : P) {
                                if (p == v1 || p == v4 || !g2.containsEdge(p, v2) && !g2.containsEdge(p, v3) && !this.isYXComplete(g2, p, X2)) continue;
                                cont = false;
                                break;
                            }
                            if (!cont) continue;
                            if (this.certify) {
                                LinkedList<E> edgeList = new LinkedList<E>();
                                if (Path2.getLength() % 2 == 0) {
                                    edgeList.add(g2.getEdge(v1, v2));
                                    edgeList.add(g2.getEdge(v2, v3));
                                    edgeList.add(g2.getEdge(v3, v4));
                                    edgeList.addAll(Path2.getEdgeList());
                                } else {
                                    edgeList.addAll(Path2.getEdgeList());
                                    V x = X2.iterator().next();
                                    edgeList.add(g2.getEdge(v4, x));
                                    edgeList.add(g2.getEdge(x, v1));
                                }
                                double weight = edgeList.stream().mapToDouble(g2::getEdgeWeight).sum();
                                this.certificate = new GraphWalk<V, E>(g2, v1, v1, edgeList, weight);
                            }
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean hasANeighbour(Graph<V, E> g2, Set<V> set, V v) {
        return set.stream().anyMatch(s2 -> g2.containsEdge(s2, v));
    }

    private Set<V> findMaximalConnectedSubset(Graph<V, E> g2, Set<V> X2, V v1, V v2, V v5) {
        Set<V> FPrime = new ConnectivityInspector<V, E>(g2).connectedSetOf(v5);
        FPrime.removeIf(t -> t != v5 && this.isYXComplete(g2, t, X2) || v1 == t || v2 == t || g2.containsEdge(v1, t) || g2.containsEdge(v2, t));
        return FPrime;
    }

    private boolean hasANonneighbourInX(Graph<V, E> g2, V v, Set<V> X2) {
        return X2.stream().anyMatch(x -> !g2.containsEdge(v, x));
    }

    boolean hasConfigurationType3(Graph<V, E> g2) {
        for (V v1 : g2.vertexSet()) {
            for (V v2 : g2.vertexSet()) {
                if (v1 == v2 || !g2.containsEdge(v1, v2)) continue;
                for (V v5 : g2.vertexSet()) {
                    if (v1 == v5 || v2 == v5 || g2.containsEdge(v1, v5) || g2.containsEdge(v2, v5)) continue;
                    HashSet<V> triple = new HashSet<V>();
                    triple.add(v1);
                    triple.add(v2);
                    triple.add(v5);
                    HashSet<V> Y = new HashSet<V>();
                    for (V y : g2.vertexSet()) {
                        if (!this.isYXComplete(g2, y, triple)) continue;
                        Y.add(y);
                    }
                    List<Set<V>> anticomponents = this.findAllAnticomponentsOfY(g2, Y);
                    for (Set<V> X2 : anticomponents) {
                        Set<V> FPrime = this.findMaximalConnectedSubset(g2, X2, v1, v2, v5);
                        HashSet<V> F2 = new HashSet<V>();
                        F2.addAll(FPrime);
                        for (V x : X2) {
                            if (g2.containsEdge(x, v1) || g2.containsEdge(x, v2) || g2.containsEdge(x, v5) || !this.hasANeighbour(g2, FPrime, x)) continue;
                            F2.add(x);
                        }
                        for (V v4 : g2.vertexSet()) {
                            if (v4 == v1 || v4 == v2 || v4 == v5 || g2.containsEdge(v2, v4) || g2.containsEdge(v5, v4) || !g2.containsEdge(v1, v4) || !this.hasANeighbour(g2, F2, v4) || !this.hasANonneighbourInX(g2, v4, X2) || this.isYXComplete(g2, v4, X2)) continue;
                            for (V v3 : g2.vertexSet()) {
                                if (v3 == v1 || v3 == v2 || v3 == v4 || v3 == v5 || !g2.containsEdge(v2, v3) || !g2.containsEdge(v3, v4) || !g2.containsEdge(v5, v3) || g2.containsEdge(v1, v3) || !this.hasANonneighbourInX(g2, v3, X2) || this.isYXComplete(g2, v3, X2)) continue;
                                for (Object v6 : F2) {
                                    if (v6 == v1 || v6 == v2 || v6 == v3 || v6 == v4 || v6 == v5 || !g2.containsEdge(v4, v6) || g2.containsEdge(v1, v6) || g2.containsEdge(v2, v6) || g2.containsEdge(v5, v6) && !this.isYXComplete(g2, v6, X2)) continue;
                                    HashSet<Object> verticesForPv5v6 = new HashSet<Object>();
                                    verticesForPv5v6.addAll(FPrime);
                                    verticesForPv5v6.add(v5);
                                    verticesForPv5v6.add(v6);
                                    verticesForPv5v6.remove(v1);
                                    verticesForPv5v6.remove(v2);
                                    verticesForPv5v6.remove(v3);
                                    verticesForPv5v6.remove(v4);
                                    if (!new ConnectivityInspector(new AsSubgraph<V, E>(g2, verticesForPv5v6)).pathExists(v6, v5)) continue;
                                    if (this.certify) {
                                        LinkedList<E> edgeList = new LinkedList<E>();
                                        edgeList.add(g2.getEdge(v1, v4));
                                        edgeList.add(g2.getEdge(v4, v6));
                                        GraphPath<V, E> P = new DijkstraShortestPath(g2).getPath(v6, v5);
                                        edgeList.addAll(P.getEdgeList());
                                        if (P.getLength() % 2 == 1) {
                                            V x = X2.iterator().next();
                                            edgeList.add(g2.getEdge(v5, x));
                                            edgeList.add(g2.getEdge(x, v1));
                                        } else {
                                            edgeList.add(g2.getEdge(v5, v3));
                                            edgeList.add(g2.getEdge(v3, v4));
                                            edgeList.add(g2.getEdge(v4, v1));
                                        }
                                        double weight = edgeList.stream().mapToDouble(g2::getEdgeWeight).sum();
                                        this.certificate = new GraphWalk<V, E>(g2, v1, v1, edgeList, weight);
                                    }
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean routine2(Graph<V, E> g2) {
        return this.containsPyramid(g2) || this.containsJewel(g2) || this.hasConfigurationType1(g2) || this.hasConfigurationType2(g2) || this.hasConfigurationType3(g2);
    }

    private Set<V> N(Graph<V, E> g2, V a2, V b2) {
        return g2.vertexSet().stream().filter(t -> g2.containsEdge(t, a2) && g2.containsEdge(t, b2)).collect(Collectors.toSet());
    }

    private int r(Graph<V, E> g2, Set<V> Nab, V c2) {
        if (this.isYXComplete(g2, c2, Nab)) {
            return 0;
        }
        List<Set<V>> anticomponents = this.findAllAnticomponentsOfY(g2, Nab);
        return anticomponents.stream().mapToInt(Set::size).max().getAsInt();
    }

    private Set<V> Y(Graph<V, E> g2, Set<V> Nab, V c2) {
        int cutoff = this.r(g2, Nab, c2);
        List<Set<V>> anticomponents = this.findAllAnticomponentsOfY(g2, Nab);
        HashSet<V> res = new HashSet<V>();
        for (Set<V> anticomponent : anticomponents) {
            if (anticomponent.size() <= cutoff) continue;
            res.addAll(anticomponent);
        }
        return res;
    }

    private Set<V> W(Graph<V, E> g2, Set<V> Nab, V c2) {
        HashSet<V> temp = new HashSet<V>();
        temp.addAll(Nab);
        temp.add(c2);
        List<Set<V>> anticomponents = this.findAllAnticomponentsOfY(g2, temp);
        for (Set<V> anticomponent : anticomponents) {
            if (!anticomponent.contains(c2)) continue;
            return anticomponent;
        }
        return null;
    }

    private Set<V> Z(Graph<V, E> g2, Set<V> Nab, V c2) {
        HashSet<V> temp = new HashSet<V>();
        temp.addAll(this.Y(g2, Nab, c2));
        temp.addAll(this.W(g2, Nab, c2));
        HashSet<V> res = new HashSet<V>();
        for (V it : g2.vertexSet()) {
            if (!this.isYXComplete(g2, it, temp)) continue;
            res.add(it);
        }
        return res;
    }

    private Set<V> X(Graph<V, E> g2, Set<V> Nab, V c2) {
        HashSet<V> res = new HashSet<V>();
        res.addAll(this.Y(g2, Nab, c2));
        res.addAll(this.Z(g2, Nab, c2));
        return res;
    }

    private boolean isTripleRelevant(Graph<V, E> g2, V a2, V b2, V c2) {
        return a2 != b2 && !g2.containsEdge(a2, b2) && !this.N(g2, a2, b2).contains(c2);
    }

    Set<Set<V>> routine3(Graph<V, E> g2) {
        HashSet<Set<Object>> NuvList = new HashSet<Set<Object>>();
        for (Iterator<Object> u : g2.vertexSet()) {
            for (Object object : g2.vertexSet()) {
                if (u == object || !g2.containsEdge(u, object)) continue;
                NuvList.add(this.N(g2, u, object));
            }
        }
        HashSet<Set<Object>> tripleList = new HashSet<Set<Object>>();
        for (Object a2 : g2.vertexSet()) {
            for (Object b2 : g2.vertexSet()) {
                if (a2 == b2 || g2.containsEdge(a2, b2)) continue;
                Set<Object> set = this.N(g2, a2, b2);
                for (Object c2 : g2.vertexSet()) {
                    if (!this.isTripleRelevant(g2, a2, b2, c2)) continue;
                    tripleList.add(this.X(g2, set, c2));
                }
            }
        }
        HashSet<Set<V>> res = new HashSet<Set<V>>();
        for (Set set : NuvList) {
            for (Set set2 : tripleList) {
                HashSet temp = new HashSet();
                temp.addAll(set);
                temp.addAll(set2);
                res.add(temp);
            }
        }
        return res;
    }

    public boolean isBerge(Graph<V, E> g2, boolean computeCertificate) {
        GraphTests.requireDirectedOrUndirected(g2);
        AbstractBaseGraph complementGraph = g2.getType().isSimple() ? new SimpleGraph<V, E>(g2.getVertexSupplier(), g2.getEdgeSupplier(), g2.getType().isWeighted()) : new Multigraph<V, E>(g2.getVertexSupplier(), g2.getEdgeSupplier(), g2.getType().isWeighted());
        new ComplementGraphGenerator<V, E>(g2).generateGraph(complementGraph);
        this.certify = computeCertificate;
        if (this.routine2(g2) || this.routine2(complementGraph)) {
            this.certify = false;
            return false;
        }
        for (Set<V> it : this.routine3(g2)) {
            if (!this.routine1(g2, it)) continue;
            this.certify = false;
            return false;
        }
        for (Set<V> it : this.routine3(complementGraph)) {
            if (!this.routine1(complementGraph, it)) continue;
            this.certify = false;
            return false;
        }
        this.certify = false;
        return true;
    }

    public boolean isBerge(Graph<V, E> g2) {
        return this.isBerge(g2, false);
    }

    public GraphPath<V, E> getCertificate() {
        return this.certificate;
    }
}

