/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.knowm.xchart.internal.chartpart.Annotation;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.AxisPair;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.chartpart.ChartTitle;
import org.knowm.xchart.internal.chartpart.Legend_;
import org.knowm.xchart.internal.chartpart.Plot_;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.Styler;

public abstract class Chart<ST extends Styler, S extends Series> {
    protected final ST styler;
    protected final ChartTitle<ST, S> chartTitle;
    protected final Map<String, S> seriesMap = new LinkedHashMap<String, S>();
    protected final ArrayList<ChartPart> annotations = new ArrayList();
    protected AxisPair axisPair;
    protected Plot_<ST, S> plot;
    protected Legend_<ST, S> legend;
    private int width;
    private int height;
    private String title = "";
    private String xAxisTitle = "";
    private String yAxisTitle = "";
    private final Map<Integer, String> yAxisGroupTitleMap = new HashMap<Integer, String>();

    protected Chart(int width, int height, ST styler) {
        this.width = width;
        this.height = height;
        this.styler = styler;
        this.chartTitle = new ChartTitle(this);
    }

    public abstract void paint(Graphics2D var1, int var2, int var3);

    protected void paintBackground(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ((Styler)this.styler).getAntiAlias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setColor(((Styler)this.styler).getChartBackgroundColor());
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        g2.fill(rect);
    }

    public ST getStyler() {
        return this.styler;
    }

    public S removeSeries(String seriesName) {
        return (S)((Series)this.seriesMap.remove(seriesName));
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getXAxisTitle() {
        return this.xAxisTitle;
    }

    public void setXAxisTitle(String xAxisTitle) {
        this.xAxisTitle = xAxisTitle;
    }

    public String getYAxisTitle() {
        return this.yAxisTitle;
    }

    public void setYAxisTitle(String yAxisTitle) {
        this.yAxisTitle = yAxisTitle;
    }

    public String getYAxisGroupTitle(int yAxisGroup) {
        String title = this.yAxisGroupTitleMap.get(yAxisGroup);
        if (title == null) {
            return this.yAxisTitle;
        }
        return title;
    }

    public void setYAxisGroupTitle(int yAxisGroup, String yAxisTitle) {
        this.yAxisGroupTitleMap.put(yAxisGroup, yAxisTitle);
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        annotation.init(this);
    }

    public void setCustomXAxisTickLabelsFormatter(Function<Double, String> customFormattingFunction) {
        AxesChartStyler axesChartStyler = (AxesChartStyler)this.styler;
        axesChartStyler.setxAxisTickLabelsFormattingFunction(customFormattingFunction);
    }

    public void setCustomYAxisTickLabelsFormatter(Function<Double, String> customFormattingFunction) {
        AxesChartStyler axesChartStyler = (AxesChartStyler)this.styler;
        axesChartStyler.setyAxisTickLabelsFormattingFunction(customFormattingFunction);
    }

    ChartTitle<ST, S> getChartTitle() {
        return this.chartTitle;
    }

    Legend_<ST, S> getLegend() {
        return this.legend;
    }

    Plot_<ST, S> getPlot() {
        return this.plot;
    }

    Axis getXAxis() {
        return this.axisPair.getXAxis();
    }

    Axis getYAxis() {
        return this.axisPair.getYAxis();
    }

    Axis getYAxis(int yIndex) {
        return this.axisPair.getYAxis(yIndex);
    }

    AxisPair getAxisPair() {
        return this.axisPair;
    }

    Format getXAxisFormat() {
        return this.axisPair.getXAxis().getAxisTickCalculator().getAxisFormat();
    }

    Format getYAxisFormat() {
        return this.axisPair.getYAxis().getAxisTickCalculator().getAxisFormat();
    }

    Format getYAxisFormat(String yAxisDecimalPattern) {
        Format format = yAxisDecimalPattern != null ? new DecimalFormat(yAxisDecimalPattern) : this.axisPair.getYAxis().getAxisTickCalculator().getAxisFormat();
        return format;
    }

    public double getYAxisLeftWidth() {
        Rectangle2D.Double bounds = this.getAxisPair().getLeftYAxisBounds();
        return bounds.width + bounds.x;
    }

    public Map<String, S> getSeriesMap() {
        return this.seriesMap;
    }
}

