/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.spi;

import java.util.Objects;
import tech.uom.lib.common.function.MaximumSupplier;
import tech.uom.lib.common.function.MinimumSupplier;

public abstract class Range<T>
implements MinimumSupplier<T>,
MaximumSupplier<T> {
    private final T min;
    private final T max;
    private T res;

    protected Range(T min2, T max, T res) {
        this.min = min2;
        this.max = max;
        this.res = res;
    }

    protected Range(T min2, T max) {
        this.min = min2;
        this.max = max;
    }

    @Override
    public T getMinimum() {
        return this.min;
    }

    @Override
    public T getMaximum() {
        return this.max;
    }

    public T getResolution() {
        return this.res;
    }

    public boolean hasMinimum() {
        return this.min != null;
    }

    public boolean hasMaximum() {
        return this.max != null;
    }

    public abstract boolean contains(T var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Range) {
            Range other = (Range)obj;
            return Objects.equals(this.getMinimum(), other.getMinimum()) && Objects.equals(this.getMaximum(), other.getMaximum()) && Objects.equals(this.getResolution(), other.getResolution());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.res);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("min= ").append(this.getMinimum()).append(", max= ").append(this.getMaximum());
        if (this.res != null) {
            sb.append(", res= ").append(this.getResolution());
        }
        return sb.toString();
    }
}

