/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone;

import com.nexagis.jawbone.ParseIndexFile;
import com.nexagis.jawbone.PartOfSpeech;

public final class WordData {
    private String word = null;
    private int lexID = 0;
    private String syntacticMarker = null;
    private long dataFileOffset = 0L;
    private int senseNum = -1;
    private PartOfSpeech pos;

    public WordData() {
    }

    public WordData(String string, int n, String string2, PartOfSpeech partOfSpeech, long l) {
        this.word = string;
        this.lexID = n;
        this.syntacticMarker = string2;
        this.pos = partOfSpeech;
        this.dataFileOffset = l;
    }

    public int getLexID() {
        return this.lexID;
    }

    public void setLexID(int n) {
        this.lexID = n;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String string) {
        this.word = string;
    }

    public String getSyntacticMarker() {
        return this.syntacticMarker;
    }

    public void setSyntacticMarker(String string) {
        this.syntacticMarker = string;
    }

    public PartOfSpeech getPos() {
        return this.pos;
    }

    public int getSenseNumber() {
        if (this.senseNum < 0) {
            this.senseNum = ParseIndexFile.getSenseNumber(this.word, this.pos, this.dataFileOffset);
        }
        return this.senseNum;
    }

    public void setSenseNumber(int n) {
        this.senseNum = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Word: ").append(this.word).append("  Lexicon-ID: ").append(this.lexID).append("  Syntactic-Marker: ").append(this.syntacticMarker).append("\nPOS: ").append(this.pos.toString()).append("  Offset: ").append(Long.toString(this.dataFileOffset)).append("  Sense");
        if (this.senseNum < 0) {
            stringBuffer.append(": <Not loaded>");
        } else if (this.senseNum == 0) {
            stringBuffer.append(": <Not found>");
        } else {
            stringBuffer.append(" #").append(Integer.toString(this.senseNum));
        }
        return stringBuffer.toString();
    }
}

