/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.data.Complex64F;
import org.ejml.data.ComplexMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix32F;
import org.ejml.data.RealMatrix64F;

public class EjmlUnitTests {
    public static void assertCountable(RealMatrix64F A) {
        for (int i = 0; i < A.getNumRows(); ++i) {
            for (int j = 0; j < A.getNumCols(); ++j) {
                EjmlUnitTests.assertTrue(!Double.isNaN(A.get(i, j)), "NaN found at " + i + " " + j);
                EjmlUnitTests.assertTrue(!Double.isInfinite(A.get(i, j)), "Infinite found at " + i + " " + j);
            }
        }
    }

    public static void assertShape(Matrix A, Matrix B) {
        EjmlUnitTests.assertTrue(A.getNumRows() == B.getNumRows(), "Number of rows do not match");
        EjmlUnitTests.assertTrue(A.getNumCols() == B.getNumCols(), "Number of columns do not match");
    }

    public static void assertShape(RealMatrix64F A, int numRows, int numCols) {
        EjmlUnitTests.assertTrue(A.getNumRows() == numRows, "Unexpected number of rows.");
        EjmlUnitTests.assertTrue(A.getNumCols() == numCols, "Unexpected number of columns.");
    }

    public static void assertEqualsUncountable(RealMatrix64F A, RealMatrix64F B, double tol) {
        EjmlUnitTests.assertShape(A, B);
        for (int i = 0; i < A.getNumRows(); ++i) {
            for (int j = 0; j < A.getNumCols(); ++j) {
                double valA = A.get(i, j);
                double valB = B.get(i, j);
                if (Double.isNaN(valA)) {
                    EjmlUnitTests.assertTrue(Double.isNaN(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                    continue;
                }
                if (Double.isInfinite(valA)) {
                    EjmlUnitTests.assertTrue(Double.isInfinite(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                    continue;
                }
                double diff = Math.abs(valA - valB);
                EjmlUnitTests.assertTrue(diff <= tol, "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
            }
        }
    }

    public static void assertEquals(RealMatrix64F A, RealMatrix64F B, double tol) {
        EjmlUnitTests.assertShape(A, B);
        for (int i = 0; i < A.getNumRows(); ++i) {
            for (int j = 0; j < A.getNumCols(); ++j) {
                double valA = A.get(i, j);
                double valB = B.get(i, j);
                EjmlUnitTests.assertTrue(!Double.isNaN(valA) && !Double.isNaN(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                EjmlUnitTests.assertTrue(!Double.isInfinite(valA) && !Double.isInfinite(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                EjmlUnitTests.assertTrue(Math.abs(valA - valB) <= tol, "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
            }
        }
    }

    public static void assertEquals(RealMatrix32F A, RealMatrix32F B, float tol) {
        EjmlUnitTests.assertShape(A, B);
        for (int i = 0; i < A.getNumRows(); ++i) {
            for (int j = 0; j < A.getNumCols(); ++j) {
                float valA = A.get(i, j);
                float valB = B.get(i, j);
                EjmlUnitTests.assertTrue(!Float.isNaN(valA) && !Float.isNaN(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                EjmlUnitTests.assertTrue(!Float.isInfinite(valA) && !Float.isInfinite(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                EjmlUnitTests.assertTrue(Math.abs(valA - valB) <= tol, "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
            }
        }
    }

    public static void assertEquals(Complex64F a, Complex64F b, double tol) {
        EjmlUnitTests.assertTrue(!Double.isNaN(a.real) && !Double.isNaN(b.real), "real a = " + a.real + " b = " + b.real);
        EjmlUnitTests.assertTrue(!Double.isInfinite(a.real) && !Double.isInfinite(b.real), "real a = " + a.real + " b = " + b.real);
        EjmlUnitTests.assertTrue(Math.abs(a.real - b.real) <= tol, "real a = " + a.real + " b = " + b.real);
        EjmlUnitTests.assertTrue(!Double.isNaN(a.imaginary) && !Double.isNaN(b.imaginary), "imaginary a = " + a.imaginary + " b = " + b.imaginary);
        EjmlUnitTests.assertTrue(!Double.isInfinite(a.imaginary) && !Double.isInfinite(b.imaginary), "imaginary a = " + a.imaginary + " b = " + b.imaginary);
        EjmlUnitTests.assertTrue(Math.abs(a.imaginary - b.imaginary) <= tol, "imaginary a = " + a.imaginary + " b = " + b.imaginary);
    }

    public static void assertEquals(ComplexMatrix64F A, ComplexMatrix64F B, double tol) {
        EjmlUnitTests.assertShape(A, B);
        Complex64F a = new Complex64F();
        Complex64F b = new Complex64F();
        for (int i = 0; i < A.getNumRows(); ++i) {
            for (int j = 0; j < A.getNumCols(); ++j) {
                A.get(i, j, a);
                B.get(i, j, b);
                EjmlUnitTests.assertTrue(!Double.isNaN(a.real) && !Double.isNaN(b.real), "Real At (" + i + "," + j + ") A = " + a.real + " B = " + b.real);
                EjmlUnitTests.assertTrue(!Double.isInfinite(a.real) && !Double.isInfinite(b.real), "Real At (" + i + "," + j + ") A = " + a.real + " B = " + b.real);
                EjmlUnitTests.assertTrue(Math.abs(a.real - b.real) <= tol, "Real At (" + i + "," + j + ") A = " + a.real + " B = " + b.real);
                EjmlUnitTests.assertTrue(!Double.isNaN(a.imaginary) && !Double.isNaN(b.imaginary), "Img At (" + i + "," + j + ") A = " + a.imaginary + " B = " + b.imaginary);
                EjmlUnitTests.assertTrue(!Double.isInfinite(a.imaginary) && !Double.isInfinite(b.imaginary), "Img At (" + i + "," + j + ") A = " + a.imaginary + " B = " + b.imaginary);
                EjmlUnitTests.assertTrue(Math.abs(a.imaginary - b.imaginary) <= tol, "Img At (" + i + "," + j + ") A = " + a.imaginary + " B = " + b.imaginary);
            }
        }
    }

    public static void assertEqualsTrans(RealMatrix64F A, RealMatrix64F B, double tol) {
        EjmlUnitTests.assertShape(A, B.getNumCols(), B.getNumRows());
        for (int i = 0; i < A.getNumRows(); ++i) {
            for (int j = 0; j < A.getNumCols(); ++j) {
                double valA = A.get(i, j);
                double valB = B.get(j, i);
                EjmlUnitTests.assertTrue(!Double.isNaN(valA) && !Double.isNaN(valB), "A(" + i + "," + j + ") = " + valA + ") B(" + j + "," + i + ") = " + valB);
                EjmlUnitTests.assertTrue(!Double.isInfinite(valA) && !Double.isInfinite(valB), "A(" + i + "," + j + ") = " + valA + ") B(" + j + "," + i + ") = " + valB);
                EjmlUnitTests.assertTrue(Math.abs(valA - valB) <= tol, "A(" + i + "," + j + ") = " + valA + ") B(" + j + "," + i + ") = " + valB);
            }
        }
    }

    private static void assertTrue(boolean result, String message) {
        assert (result) : message;
        if (!result) {
            throw new TestException(message);
        }
    }

    public static class TestException
    extends RuntimeException {
        public TestException(String message) {
            super(message);
        }
    }
}

